(self["webpackChunkmatngular"] = self["webpackChunkmatngular"] || []).push([["vendor"],{

/***/ 73624:
/*!*****************************************************!*\
  !*** ./node_modules/@agm/core/fesm2015/agm-core.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AgmBicyclingLayer": () => (/* binding */ AgmBicyclingLayer),
/* harmony export */   "AgmCircle": () => (/* binding */ AgmCircle),
/* harmony export */   "AgmCoreModule": () => (/* binding */ AgmCoreModule),
/* harmony export */   "AgmDataLayer": () => (/* binding */ AgmDataLayer),
/* harmony export */   "AgmFitBounds": () => (/* binding */ AgmFitBounds),
/* harmony export */   "AgmGeocoder": () => (/* binding */ AgmGeocoder),
/* harmony export */   "AgmInfoWindow": () => (/* binding */ AgmInfoWindow),
/* harmony export */   "AgmKmlLayer": () => (/* binding */ AgmKmlLayer),
/* harmony export */   "AgmMap": () => (/* binding */ AgmMap),
/* harmony export */   "AgmMarker": () => (/* binding */ AgmMarker),
/* harmony export */   "AgmPolygon": () => (/* binding */ AgmPolygon),
/* harmony export */   "AgmPolyline": () => (/* binding */ AgmPolyline),
/* harmony export */   "AgmPolylineIcon": () => (/* binding */ AgmPolylineIcon),
/* harmony export */   "AgmPolylinePoint": () => (/* binding */ AgmPolylinePoint),
/* harmony export */   "AgmRectangle": () => (/* binding */ AgmRectangle),
/* harmony export */   "AgmTransitLayer": () => (/* binding */ AgmTransitLayer),
/* harmony export */   "CircleManager": () => (/* binding */ CircleManager),
/* harmony export */   "ControlPosition": () => (/* binding */ ControlPosition),
/* harmony export */   "DataLayerManager": () => (/* binding */ DataLayerManager),
/* harmony export */   "FitBoundsAccessor": () => (/* binding */ FitBoundsAccessor),
/* harmony export */   "GeocoderLocationType": () => (/* binding */ GeocoderLocationType),
/* harmony export */   "GeocoderStatus": () => (/* binding */ GeocoderStatus),
/* harmony export */   "GoogleMapsAPIWrapper": () => (/* binding */ GoogleMapsAPIWrapper),
/* harmony export */   "GoogleMapsScriptProtocol": () => (/* binding */ GoogleMapsScriptProtocol),
/* harmony export */   "InfoWindowManager": () => (/* binding */ InfoWindowManager),
/* harmony export */   "KmlLayerManager": () => (/* binding */ KmlLayerManager),
/* harmony export */   "LAZY_MAPS_API_CONFIG": () => (/* binding */ LAZY_MAPS_API_CONFIG),
/* harmony export */   "LayerManager": () => (/* binding */ LayerManager),
/* harmony export */   "LazyMapsAPILoader": () => (/* binding */ LazyMapsAPILoader),
/* harmony export */   "MapTypeId": () => (/* binding */ MapTypeId),
/* harmony export */   "MapsAPILoader": () => (/* binding */ MapsAPILoader),
/* harmony export */   "MarkerManager": () => (/* binding */ MarkerManager),
/* harmony export */   "NoOpMapsAPILoader": () => (/* binding */ NoOpMapsAPILoader),
/* harmony export */   "PolygonManager": () => (/* binding */ PolygonManager),
/* harmony export */   "PolylineManager": () => (/* binding */ PolylineManager),
/* harmony export */   "RectangleManager": () => (/* binding */ RectangleManager),
/* harmony export */   "ScaleControlStyle": () => (/* binding */ ScaleControlStyle),
/* harmony export */   "ZoomControlStyle": () => (/* binding */ ZoomControlStyle),
/* harmony export */   "ɵa": () => (/* binding */ FitBoundsService),
/* harmony export */   "ɵb": () => (/* binding */ coreDirectives),
/* harmony export */   "ɵc": () => (/* binding */ WindowRef),
/* harmony export */   "ɵd": () => (/* binding */ DocumentRef),
/* harmony export */   "ɵe": () => (/* binding */ BROWSER_GLOBALS_PROVIDERS)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 77153);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 12378);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 84505);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 24383);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 45398);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs */ 92218);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs */ 57270);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs */ 88623);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! rxjs */ 61555);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! rxjs */ 35290);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! rxjs */ 64139);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! rxjs */ 66587);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ 80522);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ 62159);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 59095);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs/operators */ 86942);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs/operators */ 79128);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs/operators */ 53298);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs/operators */ 85921);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs/operators */ 25722);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! rxjs/operators */ 16276);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! rxjs/operators */ 72787);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/common */ 94666);






const _c0 = ["*"];
let MapsAPILoader = /*#__PURE__*/(() => {
  let MapsAPILoader = class MapsAPILoader {};

  MapsAPILoader.ɵfac = function MapsAPILoader_Factory(t) {
    return new (t || MapsAPILoader)();
  };

  MapsAPILoader.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: MapsAPILoader,
    factory: function (t) {
      return MapsAPILoader.ɵfac(t);
    }
  });
  /**
   * Wrapper class that handles the communication with the Google Maps Javascript
   * API v3
   */

  return MapsAPILoader;
})();
let GoogleMapsAPIWrapper = /*#__PURE__*/(() => {
  let GoogleMapsAPIWrapper = class GoogleMapsAPIWrapper {
    constructor(_loader, _zone) {
      this._loader = _loader;
      this._zone = _zone;
      this._map = new Promise(resolve => {
        this._mapResolver = resolve;
      });
    }

    createMap(el, mapOptions) {
      return this._zone.runOutsideAngular(() => {
        return this._loader.load().then(() => {
          const map = new google.maps.Map(el, mapOptions);

          this._mapResolver(map);

          return;
        });
      });
    }

    setMapOptions(options) {
      return this._zone.runOutsideAngular(() => {
        this._map.then(m => {
          m.setOptions(options);
        });
      });
    }
    /**
     * Creates a google map marker with the map context
     */


    createMarker(options = {}, addToMap = true) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => {
          if (addToMap) {
            options.map = map;
          }

          return new google.maps.Marker(options);
        });
      });
    }

    createInfoWindow(options) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(() => {
          return new google.maps.InfoWindow(options);
        });
      });
    }
    /**
     * Creates a google.map.Circle for the current map.
     */


    createCircle(options) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => {
          if (typeof options.strokePosition === 'string') {
            options.strokePosition = google.maps.StrokePosition[options.strokePosition];
          }

          options.map = map;
          return new google.maps.Circle(options);
        });
      });
    }
    /**
     * Creates a google.map.Rectangle for the current map.
     */


    createRectangle(options) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => {
          options.map = map;
          return new google.maps.Rectangle(options);
        });
      });
    }

    createPolyline(options) {
      return this._zone.runOutsideAngular(() => {
        return this.getNativeMap().then(map => {
          let line = new google.maps.Polyline(options);
          line.setMap(map);
          return line;
        });
      });
    }

    createPolygon(options) {
      return this._zone.runOutsideAngular(() => {
        return this.getNativeMap().then(map => {
          let polygon = new google.maps.Polygon(options);
          polygon.setMap(map);
          return polygon;
        });
      });
    }
    /**
     * Creates a new google.map.Data layer for the current map
     */


    createDataLayer(options) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(m => {
          let data = new google.maps.Data(options);
          data.setMap(m);
          return data;
        });
      });
    }
    /**
     * Creates a TransitLayer instance for a map
     * @param {TransitLayerOptions} options - used for setting layer options
     * @returns {Promise<TransitLayer>} a new transit layer object
     */


    createTransitLayer(options) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => {
          let newLayer = new google.maps.TransitLayer();
          newLayer.setMap(options.visible ? map : null);
          return newLayer;
        });
      });
    }
    /**
     * Creates a BicyclingLayer instance for a map
     * @param {BicyclingLayerOptions} options - used for setting layer options
     * @returns {Promise<BicyclingLayer>} a new bicycling layer object
     */


    createBicyclingLayer(options) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => {
          let newLayer = new google.maps.BicyclingLayer();
          newLayer.setMap(options.visible ? map : null);
          return newLayer;
        });
      });
    }
    /**
     * Determines if given coordinates are insite a Polygon path.
     */


    containsLocation(latLng, polygon) {
      return google.maps.geometry.poly.containsLocation(latLng, polygon);
    }

    subscribeToMapEvent(eventName) {
      return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
        this._map.then(m => {
          m.addListener(eventName, arg => {
            this._zone.run(() => observer.next(arg));
          });
        });
      });
    }

    clearInstanceListeners() {
      return this._zone.runOutsideAngular(() => {
        this._map.then(map => {
          google.maps.event.clearInstanceListeners(map);
        });
      });
    }

    setCenter(latLng) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.setCenter(latLng));
      });
    }

    getZoom() {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.getZoom());
      });
    }

    getBounds() {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.getBounds());
      });
    }

    getMapTypeId() {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.getMapTypeId());
      });
    }

    setZoom(zoom) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.setZoom(zoom));
      });
    }

    getCenter() {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.getCenter());
      });
    }

    panTo(latLng) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.panTo(latLng));
      });
    }

    panBy(x, y) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.panBy(x, y));
      });
    }

    fitBounds(latLng, padding) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.fitBounds(latLng, padding));
      });
    }

    panToBounds(latLng, padding) {
      return this._zone.runOutsideAngular(() => {
        return this._map.then(map => map.panToBounds(latLng, padding));
      });
    }
    /**
     * Returns the native Google Maps Map instance. Be careful when using this instance directly.
     */


    getNativeMap() {
      return this._map;
    }
    /**
     * Triggers the given event name on the map instance.
     */


    triggerMapEvent(eventName) {
      return this._map.then(m => google.maps.event.trigger(m, eventName));
    }

  };

  GoogleMapsAPIWrapper.ɵfac = function GoogleMapsAPIWrapper_Factory(t) {
    return new (t || GoogleMapsAPIWrapper)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](MapsAPILoader), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  GoogleMapsAPIWrapper.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: GoogleMapsAPIWrapper,
    factory: function (t) {
      return GoogleMapsAPIWrapper.ɵfac(t);
    }
  });
  GoogleMapsAPIWrapper = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [MapsAPILoader, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], GoogleMapsAPIWrapper);
  /**
   * This class manages Transit and Bicycling Layers for a Google Map instance.
   */

  return GoogleMapsAPIWrapper;
})();
let LayerManager = /*#__PURE__*/(() => {
  let LayerManager = class LayerManager {
    constructor(_wrapper) {
      this._wrapper = _wrapper;
      this._layers = new Map();
    }
    /**
     * Adds a transit layer to a map instance.
     * @param {AgmTransitLayer} layer - a TransitLayer object
     * @param {TransitLayerOptions} options - TransitLayerOptions options
     * @returns void
     */


    addTransitLayer(layer, options) {
      const newLayer = this._wrapper.createTransitLayer(options);

      this._layers.set(layer, newLayer);
    }
    /**
     * Adds a bicycling layer to a map instance.
     * @param {AgmBicyclingLayer} layer - a bicycling layer object
     * @param {BicyclingLayerOptions} options - BicyclingLayer options
     * @returns void
     */


    addBicyclingLayer(layer, options) {
      const newLayer = this._wrapper.createBicyclingLayer(options);

      this._layers.set(layer, newLayer);
    }
    /**
     * Deletes a map layer
     * @param {AgmTransitLayer|AgmBicyclingLayer} layer - the layer to delete
     * @returns  Promise<void>
     */


    deleteLayer(layer) {
      return this._layers.get(layer).then(currentLayer => {
        currentLayer.setMap(null);

        this._layers.delete(layer);
      });
    }
    /**
     * Hide/Show a google map layer
     * @param { AgmTransitLayer|AgmBicyclingLayer} layer - the layer to hide/show
     * @param {TransitLayerOptions|BicyclingLayerOptions} options - used to set visibility of the layer
     * @returns Promise<void>
     */


    toggleLayerVisibility(layer, options) {
      return this._layers.get(layer).then(currentLayer => {
        if (!options.visible) {
          currentLayer.setMap(null);
          return;
        } else {
          return this._wrapper.getNativeMap().then(map => {
            currentLayer.setMap(map);
          });
        }
      });
    }

  };

  LayerManager.ɵfac = function LayerManager_Factory(t) {
    return new (t || LayerManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper));
  };

  LayerManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: LayerManager,
    factory: function (t) {
      return LayerManager.ɵfac(t);
    }
  });
  LayerManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper])], LayerManager);
  return LayerManager;
})();
let layerId = 0;
/*
 * This directive adds a bicycling layer to a google map instance
 * <agm-bicycling-layer [visible]="true|false"> <agm-bicycling-layer>
 * */

let AgmBicyclingLayer = /*#__PURE__*/(() => {
  let AgmBicyclingLayer = class AgmBicyclingLayer {
    constructor(_manager) {
      this._manager = _manager;
      this._addedToManager = false;
      this._id = (layerId++).toString();
      /**
       * Hide/show bicycling layer
       */

      this.visible = true;
    }

    ngOnInit() {
      if (this._addedToManager) {
        return;
      }

      this._manager.addBicyclingLayer(this, {
        visible: this.visible
      });

      this._addedToManager = true;
    }

    ngOnChanges(changes) {
      if (!this._addedToManager) {
        return;
      }

      if (changes['visible'] != null) {
        this._manager.toggleLayerVisibility(this, {
          visible: changes['visible'].currentValue
        });
      }
    }
    /** @internal */


    id() {
      return this._id;
    }
    /** @internal */


    toString() {
      return `AgmBicyclingLayer-${this._id.toString()}`;
    }
    /** @internal */


    ngOnDestroy() {
      this._manager.deleteLayer(this);
    }

  };

  AgmBicyclingLayer.ɵfac = function AgmBicyclingLayer_Factory(t) {
    return new (t || AgmBicyclingLayer)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](LayerManager));
  };

  AgmBicyclingLayer.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: AgmBicyclingLayer,
    selectors: [["agm-bicycling-layer"]],
    inputs: {
      visible: "visible"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmBicyclingLayer.prototype, "visible", void 0);

  AgmBicyclingLayer = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [LayerManager])], AgmBicyclingLayer);
  return AgmBicyclingLayer;
})();
let CircleManager = /*#__PURE__*/(() => {
  let CircleManager = class CircleManager {
    constructor(_apiWrapper, _zone) {
      this._apiWrapper = _apiWrapper;
      this._zone = _zone;
      this._circles = new Map();
    }

    addCircle(circle) {
      this._circles.set(circle, this._apiWrapper.createCircle({
        center: {
          lat: circle.latitude,
          lng: circle.longitude
        },
        clickable: circle.clickable,
        draggable: circle.draggable,
        editable: circle.editable,
        fillColor: circle.fillColor,
        fillOpacity: circle.fillOpacity,
        radius: circle.radius,
        strokeColor: circle.strokeColor,
        strokeOpacity: circle.strokeOpacity,
        strokePosition: circle.strokePosition,
        strokeWeight: circle.strokeWeight,
        visible: circle.visible,
        zIndex: circle.zIndex
      }));
    }
    /**
     * Removes the given circle from the map.
     */


    removeCircle(circle) {
      return this._circles.get(circle).then(c => {
        c.setMap(null);

        this._circles.delete(circle);
      });
    }

    setOptions(circle, options) {
      return this._circles.get(circle).then(c => {
        if (typeof options.strokePosition === 'string') {
          options.strokePosition = google.maps.StrokePosition[options.strokePosition];
        }

        c.setOptions(options);
      });
    }

    getBounds(circle) {
      return this._circles.get(circle).then(c => c.getBounds());
    }

    getCenter(circle) {
      return this._circles.get(circle).then(c => c.getCenter());
    }

    getRadius(circle) {
      return this._circles.get(circle).then(c => c.getRadius());
    }

    setCenter(circle) {
      return this._circles.get(circle).then(c => {
        return c.setCenter({
          lat: circle.latitude,
          lng: circle.longitude
        });
      });
    }

    setEditable(circle) {
      return this._circles.get(circle).then(c => {
        return c.setEditable(circle.editable);
      });
    }

    setDraggable(circle) {
      return this._circles.get(circle).then(c => {
        return c.setDraggable(circle.draggable);
      });
    }

    setVisible(circle) {
      return this._circles.get(circle).then(c => {
        return c.setVisible(circle.visible);
      });
    }

    setRadius(circle) {
      return this._circles.get(circle).then(c => {
        return c.setRadius(circle.radius);
      });
    }

    getNativeCircle(circle) {
      return this._circles.get(circle);
    }

    createEventObservable(eventName, circle) {
      return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
        let listener = null;

        this._circles.get(circle).then(c => {
          listener = c.addListener(eventName, e => this._zone.run(() => observer.next(e)));
        });

        return () => {
          if (listener !== null) {
            listener.remove();
          }
        };
      });
    }

  };

  CircleManager.ɵfac = function CircleManager_Factory(t) {
    return new (t || CircleManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  CircleManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: CircleManager,
    factory: function (t) {
      return CircleManager.ɵfac(t);
    }
  });
  CircleManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], CircleManager);
  return CircleManager;
})();
var AgmCircle_1;
let AgmCircle = AgmCircle_1 = class AgmCircle {
  constructor(_manager) {
    this._manager = _manager;
    /**
     * Indicates whether this Circle handles mouse events. Defaults to true.
     */

    this.clickable = true;
    /**
     * If set to true, the user can drag this circle over the map. Defaults to false.
     */
    // tslint:disable-next-line:no-input-rename

    this.draggable = false;
    /**
     * If set to true, the user can edit this circle by dragging the control points shown at
     * the center and around the circumference of the circle. Defaults to false.
     */

    this.editable = false;
    /**
     * The radius in meters on the Earth's surface.
     */

    this.radius = 0;
    /**
     * The stroke position. Defaults to CENTER.
     * This property is not supported on Internet Explorer 8 and earlier.
     */

    this.strokePosition = 'CENTER';
    /**
     * The stroke width in pixels.
     */

    this.strokeWeight = 0;
    /**
     * Whether this circle is visible on the map. Defaults to true.
     */

    this.visible = true;
    /**
     * This event is fired when the circle's center is changed.
     */

    this.centerChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user clicks on the circle.
     */

    this.circleClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user clicks on the circle.
     */

    this.circleDblClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is repeatedly fired while the user drags the circle.
     */

    this.drag = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user stops dragging the circle.
     */

    this.dragEnd = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user starts dragging the circle.
     */

    this.dragStart = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousedown event is fired on the circle.
     */

    this.mouseDown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousemove event is fired on the circle.
     */

    this.mouseMove = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on circle mouseout.
     */

    this.mouseOut = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on circle mouseover.
     */

    this.mouseOver = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mouseup event is fired on the circle.
     */

    this.mouseUp = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the circle's radius is changed.
     */

    this.radiusChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the circle is right-clicked on.
     */

    this.rightClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    this._circleAddedToManager = false;
    this._eventSubscriptions = [];
  }
  /** @internal */


  ngOnInit() {
    this._manager.addCircle(this);

    this._circleAddedToManager = true;

    this._registerEventListeners();
  }
  /** @internal */


  ngOnChanges(changes) {
    if (!this._circleAddedToManager) {
      return;
    }

    if (changes['latitude'] || changes['longitude']) {
      this._manager.setCenter(this);
    }

    if (changes['editable']) {
      this._manager.setEditable(this);
    }

    if (changes['draggable']) {
      this._manager.setDraggable(this);
    }

    if (changes['visible']) {
      this._manager.setVisible(this);
    }

    if (changes['radius']) {
      this._manager.setRadius(this);
    }

    this._updateCircleOptionsChanges(changes);
  }

  _updateCircleOptionsChanges(changes) {
    let options = {};
    let optionKeys = Object.keys(changes).filter(k => AgmCircle_1._mapOptions.indexOf(k) !== -1);
    optionKeys.forEach(k => {
      options[k] = changes[k].currentValue;
    });

    if (optionKeys.length > 0) {
      this._manager.setOptions(this, options);
    }
  }

  _registerEventListeners() {
    let events = new Map();
    events.set('center_changed', this.centerChange);
    events.set('click', this.circleClick);
    events.set('dblclick', this.circleDblClick);
    events.set('drag', this.drag);
    events.set('dragend', this.dragEnd);
    events.set('dragstart', this.dragStart);
    events.set('mousedown', this.mouseDown);
    events.set('mousemove', this.mouseMove);
    events.set('mouseout', this.mouseOut);
    events.set('mouseover', this.mouseOver);
    events.set('mouseup', this.mouseUp);
    events.set('radius_changed', this.radiusChange);
    events.set('rightclick', this.rightClick);
    events.forEach((eventEmitter, eventName) => {
      this._eventSubscriptions.push(this._manager.createEventObservable(eventName, this).subscribe(value => {
        switch (eventName) {
          case 'radius_changed':
            this._manager.getRadius(this).then(radius => eventEmitter.emit(radius));

            break;

          case 'center_changed':
            this._manager.getCenter(this).then(center => eventEmitter.emit({
              lat: center.lat(),
              lng: center.lng()
            }));

            break;

          default:
            eventEmitter.emit({
              coords: {
                lat: value.latLng.lat(),
                lng: value.latLng.lng()
              }
            });
        }
      }));
    });
  }
  /** @internal */


  ngOnDestroy() {
    this._eventSubscriptions.forEach(function (s) {
      s.unsubscribe();
    });

    this._eventSubscriptions = null;

    this._manager.removeCircle(this);
  }
  /**
   * Gets the LatLngBounds of this Circle.
   */


  getBounds() {
    return this._manager.getBounds(this);
  }

  getCenter() {
    return this._manager.getCenter(this);
  }

};

AgmCircle.ɵfac = function AgmCircle_Factory(t) {
  return new (t || AgmCircle)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](CircleManager));
};

AgmCircle.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmCircle,
  selectors: [["agm-circle"]],
  inputs: {
    clickable: "clickable",
    draggable: ["circleDraggable", "draggable"],
    editable: "editable",
    radius: "radius",
    strokePosition: "strokePosition",
    strokeWeight: "strokeWeight",
    visible: "visible",
    latitude: "latitude",
    longitude: "longitude",
    fillColor: "fillColor",
    fillOpacity: "fillOpacity",
    strokeColor: "strokeColor",
    strokeOpacity: "strokeOpacity",
    zIndex: "zIndex"
  },
  outputs: {
    centerChange: "centerChange",
    circleClick: "circleClick",
    circleDblClick: "circleDblClick",
    drag: "drag",
    dragEnd: "dragEnd",
    dragStart: "dragStart",
    mouseDown: "mouseDown",
    mouseMove: "mouseMove",
    mouseOut: "mouseOut",
    mouseOver: "mouseOver",
    mouseUp: "mouseUp",
    radiusChange: "radiusChange",
    rightClick: "rightClick"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
AgmCircle._mapOptions = ['fillColor', 'fillOpacity', 'strokeColor', 'strokeOpacity', 'strokePosition', 'strokeWeight', 'visible', 'zIndex', 'clickable'];

AgmCircle.ctorParameters = () => [{
  type: CircleManager
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmCircle.prototype, "latitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmCircle.prototype, "longitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmCircle.prototype, "clickable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('circleDraggable'), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmCircle.prototype, "draggable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmCircle.prototype, "editable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmCircle.prototype, "fillColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmCircle.prototype, "fillOpacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmCircle.prototype, "radius", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmCircle.prototype, "strokeColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmCircle.prototype, "strokeOpacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmCircle.prototype, "strokePosition", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmCircle.prototype, "strokeWeight", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmCircle.prototype, "visible", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmCircle.prototype, "zIndex", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "centerChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "circleClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "circleDblClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "drag", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "dragEnd", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "dragStart", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "mouseDown", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "mouseMove", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "mouseOut", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "mouseOver", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "mouseUp", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "radiusChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmCircle.prototype, "rightClick", void 0);

AgmCircle = AgmCircle_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [CircleManager])], AgmCircle);
/**
 * Manages all Data Layers for a Google Map instance.
 */

let DataLayerManager = /*#__PURE__*/(() => {
  let DataLayerManager = class DataLayerManager {
    constructor(_wrapper, _zone) {
      this._wrapper = _wrapper;
      this._zone = _zone;
      this._layers = new Map();
    }
    /**
     * Adds a new Data Layer to the map.
     */


    addDataLayer(layer) {
      const newLayer = this._wrapper.createDataLayer({
        style: layer.style
      }).then(d => {
        if (layer.geoJson) {
          this.getDataFeatures(d, layer.geoJson).then(features => d.features = features);
        }

        return d;
      });

      this._layers.set(layer, newLayer);
    }

    deleteDataLayer(layer) {
      this._layers.get(layer).then(l => {
        l.setMap(null);

        this._layers.delete(layer);
      });
    }

    updateGeoJson(layer, geoJson) {
      this._layers.get(layer).then(l => {
        l.forEach(function (feature) {
          l.remove(feature);
          var index = l.features.indexOf(feature, 0);

          if (index > -1) {
            l.features.splice(index, 1);
          }
        });
        this.getDataFeatures(l, geoJson).then(features => l.features = features);
      });
    }

    setDataOptions(layer, options) {
      this._layers.get(layer).then(l => {
        l.setControlPosition(options.controlPosition);
        l.setControls(options.controls);
        l.setDrawingMode(options.drawingMode);
        l.setStyle(options.style);
      });
    }
    /**
     * Creates a Google Maps event listener for the given DataLayer as an Observable
     */


    createEventObservable(eventName, layer) {
      return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
        this._layers.get(layer).then(d => {
          d.addListener(eventName, e => this._zone.run(() => observer.next(e)));
        });
      });
    }
    /**
     * Extract features from a geoJson using google.maps Data Class
     * @param d : google.maps.Data class instance
     * @param geoJson : url or geojson object
     */


    getDataFeatures(d, geoJson) {
      return new Promise((resolve, reject) => {
        if (typeof geoJson === 'object') {
          try {
            const features = d.addGeoJson(geoJson);
            resolve(features);
          } catch (e) {
            reject(e);
          }
        } else if (typeof geoJson === 'string') {
          d.loadGeoJson(geoJson, null, resolve);
        } else {
          reject(`Impossible to extract features from geoJson: wrong argument type`);
        }
      });
    }

  };

  DataLayerManager.ɵfac = function DataLayerManager_Factory(t) {
    return new (t || DataLayerManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  DataLayerManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: DataLayerManager,
    factory: function (t) {
      return DataLayerManager.ɵfac(t);
    }
  });
  DataLayerManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], DataLayerManager);
  return DataLayerManager;
})();
var AgmDataLayer_1;
let layerId$1 = 0;
/**
 * AgmDataLayer enables the user to add data layers to the map.
 *
 * ### Example
 * ```typescript
 * import { Component } from 'angular2/core';
 * import { AgmMap, AgmDataLayer } from
 * 'angular-google-maps/core';
 *
 * @Component({
 *  selector: 'my-map-cmp',
 *  directives: [AgmMap, AgmDataLayer],
 *  styles: [`
 *    .agm-container {
 *      height: 300px;
 *    }
 * `],
 *  template: `
 * <agm-map [latitude]="lat" [longitude]="lng" [zoom]="zoom">
 * 	  <agm-data-layer [geoJson]="geoJsonObject" (layerClick)="clicked($event)" [style]="styleFunc">
 * 	  </agm-data-layer>
 * </agm-map>
 *  `
 * })
 * export class MyMapCmp {
 *   lat: number = -25.274449;
 *   lng: number = 133.775060;
 *   zoom: number = 5;
 *
 * clicked(clickEvent) {
 *    console.log(clickEvent);
 *  }
 *
 *  styleFunc(feature) {
 *    return ({
 *      clickable: false,
 *      fillColor: feature.getProperty('color'),
 *      strokeWeight: 1
 *    });
 *  }
 *
 *  geoJsonObject: Object = {
 *    "type": "FeatureCollection",
 *    "features": [
 *      {
 *        "type": "Feature",
 *        "properties": {
 *          "letter": "G",
 *          "color": "blue",
 *          "rank": "7",
 *          "ascii": "71"
 *        },
 *        "geometry": {
 *          "type": "Polygon",
 *          "coordinates": [
 *            [
 *              [123.61, -22.14], [122.38, -21.73], [121.06, -21.69], [119.66, -22.22], [119.00, -23.40],
 *              [118.65, -24.76], [118.43, -26.07], [118.78, -27.56], [119.22, -28.57], [120.23, -29.49],
 *              [121.77, -29.87], [123.57, -29.64], [124.45, -29.03], [124.71, -27.95], [124.80, -26.70],
 *              [124.80, -25.60], [123.61, -25.64], [122.56, -25.64], [121.72, -25.72], [121.81, -26.62],
 *              [121.86, -26.98], [122.60, -26.90], [123.57, -27.05], [123.57, -27.68], [123.35, -28.18],
 *              [122.51, -28.38], [121.77, -28.26], [121.02, -27.91], [120.49, -27.21], [120.14, -26.50],
 *              [120.10, -25.64], [120.27, -24.52], [120.67, -23.68], [121.72, -23.32], [122.43, -23.48],
 *              [123.04, -24.04], [124.54, -24.28], [124.58, -23.20], [123.61, -22.14]
 *            ]
 *          ]
 *        }
 *      },
 *      {
 *        "type": "Feature",
 *        "properties": {
 *          "letter": "o",
 *          "color": "red",
 *          "rank": "15",
 *          "ascii": "111"
 *        },
 *        "geometry": {
 *          "type": "Polygon",
 *          "coordinates": [
 *            [
 *              [128.84, -25.76], [128.18, -25.60], [127.96, -25.52], [127.88, -25.52], [127.70, -25.60],
 *              [127.26, -25.79], [126.60, -26.11], [126.16, -26.78], [126.12, -27.68], [126.21, -28.42],
 *              [126.69, -29.49], [127.74, -29.80], [128.80, -29.72], [129.41, -29.03], [129.72, -27.95],
 *              [129.68, -27.21], [129.33, -26.23], [128.84, -25.76]
 *            ],
 *            [
 *              [128.45, -27.44], [128.32, -26.94], [127.70, -26.82], [127.35, -27.05], [127.17, -27.80],
 *              [127.57, -28.22], [128.10, -28.42], [128.49, -27.80], [128.45, -27.44]
 *            ]
 *          ]
 *        }
 *      },
 *      {
 *        "type": "Feature",
 *        "properties": {
 *          "letter": "o",
 *          "color": "yellow",
 *          "rank": "15",
 *          "ascii": "111"
 *        },
 *        "geometry": {
 *          "type": "Polygon",
 *          "coordinates": [
 *            [
 *              [131.87, -25.76], [131.35, -26.07], [130.95, -26.78], [130.82, -27.64], [130.86, -28.53],
 *              [131.26, -29.22], [131.92, -29.76], [132.45, -29.87], [133.06, -29.76], [133.72, -29.34],
 *              [134.07, -28.80], [134.20, -27.91], [134.07, -27.21], [133.81, -26.31], [133.37, -25.83],
 *              [132.71, -25.64], [131.87, -25.76]
 *            ],
 *            [
 *              [133.15, -27.17], [132.71, -26.86], [132.09, -26.90], [131.74, -27.56], [131.79, -28.26],
 *              [132.36, -28.45], [132.93, -28.34], [133.15, -27.76], [133.15, -27.17]
 *            ]
 *          ]
 *        }
 *      },
 *      {
 *        "type": "Feature",
 *        "properties": {
 *          "letter": "g",
 *          "color": "blue",
 *          "rank": "7",
 *          "ascii": "103"
 *        },
 *        "geometry": {
 *          "type": "Polygon",
 *          "coordinates": [
 *            [
 *              [138.12, -25.04], [136.84, -25.16], [135.96, -25.36], [135.26, -25.99], [135, -26.90],
 *              [135.04, -27.91], [135.26, -28.88], [136.05, -29.45], [137.02, -29.49], [137.81, -29.49],
 *              [137.94, -29.99], [137.90, -31.20], [137.85, -32.24], [136.88, -32.69], [136.45, -32.36],
 *              [136.27, -31.80], [134.95, -31.84], [135.17, -32.99], [135.52, -33.43], [136.14, -33.76],
 *              [137.06, -33.83], [138.12, -33.65], [138.86, -33.21], [139.30, -32.28], [139.30, -31.24],
 *              [139.30, -30.14], [139.21, -28.96], [139.17, -28.22], [139.08, -27.41], [139.08, -26.47],
 *              [138.99, -25.40], [138.73, -25.00], [138.12, -25.04]
 *            ],
 *            [
 *              [137.50, -26.54], [136.97, -26.47], [136.49, -26.58], [136.31, -27.13], [136.31, -27.72],
 *              [136.58, -27.99], [137.50, -28.03], [137.68, -27.68], [137.59, -26.78], [137.50, -26.54]
 *            ]
 *          ]
 *        }
 *      },
 *      {
 *        "type": "Feature",
 *        "properties": {
 *          "letter": "l",
 *          "color": "green",
 *          "rank": "12",
 *          "ascii": "108"
 *        },
 *        "geometry": {
 *          "type": "Polygon",
 *          "coordinates": [
 *            [
 *              [140.14, -21.04], [140.31, -29.42], [141.67, -29.49], [141.59, -20.92], [140.14, -21.04]
 *            ]
 *          ]
 *        }
 *      },
 *      {
 *        "type": "Feature",
 *        "properties": {
 *          "letter": "e",
 *          "color": "red",
 *          "rank": "5",
 *          "ascii": "101"
 *        },
 *        "geometry": {
 *          "type": "Polygon",
 *          "coordinates": [
 *            [
 *              [144.14, -27.41], [145.67, -27.52], [146.86, -27.09], [146.82, -25.64], [146.25, -25.04],
 *              [145.45, -24.68], [144.66, -24.60], [144.09, -24.76], [143.43, -25.08], [142.99, -25.40],
 *              [142.64, -26.03], [142.64, -27.05], [142.64, -28.26], [143.30, -29.11], [144.18, -29.57],
 *              [145.41, -29.64], [146.46, -29.19], [146.64, -28.72], [146.82, -28.14], [144.84, -28.42],
 *              [144.31, -28.26], [144.14, -27.41]
 *            ],
 *            [
 *              [144.18, -26.39], [144.53, -26.58], [145.19, -26.62], [145.72, -26.35], [145.81, -25.91],
 *              [145.41, -25.68], [144.97, -25.68], [144.49, -25.64], [144, -25.99], [144.18, -26.39]
 *            ]
 *          ]
 *        }
 *      }
 *    ]
 *  };
 * }
 * ```
 */

let AgmDataLayer = AgmDataLayer_1 = class AgmDataLayer {
  constructor(_manager) {
    this._manager = _manager;
    this._addedToManager = false;
    this._id = (layerId$1++).toString();
    this._subscriptions = [];
    /**
     * This event is fired when a feature in the layer is clicked.
     */

    this.layerClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * The geoJson to be displayed
     */

    this.geoJson = null;
  }

  ngOnInit() {
    if (this._addedToManager) {
      return;
    }

    this._manager.addDataLayer(this);

    this._addedToManager = true;

    this._addEventListeners();
  }

  _addEventListeners() {
    const listeners = [{
      name: 'click',
      handler: ev => this.layerClick.emit(ev)
    }];
    listeners.forEach(obj => {
      const os = this._manager.createEventObservable(obj.name, this).subscribe(obj.handler);

      this._subscriptions.push(os);
    });
  }
  /** @internal */


  id() {
    return this._id;
  }
  /** @internal */


  toString() {
    return `AgmDataLayer-${this._id.toString()}`;
  }
  /** @internal */


  ngOnDestroy() {
    this._manager.deleteDataLayer(this); // unsubscribe all registered observable subscriptions


    this._subscriptions.forEach(s => s.unsubscribe());
  }
  /** @internal */


  ngOnChanges(changes) {
    if (!this._addedToManager) {
      return;
    }

    var geoJsonChange = changes['geoJson'];

    if (geoJsonChange) {
      this._manager.updateGeoJson(this, geoJsonChange.currentValue);
    }

    let dataOptions = {};

    AgmDataLayer_1._dataOptionsAttributes.forEach(k => dataOptions[k] = changes.hasOwnProperty(k) ? changes[k].currentValue : this[k]);

    this._manager.setDataOptions(this, dataOptions);
  }

};

AgmDataLayer.ɵfac = function AgmDataLayer_Factory(t) {
  return new (t || AgmDataLayer)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](DataLayerManager));
};

AgmDataLayer.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmDataLayer,
  selectors: [["agm-data-layer"]],
  inputs: {
    geoJson: "geoJson",
    style: "style"
  },
  outputs: {
    layerClick: "layerClick"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
AgmDataLayer._dataOptionsAttributes = ['style'];

AgmDataLayer.ctorParameters = () => [{
  type: DataLayerManager
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmDataLayer.prototype, "layerClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmDataLayer.prototype, "geoJson", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Function)], AgmDataLayer.prototype, "style", void 0);

AgmDataLayer = AgmDataLayer_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [DataLayerManager])], AgmDataLayer);
/**
 * Class to implement when you what to be able to make it work with the auto fit bounds feature
 * of AGM.
 */

class FitBoundsAccessor {}
/**
 * The FitBoundsService is responsible for computing the bounds of the a single map.
 */


let FitBoundsService = /*#__PURE__*/(() => {
  let FitBoundsService = class FitBoundsService {
    constructor(loader) {
      this._boundsChangeSampleTime$ = new rxjs__WEBPACK_IMPORTED_MODULE_3__.BehaviorSubject(200);
      this._includeInBounds$ = new rxjs__WEBPACK_IMPORTED_MODULE_3__.BehaviorSubject(new Map());
      this.bounds$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_4__.from)(loader.load()).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.flatMap)(() => this._includeInBounds$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_6__.sample)(this._boundsChangeSampleTime$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.switchMap)(time => (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.timer)(0, time)))), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.map)(includeInBounds => this._generateBounds(includeInBounds)), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.shareReplay)(1));
    }

    _generateBounds(includeInBounds) {
      const bounds = new google.maps.LatLngBounds();
      includeInBounds.forEach(b => bounds.extend(b));
      return bounds;
    }

    addToBounds(latLng) {
      const id = this._createIdentifier(latLng);

      if (this._includeInBounds$.value.has(id)) {
        return;
      }

      const map = this._includeInBounds$.value;
      map.set(id, latLng);

      this._includeInBounds$.next(map);
    }

    removeFromBounds(latLng) {
      const map = this._includeInBounds$.value;
      map.delete(this._createIdentifier(latLng));

      this._includeInBounds$.next(map);
    }

    changeFitBoundsChangeSampleTime(timeMs) {
      this._boundsChangeSampleTime$.next(timeMs);
    }

    getBounds$() {
      return this.bounds$;
    }

    _createIdentifier(latLng) {
      return `${latLng.lat}+${latLng.lng}`;
    }

  };

  FitBoundsService.ɵfac = function FitBoundsService_Factory(t) {
    return new (t || FitBoundsService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](MapsAPILoader));
  };

  FitBoundsService.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: FitBoundsService,
    factory: function (t) {
      return FitBoundsService.ɵfac(t);
    }
  });
  FitBoundsService = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [MapsAPILoader])], FitBoundsService);
  /**
   * Adds the given directive to the auto fit bounds feature when the value is true.
   * To make it work with you custom AGM component, you also have to implement the {@link FitBoundsAccessor} abstract class.
   * @example
   * <agm-marker [agmFitBounds]="true"></agm-marker>
   */

  return FitBoundsService;
})();
let AgmFitBounds = /*#__PURE__*/(() => {
  let AgmFitBounds = class AgmFitBounds {
    constructor(_fitBoundsAccessor, _fitBoundsService) {
      this._fitBoundsAccessor = _fitBoundsAccessor;
      this._fitBoundsService = _fitBoundsService;
      /**
       * If the value is true, the element gets added to the bounds of the map.
       * Default: true.
       */

      this.agmFitBounds = true;
      this._destroyed$ = new rxjs__WEBPACK_IMPORTED_MODULE_11__.Subject();
      this._latestFitBoundsDetails = null;
    }
    /**
     * @internal
     */


    ngOnChanges() {
      this._updateBounds();
    }
    /**
     * @internal
     */


    ngOnInit() {
      this._fitBoundsAccessor.getFitBoundsDetails$().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_12__.distinctUntilChanged)((x, y) => x.latLng.lat === y.latLng.lat && x.latLng.lng === y.latLng.lng), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_13__.takeUntil)(this._destroyed$)).subscribe(details => this._updateBounds(details));
    }
    /*
     Either the location changed, or visible status changed.
     Possible state changes are
     invisible -> visible
     visible -> invisible
     visible -> visible (new location)
    */


    _updateBounds(newFitBoundsDetails) {
      // either visibility will change, or location, so remove the old one anyway
      if (this._latestFitBoundsDetails) {
        this._fitBoundsService.removeFromBounds(this._latestFitBoundsDetails.latLng); // don't set latestFitBoundsDetails to null, because we can toggle visibility from
        // true -> false -> true, in which case we still need old value cached here

      }

      if (newFitBoundsDetails) {
        this._latestFitBoundsDetails = newFitBoundsDetails;
      }

      if (!this._latestFitBoundsDetails) {
        return;
      }

      if (this.agmFitBounds === true) {
        this._fitBoundsService.addToBounds(this._latestFitBoundsDetails.latLng);
      }
    }
    /**
     * @internal
     */


    ngOnDestroy() {
      this._destroyed$.next();

      this._destroyed$.complete();

      if (this._latestFitBoundsDetails !== null) {
        this._fitBoundsService.removeFromBounds(this._latestFitBoundsDetails.latLng);
      }
    }

  };

  AgmFitBounds.ɵfac = function AgmFitBounds_Factory(t) {
    return new (t || AgmFitBounds)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FitBoundsAccessor, 2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FitBoundsService));
  };

  AgmFitBounds.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: AgmFitBounds,
    selectors: [["", "agmFitBounds", ""]],
    inputs: {
      agmFitBounds: "agmFitBounds"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmFitBounds.prototype, "agmFitBounds", void 0);

  AgmFitBounds = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__param)(0, (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Self)()), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [FitBoundsAccessor, FitBoundsService])], AgmFitBounds);
  return AgmFitBounds;
})();
let MarkerManager = /*#__PURE__*/(() => {
  let MarkerManager = class MarkerManager {
    constructor(_mapsWrapper, _zone) {
      this._mapsWrapper = _mapsWrapper;
      this._zone = _zone;
      this._markers = new Map();
    }

    convertAnimation(uiAnim) {
      return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
        if (uiAnim === null) {
          return null;
        } else {
          return this._mapsWrapper.getNativeMap().then(() => google.maps.Animation[uiAnim]);
        }
      });
    }

    deleteMarker(marker) {
      const m = this._markers.get(marker);

      if (m == null) {
        // marker already deleted
        return Promise.resolve();
      }

      return m.then(m => {
        return this._zone.run(() => {
          m.setMap(null);

          this._markers.delete(marker);
        });
      });
    }

    updateMarkerPosition(marker) {
      return this._markers.get(marker).then(m => m.setPosition({
        lat: marker.latitude,
        lng: marker.longitude
      }));
    }

    updateTitle(marker) {
      return this._markers.get(marker).then(m => m.setTitle(marker.title));
    }

    updateLabel(marker) {
      return this._markers.get(marker).then(m => {
        m.setLabel(marker.label);
      });
    }

    updateDraggable(marker) {
      return this._markers.get(marker).then(m => m.setDraggable(marker.draggable));
    }

    updateIcon(marker) {
      return this._markers.get(marker).then(m => m.setIcon(marker.iconUrl));
    }

    updateOpacity(marker) {
      return this._markers.get(marker).then(m => m.setOpacity(marker.opacity));
    }

    updateVisible(marker) {
      return this._markers.get(marker).then(m => m.setVisible(marker.visible));
    }

    updateZIndex(marker) {
      return this._markers.get(marker).then(m => m.setZIndex(marker.zIndex));
    }

    updateClickable(marker) {
      return this._markers.get(marker).then(m => m.setClickable(marker.clickable));
    }

    updateAnimation(marker) {
      return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
        const m = yield this._markers.get(marker);
        m.setAnimation(yield this.convertAnimation(marker.animation));
      });
    }

    addMarker(marker) {
      const markerPromise = new Promise(resolve => (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
        return this._mapsWrapper.createMarker({
          position: {
            lat: marker.latitude,
            lng: marker.longitude
          },
          label: marker.label,
          draggable: marker.draggable,
          icon: marker.iconUrl,
          opacity: marker.opacity,
          visible: marker.visible,
          zIndex: marker.zIndex,
          title: marker.title,
          clickable: marker.clickable,
          animation: yield this.convertAnimation(marker.animation)
        }).then(resolve);
      }));

      this._markers.set(marker, markerPromise);
    }

    getNativeMarker(marker) {
      return this._markers.get(marker);
    }

    createEventObservable(eventName, marker) {
      return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
        this._markers.get(marker).then(m => {
          m.addListener(eventName, e => this._zone.run(() => observer.next(e)));
        });
      });
    }

  };

  MarkerManager.ɵfac = function MarkerManager_Factory(t) {
    return new (t || MarkerManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  MarkerManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: MarkerManager,
    factory: function (t) {
      return MarkerManager.ɵfac(t);
    }
  });
  MarkerManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], MarkerManager);
  return MarkerManager;
})();
let InfoWindowManager = /*#__PURE__*/(() => {
  let InfoWindowManager = class InfoWindowManager {
    constructor(_mapsWrapper, _zone, _markerManager) {
      this._mapsWrapper = _mapsWrapper;
      this._zone = _zone;
      this._markerManager = _markerManager;
      this._infoWindows = new Map();
    }

    deleteInfoWindow(infoWindow) {
      const iWindow = this._infoWindows.get(infoWindow);

      if (iWindow == null) {
        // info window already deleted
        return Promise.resolve();
      }

      return iWindow.then(i => {
        return this._zone.run(() => {
          i.close();

          this._infoWindows.delete(infoWindow);
        });
      });
    }

    setPosition(infoWindow) {
      return this._infoWindows.get(infoWindow).then(i => i.setPosition({
        lat: infoWindow.latitude,
        lng: infoWindow.longitude
      }));
    }

    setZIndex(infoWindow) {
      return this._infoWindows.get(infoWindow).then(i => i.setZIndex(infoWindow.zIndex));
    }

    open(infoWindow) {
      return this._infoWindows.get(infoWindow).then(w => {
        if (infoWindow.hostMarker != null) {
          return this._markerManager.getNativeMarker(infoWindow.hostMarker).then(marker => {
            return this._mapsWrapper.getNativeMap().then(map => w.open(map, marker));
          });
        }

        return this._mapsWrapper.getNativeMap().then(map => w.open(map));
      });
    }

    close(infoWindow) {
      return this._infoWindows.get(infoWindow).then(w => w.close());
    }

    setOptions(infoWindow, options) {
      return this._infoWindows.get(infoWindow).then(i => i.setOptions(options));
    }

    addInfoWindow(infoWindow) {
      const options = {
        content: infoWindow.content,
        maxWidth: infoWindow.maxWidth,
        zIndex: infoWindow.zIndex,
        disableAutoPan: infoWindow.disableAutoPan
      };

      if (typeof infoWindow.latitude === 'number' && typeof infoWindow.longitude === 'number') {
        options.position = {
          lat: infoWindow.latitude,
          lng: infoWindow.longitude
        };
      }

      const infoWindowPromise = this._mapsWrapper.createInfoWindow(options);

      this._infoWindows.set(infoWindow, infoWindowPromise);
    }
    /**
     * Creates a Google Maps event listener for the given InfoWindow as an Observable
     */


    createEventObservable(eventName, infoWindow) {
      return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
        this._infoWindows.get(infoWindow).then(i => {
          i.addListener(eventName, e => this._zone.run(() => observer.next(e)));
        });
      });
    }

  };

  InfoWindowManager.ɵfac = function InfoWindowManager_Factory(t) {
    return new (t || InfoWindowManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](MarkerManager));
  };

  InfoWindowManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: InfoWindowManager,
    factory: function (t) {
      return InfoWindowManager.ɵfac(t);
    }
  });
  InfoWindowManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone, MarkerManager])], InfoWindowManager);
  return InfoWindowManager;
})();
var AgmInfoWindow_1;
let infoWindowId = 0;
/**
 * AgmInfoWindow renders a info window inside a {@link AgmMarker} or standalone.
 *
 * ### Example
 * ```typescript
 * import { Component } from '@angular/core';
 *
 * @Component({
 *  selector: 'my-map-cmp',
 *  styles: [`
 *    .agm-map-container {
 *      height: 300px;
 *    }
 * `],
 *  template: `
 *    <agm-map [latitude]="lat" [longitude]="lng" [zoom]="zoom">
 *      <agm-marker [latitude]="lat" [longitude]="lng" [label]="'M'">
 *        <agm-info-window [disableAutoPan]="true">
 *          Hi, this is the content of the <strong>info window</strong>
 *        </agm-info-window>
 *      </agm-marker>
 *    </agm-map>
 *  `
 * })
 * ```
 */

let AgmInfoWindow = AgmInfoWindow_1 = class AgmInfoWindow {
  constructor(_infoWindowManager, _el) {
    this._infoWindowManager = _infoWindowManager;
    this._el = _el;
    /**
     * Sets the open state for the InfoWindow. You can also call the open() and close() methods.
     */

    this.isOpen = false;
    /**
     * Emits an event when the info window is closed.
     */

    this.infoWindowClose = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    this._infoWindowAddedToManager = false;
    this._id = (infoWindowId++).toString();
  }

  ngOnInit() {
    this.content = this._el.nativeElement.querySelector('.agm-info-window-content');

    this._infoWindowManager.addInfoWindow(this);

    this._infoWindowAddedToManager = true;

    this._updateOpenState();

    this._registerEventListeners();
  }
  /** @internal */


  ngOnChanges(changes) {
    if (!this._infoWindowAddedToManager) {
      return;
    }

    if ((changes['latitude'] || changes['longitude']) && typeof this.latitude === 'number' && typeof this.longitude === 'number') {
      this._infoWindowManager.setPosition(this);
    }

    if (changes['zIndex']) {
      this._infoWindowManager.setZIndex(this);
    }

    if (changes['isOpen']) {
      this._updateOpenState();
    }

    this._setInfoWindowOptions(changes);
  }

  _registerEventListeners() {
    this._infoWindowManager.createEventObservable('closeclick', this).subscribe(() => {
      this.isOpen = false;
      this.infoWindowClose.emit();
    });
  }

  _updateOpenState() {
    this.isOpen ? this.open() : this.close();
  }

  _setInfoWindowOptions(changes) {
    let options = {};
    let optionKeys = Object.keys(changes).filter(k => AgmInfoWindow_1._infoWindowOptionsInputs.indexOf(k) !== -1);
    optionKeys.forEach(k => {
      options[k] = changes[k].currentValue;
    });

    this._infoWindowManager.setOptions(this, options);
  }
  /**
   * Opens the info window.
   */


  open() {
    return this._infoWindowManager.open(this);
  }
  /**
   * Closes the info window.
   */


  close() {
    return this._infoWindowManager.close(this).then(() => {
      this.infoWindowClose.emit();
    });
  }
  /** @internal */


  id() {
    return this._id;
  }
  /** @internal */


  toString() {
    return 'AgmInfoWindow-' + this._id.toString();
  }
  /** @internal */


  ngOnDestroy() {
    this._infoWindowManager.deleteInfoWindow(this);
  }

};

AgmInfoWindow.ɵfac = function AgmInfoWindow_Factory(t) {
  return new (t || AgmInfoWindow)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](InfoWindowManager), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
};

AgmInfoWindow.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: AgmInfoWindow,
  selectors: [["agm-info-window"]],
  inputs: {
    isOpen: "isOpen",
    latitude: "latitude",
    longitude: "longitude",
    disableAutoPan: "disableAutoPan",
    zIndex: "zIndex",
    maxWidth: "maxWidth"
  },
  outputs: {
    infoWindowClose: "infoWindowClose"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
  ngContentSelectors: _c0,
  decls: 2,
  vars: 0,
  consts: [[1, "agm-info-window-content"]],
  template: function AgmInfoWindow_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](1);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    }
  },
  encapsulation: 2
});
AgmInfoWindow._infoWindowOptionsInputs = ['disableAutoPan', 'maxWidth'];

AgmInfoWindow.ctorParameters = () => [{
  type: InfoWindowManager
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmInfoWindow.prototype, "latitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmInfoWindow.prototype, "longitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Boolean)], AgmInfoWindow.prototype, "disableAutoPan", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmInfoWindow.prototype, "zIndex", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmInfoWindow.prototype, "maxWidth", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmInfoWindow.prototype, "isOpen", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmInfoWindow.prototype, "infoWindowClose", void 0);

AgmInfoWindow = AgmInfoWindow_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [InfoWindowManager, _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef])], AgmInfoWindow);
/**
 * Manages all KML Layers for a Google Map instance.
 */

let KmlLayerManager = /*#__PURE__*/(() => {
  let KmlLayerManager = class KmlLayerManager {
    constructor(_wrapper, _zone) {
      this._wrapper = _wrapper;
      this._zone = _zone;
      this._layers = new Map();
    }
    /**
     * Adds a new KML Layer to the map.
     */


    addKmlLayer(layer) {
      const newLayer = this._wrapper.getNativeMap().then(m => {
        return new google.maps.KmlLayer({
          clickable: layer.clickable,
          map: m,
          preserveViewport: layer.preserveViewport,
          screenOverlays: layer.screenOverlays,
          suppressInfoWindows: layer.suppressInfoWindows,
          url: layer.url,
          zIndex: layer.zIndex
        });
      });

      this._layers.set(layer, newLayer);
    }

    setOptions(layer, options) {
      this._layers.get(layer).then(l => l.setOptions(options));
    }

    deleteKmlLayer(layer) {
      this._layers.get(layer).then(l => {
        l.setMap(null);

        this._layers.delete(layer);
      });
    }
    /**
     * Creates a Google Maps event listener for the given KmlLayer as an Observable
     */


    createEventObservable(eventName, layer) {
      return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
        this._layers.get(layer).then(m => {
          m.addListener(eventName, e => this._zone.run(() => observer.next(e)));
        });
      });
    }

  };

  KmlLayerManager.ɵfac = function KmlLayerManager_Factory(t) {
    return new (t || KmlLayerManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  KmlLayerManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: KmlLayerManager,
    factory: function (t) {
      return KmlLayerManager.ɵfac(t);
    }
  });
  KmlLayerManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], KmlLayerManager);
  return KmlLayerManager;
})();
var AgmKmlLayer_1;
let layerId$2 = 0;
let AgmKmlLayer = AgmKmlLayer_1 = class AgmKmlLayer {
  constructor(_manager) {
    this._manager = _manager;
    this._addedToManager = false;
    this._id = (layerId$2++).toString();
    this._subscriptions = [];
    /**
     * If true, the layer receives mouse events. Default value is true.
     */

    this.clickable = true;
    /**
     * By default, the input map is centered and zoomed to the bounding box of the contents of the
     * layer.
     * If this option is set to true, the viewport is left unchanged, unless the map's center and zoom
     * were never set.
     */

    this.preserveViewport = false;
    /**
     * Whether to render the screen overlays. Default true.
     */

    this.screenOverlays = true;
    /**
     * Suppress the rendering of info windows when layer features are clicked.
     */

    this.suppressInfoWindows = false;
    /**
     * The URL of the KML document to display.
     */

    this.url = null;
    /**
     * The z-index of the layer.
     */

    this.zIndex = null;
    /**
     * This event is fired when a feature in the layer is clicked.
     */

    this.layerClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the KML layers default viewport has changed.
     */

    this.defaultViewportChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the KML layer has finished loading.
     * At this point it is safe to read the status property to determine if the layer loaded
     * successfully.
     */

    this.statusChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
  }

  ngOnInit() {
    if (this._addedToManager) {
      return;
    }

    this._manager.addKmlLayer(this);

    this._addedToManager = true;

    this._addEventListeners();
  }

  ngOnChanges(changes) {
    if (!this._addedToManager) {
      return;
    }

    this._updatePolygonOptions(changes);
  }

  _updatePolygonOptions(changes) {
    const options = Object.keys(changes).filter(k => AgmKmlLayer_1._kmlLayerOptions.indexOf(k) !== -1).reduce((obj, k) => {
      obj[k] = changes[k].currentValue;
      return obj;
    }, {});

    if (Object.keys(options).length > 0) {
      this._manager.setOptions(this, options);
    }
  }

  _addEventListeners() {
    const listeners = [{
      name: 'click',
      handler: ev => this.layerClick.emit(ev)
    }, {
      name: 'defaultviewport_changed',
      handler: () => this.defaultViewportChange.emit()
    }, {
      name: 'status_changed',
      handler: () => this.statusChange.emit()
    }];
    listeners.forEach(obj => {
      const os = this._manager.createEventObservable(obj.name, this).subscribe(obj.handler);

      this._subscriptions.push(os);
    });
  }
  /** @internal */


  id() {
    return this._id;
  }
  /** @internal */


  toString() {
    return `AgmKmlLayer-${this._id.toString()}`;
  }
  /** @internal */


  ngOnDestroy() {
    this._manager.deleteKmlLayer(this); // unsubscribe all registered observable subscriptions


    this._subscriptions.forEach(s => s.unsubscribe());
  }

};

AgmKmlLayer.ɵfac = function AgmKmlLayer_Factory(t) {
  return new (t || AgmKmlLayer)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](KmlLayerManager));
};

AgmKmlLayer.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmKmlLayer,
  selectors: [["agm-kml-layer"]],
  inputs: {
    clickable: "clickable",
    preserveViewport: "preserveViewport",
    screenOverlays: "screenOverlays",
    suppressInfoWindows: "suppressInfoWindows",
    url: "url",
    zIndex: "zIndex"
  },
  outputs: {
    layerClick: "layerClick",
    defaultViewportChange: "defaultViewportChange",
    statusChange: "statusChange"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
AgmKmlLayer._kmlLayerOptions = ['clickable', 'preserveViewport', 'screenOverlays', 'suppressInfoWindows', 'url', 'zIndex'];

AgmKmlLayer.ctorParameters = () => [{
  type: KmlLayerManager
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmKmlLayer.prototype, "clickable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmKmlLayer.prototype, "preserveViewport", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmKmlLayer.prototype, "screenOverlays", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmKmlLayer.prototype, "suppressInfoWindows", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmKmlLayer.prototype, "url", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmKmlLayer.prototype, "zIndex", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmKmlLayer.prototype, "layerClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmKmlLayer.prototype, "defaultViewportChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmKmlLayer.prototype, "statusChange", void 0);

AgmKmlLayer = AgmKmlLayer_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [KmlLayerManager])], AgmKmlLayer);

function createMVCEventObservable(array) {
  const eventNames = ['insert_at', 'remove_at', 'set_at'];
  return (0,rxjs__WEBPACK_IMPORTED_MODULE_14__.fromEventPattern)(handler => eventNames.map(evName => array.addListener(evName, (index, previous) => handler.apply(array, [{
    'newArr': array.getArray(),
    evName,
    index,
    previous
  }]))), (_handler, evListeners) => evListeners.forEach(evListener => evListener.remove()));
}

class MvcArrayMock {
  constructor() {
    this.vals = [];
    this.listeners = {
      'remove_at': [],
      'insert_at': [],
      'set_at': []
    };
  }

  clear() {
    for (let i = this.vals.length - 1; i >= 0; i--) {
      this.removeAt(i);
    }
  }

  getArray() {
    return [...this.vals];
  }

  getAt(i) {
    return this.vals[i];
  }

  getLength() {
    return this.vals.length;
  }

  insertAt(i, elem) {
    this.vals.splice(i, 0, elem);
    this.listeners.insert_at.map(listener => listener(i));
  }

  pop() {
    const deleted = this.vals.pop();
    this.listeners.remove_at.map(listener => listener(this.vals.length, deleted));
    return deleted;
  }

  push(elem) {
    this.vals.push(elem);
    this.listeners.insert_at.map(listener => listener(this.vals.length - 1));
    return this.vals.length;
  }

  removeAt(i) {
    const deleted = this.vals.splice(i, 1)[0];
    this.listeners.remove_at.map(listener => listener(i, deleted));
    return deleted;
  }

  setAt(i, elem) {
    const deleted = this.vals[i];
    this.vals[i] = elem;
    this.listeners.set_at.map(listener => listener(i, deleted));
  }

  forEach(callback) {
    this.vals.forEach(callback);
  }

  addListener(eventName, handler) {
    const listenerArr = this.listeners[eventName];
    listenerArr.push(handler);
    return {
      remove: () => {
        listenerArr.splice(listenerArr.indexOf(handler), 1);
      }
    };
  }

}

let PolygonManager = /*#__PURE__*/(() => {
  let PolygonManager = class PolygonManager {
    constructor(_mapsWrapper, _zone) {
      this._mapsWrapper = _mapsWrapper;
      this._zone = _zone;
      this._polygons = new Map();
    }

    addPolygon(path) {
      const polygonPromise = this._mapsWrapper.createPolygon({
        clickable: path.clickable,
        draggable: path.draggable,
        editable: path.editable,
        fillColor: path.fillColor,
        fillOpacity: path.fillOpacity,
        geodesic: path.geodesic,
        paths: path.paths,
        strokeColor: path.strokeColor,
        strokeOpacity: path.strokeOpacity,
        strokeWeight: path.strokeWeight,
        visible: path.visible,
        zIndex: path.zIndex
      });

      this._polygons.set(path, polygonPromise);
    }

    updatePolygon(polygon) {
      const m = this._polygons.get(polygon);

      if (m == null) {
        return Promise.resolve();
      }

      return m.then(l => this._zone.run(() => {
        l.setPaths(polygon.paths);
      }));
    }

    setPolygonOptions(path, options) {
      return this._polygons.get(path).then(l => {
        l.setOptions(options);
      });
    }

    deletePolygon(paths) {
      const m = this._polygons.get(paths);

      if (m == null) {
        return Promise.resolve();
      }

      return m.then(l => {
        return this._zone.run(() => {
          l.setMap(null);

          this._polygons.delete(paths);
        });
      });
    }

    getPath(polygon) {
      return this._polygons.get(polygon).then(polygon => polygon.getPath().getArray());
    }

    getPaths(polygon) {
      return this._polygons.get(polygon).then(polygon => polygon.getPaths().getArray().map(p => p.getArray()));
    }

    createEventObservable(eventName, path) {
      return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
        this._polygons.get(path).then(l => {
          l.addListener(eventName, e => this._zone.run(() => observer.next(e)));
        });
      });
    }

    createPathEventObservable(agmPolygon) {
      return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
        const polygon = yield this._polygons.get(agmPolygon);
        const paths = polygon.getPaths();
        const pathsChanges$ = createMVCEventObservable(paths);
        return pathsChanges$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_15__.startWith)({
          newArr: paths.getArray()
        }), // in order to subscribe to them all
        (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.switchMap)(parentMVEvent => (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.merge)(... // rest parameter
        parentMVEvent.newArr.map((chMVC, index) => createMVCEventObservable(chMVC).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.map)(chMVCEvent => ({
          parentMVEvent,
          chMVCEvent,
          pathIndex: index
        }))))).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_15__.startWith)({
          parentMVEvent,
          chMVCEvent: null,
          pathIndex: null
        }))), // start the merged ob with an event signinifing change to parent
        (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.skip)(1), // skip the manually added event
        (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.map)(({
          parentMVEvent,
          chMVCEvent,
          pathIndex
        }) => {
          let retVal;

          if (!chMVCEvent) {
            retVal = {
              newArr: parentMVEvent.newArr.map(subArr => subArr.getArray().map(latLng => latLng.toJSON())),
              eventName: parentMVEvent.evName,
              index: parentMVEvent.index
            };

            if (parentMVEvent.previous) {
              retVal.previous = parentMVEvent.previous.getArray();
            }
          } else {
            retVal = {
              newArr: parentMVEvent.newArr.map(subArr => subArr.getArray().map(latLng => latLng.toJSON())),
              pathIndex,
              eventName: chMVCEvent.evName,
              index: chMVCEvent.index
            };

            if (chMVCEvent.previous) {
              retVal.previous = chMVCEvent.previous;
            }
          }

          return retVal;
        }));
      });
    }

  };

  PolygonManager.ɵfac = function PolygonManager_Factory(t) {
    return new (t || PolygonManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  PolygonManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: PolygonManager,
    factory: function (t) {
      return PolygonManager.ɵfac(t);
    }
  });
  PolygonManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], PolygonManager);
  return PolygonManager;
})();
var PolylineManager_1;
let PolylineManager = PolylineManager_1 = class PolylineManager {
  constructor(_mapsWrapper, _zone) {
    this._mapsWrapper = _mapsWrapper;
    this._zone = _zone;
    this._polylines = new Map();
  }

  static _convertPoints(line) {
    const path = line._getPoints().map(point => {
      return {
        lat: point.latitude,
        lng: point.longitude
      };
    });

    return path;
  }

  static _convertPath(path) {
    const symbolPath = google.maps.SymbolPath[path];

    if (typeof symbolPath === 'number') {
      return symbolPath;
    } else {
      return path;
    }
  }

  static _convertIcons(line) {
    const icons = line._getIcons().map(agmIcon => ({
      fixedRotation: agmIcon.fixedRotation,
      offset: agmIcon.offset,
      repeat: agmIcon.repeat,
      icon: {
        anchor: new google.maps.Point(agmIcon.anchorX, agmIcon.anchorY),
        fillColor: agmIcon.fillColor,
        fillOpacity: agmIcon.fillOpacity,
        path: PolylineManager_1._convertPath(agmIcon.path),
        rotation: agmIcon.rotation,
        scale: agmIcon.scale,
        strokeColor: agmIcon.strokeColor,
        strokeOpacity: agmIcon.strokeOpacity,
        strokeWeight: agmIcon.strokeWeight
      }
    })); // prune undefineds;


    icons.forEach(icon => {
      Object.entries(icon).forEach(([key, val]) => {
        if (typeof val === 'undefined') {
          delete icon[key];
        }
      });

      if (typeof icon.icon.anchor.x === 'undefined' || typeof icon.icon.anchor.y === 'undefined') {
        delete icon.icon.anchor;
      }
    });
    return icons;
  }

  addPolyline(line) {
    const polylinePromise = this._mapsWrapper.getNativeMap().then(() => [PolylineManager_1._convertPoints(line), PolylineManager_1._convertIcons(line)]).then(([path, icons]) => this._mapsWrapper.createPolyline({
      clickable: line.clickable,
      draggable: line.draggable,
      editable: line.editable,
      geodesic: line.geodesic,
      strokeColor: line.strokeColor,
      strokeOpacity: line.strokeOpacity,
      strokeWeight: line.strokeWeight,
      visible: line.visible,
      zIndex: line.zIndex,
      path: path,
      icons: icons
    }));

    this._polylines.set(line, polylinePromise);
  }

  updatePolylinePoints(line) {
    const path = PolylineManager_1._convertPoints(line);

    const m = this._polylines.get(line);

    if (m == null) {
      return Promise.resolve();
    }

    return m.then(l => {
      return this._zone.run(() => {
        l.setPath(path);
      });
    });
  }

  updateIconSequences(line) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
      yield this._mapsWrapper.getNativeMap();

      const icons = PolylineManager_1._convertIcons(line);

      const m = this._polylines.get(line);

      if (m == null) {
        return;
      }

      return m.then(l => this._zone.run(() => l.setOptions({
        icons: icons
      })));
    });
  }

  setPolylineOptions(line, options) {
    return this._polylines.get(line).then(l => {
      l.setOptions(options);
    });
  }

  deletePolyline(line) {
    const m = this._polylines.get(line);

    if (m == null) {
      return Promise.resolve();
    }

    return m.then(l => {
      return this._zone.run(() => {
        l.setMap(null);

        this._polylines.delete(line);
      });
    });
  }

  getMVCPath(agmPolyline) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
      const polyline = yield this._polylines.get(agmPolyline);
      return polyline.getPath();
    });
  }

  getPath(agmPolyline) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
      return (yield this.getMVCPath(agmPolyline)).getArray();
    });
  }

  createEventObservable(eventName, line) {
    return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
      this._polylines.get(line).then(l => {
        l.addListener(eventName, e => this._zone.run(() => observer.next(e)));
      });
    });
  }

  createPathEventObservable(line) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
      const mvcPath = yield this.getMVCPath(line);
      return createMVCEventObservable(mvcPath);
    });
  }

};

PolylineManager.ɵfac = function PolylineManager_Factory(t) {
  return new (t || PolylineManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
};

PolylineManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
  token: PolylineManager,
  factory: function (t) {
    return PolylineManager.ɵfac(t);
  }
});

PolylineManager.ctorParameters = () => [{
  type: GoogleMapsAPIWrapper
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone
}];

PolylineManager = PolylineManager_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], PolylineManager);
let RectangleManager = /*#__PURE__*/(() => {
  let RectangleManager = class RectangleManager {
    constructor(_apiWrapper, _zone) {
      this._apiWrapper = _apiWrapper;
      this._zone = _zone;
      this._rectangles = new Map();
    }

    addRectangle(rectangle) {
      this._rectangles.set(rectangle, this._apiWrapper.createRectangle({
        bounds: {
          north: rectangle.north,
          east: rectangle.east,
          south: rectangle.south,
          west: rectangle.west
        },
        clickable: rectangle.clickable,
        draggable: rectangle.draggable,
        editable: rectangle.editable,
        fillColor: rectangle.fillColor,
        fillOpacity: rectangle.fillOpacity,
        strokeColor: rectangle.strokeColor,
        strokeOpacity: rectangle.strokeOpacity,
        strokePosition: rectangle.strokePosition,
        strokeWeight: rectangle.strokeWeight,
        visible: rectangle.visible,
        zIndex: rectangle.zIndex
      }));
    }
    /**
     * Removes the given rectangle from the map.
     */


    removeRectangle(rectangle) {
      return this._rectangles.get(rectangle).then(r => {
        r.setMap(null);

        this._rectangles.delete(rectangle);
      });
    }

    setOptions(rectangle, options) {
      return this._rectangles.get(rectangle).then(r => r.setOptions(options));
    }

    getBounds(rectangle) {
      return this._rectangles.get(rectangle).then(r => r.getBounds());
    }

    setBounds(rectangle) {
      return this._rectangles.get(rectangle).then(r => {
        return r.setBounds({
          north: rectangle.north,
          east: rectangle.east,
          south: rectangle.south,
          west: rectangle.west
        });
      });
    }

    setEditable(rectangle) {
      return this._rectangles.get(rectangle).then(r => {
        return r.setEditable(rectangle.editable);
      });
    }

    setDraggable(rectangle) {
      return this._rectangles.get(rectangle).then(r => {
        return r.setDraggable(rectangle.draggable);
      });
    }

    setVisible(rectangle) {
      return this._rectangles.get(rectangle).then(r => {
        return r.setVisible(rectangle.visible);
      });
    }

    createEventObservable(eventName, rectangle) {
      return rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable.create(observer => {
        let listener = null;

        this._rectangles.get(rectangle).then(r => {
          listener = r.addListener(eventName, e => this._zone.run(() => observer.next(e)));
        });

        return () => {
          if (listener !== null) {
            listener.remove();
          }
        };
      });
    }

  };

  RectangleManager.ɵfac = function RectangleManager_Factory(t) {
    return new (t || RectangleManager)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  RectangleManager.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: RectangleManager,
    factory: function (t) {
      return RectangleManager.ɵfac(t);
    }
  });
  RectangleManager = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [GoogleMapsAPIWrapper, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], RectangleManager);
  return RectangleManager;
})();
var AgmMap_1;
/**
 * AgmMap renders a Google Map.
 * **Important note**: To be able see a map in the browser, you have to define a height for the
 * element `agm-map`.
 *
 * ### Example
 * ```typescript
 * import { Component } from '@angular/core';
 *
 * @Component({
 *  selector: 'my-map-cmp',
 *  styles: [`
 *    agm-map {
 *      height: 300px;
 *    }
 * `],
 *  template: `
 *    <agm-map [latitude]="lat" [longitude]="lng" [zoom]="zoom">
 *    </agm-map>
 *  `
 * })
 * ```
 */

let AgmMap = AgmMap_1 = class AgmMap {
  constructor(_elem, _mapsWrapper, _platformId, _fitBoundsService, _zone) {
    this._elem = _elem;
    this._mapsWrapper = _mapsWrapper;
    this._platformId = _platformId;
    this._fitBoundsService = _fitBoundsService;
    this._zone = _zone;
    /**
     * The longitude that defines the center of the map.
     */

    this.longitude = 0;
    /**
     * The latitude that defines the center of the map.
     */

    this.latitude = 0;
    /**
     * The zoom level of the map. The default zoom level is 8.
     */

    this.zoom = 8;
    /**
     * Enables/disables if map is draggable.
     */
    // tslint:disable-next-line:no-input-rename

    this.draggable = true;
    /**
     * Enables/disables zoom and center on double click. Enabled by default.
     */

    this.disableDoubleClickZoom = false;
    /**
     * Enables/disables all default UI of the Google map. Please note: When the map is created, this
     * value cannot get updated.
     */

    this.disableDefaultUI = false;
    /**
     * If false, disables scrollwheel zooming on the map. The scrollwheel is enabled by default.
     */

    this.scrollwheel = true;
    /**
     * If false, prevents the map from being controlled by the keyboard. Keyboard shortcuts are
     * enabled by default.
     */

    this.keyboardShortcuts = true;
    /**
     * Styles to apply to each of the default map types. Note that for Satellite/Hybrid and Terrain
     * modes, these styles will only apply to labels and geometry.
     */

    this.styles = [];
    /**
     * When true and the latitude and/or longitude values changes, the Google Maps panTo method is
     * used to
     * center the map. See: https://developers.google.com/maps/documentation/javascript/reference#Map
     */

    this.usePanning = false;
    /**
     * Sets the viewport to contain the given bounds.
     * If this option to `true`, the bounds get automatically computed from all elements that use the {@link AgmFitBounds} directive.
     */

    this.fitBounds = false;
    /**
     * The initial enabled/disabled state of the Scale control. This is disabled by default.
     */

    this.scaleControl = false;
    /**
     * The initial enabled/disabled state of the Map type control.
     */

    this.mapTypeControl = false;
    /**
     * The initial enabled/disabled state of the Pan control.
     */

    this.panControl = false;
    /**
     * The initial enabled/disabled state of the Rotate control.
     */

    this.rotateControl = false;
    /**
     * The initial enabled/disabled state of the Fullscreen control.
     */

    this.fullscreenControl = false;
    /**
     * The map mapTypeId. Defaults to 'roadmap'.
     */

    this.mapTypeId = 'roadmap';
    /**
     * When false, map icons are not clickable. A map icon represents a point of interest,
     * also known as a POI. By default map icons are clickable.
     */

    this.clickableIcons = true;
    /**
     * A map icon represents a point of interest, also known as a POI.
     * When map icons are clickable by default, an info window is displayed.
     * When this property is set to false, the info window will not be shown but the click event
     * will still fire
     */

    this.showDefaultInfoWindow = true;
    /**
     * This setting controls how gestures on the map are handled.
     * Allowed values:
     * - 'cooperative' (Two-finger touch gestures pan and zoom the map. One-finger touch gestures are not handled by the map.)
     * - 'greedy'      (All touch gestures pan or zoom the map.)
     * - 'none'        (The map cannot be panned or zoomed by user gestures.)
     * - 'auto'        [default] (Gesture handling is either cooperative or greedy, depending on whether the page is scrollable or not.
     */

    this.gestureHandling = 'auto';
    /**
     * Controls the automatic switching behavior for the angle of incidence of
     * the map. The only allowed values are 0 and 45. The value 0 causes the map
     * to always use a 0° overhead view regardless of the zoom level and
     * viewport. The value 45 causes the tilt angle to automatically switch to
     * 45 whenever 45° imagery is available for the current zoom level and
     * viewport, and switch back to 0 whenever 45° imagery is not available
     * (this is the default behavior). 45° imagery is only available for
     * satellite and hybrid map types, within some locations, and at some zoom
     * levels. Note: getTilt returns the current tilt angle, not the value
     * specified by this option. Because getTilt and this option refer to
     * different things, do not bind() the tilt property; doing so may yield
     * unpredictable effects. (Default of AGM is 0 (disabled). Enable it with value 45.)
     */

    this.tilt = 0;
    this._observableSubscriptions = [];
    /**
     * This event emitter gets emitted when the user clicks on the map (but not when they click on a
     * marker or infoWindow).
     */

    this.mapClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user right-clicks on the map (but not when they click
     * on a marker or infoWindow).
     */

    this.mapRightClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user double-clicks on the map (but not when they click
     * on a marker or infoWindow).
     */

    this.mapDblClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter is fired when the map center changes.
     */

    this.centerChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the viewport bounds have changed.
     */

    this.boundsChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the mapTypeId property changes.
     */

    this.mapTypeIdChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the map becomes idle after panning or zooming.
     */

    this.idle = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the zoom level has changed.
     */

    this.zoomChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the google map is fully initialized.
     * You get the google.maps.Map instance as a result of this EventEmitter.
     */

    this.mapReady = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the visible tiles have finished loading.
     */

    this.tilesLoaded = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
  }
  /** @internal */


  ngOnInit() {
    if ((0,_angular_common__WEBPACK_IMPORTED_MODULE_18__.isPlatformServer)(this._platformId)) {
      // The code is running on the server, do nothing
      return;
    } // todo: this should be solved with a new component and a viewChild decorator


    const container = this._elem.nativeElement.querySelector('.agm-map-container-inner');

    this._initMapInstance(container);
  }

  _initMapInstance(el) {
    this._mapsWrapper.createMap(el, {
      center: {
        lat: this.latitude || 0,
        lng: this.longitude || 0
      },
      zoom: this.zoom,
      minZoom: this.minZoom,
      maxZoom: this.maxZoom,
      controlSize: this.controlSize,
      disableDefaultUI: this.disableDefaultUI,
      disableDoubleClickZoom: this.disableDoubleClickZoom,
      scrollwheel: this.scrollwheel,
      backgroundColor: this.backgroundColor,
      draggable: this.draggable,
      draggableCursor: this.draggableCursor,
      draggingCursor: this.draggingCursor,
      keyboardShortcuts: this.keyboardShortcuts,
      styles: this.styles,
      zoomControl: this.zoomControl,
      zoomControlOptions: this.zoomControlOptions,
      streetViewControl: this.streetViewControl,
      streetViewControlOptions: this.streetViewControlOptions,
      scaleControl: this.scaleControl,
      scaleControlOptions: this.scaleControlOptions,
      mapTypeControl: this.mapTypeControl,
      mapTypeControlOptions: this.mapTypeControlOptions,
      panControl: this.panControl,
      panControlOptions: this.panControlOptions,
      rotateControl: this.rotateControl,
      rotateControlOptions: this.rotateControlOptions,
      fullscreenControl: this.fullscreenControl,
      fullscreenControlOptions: this.fullscreenControlOptions,
      mapTypeId: this.mapTypeId,
      clickableIcons: this.clickableIcons,
      gestureHandling: this.gestureHandling,
      tilt: this.tilt,
      restriction: this.restriction
    }).then(() => this._mapsWrapper.getNativeMap()).then(map => this.mapReady.emit(map)); // register event listeners


    this._handleMapCenterChange();

    this._handleMapZoomChange();

    this._handleMapMouseEvents();

    this._handleBoundsChange();

    this._handleMapTypeIdChange();

    this._handleTilesLoadedEvent();

    this._handleIdleEvent();
  }
  /** @internal */


  ngOnDestroy() {
    // unsubscribe all registered observable subscriptions
    this._observableSubscriptions.forEach(s => s.unsubscribe()); // remove all listeners from the map instance


    this._mapsWrapper.clearInstanceListeners();

    if (this._fitBoundsSubscription) {
      this._fitBoundsSubscription.unsubscribe();
    }
  }
  /* @internal */


  ngOnChanges(changes) {
    this._updateMapOptionsChanges(changes);

    this._updatePosition(changes);
  }

  _updateMapOptionsChanges(changes) {
    let options = {};
    let optionKeys = Object.keys(changes).filter(k => AgmMap_1._mapOptionsAttributes.indexOf(k) !== -1);
    optionKeys.forEach(k => {
      options[k] = changes[k].currentValue;
    });

    this._mapsWrapper.setMapOptions(options);
  }
  /**
   * Triggers a resize event on the google map instance.
   * When recenter is true, the of the google map gets called with the current lat/lng values or fitBounds value to recenter the map.
   * Returns a promise that gets resolved after the event was triggered.
   */


  triggerResize(recenter = true) {
    // Note: When we would trigger the resize event and show the map in the same turn (which is a
    // common case for triggering a resize event), then the resize event would not
    // work (to show the map), so we trigger the event in a timeout.
    return new Promise(resolve => {
      setTimeout(() => {
        return this._mapsWrapper.triggerMapEvent('resize').then(() => {
          if (recenter) {
            this.fitBounds != null ? this._fitBounds() : this._setCenter();
          }

          resolve();
        });
      });
    });
  }

  _updatePosition(changes) {
    if (changes['latitude'] == null && changes['longitude'] == null && !changes['fitBounds']) {
      // no position update needed
      return;
    } // we prefer fitBounds in changes


    if ('fitBounds' in changes) {
      this._fitBounds();

      return;
    }

    if (typeof this.latitude !== 'number' || typeof this.longitude !== 'number') {
      return;
    }

    this._setCenter();
  }

  _setCenter() {
    let newCenter = {
      lat: this.latitude,
      lng: this.longitude
    };

    if (this.usePanning) {
      this._mapsWrapper.panTo(newCenter);
    } else {
      this._mapsWrapper.setCenter(newCenter);
    }
  }

  _fitBounds() {
    switch (this.fitBounds) {
      case true:
        this._subscribeToFitBoundsUpdates();

        break;

      case false:
        if (this._fitBoundsSubscription) {
          this._fitBoundsSubscription.unsubscribe();
        }

        break;

      default:
        this._updateBounds(this.fitBounds, this.fitBoundsPadding);

    }
  }

  _subscribeToFitBoundsUpdates() {
    this._zone.runOutsideAngular(() => {
      this._fitBoundsSubscription = this._fitBoundsService.getBounds$().subscribe(b => {
        this._zone.run(() => this._updateBounds(b, this.fitBoundsPadding));
      });
    });
  }

  _updateBounds(bounds, padding) {
    if (!bounds) {
      return;
    }

    if (this._isLatLngBoundsLiteral(bounds) && typeof google !== 'undefined' && google && google.maps && google.maps.LatLngBounds) {
      const newBounds = new google.maps.LatLngBounds();
      newBounds.union(bounds);
      bounds = newBounds;
    }

    if (this.usePanning) {
      this._mapsWrapper.panToBounds(bounds, padding);

      return;
    }

    this._mapsWrapper.fitBounds(bounds, padding);
  }

  _isLatLngBoundsLiteral(bounds) {
    return bounds != null && bounds.extend === undefined;
  }

  _handleMapCenterChange() {
    const s = this._mapsWrapper.subscribeToMapEvent('center_changed').subscribe(() => {
      this._mapsWrapper.getCenter().then(center => {
        this.latitude = center.lat();
        this.longitude = center.lng();
        this.centerChange.emit({
          lat: this.latitude,
          lng: this.longitude
        });
      });
    });

    this._observableSubscriptions.push(s);
  }

  _handleBoundsChange() {
    const s = this._mapsWrapper.subscribeToMapEvent('bounds_changed').subscribe(() => {
      this._mapsWrapper.getBounds().then(bounds => {
        this.boundsChange.emit(bounds);
      });
    });

    this._observableSubscriptions.push(s);
  }

  _handleMapTypeIdChange() {
    const s = this._mapsWrapper.subscribeToMapEvent('maptypeid_changed').subscribe(() => {
      this._mapsWrapper.getMapTypeId().then(mapTypeId => {
        this.mapTypeIdChange.emit(mapTypeId);
      });
    });

    this._observableSubscriptions.push(s);
  }

  _handleMapZoomChange() {
    const s = this._mapsWrapper.subscribeToMapEvent('zoom_changed').subscribe(() => {
      this._mapsWrapper.getZoom().then(z => {
        this.zoom = z;
        this.zoomChange.emit(z);
      });
    });

    this._observableSubscriptions.push(s);
  }

  _handleIdleEvent() {
    const s = this._mapsWrapper.subscribeToMapEvent('idle').subscribe(() => {
      this.idle.emit(void 0);
    });

    this._observableSubscriptions.push(s);
  }

  _handleTilesLoadedEvent() {
    const s = this._mapsWrapper.subscribeToMapEvent('tilesloaded').subscribe(() => this.tilesLoaded.emit(void 0));

    this._observableSubscriptions.push(s);
  }

  _handleMapMouseEvents() {
    const events = [{
      name: 'click',
      emitter: this.mapClick
    }, {
      name: 'rightclick',
      emitter: this.mapRightClick
    }, {
      name: 'dblclick',
      emitter: this.mapDblClick
    }];
    events.forEach(e => {
      const s = this._mapsWrapper.subscribeToMapEvent(e.name).subscribe(event => {
        let value = {
          coords: {
            lat: event.latLng.lat(),
            lng: event.latLng.lng()
          },
          placeId: event.placeId
        }; // the placeId will be undefined in case the event was not an IconMouseEvent (google types)

        if (value.placeId && !this.showDefaultInfoWindow) {
          event.stop();
        }

        e.emitter.emit(value);
      });

      this._observableSubscriptions.push(s);
    });
  }

};

AgmMap.ɵfac = function AgmMap_Factory(t) {
  return new (t || AgmMap)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](GoogleMapsAPIWrapper), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.PLATFORM_ID), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](FitBoundsService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
};

AgmMap.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
  type: AgmMap,
  selectors: [["agm-map"]],
  hostVars: 2,
  hostBindings: function AgmMap_HostBindings(rf, ctx) {
    if (rf & 2) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("sebm-google-map-container", true);
    }
  },
  inputs: {
    longitude: "longitude",
    latitude: "latitude",
    zoom: "zoom",
    draggable: ["mapDraggable", "draggable"],
    disableDoubleClickZoom: "disableDoubleClickZoom",
    disableDefaultUI: "disableDefaultUI",
    scrollwheel: "scrollwheel",
    keyboardShortcuts: "keyboardShortcuts",
    styles: "styles",
    usePanning: "usePanning",
    fitBounds: "fitBounds",
    scaleControl: "scaleControl",
    mapTypeControl: "mapTypeControl",
    panControl: "panControl",
    rotateControl: "rotateControl",
    fullscreenControl: "fullscreenControl",
    mapTypeId: "mapTypeId",
    clickableIcons: "clickableIcons",
    showDefaultInfoWindow: "showDefaultInfoWindow",
    gestureHandling: "gestureHandling",
    tilt: "tilt",
    minZoom: "minZoom",
    maxZoom: "maxZoom",
    controlSize: "controlSize",
    backgroundColor: "backgroundColor",
    draggableCursor: "draggableCursor",
    draggingCursor: "draggingCursor",
    zoomControl: "zoomControl",
    zoomControlOptions: "zoomControlOptions",
    streetViewControl: "streetViewControl",
    streetViewControlOptions: "streetViewControlOptions",
    fitBoundsPadding: "fitBoundsPadding",
    scaleControlOptions: "scaleControlOptions",
    mapTypeControlOptions: "mapTypeControlOptions",
    panControlOptions: "panControlOptions",
    rotateControlOptions: "rotateControlOptions",
    fullscreenControlOptions: "fullscreenControlOptions",
    restriction: "restriction"
  },
  outputs: {
    mapClick: "mapClick",
    mapRightClick: "mapRightClick",
    mapDblClick: "mapDblClick",
    centerChange: "centerChange",
    boundsChange: "boundsChange",
    mapTypeIdChange: "mapTypeIdChange",
    idle: "idle",
    zoomChange: "zoomChange",
    mapReady: "mapReady",
    tilesLoaded: "tilesLoaded"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([CircleManager, DataLayerManager, DataLayerManager, FitBoundsService, GoogleMapsAPIWrapper, InfoWindowManager, KmlLayerManager, LayerManager, MarkerManager, PolygonManager, PolylineManager, RectangleManager]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
  ngContentSelectors: _c0,
  decls: 3,
  vars: 0,
  consts: [[1, "agm-map-container-inner", "sebm-google-map-container-inner"], [1, "agm-map-content"]],
  template: function AgmMap_Template(rf, ctx) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 0);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](2);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    }
  },
  styles: [".agm-map-container-inner[_ngcontent-%COMP%] {\n      width: inherit;\n      height: inherit;\n    }\n    .agm-map-content[_ngcontent-%COMP%] {\n      display:none;\n    }"]
});
/**
 * Map option attributes that can change over time
 */

AgmMap._mapOptionsAttributes = ['disableDoubleClickZoom', 'scrollwheel', 'draggable', 'draggableCursor', 'draggingCursor', 'keyboardShortcuts', 'zoomControl', 'zoomControlOptions', 'styles', 'streetViewControl', 'streetViewControlOptions', 'zoom', 'mapTypeControl', 'mapTypeControlOptions', 'minZoom', 'maxZoom', 'panControl', 'panControlOptions', 'rotateControl', 'rotateControlOptions', 'fullscreenControl', 'fullscreenControlOptions', 'scaleControl', 'scaleControlOptions', 'mapTypeId', 'clickableIcons', 'gestureHandling', 'tilt', 'restriction'];

AgmMap.ctorParameters = () => [{
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef
}, {
  type: GoogleMapsAPIWrapper
}, {
  type: Object,
  decorators: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.Inject,
    args: [_angular_core__WEBPACK_IMPORTED_MODULE_0__.PLATFORM_ID]
  }]
}, {
  type: FitBoundsService
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "longitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "latitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "zoom", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmMap.prototype, "minZoom", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmMap.prototype, "maxZoom", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmMap.prototype, "controlSize", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('mapDraggable'), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "draggable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "disableDoubleClickZoom", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "disableDefaultUI", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "scrollwheel", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMap.prototype, "backgroundColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMap.prototype, "draggableCursor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMap.prototype, "draggingCursor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "keyboardShortcuts", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Boolean)], AgmMap.prototype, "zoomControl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "zoomControlOptions", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Array)], AgmMap.prototype, "styles", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "usePanning", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Boolean)], AgmMap.prototype, "streetViewControl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "streetViewControlOptions", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "fitBounds", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "fitBoundsPadding", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "scaleControl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "scaleControlOptions", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "mapTypeControl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "mapTypeControlOptions", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "panControl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "panControlOptions", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "rotateControl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "rotateControlOptions", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "fullscreenControl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "fullscreenControlOptions", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMap.prototype, "mapTypeId", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "clickableIcons", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "showDefaultInfoWindow", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMap.prototype, "gestureHandling", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "tilt", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMap.prototype, "restriction", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "mapClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "mapRightClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "mapDblClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "centerChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "boundsChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "mapTypeIdChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "idle", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "zoomChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "mapReady", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMap.prototype, "tilesLoaded", void 0);

AgmMap = AgmMap_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__param)(2, (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Inject)(_angular_core__WEBPACK_IMPORTED_MODULE_0__.PLATFORM_ID)), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef, GoogleMapsAPIWrapper, Object, FitBoundsService, _angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone])], AgmMap);
var AgmMarker_1;
let markerId = 0;
/**
 * AgmMarker renders a map marker inside a {@link AgmMap}.
 *
 * ### Example
 * ```typescript
 * import { Component } from '@angular/core';
 *
 * @Component({
 *  selector: 'my-map-cmp',
 *  styles: [`
 *    .agm-map-container {
 *      height: 300px;
 *    }
 * `],
 *  template: `
 *    <agm-map [latitude]="lat" [longitude]="lng" [zoom]="zoom">
 *      <agm-marker [latitude]="lat" [longitude]="lng" [label]="'M'">
 *      </agm-marker>
 *    </agm-map>
 *  `
 * })
 * ```
 */

let AgmMarker = AgmMarker_1 = class AgmMarker {
  constructor(_markerManager) {
    this._markerManager = _markerManager;
    /**
     * If true, the marker can be dragged. Default value is false.
     */
    // tslint:disable-next-line:no-input-rename

    this.draggable = false;
    /**
     * If true, the marker is visible
     */

    this.visible = true;
    /**
     * Whether to automatically open the child info window when the marker is clicked.
     */

    this.openInfoWindow = true;
    /**
     * The marker's opacity between 0.0 and 1.0.
     */

    this.opacity = 1;
    /**
     * All markers are displayed on the map in order of their zIndex, with higher values displaying in
     * front of markers with lower values. By default, markers are displayed according to their
     * vertical position on screen, with lower markers appearing in front of markers further up the
     * screen.
     */

    this.zIndex = 1;
    /**
     * If true, the marker can be clicked. Default value is true.
     */
    // tslint:disable-next-line:no-input-rename

    this.clickable = true;
    /**
     * This event is fired when the marker's animation property changes.
     *
     * @memberof AgmMarker
     */

    this.animationChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user clicks on the marker.
     */

    this.markerClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user clicks twice on the marker.
     */

    this.markerDblClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user rightclicks on the marker.
     */

    this.markerRightClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user starts dragging the marker.
     */

    this.dragStart = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is repeatedly fired while the user drags the marker.
     */

    this.drag = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user stops dragging the marker.
     */

    this.dragEnd = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user mouses over the marker.
     */

    this.mouseOver = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user mouses outside the marker.
     */

    this.mouseOut = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /** @internal */

    this.infoWindow = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.QueryList();
    this._markerAddedToManger = false;
    this._observableSubscriptions = [];
    this._fitBoundsDetails$ = new rxjs__WEBPACK_IMPORTED_MODULE_19__.ReplaySubject(1);
    this._id = (markerId++).toString();
  }
  /* @internal */


  ngAfterContentInit() {
    this.handleInfoWindowUpdate();
    this.infoWindow.changes.subscribe(() => this.handleInfoWindowUpdate());
  }

  handleInfoWindowUpdate() {
    if (this.infoWindow.length > 1) {
      throw new Error('Expected no more than one info window.');
    }

    this.infoWindow.forEach(marker => {
      marker.hostMarker = this;
    });
  }
  /** @internal */


  ngOnChanges(changes) {
    if (typeof this.latitude === 'string') {
      this.latitude = Number(this.latitude);
    }

    if (typeof this.longitude === 'string') {
      this.longitude = Number(this.longitude);
    }

    if (typeof this.latitude !== 'number' || typeof this.longitude !== 'number') {
      return;
    }

    if (!this._markerAddedToManger) {
      this._markerManager.addMarker(this);

      this._updateFitBoundsDetails();

      this._markerAddedToManger = true;

      this._addEventListeners();

      return;
    }

    if (changes['latitude'] || changes['longitude']) {
      this._markerManager.updateMarkerPosition(this);

      this._updateFitBoundsDetails();
    }

    if (changes['title']) {
      this._markerManager.updateTitle(this);
    }

    if (changes['label']) {
      this._markerManager.updateLabel(this);
    }

    if (changes['draggable']) {
      this._markerManager.updateDraggable(this);
    }

    if (changes['iconUrl']) {
      this._markerManager.updateIcon(this);
    }

    if (changes['opacity']) {
      this._markerManager.updateOpacity(this);
    }

    if (changes['visible']) {
      this._markerManager.updateVisible(this);
    }

    if (changes['zIndex']) {
      this._markerManager.updateZIndex(this);
    }

    if (changes['clickable']) {
      this._markerManager.updateClickable(this);
    }

    if (changes['animation']) {
      this._markerManager.updateAnimation(this);
    }
  }
  /** @internal */


  getFitBoundsDetails$() {
    return this._fitBoundsDetails$.asObservable();
  }

  _updateFitBoundsDetails() {
    this._fitBoundsDetails$.next({
      latLng: {
        lat: this.latitude,
        lng: this.longitude
      }
    });
  }

  _addEventListeners() {
    const cs = this._markerManager.createEventObservable('click', this).subscribe(() => {
      if (this.openInfoWindow) {
        this.infoWindow.forEach(infoWindow => infoWindow.open());
      }

      this.markerClick.emit(this);
    });

    this._observableSubscriptions.push(cs);

    const dcs = this._markerManager.createEventObservable('dblclick', this).subscribe(() => {
      this.markerDblClick.emit(null);
    });

    this._observableSubscriptions.push(dcs);

    const rc = this._markerManager.createEventObservable('rightclick', this).subscribe(() => {
      this.markerRightClick.emit(null);
    });

    this._observableSubscriptions.push(rc);

    const ds = this._markerManager.createEventObservable('dragstart', this).subscribe(e => {
      this.dragStart.emit({
        coords: {
          lat: e.latLng.lat(),
          lng: e.latLng.lng()
        }
      });
    });

    this._observableSubscriptions.push(ds);

    const d = this._markerManager.createEventObservable('drag', this).subscribe(e => {
      this.drag.emit({
        coords: {
          lat: e.latLng.lat(),
          lng: e.latLng.lng()
        }
      });
    });

    this._observableSubscriptions.push(d);

    const de = this._markerManager.createEventObservable('dragend', this).subscribe(e => {
      this.dragEnd.emit({
        coords: {
          lat: e.latLng.lat(),
          lng: e.latLng.lng()
        }
      });
    });

    this._observableSubscriptions.push(de);

    const mover = this._markerManager.createEventObservable('mouseover', this).subscribe(e => {
      this.mouseOver.emit({
        coords: {
          lat: e.latLng.lat(),
          lng: e.latLng.lng()
        }
      });
    });

    this._observableSubscriptions.push(mover);

    const mout = this._markerManager.createEventObservable('mouseout', this).subscribe(e => {
      this.mouseOut.emit({
        coords: {
          lat: e.latLng.lat(),
          lng: e.latLng.lng()
        }
      });
    });

    this._observableSubscriptions.push(mout);

    const anChng = this._markerManager.createEventObservable('animation_changed', this).subscribe(() => {
      this.animationChange.emit(this.animation);
    });

    this._observableSubscriptions.push(anChng);
  }
  /** @internal */


  id() {
    return this._id;
  }
  /** @internal */


  toString() {
    return 'AgmMarker-' + this._id.toString();
  }
  /** @internal */


  ngOnDestroy() {
    this._markerManager.deleteMarker(this); // unsubscribe all registered observable subscriptions


    this._observableSubscriptions.forEach(s => s.unsubscribe());
  }

};

AgmMarker.ɵfac = function AgmMarker_Factory(t) {
  return new (t || AgmMarker)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](MarkerManager));
};

AgmMarker.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmMarker,
  selectors: [["agm-marker"]],
  contentQueries: function AgmMarker_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, AgmInfoWindow, 4);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.infoWindow = _t);
    }
  },
  inputs: {
    latitude: "latitude",
    longitude: "longitude",
    title: "title",
    label: "label",
    draggable: ["markerDraggable", "draggable"],
    iconUrl: "iconUrl",
    openInfoWindow: "openInfoWindow",
    opacity: "opacity",
    visible: "visible",
    zIndex: "zIndex",
    animation: "animation",
    clickable: ["markerClickable", "clickable"]
  },
  outputs: {
    markerClick: "markerClick",
    dragStart: "dragStart",
    drag: "drag",
    dragEnd: "dragEnd",
    mouseOver: "mouseOver",
    mouseOut: "mouseOut",
    animationChange: "animationChange",
    markerDblClick: "markerDblClick",
    markerRightClick: "markerRightClick"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
    provide: FitBoundsAccessor,
    useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => AgmMarker_1)
  }]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});

AgmMarker.ctorParameters = () => [{
  type: MarkerManager
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmMarker.prototype, "latitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmMarker.prototype, "longitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMarker.prototype, "title", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "label", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('markerDraggable'), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "draggable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMarker.prototype, "iconUrl", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "visible", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "openInfoWindow", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "opacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "zIndex", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('markerClickable'), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "clickable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmMarker.prototype, "animation", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmMarker.prototype, "animationChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "markerClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "markerDblClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "markerRightClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "dragStart", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "drag", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "dragEnd", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "mouseOver", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmMarker.prototype, "mouseOut", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.ContentChildren)(AgmInfoWindow), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.QueryList)], AgmMarker.prototype, "infoWindow", void 0);

AgmMarker = AgmMarker_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [MarkerManager])], AgmMarker);
var AgmPolygon_1;
/**
 * AgmPolygon renders a polygon on a {@link AgmMap}
 *
 * ### Example
 * ```typescript
 * import { Component } from '@angular/core';
 *
 * @Component({
 *  selector: 'my-map-cmp',
 *  styles: [`
 *    agm-map {
 *      height: 300px;
 *    }
 * `],
 *  template: `
 *    <agm-map [latitude]="lat" [longitude]="lng" [zoom]="zoom">
 *      <agm-polygon [paths]="paths">
 *      </agm-polygon>
 *    </agm-map>
 *  `
 * })
 * export class MyMapCmp {
 *   lat: number = 0;
 *   lng: number = 0;
 *   zoom: number = 10;
 *   paths: Array<LatLngLiteral> = [
 *     { lat: 0,  lng: 10 },
 *     { lat: 0,  lng: 20 },
 *     { lat: 10, lng: 20 },
 *     { lat: 10, lng: 10 },
 *     { lat: 0,  lng: 10 }
 *   ]
 *   // Nesting paths will create a hole where they overlap;
 *   nestedPaths: Array<Array<LatLngLiteral>> = [[
 *     { lat: 0,  lng: 10 },
 *     { lat: 0,  lng: 20 },
 *     { lat: 10, lng: 20 },
 *     { lat: 10, lng: 10 },
 *     { lat: 0,  lng: 10 }
 *   ], [
 *     { lat: 0, lng: 15 },
 *     { lat: 0, lng: 20 },
 *     { lat: 5, lng: 20 },
 *     { lat: 5, lng: 15 },
 *     { lat: 0, lng: 15 }
 *   ]]
 * }
 * ```
 */

let AgmPolygon = AgmPolygon_1 = class AgmPolygon {
  constructor(_polygonManager) {
    this._polygonManager = _polygonManager;
    /**
     * Indicates whether this Polygon handles mouse events. Defaults to true.
     */

    this.clickable = true;
    /**
     * If set to true, the user can drag this shape over the map. The geodesic
     * property defines the mode of dragging. Defaults to false.
     */
    // tslint:disable-next-line:no-input-rename

    this.draggable = false;
    /**
     * If set to true, the user can edit this shape by dragging the control
     * points shown at the vertices and on each segment. Defaults to false.
     */

    this.editable = false;
    /**
     * When true, edges of the polygon are interpreted as geodesic and will
     * follow the curvature of the Earth. When false, edges of the polygon are
     * rendered as straight lines in screen space. Note that the shape of a
     * geodesic polygon may appear to change when dragged, as the dimensions
     * are maintained relative to the surface of the earth. Defaults to false.
     */

    this.geodesic = false;
    /**
     * The ordered sequence of coordinates that designates a closed loop.
     * Unlike polylines, a polygon may consist of one or more paths.
     *  As a result, the paths property may specify one or more arrays of
     * LatLng coordinates. Paths are closed automatically; do not repeat the
     * first vertex of the path as the last vertex. Simple polygons may be
     * defined using a single array of LatLngs. More complex polygons may
     * specify an array of arrays. Any simple arrays are converted into Arrays.
     * Inserting or removing LatLngs from the Array will automatically update
     * the polygon on the map.
     */

    this.paths = [];
    /**
     * This event is fired when the DOM click event is fired on the Polygon.
     */

    this.polyClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM dblclick event is fired on the Polygon.
     */

    this.polyDblClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is repeatedly fired while the user drags the polygon.
     */

    this.polyDrag = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user stops dragging the polygon.
     */

    this.polyDragEnd = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user starts dragging the polygon.
     */

    this.polyDragStart = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousedown event is fired on the Polygon.
     */

    this.polyMouseDown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousemove event is fired on the Polygon.
     */

    this.polyMouseMove = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on Polygon mouseout.
     */

    this.polyMouseOut = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on Polygon mouseover.
     */

    this.polyMouseOver = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired whe the DOM mouseup event is fired on the Polygon
     */

    this.polyMouseUp = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the Polygon is right-clicked on.
     */

    this.polyRightClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired after Polygon first path changes.
     */

    this.polyPathsChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    this._polygonAddedToManager = false;
    this._subscriptions = [];
  }
  /** @internal */


  ngAfterContentInit() {
    if (!this._polygonAddedToManager) {
      this._init();
    }
  }

  ngOnChanges(changes) {
    if (!this._polygonAddedToManager) {
      this._init();

      return;
    }

    this._polygonManager.setPolygonOptions(this, this._updatePolygonOptions(changes));
  }

  _init() {
    this._polygonManager.addPolygon(this);

    this._polygonAddedToManager = true;

    this._addEventListeners();
  }

  _addEventListeners() {
    const handlers = [{
      name: 'click',
      handler: ev => this.polyClick.emit(ev)
    }, {
      name: 'dblclick',
      handler: ev => this.polyDblClick.emit(ev)
    }, {
      name: 'drag',
      handler: ev => this.polyDrag.emit(ev)
    }, {
      name: 'dragend',
      handler: ev => this.polyDragEnd.emit(ev)
    }, {
      name: 'dragstart',
      handler: ev => this.polyDragStart.emit(ev)
    }, {
      name: 'mousedown',
      handler: ev => this.polyMouseDown.emit(ev)
    }, {
      name: 'mousemove',
      handler: ev => this.polyMouseMove.emit(ev)
    }, {
      name: 'mouseout',
      handler: ev => this.polyMouseOut.emit(ev)
    }, {
      name: 'mouseover',
      handler: ev => this.polyMouseOver.emit(ev)
    }, {
      name: 'mouseup',
      handler: ev => this.polyMouseUp.emit(ev)
    }, {
      name: 'rightclick',
      handler: ev => this.polyRightClick.emit(ev)
    }];
    handlers.forEach(obj => {
      const os = this._polygonManager.createEventObservable(obj.name, this).subscribe(obj.handler);

      this._subscriptions.push(os);
    });

    this._polygonManager.createPathEventObservable(this).then(paths$ => {
      const os = paths$.subscribe(pathEvent => this.polyPathsChange.emit(pathEvent));

      this._subscriptions.push(os);
    });
  }

  _updatePolygonOptions(changes) {
    return Object.keys(changes).filter(k => AgmPolygon_1._polygonOptionsAttributes.indexOf(k) !== -1).reduce((obj, k) => {
      obj[k] = changes[k].currentValue;
      return obj;
    }, {});
  }
  /** @internal */


  id() {
    return this._id;
  }
  /** @internal */


  ngOnDestroy() {
    this._polygonManager.deletePolygon(this); // unsubscribe all registered observable subscriptions


    this._subscriptions.forEach(s => s.unsubscribe());
  }

  getPath() {
    return this._polygonManager.getPath(this);
  }

  getPaths() {
    return this._polygonManager.getPaths(this);
  }

};

AgmPolygon.ɵfac = function AgmPolygon_Factory(t) {
  return new (t || AgmPolygon)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](PolygonManager));
};

AgmPolygon.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmPolygon,
  selectors: [["agm-polygon"]],
  inputs: {
    clickable: "clickable",
    draggable: ["polyDraggable", "draggable"],
    editable: "editable",
    geodesic: "geodesic",
    paths: "paths",
    fillColor: "fillColor",
    fillOpacity: "fillOpacity",
    strokeColor: "strokeColor",
    strokeOpacity: "strokeOpacity",
    strokeWeight: "strokeWeight",
    visible: "visible",
    zIndex: "zIndex"
  },
  outputs: {
    polyClick: "polyClick",
    polyDblClick: "polyDblClick",
    polyDrag: "polyDrag",
    polyDragEnd: "polyDragEnd",
    polyDragStart: "polyDragStart",
    polyMouseDown: "polyMouseDown",
    polyMouseMove: "polyMouseMove",
    polyMouseOut: "polyMouseOut",
    polyMouseOver: "polyMouseOver",
    polyMouseUp: "polyMouseUp",
    polyRightClick: "polyRightClick",
    polyPathsChange: "polyPathsChange"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
AgmPolygon._polygonOptionsAttributes = ['clickable', 'draggable', 'editable', 'fillColor', 'fillOpacity', 'geodesic', 'icon', 'map', 'paths', 'strokeColor', 'strokeOpacity', 'strokeWeight', 'visible', 'zIndex', 'draggable', 'editable', 'visible'];

AgmPolygon.ctorParameters = () => [{
  type: PolygonManager
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolygon.prototype, "clickable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('polyDraggable'), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolygon.prototype, "draggable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolygon.prototype, "editable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolygon.prototype, "fillColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolygon.prototype, "fillOpacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolygon.prototype, "geodesic", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Array)], AgmPolygon.prototype, "paths", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolygon.prototype, "strokeColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolygon.prototype, "strokeOpacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolygon.prototype, "strokeWeight", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Boolean)], AgmPolygon.prototype, "visible", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolygon.prototype, "zIndex", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyDblClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyDrag", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyDragEnd", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyDragStart", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyMouseDown", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyMouseMove", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyMouseOut", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyMouseOver", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyMouseUp", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolygon.prototype, "polyRightClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolygon.prototype, "polyPathsChange", void 0);

AgmPolygon = AgmPolygon_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [PolygonManager])], AgmPolygon);
/**
 * AgmPolylineIcon enables to add polyline sequences to add arrows, circle,
 * or custom icons either along the entire line, or in a specific part of it.
 * See https://developers.google.com/maps/documentation/javascript/shapes#polyline_customize
 *
 * ### Example
 * ```html
 *    <agm-map [latitude]="lat" [longitude]="lng" [zoom]="zoom">
 *      <agm-polyline>
 *          <agm-icon-sequence [fixedRotation]="true" [path]="'FORWARD_OPEN_ARROW'">
 *          </agm-icon-sequence>
 *      </agm-polyline>
 *    </agm-map>
 * ```
 *
 * @export
 * @class AgmPolylineIcon
 */

let AgmPolylineIcon = /*#__PURE__*/(() => {
  let AgmPolylineIcon = class AgmPolylineIcon {
    ngOnInit() {
      if (this.path == null) {
        throw new Error('Icon Sequence path is required');
      }
    }

  };

  AgmPolylineIcon.ɵfac = function AgmPolylineIcon_Factory(t) {
    return new (t || AgmPolylineIcon)();
  };

  AgmPolylineIcon.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: AgmPolylineIcon,
    selectors: [["agm-icon-sequence"]],
    inputs: {
      fixedRotation: "fixedRotation",
      offset: "offset",
      repeat: "repeat",
      anchorX: "anchorX",
      anchorY: "anchorY",
      fillColor: "fillColor",
      fillOpacity: "fillOpacity",
      path: "path",
      rotation: "rotation",
      scale: "scale",
      strokeColor: "strokeColor",
      strokeOpacity: "strokeOpacity",
      strokeWeight: "strokeWeight"
    }
  });

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Boolean)], AgmPolylineIcon.prototype, "fixedRotation", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolylineIcon.prototype, "offset", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolylineIcon.prototype, "repeat", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylineIcon.prototype, "anchorX", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylineIcon.prototype, "anchorY", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolylineIcon.prototype, "fillColor", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylineIcon.prototype, "fillOpacity", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolylineIcon.prototype, "path", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylineIcon.prototype, "rotation", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylineIcon.prototype, "scale", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolylineIcon.prototype, "strokeColor", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylineIcon.prototype, "strokeOpacity", void 0);

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylineIcon.prototype, "strokeWeight", void 0);

  return AgmPolylineIcon;
})();
var AgmPolylinePoint_1;
/**
 * AgmPolylinePoint represents one element of a polyline within a  {@link
 * AgmPolyline}
 */

let AgmPolylinePoint = AgmPolylinePoint_1 = class AgmPolylinePoint {
  constructor() {
    /**
     * This event emitter gets emitted when the position of the point changed.
     */
    this.positionChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
  }

  ngOnChanges(changes) {
    if (changes['latitude'] || changes['longitude']) {
      const position = {
        lat: changes['latitude'] ? changes['latitude'].currentValue : this.latitude,
        lng: changes['longitude'] ? changes['longitude'].currentValue : this.longitude
      };
      this.positionChanged.emit(position);
    }
  }
  /** @internal */


  getFitBoundsDetails$() {
    return this.positionChanged.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_15__.startWith)({
      lat: this.latitude,
      lng: this.longitude
    }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.map)(position => ({
      latLng: position
    })));
  }

};

AgmPolylinePoint.ɵfac = function AgmPolylinePoint_Factory(t) {
  return new (t || AgmPolylinePoint)();
};

AgmPolylinePoint.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmPolylinePoint,
  selectors: [["agm-polyline-point"]],
  inputs: {
    latitude: "latitude",
    longitude: "longitude"
  },
  outputs: {
    positionChanged: "positionChanged"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
    provide: FitBoundsAccessor,
    useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => AgmPolylinePoint_1)
  }]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylinePoint.prototype, "latitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolylinePoint.prototype, "longitude", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolylinePoint.prototype, "positionChanged", void 0);

AgmPolylinePoint = AgmPolylinePoint_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [])], AgmPolylinePoint);
var AgmPolyline_1;
let polylineId = 0;
/**
 * AgmPolyline renders a polyline on a {@link AgmMap}
 *
 * ### Example
 * ```typescript
 * import { Component } from '@angular/core';
 *
 * @Component({
 *  selector: 'my-map-cmp',
 *  styles: [`
 *    .agm-map-container {
 *      height: 300px;
 *    }
 * `],
 *  template: `
 *    <agm-map [latitude]="lat" [longitude]="lng" [zoom]="zoom">
 *      <agm-polyline>
 *          <agm-polyline-point [latitude]="latA" [longitude]="lngA">
 *          </agm-polyline-point>
 *          <agm-polyline-point [latitude]="latB" [longitude]="lngB">
 *          </agm-polyline-point>
 *      </agm-polyline>
 *    </agm-map>
 *  `
 * })
 * ```
 */

let AgmPolyline = AgmPolyline_1 = class AgmPolyline {
  constructor(_polylineManager) {
    this._polylineManager = _polylineManager;
    /**
     * Indicates whether this Polyline handles mouse events. Defaults to true.
     */

    this.clickable = true;
    /**
     * If set to true, the user can drag this shape over the map. The geodesic property defines the
     * mode of dragging. Defaults to false.
     */
    // tslint:disable-next-line:no-input-rename

    this.draggable = false;
    /**
     * If set to true, the user can edit this shape by dragging the control points shown at the
     * vertices and on each segment. Defaults to false.
     */

    this.editable = false;
    /**
     * When true, edges of the polygon are interpreted as geodesic and will follow the curvature of
     * the Earth. When false, edges of the polygon are rendered as straight lines in screen space.
     * Note that the shape of a geodesic polygon may appear to change when dragged, as the dimensions
     * are maintained relative to the surface of the earth. Defaults to false.
     */

    this.geodesic = false;
    /**
     * Whether this polyline is visible on the map. Defaults to true.
     */

    this.visible = true;
    /**
     * This event is fired when the DOM click event is fired on the Polyline.
     */

    this.lineClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM dblclick event is fired on the Polyline.
     */

    this.lineDblClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is repeatedly fired while the user drags the polyline.
     */

    this.lineDrag = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user stops dragging the polyline.
     */

    this.lineDragEnd = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user starts dragging the polyline.
     */

    this.lineDragStart = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousedown event is fired on the Polyline.
     */

    this.lineMouseDown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousemove event is fired on the Polyline.
     */

    this.lineMouseMove = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on Polyline mouseout.
     */

    this.lineMouseOut = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on Polyline mouseover.
     */

    this.lineMouseOver = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired whe the DOM mouseup event is fired on the Polyline
     */

    this.lineMouseUp = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the Polyline is right-clicked on.
     */

    this.lineRightClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired after Polyline's path changes.
     */

    this.polyPathChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    this._polylineAddedToManager = false;
    this._subscriptions = [];
    this._id = (polylineId++).toString();
  }
  /** @internal */


  ngAfterContentInit() {
    if (this.points.length) {
      this.points.forEach(point => {
        const s = point.positionChanged.subscribe(() => {
          this._polylineManager.updatePolylinePoints(this);
        });

        this._subscriptions.push(s);
      });
    }

    if (!this._polylineAddedToManager) {
      this._init();
    }

    const pointSub = this.points.changes.subscribe(() => this._polylineManager.updatePolylinePoints(this));

    this._subscriptions.push(pointSub);

    this._polylineManager.updatePolylinePoints(this);

    const iconSub = this.iconSequences.changes.subscribe(() => this._polylineManager.updateIconSequences(this));

    this._subscriptions.push(iconSub);
  }

  ngOnChanges(changes) {
    if (!this._polylineAddedToManager) {
      this._init();

      return;
    }

    let options = {};
    const optionKeys = Object.keys(changes).filter(k => AgmPolyline_1._polylineOptionsAttributes.indexOf(k) !== -1);
    optionKeys.forEach(k => options[k] = changes[k].currentValue);

    this._polylineManager.setPolylineOptions(this, options);
  }

  getPath() {
    return this._polylineManager.getPath(this);
  }

  _init() {
    this._polylineManager.addPolyline(this);

    this._polylineAddedToManager = true;

    this._addEventListeners();
  }

  _addEventListeners() {
    const handlers = [{
      name: 'click',
      handler: ev => this.lineClick.emit(ev)
    }, {
      name: 'dblclick',
      handler: ev => this.lineDblClick.emit(ev)
    }, {
      name: 'drag',
      handler: ev => this.lineDrag.emit(ev)
    }, {
      name: 'dragend',
      handler: ev => this.lineDragEnd.emit(ev)
    }, {
      name: 'dragstart',
      handler: ev => this.lineDragStart.emit(ev)
    }, {
      name: 'mousedown',
      handler: ev => this.lineMouseDown.emit(ev)
    }, {
      name: 'mousemove',
      handler: ev => this.lineMouseMove.emit(ev)
    }, {
      name: 'mouseout',
      handler: ev => this.lineMouseOut.emit(ev)
    }, {
      name: 'mouseover',
      handler: ev => this.lineMouseOver.emit(ev)
    }, {
      name: 'mouseup',
      handler: ev => this.lineMouseUp.emit(ev)
    }, {
      name: 'rightclick',
      handler: ev => this.lineRightClick.emit(ev)
    }];
    handlers.forEach(obj => {
      const os = this._polylineManager.createEventObservable(obj.name, this).subscribe(obj.handler);

      this._subscriptions.push(os);
    });

    this._polylineManager.createPathEventObservable(this).then(ob$ => {
      const os = ob$.subscribe(pathEvent => this.polyPathChange.emit(pathEvent));

      this._subscriptions.push(os);
    });
  }
  /** @internal */


  _getPoints() {
    if (this.points) {
      return this.points.toArray();
    }

    return [];
  }

  _getIcons() {
    if (this.iconSequences) {
      return this.iconSequences.toArray();
    }

    return [];
  }
  /** @internal */


  id() {
    return this._id;
  }
  /** @internal */


  ngOnDestroy() {
    this._polylineManager.deletePolyline(this); // unsubscribe all registered observable subscriptions


    this._subscriptions.forEach(s => s.unsubscribe());
  }

};

AgmPolyline.ɵfac = function AgmPolyline_Factory(t) {
  return new (t || AgmPolyline)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](PolylineManager));
};

AgmPolyline.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmPolyline,
  selectors: [["agm-polyline"]],
  contentQueries: function AgmPolyline_ContentQueries(rf, ctx, dirIndex) {
    if (rf & 1) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, AgmPolylinePoint, 4);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, AgmPolylineIcon, 4);
    }

    if (rf & 2) {
      let _t;

      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.points = _t);
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.iconSequences = _t);
    }
  },
  inputs: {
    clickable: "clickable",
    draggable: ["polylineDraggable", "draggable"],
    editable: "editable",
    geodesic: "geodesic",
    visible: "visible",
    strokeColor: "strokeColor",
    strokeOpacity: "strokeOpacity",
    strokeWeight: "strokeWeight",
    zIndex: "zIndex"
  },
  outputs: {
    lineClick: "lineClick",
    lineDblClick: "lineDblClick",
    lineDrag: "lineDrag",
    lineDragEnd: "lineDragEnd",
    lineDragStart: "lineDragStart",
    lineMouseDown: "lineMouseDown",
    lineMouseMove: "lineMouseMove",
    lineMouseOut: "lineMouseOut",
    lineMouseOver: "lineMouseOver",
    lineMouseUp: "lineMouseUp",
    lineRightClick: "lineRightClick",
    polyPathChange: "polyPathChange"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
AgmPolyline._polylineOptionsAttributes = ['draggable', 'editable', 'visible', 'geodesic', 'strokeColor', 'strokeOpacity', 'strokeWeight', 'zIndex'];

AgmPolyline.ctorParameters = () => [{
  type: PolylineManager
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolyline.prototype, "clickable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('polylineDraggable'), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolyline.prototype, "draggable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolyline.prototype, "editable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolyline.prototype, "geodesic", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmPolyline.prototype, "strokeColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolyline.prototype, "strokeOpacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolyline.prototype, "strokeWeight", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolyline.prototype, "visible", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmPolyline.prototype, "zIndex", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineDblClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineDrag", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineDragEnd", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineDragStart", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineMouseDown", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineMouseMove", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineMouseOut", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineMouseOver", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineMouseUp", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmPolyline.prototype, "lineRightClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmPolyline.prototype, "polyPathChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.ContentChildren)(AgmPolylinePoint), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.QueryList)], AgmPolyline.prototype, "points", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.ContentChildren)(AgmPolylineIcon), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.QueryList)], AgmPolyline.prototype, "iconSequences", void 0);

AgmPolyline = AgmPolyline_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [PolylineManager])], AgmPolyline);
var AgmRectangle_1;
let AgmRectangle = AgmRectangle_1 = class AgmRectangle {
  constructor(_manager) {
    this._manager = _manager;
    /**
     * Indicates whether this Rectangle handles mouse events. Defaults to true.
     */

    this.clickable = true;
    /**
     * If set to true, the user can drag this rectangle over the map. Defaults to false.
     */
    // tslint:disable-next-line:no-input-rename

    this.draggable = false;
    /**
     * If set to true, the user can edit this rectangle by dragging the control points shown at
     * the center and around the circumference of the rectangle. Defaults to false.
     */

    this.editable = false;
    /**
     * The stroke position. Defaults to CENTER.
     * This property is not supported on Internet Explorer 8 and earlier.
     */

    this.strokePosition = 'CENTER';
    /**
     * The stroke width in pixels.
     */

    this.strokeWeight = 0;
    /**
     * Whether this rectangle is visible on the map. Defaults to true.
     */

    this.visible = true;
    /**
     * This event is fired when the rectangle's is changed.
     */

    this.boundsChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user clicks on the rectangle.
     */

    this.rectangleClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event emitter gets emitted when the user clicks on the rectangle.
     */

    this.rectangleDblClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is repeatedly fired while the user drags the rectangle.
     */

    this.drag = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user stops dragging the rectangle.
     */

    this.dragEnd = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the user starts dragging the rectangle.
     */

    this.dragStart = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousedown event is fired on the rectangle.
     */

    this.mouseDown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mousemove event is fired on the rectangle.
     */

    this.mouseMove = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on rectangle mouseout.
     */

    this.mouseOut = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired on rectangle mouseover.
     */

    this.mouseOver = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the DOM mouseup event is fired on the rectangle.
     */

    this.mouseUp = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    /**
     * This event is fired when the rectangle is right-clicked on.
     */

    this.rightClick = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    this._rectangleAddedToManager = false;
    this._eventSubscriptions = [];
  }
  /** @internal */


  ngOnInit() {
    this._manager.addRectangle(this);

    this._rectangleAddedToManager = true;

    this._registerEventListeners();
  }
  /** @internal */


  ngOnChanges(changes) {
    if (!this._rectangleAddedToManager) {
      return;
    }

    if (changes['north'] || changes['east'] || changes['south'] || changes['west']) {
      this._manager.setBounds(this);
    }

    if (changes['editable']) {
      this._manager.setEditable(this);
    }

    if (changes['draggable']) {
      this._manager.setDraggable(this);
    }

    if (changes['visible']) {
      this._manager.setVisible(this);
    }

    this._updateRectangleOptionsChanges(changes);
  }

  _updateRectangleOptionsChanges(changes) {
    let options = {};
    let optionKeys = Object.keys(changes).filter(k => AgmRectangle_1._mapOptions.indexOf(k) !== -1);
    optionKeys.forEach(k => {
      options[k] = changes[k].currentValue;
    });

    if (optionKeys.length > 0) {
      this._manager.setOptions(this, options);
    }
  }

  _registerEventListeners() {
    let events = new Map();
    events.set('bounds_changed', this.boundsChange);
    events.set('click', this.rectangleClick);
    events.set('dblclick', this.rectangleDblClick);
    events.set('drag', this.drag);
    events.set('dragend', this.dragEnd);
    events.set('dragStart', this.dragStart);
    events.set('mousedown', this.mouseDown);
    events.set('mousemove', this.mouseMove);
    events.set('mouseout', this.mouseOut);
    events.set('mouseover', this.mouseOver);
    events.set('mouseup', this.mouseUp);
    events.set('rightclick', this.rightClick);
    events.forEach((eventEmitter, eventName) => {
      this._eventSubscriptions.push(this._manager.createEventObservable(eventName, this).subscribe(value => {
        switch (eventName) {
          case 'bounds_changed':
            this._manager.getBounds(this).then(bounds => eventEmitter.emit({
              north: bounds.getNorthEast().lat(),
              east: bounds.getNorthEast().lng(),
              south: bounds.getSouthWest().lat(),
              west: bounds.getSouthWest().lng()
            }));

            break;

          default:
            eventEmitter.emit({
              coords: {
                lat: value.latLng.lat(),
                lng: value.latLng.lng()
              }
            });
        }
      }));
    });
  }
  /** @internal */


  ngOnDestroy() {
    this._eventSubscriptions.forEach(function (s) {
      s.unsubscribe();
    });

    this._eventSubscriptions = null;

    this._manager.removeRectangle(this);
  }
  /**
   * Gets the LatLngBounds of this Rectangle.
   */


  getBounds() {
    return this._manager.getBounds(this);
  }

};

AgmRectangle.ɵfac = function AgmRectangle_Factory(t) {
  return new (t || AgmRectangle)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](RectangleManager));
};

AgmRectangle.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
  type: AgmRectangle,
  selectors: [["agm-rectangle"]],
  inputs: {
    clickable: "clickable",
    draggable: ["rectangleDraggable", "draggable"],
    editable: "editable",
    strokePosition: "strokePosition",
    strokeWeight: "strokeWeight",
    visible: "visible",
    north: "north",
    east: "east",
    south: "south",
    west: "west",
    fillColor: "fillColor",
    fillOpacity: "fillOpacity",
    strokeColor: "strokeColor",
    strokeOpacity: "strokeOpacity",
    zIndex: "zIndex"
  },
  outputs: {
    boundsChange: "boundsChange",
    rectangleClick: "rectangleClick",
    rectangleDblClick: "rectangleDblClick",
    drag: "drag",
    dragEnd: "dragEnd",
    dragStart: "dragStart",
    mouseDown: "mouseDown",
    mouseMove: "mouseMove",
    mouseOut: "mouseOut",
    mouseOver: "mouseOver",
    mouseUp: "mouseUp",
    rightClick: "rightClick"
  },
  features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
});
AgmRectangle._mapOptions = ['fillColor', 'fillOpacity', 'strokeColor', 'strokeOpacity', 'strokePosition', 'strokeWeight', 'visible', 'zIndex', 'clickable'];

AgmRectangle.ctorParameters = () => [{
  type: RectangleManager
}];

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmRectangle.prototype, "north", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmRectangle.prototype, "east", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmRectangle.prototype, "south", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmRectangle.prototype, "west", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmRectangle.prototype, "clickable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)('rectangleDraggable'), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmRectangle.prototype, "draggable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmRectangle.prototype, "editable", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmRectangle.prototype, "fillColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmRectangle.prototype, "fillOpacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmRectangle.prototype, "strokeColor", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmRectangle.prototype, "strokeOpacity", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", String)], AgmRectangle.prototype, "strokePosition", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmRectangle.prototype, "strokeWeight", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmRectangle.prototype, "visible", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Number)], AgmRectangle.prototype, "zIndex", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "boundsChange", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "rectangleClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "rectangleDblClick", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "drag", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "dragEnd", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "dragStart", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "mouseDown", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "mouseMove", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "mouseOut", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "mouseOver", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "mouseUp", void 0);

(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Output)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter)], AgmRectangle.prototype, "rightClick", void 0);

AgmRectangle = AgmRectangle_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [RectangleManager])], AgmRectangle);
let layerId$3 = 0;
/*
 * This directive adds a transit layer to a google map instance
 * <agm-transit-layer [visible]="true|false"> <agm-transit-layer>
 * */

let AgmTransitLayer = /*#__PURE__*/(() => {
  let AgmTransitLayer = class AgmTransitLayer {
    constructor(_manager) {
      this._manager = _manager;
      this._addedToManager = false;
      this._id = (layerId$3++).toString();
      /**
       * Hide/show transit layer
       */

      this.visible = true;
    }

    ngOnInit() {
      if (this._addedToManager) {
        return;
      }

      this._manager.addTransitLayer(this, {
        visible: this.visible
      });

      this._addedToManager = true;
    }

    ngOnChanges(changes) {
      if (!this._addedToManager) {
        return;
      }

      if (changes['visible'] != null) {
        this._manager.toggleLayerVisibility(this, {
          visible: changes['visible'].currentValue
        });
      }
    }
    /** @internal */


    id() {
      return this._id;
    }
    /** @internal */


    toString() {
      return `AgmTransitLayer-${this._id.toString()}`;
    }
    /** @internal */


    ngOnDestroy() {
      this._manager.deleteLayer(this);
    }

  };

  AgmTransitLayer.ɵfac = function AgmTransitLayer_Factory(t) {
    return new (t || AgmTransitLayer)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](LayerManager));
  };

  AgmTransitLayer.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: AgmTransitLayer,
    selectors: [["agm-transit-layer"]],
    inputs: {
      visible: "visible"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });

  (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Input)(), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:type", Object)], AgmTransitLayer.prototype, "visible", void 0);

  AgmTransitLayer = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [LayerManager])], AgmTransitLayer);
  return AgmTransitLayer;
})();
var google$1;
var SymbolPath = /*#__PURE__*/(() => {
  (function (SymbolPath) {
    SymbolPath[SymbolPath["BACKWARD_CLOSED_ARROW"] = 3] = "BACKWARD_CLOSED_ARROW";
    SymbolPath[SymbolPath["BACKWARD_OPEN_ARROW"] = 4] = "BACKWARD_OPEN_ARROW";
    SymbolPath[SymbolPath["CIRCLE"] = 0] = "CIRCLE";
    SymbolPath[SymbolPath["FORWARD_CLOSED_ARROW"] = 1] = "FORWARD_CLOSED_ARROW";
    SymbolPath[SymbolPath["FORWARD_OPEN_ARROW"] = 2] = "FORWARD_OPEN_ARROW";
  })(SymbolPath || (SymbolPath = {}));

  return SymbolPath;
})();

/**
 * Identifiers used to specify the placement of controls on the map. Controls are
 * positioned relative to other controls in the same layout position. Controls that
 * are added first are positioned closer to the edge of the map.
 */
var ControlPosition = /*#__PURE__*/(() => {
  (function (ControlPosition) {
    ControlPosition[ControlPosition["RIGHT_BOTTOM"] = 0] = "RIGHT_BOTTOM";
    ControlPosition[ControlPosition["TOP_LEFT"] = 1] = "TOP_LEFT";
    ControlPosition[ControlPosition["TOP_CENTER"] = 2] = "TOP_CENTER";
    ControlPosition[ControlPosition["TOP_RIGHT"] = 3] = "TOP_RIGHT";
    ControlPosition[ControlPosition["LEFT_CENTER"] = 4] = "LEFT_CENTER";
    ControlPosition[ControlPosition["LEFT_TOP"] = 5] = "LEFT_TOP";
    ControlPosition[ControlPosition["LEFT_BOTTOM"] = 6] = "LEFT_BOTTOM";
    ControlPosition[ControlPosition["RIGHT_TOP"] = 7] = "RIGHT_TOP";
    ControlPosition[ControlPosition["RIGHT_CENTER"] = 8] = "RIGHT_CENTER";
    ControlPosition[ControlPosition["BOTTOM_RIGHT"] = 9] = "BOTTOM_RIGHT";
    ControlPosition[ControlPosition["BOTTOM_LEFT"] = 10] = "BOTTOM_LEFT";
    ControlPosition[ControlPosition["BOTTOM_CENTER"] = 11] = "BOTTOM_CENTER";
  })(ControlPosition || (ControlPosition = {}));

  return ControlPosition;
})();
var MapTypeId = /*#__PURE__*/(() => {
  (function (MapTypeId) {
    /** This map type displays a transparent layer of major streets on satellite images. */
    MapTypeId[MapTypeId["HYBRID"] = 0] = "HYBRID";
    /** This map type displays a normal street map. */

    MapTypeId[MapTypeId["ROADMAP"] = 1] = "ROADMAP";
    /** This map type displays satellite images. */

    MapTypeId[MapTypeId["SATELLITE"] = 2] = "SATELLITE";
    /** This map type displays maps with physical features such as terrain and vegetation. */

    MapTypeId[MapTypeId["TERRAIN"] = 3] = "TERRAIN";
  })(MapTypeId || (MapTypeId = {}));

  return MapTypeId;
})();
var MapTypeControlStyle = /*#__PURE__*/(() => {
  (function (MapTypeControlStyle) {
    MapTypeControlStyle[MapTypeControlStyle["DEFAULT"] = 0] = "DEFAULT";
    MapTypeControlStyle[MapTypeControlStyle["DROPDOWN_MENU"] = 2] = "DROPDOWN_MENU";
    MapTypeControlStyle[MapTypeControlStyle["HORIZONTAL_BAR"] = 1] = "HORIZONTAL_BAR";
  })(MapTypeControlStyle || (MapTypeControlStyle = {}));

  return MapTypeControlStyle;
})();
var ScaleControlStyle = /*#__PURE__*/(() => {
  (function (ScaleControlStyle) {
    ScaleControlStyle[ScaleControlStyle["DEFAULT"] = 0] = "DEFAULT";
  })(ScaleControlStyle || (ScaleControlStyle = {}));

  return ScaleControlStyle;
})();
var ZoomControlStyle = /*#__PURE__*/(() => {
  (function (ZoomControlStyle) {
    ZoomControlStyle[ZoomControlStyle["DEFAULT"] = 0] = "DEFAULT";
    ZoomControlStyle[ZoomControlStyle["LARGE"] = 1] = "LARGE";
    ZoomControlStyle[ZoomControlStyle["SMALL"] = 2] = "SMALL";
  })(ZoomControlStyle || (ZoomControlStyle = {}));

  return ZoomControlStyle;
})();
var GeocoderLocationType = /*#__PURE__*/(() => {
  (function (GeocoderLocationType) {
    GeocoderLocationType["APPROXIMATE"] = "APPROXIMATE";
    GeocoderLocationType["GEOMETRIC_CENTER"] = "GEOMETRIC_CENTER";
    GeocoderLocationType["RANGE_INTERPOLATED"] = "RANGE_INTERPOLATED";
    GeocoderLocationType["ROOFTOP"] = "ROOFTOP";
  })(GeocoderLocationType || (GeocoderLocationType = {}));

  return GeocoderLocationType;
})();
var GeocoderStatus = /*#__PURE__*/(() => {
  (function (GeocoderStatus) {
    GeocoderStatus["ERROR"] = "ERROR";
    GeocoderStatus["INVALID_REQUEST"] = "INVALID_REQUEST";
    GeocoderStatus["OK"] = "OK";
    GeocoderStatus["OVER_QUERY_LIMIT"] = "OVER_QUERY_LIMIT";
    GeocoderStatus["REQUEST_DENIED"] = "REQUEST_DENIED";
    GeocoderStatus["UNKNOWN_ERROR"] = "UNKNOWN_ERROR";
    GeocoderStatus["ZERO_RESULTS"] = "ZERO_RESULTS";
  })(GeocoderStatus || (GeocoderStatus = {}));

  return GeocoderStatus;
})();
let AgmGeocoder = class AgmGeocoder {
  constructor(loader) {
    const connectableGeocoder$ = new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(subscriber => {
      loader.load().then(() => subscriber.next());
    }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.map)(() => this._createGeocoder()), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_20__.multicast)(new rxjs__WEBPACK_IMPORTED_MODULE_19__.ReplaySubject(1)));
    connectableGeocoder$.connect(); // ignore the subscription
    // since we will remain subscribed till application exits

    this.geocoder$ = connectableGeocoder$;
  }

  geocode(request) {
    return this.geocoder$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.switchMap)(geocoder => this._getGoogleResults(geocoder, request)));
  }

  _getGoogleResults(geocoder, request) {
    const geocodeObservable = (0,rxjs__WEBPACK_IMPORTED_MODULE_21__.bindCallback)(geocoder.geocode);
    return geocodeObservable(request).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.switchMap)(([results, status]) => {
      if (status === GeocoderStatus.OK) {
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_22__.of)(results);
      }

      return (0,rxjs__WEBPACK_IMPORTED_MODULE_23__.throwError)(status);
    }));
  }

  _createGeocoder() {
    return new google.maps.Geocoder();
  }

};

AgmGeocoder.ɵfac = function AgmGeocoder_Factory(t) {
  return new (t || AgmGeocoder)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](MapsAPILoader));
};

AgmGeocoder.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
  token: AgmGeocoder,
  factory: function (t) {
    return AgmGeocoder.ɵfac(t);
  },
  providedIn: 'root'
});
AgmGeocoder.ngInjectableDef = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
  factory: function AgmGeocoder_Factory() {
    return new AgmGeocoder((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(MapsAPILoader));
  },
  token: AgmGeocoder,
  providedIn: "root"
});
AgmGeocoder = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [MapsAPILoader])], AgmGeocoder);

class WindowRef {
  getNativeWindow() {
    return window;
  }

}

class DocumentRef {
  getNativeDocument() {
    return document;
  }

}

const BROWSER_GLOBALS_PROVIDERS = [WindowRef, DocumentRef];
var GoogleMapsScriptProtocol = /*#__PURE__*/(() => {
  (function (GoogleMapsScriptProtocol) {
    GoogleMapsScriptProtocol[GoogleMapsScriptProtocol["HTTP"] = 1] = "HTTP";
    GoogleMapsScriptProtocol[GoogleMapsScriptProtocol["HTTPS"] = 2] = "HTTPS";
    GoogleMapsScriptProtocol[GoogleMapsScriptProtocol["AUTO"] = 3] = "AUTO";
  })(GoogleMapsScriptProtocol || (GoogleMapsScriptProtocol = {}));

  return GoogleMapsScriptProtocol;
})();

/**
 * Token for the config of the LazyMapsAPILoader. Please provide an object of type {@link
 * LazyMapsAPILoaderConfig}.
 */
const LAZY_MAPS_API_CONFIG = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('angular-google-maps LAZY_MAPS_API_CONFIG');
let LazyMapsAPILoader = /*#__PURE__*/(() => {
  let LazyMapsAPILoader = class LazyMapsAPILoader extends MapsAPILoader {
    constructor(config = null, w, d, localeId) {
      super();
      this.localeId = localeId;
      this._SCRIPT_ID = 'agmGoogleMapsApiScript';
      this.callbackName = `agmLazyMapsAPILoader`;
      this._config = config || {};
      this._windowRef = w;
      this._documentRef = d;
    }

    load() {
      const window = this._windowRef.getNativeWindow();

      if (window.google && window.google.maps) {
        // Google maps already loaded on the page.
        return Promise.resolve();
      }

      if (this._scriptLoadingPromise) {
        return this._scriptLoadingPromise;
      } // this can happen in HMR situations or Stackblitz.io editors.


      const scriptOnPage = this._documentRef.getNativeDocument().getElementById(this._SCRIPT_ID);

      if (scriptOnPage) {
        this._assignScriptLoadingPromise(scriptOnPage);

        return this._scriptLoadingPromise;
      }

      const script = this._documentRef.getNativeDocument().createElement('script');

      script.type = 'text/javascript';
      script.async = true;
      script.defer = true;
      script.id = this._SCRIPT_ID;
      script.src = this._getScriptSrc(this.callbackName);

      this._assignScriptLoadingPromise(script);

      this._documentRef.getNativeDocument().body.appendChild(script);

      return this._scriptLoadingPromise;
    }

    _assignScriptLoadingPromise(scriptElem) {
      this._scriptLoadingPromise = new Promise((resolve, reject) => {
        this._windowRef.getNativeWindow()[this.callbackName] = () => {
          resolve();
        };

        scriptElem.onerror = error => {
          reject(error);
        };
      });
    }

    _getScriptSrc(callbackName) {
      let protocolType = this._config && this._config.protocol || GoogleMapsScriptProtocol.HTTPS;
      let protocol;

      switch (protocolType) {
        case GoogleMapsScriptProtocol.AUTO:
          protocol = '';
          break;

        case GoogleMapsScriptProtocol.HTTP:
          protocol = 'http:';
          break;

        case GoogleMapsScriptProtocol.HTTPS:
          protocol = 'https:';
          break;
      }

      const hostAndPath = this._config.hostAndPath || 'maps.googleapis.com/maps/api/js';
      const queryParams = {
        v: this._config.apiVersion || 'quarterly',
        callback: callbackName,
        key: this._config.apiKey,
        client: this._config.clientId,
        channel: this._config.channel,
        libraries: this._config.libraries,
        region: this._config.region,
        language: this._config.language || this.localeId !== 'en-US' ? this.localeId : null
      };
      const params = Object.keys(queryParams).filter(k => queryParams[k] != null).filter(k => {
        // remove empty arrays
        return !Array.isArray(queryParams[k]) || Array.isArray(queryParams[k]) && queryParams[k].length > 0;
      }).map(k => {
        // join arrays as comma seperated strings
        let i = queryParams[k];

        if (Array.isArray(i)) {
          return {
            key: k,
            value: i.join(',')
          };
        }

        return {
          key: k,
          value: queryParams[k]
        };
      }).map(entry => {
        return `${entry.key}=${entry.value}`;
      }).join('&');
      return `${protocol}//${hostAndPath}?${params}`;
    }

  };

  LazyMapsAPILoader.ɵfac = function LazyMapsAPILoader_Factory(t) {
    return new (t || LazyMapsAPILoader)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](LAZY_MAPS_API_CONFIG, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](WindowRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](DocumentRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.LOCALE_ID));
  };

  LazyMapsAPILoader.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: LazyMapsAPILoader,
    factory: function (t) {
      return LazyMapsAPILoader.ɵfac(t);
    }
  });
  LazyMapsAPILoader = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,tslib__WEBPACK_IMPORTED_MODULE_2__.__param)(0, (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Optional)()), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__param)(0, (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Inject)(LAZY_MAPS_API_CONFIG)), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__param)(3, (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.Inject)(_angular_core__WEBPACK_IMPORTED_MODULE_0__.LOCALE_ID)), (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__metadata)("design:paramtypes", [Object, WindowRef, DocumentRef, String])], LazyMapsAPILoader);
  /**
   * When using the NoOpMapsAPILoader, the Google Maps API must be added to the page via a `<script>`
   * Tag.
   * It's important that the Google Maps API script gets loaded first on the page.
   */

  return LazyMapsAPILoader;
})();

class NoOpMapsAPILoader {
  load() {
    if (!window.google || !window.google.maps) {
      throw new Error('Google Maps API not loaded on page. Make sure window.google.maps is available!');
    }

    return Promise.resolve();
  }

} // exported map types


var AgmCoreModule_1;
/**
 * @internal
 */

function coreDirectives() {
  return [AgmBicyclingLayer, AgmCircle, AgmDataLayer, AgmFitBounds, AgmInfoWindow, AgmKmlLayer, AgmMap, AgmMarker, AgmPolygon, AgmPolyline, AgmPolylineIcon, AgmPolylinePoint, AgmRectangle, AgmTransitLayer];
}
/**
 * The angular-google-maps core module. Contains all Directives/Services/Pipes
 * of the core module. Please use `AgmCoreModule.forRoot()` in your app module.
 */


let AgmCoreModule = AgmCoreModule_1 = class AgmCoreModule {
  /**
   * Please use this method when you register the module at the root level.
   */
  static forRoot(lazyMapsAPILoaderConfig) {
    return {
      ngModule: AgmCoreModule_1,
      providers: [...BROWSER_GLOBALS_PROVIDERS, {
        provide: MapsAPILoader,
        useClass: LazyMapsAPILoader
      }, {
        provide: LAZY_MAPS_API_CONFIG,
        useValue: lazyMapsAPILoaderConfig
      }]
    };
  }

};

AgmCoreModule.ɵfac = function AgmCoreModule_Factory(t) {
  return new (t || AgmCoreModule)();
};

AgmCoreModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
  type: AgmCoreModule
});
AgmCoreModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({});

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](AgmCoreModule, {
    declarations: [AgmBicyclingLayer, AgmCircle, AgmDataLayer, AgmFitBounds, AgmInfoWindow, AgmKmlLayer, AgmMap, AgmMarker, AgmPolygon, AgmPolyline, AgmPolylineIcon, AgmPolylinePoint, AgmRectangle, AgmTransitLayer],
    exports: [AgmBicyclingLayer, AgmCircle, AgmDataLayer, AgmFitBounds, AgmInfoWindow, AgmKmlLayer, AgmMap, AgmMarker, AgmPolygon, AgmPolyline, AgmPolylineIcon, AgmPolylinePoint, AgmRectangle, AgmTransitLayer]
  });
})(); // main modules

/**
 * Generated bundle index. Do not edit.
 */




/***/ }),

/***/ 61577:
/*!******************************************************************!*\
  !*** ./node_modules/@angular/fire/fesm2015/angular-fire-auth.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AngularFireAuth": () => (/* binding */ AngularFireAuth),
/* harmony export */   "AngularFireAuthModule": () => (/* binding */ AngularFireAuthModule),
/* harmony export */   "LANGUAGE_CODE": () => (/* binding */ LANGUAGE_CODE),
/* harmony export */   "PERSISTENCE": () => (/* binding */ PERSISTENCE),
/* harmony export */   "SETTINGS": () => (/* binding */ SETTINGS),
/* harmony export */   "TENANT_ID": () => (/* binding */ TENANT_ID),
/* harmony export */   "USE_DEVICE_LANGUAGE": () => (/* binding */ USE_DEVICE_LANGUAGE),
/* harmony export */   "USE_EMULATOR": () => (/* binding */ USE_EMULATOR)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 92218);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 64139);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 12378);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs */ 24383);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs */ 88623);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 63888);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ 59095);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ 86942);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 79128);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs/operators */ 25670);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs/operators */ 66426);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs/operators */ 47335);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs/operators */ 59151);
/* harmony import */ var _angular_fire__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/fire */ 63413);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 94666);





/**
 * @fileoverview added by tsickle
 * Generated from: base.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/** @type {?} */


const proxyPolyfillCompat = {
  app: null,
  applyActionCode: null,
  checkActionCode: null,
  confirmPasswordReset: null,
  createUserWithEmailAndPassword: null,
  currentUser: null,
  fetchSignInMethodsForEmail: null,
  isSignInWithEmailLink: null,
  getRedirectResult: null,
  languageCode: null,
  settings: null,
  onAuthStateChanged: null,
  onIdTokenChanged: null,
  sendSignInLinkToEmail: null,
  sendPasswordResetEmail: null,
  setPersistence: null,
  signInAndRetrieveDataWithCredential: null,
  signInAnonymously: null,
  signInWithCredential: null,
  signInWithCustomToken: null,
  signInWithEmailAndPassword: null,
  signInWithPhoneNumber: null,
  signInWithEmailLink: null,
  signInWithPopup: null,
  signInWithRedirect: null,
  signOut: null,
  tenantId: null,
  updateCurrentUser: null,
  useDeviceLanguage: null,
  useEmulator: null,
  verifyPasswordResetCode: null
};
/**
 * @fileoverview added by tsickle
 * Generated from: auth.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
// WARNING: interface has both a type and a value, skipping emit

/** @type {?} */

const USE_EMULATOR = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('angularfire2.auth.use-emulator');
/** @type {?} */

const SETTINGS = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('angularfire2.auth.settings');
/** @type {?} */

const TENANT_ID = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('angularfire2.auth.tenant-id');
/** @type {?} */

const LANGUAGE_CODE = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('angularfire2.auth.langugage-code');
/** @type {?} */

const USE_DEVICE_LANGUAGE = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('angularfire2.auth.use-device-language');
/** @type {?} */

const PERSISTENCE = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('angularfire.auth.persistence');
let AngularFireAuth = /*#__PURE__*/(() => {
  class AngularFireAuth {
    /**
     * @param {?} options
     * @param {?} nameOrConfig
     * @param {?} platformId
     * @param {?} zone
     * @param {?} _useEmulator
     * @param {?} _settings
     * @param {?} tenantId
     * @param {?} languageCode
     * @param {?} useDeviceLanguage
     * @param {?} persistence
     */
    constructor(options, nameOrConfig, // tslint:disable-next-line:ban-types
    platformId, zone, _useEmulator, // can't use the tuple here
    _settings, // can't use firebase.auth.AuthSettings here
    tenantId, languageCode, useDeviceLanguage, persistence) {
      /** @type {?} */
      const schedulers = new _angular_fire__WEBPACK_IMPORTED_MODULE_1__["ɵAngularFireSchedulers"](zone);
      /** @type {?} */

      const keepUnstableUntilFirst = (0,_angular_fire__WEBPACK_IMPORTED_MODULE_1__["ɵkeepUnstableUntilFirstFactory"])(schedulers);
      /** @type {?} */

      const logins = new rxjs__WEBPACK_IMPORTED_MODULE_2__.Subject();
      /** @type {?} */

      const auth = (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.of)(undefined).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.observeOn)(schedulers.outsideAngular), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.switchMap)(
      /**
      * @return {?}
      */
      () => zone.runOutsideAngular(
      /**
      * @return {?}
      */
      () => __webpack_require__.e(/*! import() */ "node_modules_firebase_auth_dist_index_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! firebase/auth */ 23628)))), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_6__.map)(
      /**
      * @return {?}
      */
      () => (0,_angular_fire__WEBPACK_IMPORTED_MODULE_1__["ɵfirebaseAppFactory"])(options, zone, nameOrConfig)), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_6__.map)(
      /**
      * @param {?} app
      * @return {?}
      */
      app => zone.runOutsideAngular(
      /**
      * @return {?}
      */
      () => {
        /** @type {?} */
        const useEmulator = _useEmulator;
        /** @type {?} */

        const settings = _settings;
        return (0,_angular_fire__WEBPACK_IMPORTED_MODULE_1__["ɵfetchInstance"])(`${app.name}.auth`, 'AngularFireAuth', app,
        /**
        * @return {?}
        */
        () => {
          /** @type {?} */
          const auth = zone.runOutsideAngular(
          /**
          * @return {?}
          */
          () => app.auth());

          if (useEmulator) {
            // Firebase Auth doesn't conform to the useEmulator convention, let's smooth that over
            auth.useEmulator(`http://${useEmulator.join(':')}`);
          }

          if (tenantId) {
            auth.tenantId = tenantId;
          }

          auth.languageCode = languageCode;

          if (useDeviceLanguage) {
            auth.useDeviceLanguage();
          }

          if (settings) {
            auth.settings = settings;
          }

          if (persistence) {
            auth.setPersistence(persistence);
          }

          return auth;
        }, [useEmulator, tenantId, languageCode, useDeviceLanguage, settings, persistence]);
      })), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.shareReplay)({
        bufferSize: 1,
        refCount: false
      }));

      if ((0,_angular_common__WEBPACK_IMPORTED_MODULE_8__.isPlatformServer)(platformId)) {
        this.authState = this.user = this.idToken = this.idTokenResult = this.credential = (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.of)(null);
      } else {
        // HACK, as we're exporting auth.Auth, rather than auth, developers importing firebase.auth
        //       (e.g, `import { auth } from 'firebase/app'`) are getting an undefined auth object unexpectedly
        //       as we're completely lazy. Let's eagerly load the Auth SDK here.
        //       There could potentially be race conditions still... but this greatly decreases the odds while
        //       we reevaluate the API.

        /** @type {?} */
        const _ = auth.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_9__.first)()).subscribe();
        /** @type {?} */


        const redirectResult = auth.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.switchMap)(
        /**
        * @param {?} auth
        * @return {?}
        */
        auth => auth.getRedirectResult().then(
        /**
        * @param {?} it
        * @return {?}
        */
        it => it,
        /**
        * @return {?}
        */
        () => null)), keepUnstableUntilFirst, (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.shareReplay)({
          bufferSize: 1,
          refCount: false
        }));
        /** @type {?} */

        const fromCallback =
        /**
        * @template T
        * @param {?} cb
        * @return {?}
        */
        cb => new rxjs__WEBPACK_IMPORTED_MODULE_10__.Observable(
        /**
        * @param {?} subscriber
        * @return {?}
        */
        subscriber => ({
          unsubscribe: zone.runOutsideAngular(
          /**
          * @return {?}
          */
          () => cb(subscriber))
        }));
        /** @type {?} */


        const authStateChanged = auth.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.switchMap)(
        /**
        * @param {?} auth
        * @return {?}
        */
        auth => fromCallback(auth.onAuthStateChanged.bind(auth))));
        /** @type {?} */

        const idTokenChanged = auth.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.switchMap)(
        /**
        * @param {?} auth
        * @return {?}
        */
        auth => fromCallback(auth.onIdTokenChanged.bind(auth))));
        this.authState = redirectResult.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.switchMapTo)(authStateChanged), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_12__.subscribeOn)(schedulers.outsideAngular), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.observeOn)(schedulers.insideAngular));
        this.user = redirectResult.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.switchMapTo)(idTokenChanged), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_12__.subscribeOn)(schedulers.outsideAngular), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.observeOn)(schedulers.insideAngular));
        this.idToken = this.user.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.switchMap)(
        /**
        * @param {?} user
        * @return {?}
        */
        user => user ? (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.from)(user.getIdToken()) : (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.of)(null)));
        this.idTokenResult = this.user.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.switchMap)(
        /**
        * @param {?} user
        * @return {?}
        */
        user => user ? (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.from)(user.getIdTokenResult()) : (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.of)(null)));
        this.credential = (0,rxjs__WEBPACK_IMPORTED_MODULE_14__.merge)(redirectResult, logins, // pipe in null authState to make credential zipable, just a weird devexp if
        // authState and user go null to still have a credential
        this.authState.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_15__.filter)(
        /**
        * @param {?} it
        * @return {?}
        */
        it => !it))).pipe( // handle the { user: { } } when a user is already logged in, rather have null
        // TODO handle the type corcersion better
        (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_6__.map)(
        /**
        * @param {?} credential
        * @return {?}
        */
        credential => (credential === null || credential === void 0 ? void 0 : credential.user) ?
        /** @type {?} */
        credential : null), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_12__.subscribeOn)(schedulers.outsideAngular), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.observeOn)(schedulers.insideAngular));
      }

      return (0,_angular_fire__WEBPACK_IMPORTED_MODULE_1__["ɵlazySDKProxy"])(this, auth, zone, {
        spy: {
          apply:
          /**
          * @param {?} name
          * @param {?} _
          * @param {?} val
          * @return {?}
          */
          (name, _, val) => {
            // If they call a signIn or createUser function listen into the promise
            // this will give us the user credential, push onto the logins Subject
            // to be consumed in .credential
            if (name.startsWith('signIn') || name.startsWith('createUser')) {
              // TODO fix the types, the trouble is UserCredential has everything optional
              val.then(
              /**
              * @param {?} user
              * @return {?}
              */
              user => logins.next(
              /** @type {?} */
              user));
            }
          }
        }
      });
    }

  }

  AngularFireAuth.ɵfac = function AngularFireAuth_Factory(t) {
    return new (t || AngularFireAuth)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_fire__WEBPACK_IMPORTED_MODULE_1__.FIREBASE_OPTIONS), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_fire__WEBPACK_IMPORTED_MODULE_1__.FIREBASE_APP_NAME, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.PLATFORM_ID), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](USE_EMULATOR, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](SETTINGS, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](TENANT_ID, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](LANGUAGE_CODE, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](USE_DEVICE_LANGUAGE, 8), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](PERSISTENCE, 8));
  };
  /** @nocollapse */


  /** @nocollapse */
  AngularFireAuth.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function AngularFireAuth_Factory() {
      return new AngularFireAuth((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_fire__WEBPACK_IMPORTED_MODULE_1__.FIREBASE_OPTIONS), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_fire__WEBPACK_IMPORTED_MODULE_1__.FIREBASE_APP_NAME, 8), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.PLATFORM_ID), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(USE_EMULATOR, 8), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(SETTINGS, 8), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(TENANT_ID, 8), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(LANGUAGE_CODE, 8), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(USE_DEVICE_LANGUAGE, 8), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(PERSISTENCE, 8));
    },
    token: AngularFireAuth,
    providedIn: "any"
  });
  return AngularFireAuth;
})();

/*#__PURE__*/
(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

if (false) {}

/*#__PURE__*/
(0,_angular_fire__WEBPACK_IMPORTED_MODULE_1__["ɵapplyMixins"])(AngularFireAuth, [proxyPolyfillCompat]);
/**
 * @fileoverview added by tsickle
 * Generated from: auth.module.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

let AngularFireAuthModule = /*#__PURE__*/(() => {
  class AngularFireAuthModule {}

  AngularFireAuthModule.ɵfac = function AngularFireAuthModule_Factory(t) {
    return new (t || AngularFireAuthModule)();
  };

  AngularFireAuthModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: AngularFireAuthModule
  });
  AngularFireAuthModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    providers: [AngularFireAuth]
  });
  return AngularFireAuthModule;
})();

/*#__PURE__*/
(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * @fileoverview added by tsickle
 * Generated from: public_api.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * Generated from: angular-fire-auth.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */




/***/ }),

/***/ 63413:
/*!*************************************************************!*\
  !*** ./node_modules/@angular/fire/fesm2015/angular-fire.js ***!
  \*************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AngularFireModule": () => (/* binding */ AngularFireModule),
/* harmony export */   "FIREBASE_APP_NAME": () => (/* binding */ FIREBASE_APP_NAME),
/* harmony export */   "FIREBASE_OPTIONS": () => (/* binding */ FIREBASE_OPTIONS),
/* harmony export */   "FirebaseApp": () => (/* binding */ FirebaseApp),
/* harmony export */   "VERSION": () => (/* binding */ VERSION),
/* harmony export */   "ɵAngularFireSchedulers": () => (/* binding */ ɵAngularFireSchedulers),
/* harmony export */   "ɵBlockUntilFirstOperator": () => (/* binding */ ɵBlockUntilFirstOperator),
/* harmony export */   "ɵZoneScheduler": () => (/* binding */ ɵZoneScheduler),
/* harmony export */   "ɵapplyMixins": () => (/* binding */ ɵapplyMixins),
/* harmony export */   "ɵfetchInstance": () => (/* binding */ ɵfetchInstance),
/* harmony export */   "ɵfirebaseAppFactory": () => (/* binding */ ɵfirebaseAppFactory),
/* harmony export */   "ɵkeepUnstableUntilFirstFactory": () => (/* binding */ ɵkeepUnstableUntilFirstFactory),
/* harmony export */   "ɵlazySDKProxy": () => (/* binding */ ɵlazySDKProxy),
/* harmony export */   "ɵlogAuthEmulatorError": () => (/* binding */ ɵlogAuthEmulatorError)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 28198);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 10328);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 88759);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 47335);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ 63888);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var firebase_app__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! firebase/app */ 66369);
/* module decorator */ module = __webpack_require__.hmd(module);




/**
 * @fileoverview added by tsickle
 * Generated from: angularfire2.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @return {?}
 */



function noop() {}
/**
 * Schedules tasks so that they are invoked inside the Zone that is passed in the constructor.
 */
// tslint:disable-next-line:class-name


class ɵZoneScheduler {
  /**
   * @param {?} zone
   * @param {?=} delegate
   */
  constructor(zone, delegate = rxjs__WEBPACK_IMPORTED_MODULE_1__.queueScheduler) {
    this.zone = zone;
    this.delegate = delegate;
  }
  /**
   * @return {?}
   */


  now() {
    return this.delegate.now();
  }
  /**
   * @param {?} work
   * @param {?=} delay
   * @param {?=} state
   * @return {?}
   */


  schedule(work, delay, state) {
    /** @type {?} */
    const targetZone = this.zone; // Wrap the specified work function to make sure that if nested scheduling takes place the
    // work is executed in the correct zone

    /** @type {?} */

    const workInZone =
    /**
    * @this {?}
    * @param {?} state
    * @return {?}
    */
    function (state) {
      targetZone.runGuarded(
      /**
      * @return {?}
      */
      () => {
        work.apply(this, [state]);
      });
    }; // Scheduling itself needs to be run in zone to ensure setInterval calls for async scheduling are done
    // inside the correct zone. This scheduler needs to schedule asynchronously always to ensure that
    // firebase emissions are never synchronous. Specifying a delay causes issues with the queueScheduler delegate.


    return this.delegate.schedule(workInZone, delay, state);
  }

}

if (false) {} // tslint:disable-next-line:class-name

/**
 * @template T
 */


class ɵBlockUntilFirstOperator {
  /**
   * @param {?} zone
   */
  constructor(zone) {
    this.zone = zone;
    this.task = null;
  }
  /**
   * @param {?} subscriber
   * @param {?} source
   * @return {?}
   */


  call(subscriber, source) {
    /** @type {?} */
    const unscheduleTask = this.unscheduleTask.bind(this);
    this.task = this.zone.run(
    /**
    * @return {?}
    */
    () => Zone.current.scheduleMacroTask('firebaseZoneBlock', noop, {}, noop, noop));
    return source.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.tap)({
      next: unscheduleTask,
      complete: unscheduleTask,
      error: unscheduleTask
    })).subscribe(subscriber).add(unscheduleTask);
  }
  /**
   * @private
   * @return {?}
   */


  unscheduleTask() {
    // maybe this is a race condition, invoke in a timeout
    // hold for 10ms while I try to figure out what is going on
    setTimeout(
    /**
    * @return {?}
    */
    () => {
      if (this.task != null && this.task.state === 'scheduled') {
        this.task.invoke();
        this.task = null;
      }
    }, 10);
  }

}

if (false) {} // tslint:disable-next-line:class-name


class ɵAngularFireSchedulers {
  /**
   * @param {?} ngZone
   */
  constructor(ngZone) {
    this.ngZone = ngZone;
    this.outsideAngular = ngZone.runOutsideAngular(
    /**
    * @return {?}
    */
    () => new ɵZoneScheduler(Zone.current));
    this.insideAngular = ngZone.run(
    /**
    * @return {?}
    */
    () => new ɵZoneScheduler(Zone.current, rxjs__WEBPACK_IMPORTED_MODULE_3__.asyncScheduler));
  }

}

if (false) {}
/**
 * Operator to block the zone until the first value has been emitted or the observable
 * has completed/errored. This is used to make sure that universal waits until the first
 * value from firebase but doesn't block the zone forever since the firebase subscription
 * is still alive.
 * @param {?} schedulers
 * @return {?}
 */


function ɵkeepUnstableUntilFirstFactory(schedulers) {
  return (
    /**
    * @template T
    * @param {?} obs$
    * @return {?}
    */
    function keepUnstableUntilFirst(obs$) {
      obs$ = obs$.lift(new ɵBlockUntilFirstOperator(schedulers.ngZone));
      return obs$.pipe( // Run the subscribe body outside of Angular (e.g. calling Firebase SDK to add a listener to a change event)
      (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.subscribeOn)(schedulers.outsideAngular), // Run operators inside the angular zone (e.g. side effects via tap())
      (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.observeOn)(schedulers.insideAngular) // INVESTIGATE https://github.com/angular/angularfire/pull/2315
      // share()
      );
    }
  );
} // DEBUG quick debugger function for inline logging that typescript doesn't complain about
//       wrote it for debugging the ɵlazySDKProxy, commenting out for now; should consider exposing a
//       verbose mode for AngularFire in a future release that uses something like this in multiple places
//       usage: () => log('something') || returnValue
// const log = (...args: any[]): false => { console.log(...args); return false }
// The problem here are things like ngOnDestroy are missing, then triggering the service
// rather than dig too far; I'm capturing these as I go.

/** @type {?} */


const noopFunctions = ['ngOnDestroy']; // INVESTIGATE should we make the Proxy revokable and do some cleanup?
//             right now it's fairly simple but I'm sure this will grow in complexity

/** @type {?} */

const ɵlazySDKProxy =
/**
* @param {?} klass
* @param {?} observable
* @param {?} zone
* @param {?=} options
* @return {?}
*/
(klass, observable, zone, options = {}) => {
  return new Proxy(klass, {
    get:
    /**
    * @param {?} _
    * @param {?} name
    * @return {?}
    */
    (_, name) => zone.runOutsideAngular(
    /**
    * @return {?}
    */
    () => {
      var _a;

      if (klass[name]) {
        if ((_a = options === null || options === void 0 ? void 0 : options.spy) === null || _a === void 0 ? void 0 : _a.get) {
          options.spy.get(name, klass[name]);
        }

        return klass[name];
      }

      if (noopFunctions.indexOf(name) > -1) {
        return (
          /**
          * @return {?}
          */
          () => {}
        );
      }
      /** @type {?} */


      const promise = observable.toPromise().then(
      /**
      * @param {?} mod
      * @return {?}
      */
      mod => {
        /** @type {?} */
        const ret = mod && mod[name]; // TODO move to proper type guards

        if (typeof ret === 'function') {
          return ret.bind(mod);
        } else if (ret && ret.then) {
          return ret.then(
          /**
          * @param {?} res
          * @return {?}
          */
          res => zone.run(
          /**
          * @return {?}
          */
          () => res));
        } else {
          return zone.run(
          /**
          * @return {?}
          */
          () => ret);
        }
      }); // recurse the proxy

      return new Proxy(
      /**
      * @return {?}
      */
      () => {}, {
        get:
        /**
        * @param {?} _
        * @param {?} name
        * @return {?}
        */
        (_, name) => promise[name],
        // TODO handle callbacks as transparently as I can
        apply:
        /**
        * @param {?} self
        * @param {?} _
        * @param {?} args
        * @return {?}
        */
        (self, _, args) => promise.then(
        /**
        * @param {?} it
        * @return {?}
        */
        it => {
          var _a;
          /** @type {?} */


          const res = it && it(...args);

          if ((_a = options === null || options === void 0 ? void 0 : options.spy) === null || _a === void 0 ? void 0 : _a.apply) {
            options.spy.apply(name, args, res);
          }

          return res;
        })
      });
    })
  });
};
/** @type {?} */


const ɵapplyMixins =
/**
* @param {?} derivedCtor
* @param {?} constructors
* @return {?}
*/
(derivedCtor, constructors) => {
  constructors.forEach(
  /**
  * @param {?} baseCtor
  * @return {?}
  */
  baseCtor => {
    Object.getOwnPropertyNames(baseCtor.prototype || baseCtor).forEach(
    /**
    * @param {?} name
    * @return {?}
    */
    name => {
      Object.defineProperty(derivedCtor.prototype, name, Object.getOwnPropertyDescriptor(baseCtor.prototype || baseCtor, name));
    });
  });
};
/**
 * @fileoverview added by tsickle
 * Generated from: firebase.app.module.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @record
 */


function FirebaseOptions() {}
/**
 * @record
 */


function FirebaseAppConfig() {}
/** @type {?} */


const FIREBASE_OPTIONS = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_6__.InjectionToken('angularfire2.app.options');
/** @type {?} */

const FIREBASE_APP_NAME = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_6__.InjectionToken('angularfire2.app.nameOrConfig'); // Have to implement as we need to return a class from the provider, we should consider exporting
// this in the firebase/app types as this is our highest risk of breaks

class FirebaseApp {}

if (false) {}
/** @type {?} */


const VERSION = /*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_6__.Version('6.1.4');
/**
 * @param {?} options
 * @param {?} zone
 * @param {?=} nameOrConfig
 * @return {?}
 */

function ɵfirebaseAppFactory(options, zone, nameOrConfig) {
  /** @type {?} */
  const name = typeof nameOrConfig === 'string' && nameOrConfig || '[DEFAULT]';
  /** @type {?} */

  const config = typeof nameOrConfig === 'object' && nameOrConfig || {};
  config.name = config.name || name; // Added any due to some inconsistency between @firebase/app and firebase types

  /** @type {?} */

  const existingApp =
  /** @type {?} */
  firebase_app__WEBPACK_IMPORTED_MODULE_0__["default"].apps.filter(
  /**
  * @param {?} app
  * @return {?}
  */
  app => app && app.name === config.name)[0]; // We support FirebaseConfig, initializeApp's public type only accepts string; need to cast as any
  // Could be solved with https://github.com/firebase/firebase-js-sdk/pull/1206

  /** @type {?} */

  const app =
  /** @type {?} */
  existingApp || zone.runOutsideAngular(
  /**
  * @return {?}
  */
  () => firebase_app__WEBPACK_IMPORTED_MODULE_0__["default"].initializeApp(options,
  /** @type {?} */
  config));

  try {
    if (JSON.stringify(options) !== JSON.stringify(app.options)) {
      /** @type {?} */
      const hmr = !!
      /** @type {?} */
      module.hot;
      log('error', `${app.name} Firebase App already initialized with different options${hmr ? ', you may need to reload as Firebase is not HMR aware.' : '.'}`);
    }
  } catch (e) {}

  return app;
}
/** @type {?} */


const ɵlogAuthEmulatorError =
/**
* @return {?}
*/
() => {
  // TODO sort this out, https://github.com/angular/angularfire/issues/2656
  log('warn', 'You may need to import \'firebase/auth\' manually in your component rather than rely on AngularFireAuth\'s dynamic import, when using the emulator suite https://github.com/angular/angularfire/issues/2656');
};
/** @type {?} */


const log =
/**
* @param {?} level
* @param {...?} args
* @return {?}
*/
(level, ...args) => {
  if ((0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.isDevMode)() && typeof console !== 'undefined') {
    console[level](...args);
  }
};

const ɵ0 = log;
globalThis.ɵAngularfireInstanceCache || (globalThis.ɵAngularfireInstanceCache = /*#__PURE__*/new Map());
/**
 * @template T
 * @param {?} cacheKey
 * @param {?} moduleName
 * @param {?} app
 * @param {?} fn
 * @param {?} args
 * @return {?}
 */

function ɵfetchInstance(cacheKey, moduleName, app, fn, args) {
  const [instance, ...cachedArgs] = globalThis.ɵAngularfireInstanceCache.get(cacheKey) || [];

  if (instance) {
    try {
      if (args.some(
      /**
      * @param {?} arg
      * @param {?} i
      * @return {?}
      */
      (arg, i) => {
        /** @type {?} */
        const cachedArg = cachedArgs[i];

        if (arg && typeof arg === 'object') {
          return JSON.stringify(arg) !== JSON.stringify(cachedArg);
        } else {
          return arg !== cachedArg;
        }
      })) {
        /** @type {?} */
        const hmr = !!
        /** @type {?} */
        module.hot;
        log('error', `${moduleName} was already initialized on the ${app.name} Firebase App instance with different settings.${hmr ? ' You may need to reload as Firebase is not HMR aware.' : ''}`);
      }
    } catch (e) {}

    return instance;
  } else {
    /** @type {?} */
    const newInstance = fn();
    globalThis.ɵAngularfireInstanceCache.set(cacheKey, [newInstance, ...args]);
    return newInstance;
  }
}
/** @type {?} */


const FIREBASE_APP_PROVIDER = {
  provide: FirebaseApp,
  useFactory: ɵfirebaseAppFactory,
  deps: [FIREBASE_OPTIONS, _angular_core__WEBPACK_IMPORTED_MODULE_6__.NgZone, [/*#__PURE__*/new _angular_core__WEBPACK_IMPORTED_MODULE_6__.Optional(), FIREBASE_APP_NAME]]
};
let AngularFireModule = /*#__PURE__*/(() => {
  class AngularFireModule {
    // tslint:disable-next-line:ban-types

    /**
     * @param {?} platformId
     */
    constructor(platformId) {
      firebase_app__WEBPACK_IMPORTED_MODULE_0__["default"].registerVersion('angularfire', VERSION.full, platformId.toString());
      firebase_app__WEBPACK_IMPORTED_MODULE_0__["default"].registerVersion('angular', _angular_core__WEBPACK_IMPORTED_MODULE_6__.VERSION.full);
    }
    /**
     * @param {?} options
     * @param {?=} nameOrConfig
     * @return {?}
     */


    static initializeApp(options, nameOrConfig) {
      return {
        ngModule: AngularFireModule,
        providers: [{
          provide: FIREBASE_OPTIONS,
          useValue: options
        }, {
          provide: FIREBASE_APP_NAME,
          useValue: nameOrConfig
        }]
      };
    }

  }

  AngularFireModule.ɵfac = function AngularFireModule_Factory(t) {
    return new (t || AngularFireModule)(_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_6__.PLATFORM_ID));
  };

  AngularFireModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineNgModule"]({
    type: AngularFireModule
  });
  AngularFireModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineInjector"]({
    providers: [FIREBASE_APP_PROVIDER]
  });
  /** @nocollapse */

  return AngularFireModule;
})();

/*#__PURE__*/
(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * @fileoverview added by tsickle
 * Generated from: public_api.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * Generated from: angular-fire.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */




/***/ }),

/***/ 20476:
/*!******************************************************!*\
  !*** ./node_modules/@firebase/app/dist/index.esm.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "firebase": () => (/* binding */ firebase$1)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 7207);
/* harmony import */ var _firebase_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @firebase/util */ 57541);
/* harmony import */ var _firebase_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @firebase/component */ 45947);
/* harmony import */ var _firebase_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @firebase/logger */ 66265);




/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var _a;

var ERRORS = (_a = {}, _a["no-app"
/* NO_APP */
] = "No Firebase App '{$appName}' has been created - " + 'call Firebase App.initializeApp()', _a["bad-app-name"
/* BAD_APP_NAME */
] = "Illegal App name: '{$appName}", _a["duplicate-app"
/* DUPLICATE_APP */
] = "Firebase App named '{$appName}' already exists", _a["app-deleted"
/* APP_DELETED */
] = "Firebase App named '{$appName}' already deleted", _a["invalid-app-argument"
/* INVALID_APP_ARGUMENT */
] = 'firebase.{$appName}() takes either no argument or a ' + 'Firebase App instance.', _a["invalid-log-argument"
/* INVALID_LOG_ARGUMENT */
] = 'First argument to `onLog` must be null or a function.', _a);
var ERROR_FACTORY = new _firebase_util__WEBPACK_IMPORTED_MODULE_0__.ErrorFactory('app', 'Firebase', ERRORS);
var name$1 = "@firebase/app";
var version = "0.6.13";
var name$2 = "@firebase/analytics";
var name$3 = "@firebase/auth";
var name$4 = "@firebase/database";
var name$5 = "@firebase/functions";
var name$6 = "@firebase/installations";
var name$7 = "@firebase/messaging";
var name$8 = "@firebase/performance";
var name$9 = "@firebase/remote-config";
var name$a = "@firebase/storage";
var name$b = "@firebase/firestore";
var name$c = "firebase-wrapper";
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var _a$1;

var DEFAULT_ENTRY_NAME = '[DEFAULT]';
var PLATFORM_LOG_STRING = (_a$1 = {}, _a$1[name$1] = 'fire-core', _a$1[name$2] = 'fire-analytics', _a$1[name$3] = 'fire-auth', _a$1[name$4] = 'fire-rtdb', _a$1[name$5] = 'fire-fn', _a$1[name$6] = 'fire-iid', _a$1[name$7] = 'fire-fcm', _a$1[name$8] = 'fire-perf', _a$1[name$9] = 'fire-rc', _a$1[name$a] = 'fire-gcs', _a$1[name$b] = 'fire-fst', _a$1['fire-js'] = 'fire-js', _a$1[name$c] = 'fire-js-all', _a$1);
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var logger = new _firebase_logger__WEBPACK_IMPORTED_MODULE_2__.Logger('@firebase/app');
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Global context object for a collection of services using
 * a shared authentication state.
 */

var FirebaseAppImpl =
/** @class */
function () {
  function FirebaseAppImpl(options, config, firebase_) {
    var e_1, _a;

    var _this = this;

    this.firebase_ = firebase_;
    this.isDeleted_ = false;
    this.name_ = config.name;
    this.automaticDataCollectionEnabled_ = config.automaticDataCollectionEnabled || false;
    this.options_ = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.deepCopy)(options);
    this.container = new _firebase_component__WEBPACK_IMPORTED_MODULE_1__.ComponentContainer(config.name); // add itself to container

    this._addComponent(new _firebase_component__WEBPACK_IMPORTED_MODULE_1__.Component('app', function () {
      return _this;
    }, "PUBLIC"
    /* PUBLIC */
    ));

    try {
      // populate ComponentContainer with existing components
      for (var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__values)(this.firebase_.INTERNAL.components.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
        var component = _c.value;

        this._addComponent(component);
      }
    } catch (e_1_1) {
      e_1 = {
        error: e_1_1
      };
    } finally {
      try {
        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
      } finally {
        if (e_1) throw e_1.error;
      }
    }
  }

  Object.defineProperty(FirebaseAppImpl.prototype, "automaticDataCollectionEnabled", {
    get: function () {
      this.checkDestroyed_();
      return this.automaticDataCollectionEnabled_;
    },
    set: function (val) {
      this.checkDestroyed_();
      this.automaticDataCollectionEnabled_ = val;
    },
    enumerable: false,
    configurable: true
  });
  Object.defineProperty(FirebaseAppImpl.prototype, "name", {
    get: function () {
      this.checkDestroyed_();
      return this.name_;
    },
    enumerable: false,
    configurable: true
  });
  Object.defineProperty(FirebaseAppImpl.prototype, "options", {
    get: function () {
      this.checkDestroyed_();
      return this.options_;
    },
    enumerable: false,
    configurable: true
  });

  FirebaseAppImpl.prototype.delete = function () {
    var _this = this;

    return new Promise(function (resolve) {
      _this.checkDestroyed_();

      resolve();
    }).then(function () {
      _this.firebase_.INTERNAL.removeApp(_this.name_);

      return Promise.all(_this.container.getProviders().map(function (provider) {
        return provider.delete();
      }));
    }).then(function () {
      _this.isDeleted_ = true;
    });
  };
  /**
   * Return a service instance associated with this app (creating it
   * on demand), identified by the passed instanceIdentifier.
   *
   * NOTE: Currently storage and functions are the only ones that are leveraging this
   * functionality. They invoke it by calling:
   *
   * ```javascript
   * firebase.app().storage('STORAGE BUCKET ID')
   * ```
   *
   * The service name is passed to this already
   * @internal
   */


  FirebaseAppImpl.prototype._getService = function (name, instanceIdentifier) {
    if (instanceIdentifier === void 0) {
      instanceIdentifier = DEFAULT_ENTRY_NAME;
    }

    this.checkDestroyed_(); // getImmediate will always succeed because _getService is only called for registered components.

    return this.container.getProvider(name).getImmediate({
      identifier: instanceIdentifier
    });
  };
  /**
   * Remove a service instance from the cache, so we will create a new instance for this service
   * when people try to get this service again.
   *
   * NOTE: currently only firestore is using this functionality to support firestore shutdown.
   *
   * @param name The service name
   * @param instanceIdentifier instance identifier in case multiple instances are allowed
   * @internal
   */


  FirebaseAppImpl.prototype._removeServiceInstance = function (name, instanceIdentifier) {
    if (instanceIdentifier === void 0) {
      instanceIdentifier = DEFAULT_ENTRY_NAME;
    } // eslint-disable-next-line @typescript-eslint/no-explicit-any


    this.container.getProvider(name).clearInstance(instanceIdentifier);
  };
  /**
   * @param component the component being added to this app's container
   */


  FirebaseAppImpl.prototype._addComponent = function (component) {
    try {
      this.container.addComponent(component);
    } catch (e) {
      logger.debug("Component " + component.name + " failed to register with FirebaseApp " + this.name, e);
    }
  };

  FirebaseAppImpl.prototype._addOrOverwriteComponent = function (component) {
    this.container.addOrOverwriteComponent(component);
  };
  /**
   * This function will throw an Error if the App has already been deleted -
   * use before performing API actions on the App.
   */


  FirebaseAppImpl.prototype.checkDestroyed_ = function () {
    if (this.isDeleted_) {
      throw ERROR_FACTORY.create("app-deleted"
      /* APP_DELETED */
      , {
        appName: this.name_
      });
    }
  };

  return FirebaseAppImpl;
}(); // Prevent dead-code elimination of these methods w/o invalid property
// copying.


FirebaseAppImpl.prototype.name && FirebaseAppImpl.prototype.options || FirebaseAppImpl.prototype.delete || console.log('dc');
var version$1 = "8.0.1";
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Because auth can't share code with other components, we attach the utility functions
 * in an internal namespace to share code.
 * This function return a firebase namespace object without
 * any utility functions, so it can be shared between the regular firebaseNamespace and
 * the lite version.
 */

function createFirebaseNamespaceCore(firebaseAppImpl) {
  var apps = {}; // eslint-disable-next-line @typescript-eslint/no-explicit-any

  var components = new Map(); // A namespace is a plain JavaScript Object.

  var namespace = {
    // Hack to prevent Babel from modifying the object returned
    // as the firebase namespace.
    // @ts-ignore
    __esModule: true,
    initializeApp: initializeApp,
    // @ts-ignore
    app: app,
    registerVersion: registerVersion,
    setLogLevel: _firebase_logger__WEBPACK_IMPORTED_MODULE_2__.setLogLevel,
    onLog: onLog,
    // @ts-ignore
    apps: null,
    SDK_VERSION: version$1,
    INTERNAL: {
      registerComponent: registerComponent,
      removeApp: removeApp,
      components: components,
      useAsService: useAsService
    }
  }; // Inject a circular default export to allow Babel users who were previously
  // using:
  //
  //   import firebase from 'firebase';
  //   which becomes: var firebase = require('firebase').default;
  //
  // instead of
  //
  //   import * as firebase from 'firebase';
  //   which becomes: var firebase = require('firebase');
  // eslint-disable-next-line @typescript-eslint/no-explicit-any

  namespace['default'] = namespace; // firebase.apps is a read-only getter.

  Object.defineProperty(namespace, 'apps', {
    get: getApps
  });
  /**
   * Called by App.delete() - but before any services associated with the App
   * are deleted.
   */

  function removeApp(name) {
    delete apps[name];
  }
  /**
   * Get the App object for a given name (or DEFAULT).
   */


  function app(name) {
    name = name || DEFAULT_ENTRY_NAME;

    if (!(0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.contains)(apps, name)) {
      throw ERROR_FACTORY.create("no-app"
      /* NO_APP */
      , {
        appName: name
      });
    }

    return apps[name];
  } // @ts-ignore


  app['App'] = firebaseAppImpl;

  function initializeApp(options, rawConfig) {
    if (rawConfig === void 0) {
      rawConfig = {};
    }

    if (typeof rawConfig !== 'object' || rawConfig === null) {
      var name_1 = rawConfig;
      rawConfig = {
        name: name_1
      };
    }

    var config = rawConfig;

    if (config.name === undefined) {
      config.name = DEFAULT_ENTRY_NAME;
    }

    var name = config.name;

    if (typeof name !== 'string' || !name) {
      throw ERROR_FACTORY.create("bad-app-name"
      /* BAD_APP_NAME */
      , {
        appName: String(name)
      });
    }

    if ((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.contains)(apps, name)) {
      throw ERROR_FACTORY.create("duplicate-app"
      /* DUPLICATE_APP */
      , {
        appName: name
      });
    }

    var app = new firebaseAppImpl(options, config, namespace);
    apps[name] = app;
    return app;
  }
  /*
   * Return an array of all the non-deleted FirebaseApps.
   */


  function getApps() {
    // Make a copy so caller cannot mutate the apps list.
    return Object.keys(apps).map(function (name) {
      return apps[name];
    });
  }

  function registerComponent(component) {
    var e_1, _a;

    var componentName = component.name;

    if (components.has(componentName)) {
      logger.debug("There were multiple attempts to register component " + componentName + ".");
      return component.type === "PUBLIC"
      /* PUBLIC */
      ? // eslint-disable-next-line @typescript-eslint/no-explicit-any
      namespace[componentName] : null;
    }

    components.set(componentName, component); // create service namespace for public components

    if (component.type === "PUBLIC"
    /* PUBLIC */
    ) {
      // The Service namespace is an accessor function ...
      var serviceNamespace = function (appArg) {
        if (appArg === void 0) {
          appArg = app();
        } // eslint-disable-next-line @typescript-eslint/no-explicit-any


        if (typeof appArg[componentName] !== 'function') {
          // Invalid argument.
          // This happens in the following case: firebase.storage('gs:/')
          throw ERROR_FACTORY.create("invalid-app-argument"
          /* INVALID_APP_ARGUMENT */
          , {
            appName: componentName
          });
        } // Forward service instance lookup to the FirebaseApp.
        // eslint-disable-next-line @typescript-eslint/no-explicit-any


        return appArg[componentName]();
      }; // ... and a container for service-level properties.


      if (component.serviceProps !== undefined) {
        (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.deepExtend)(serviceNamespace, component.serviceProps);
      } // eslint-disable-next-line @typescript-eslint/no-explicit-any


      namespace[componentName] = serviceNamespace; // Patch the FirebaseAppImpl prototype
      // eslint-disable-next-line @typescript-eslint/no-explicit-any

      firebaseAppImpl.prototype[componentName] = // TODO: The eslint disable can be removed and the 'ignoreRestArgs'
      // option added to the no-explicit-any rule when ESlint releases it.
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      function () {
        var args = [];

        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }

        var serviceFxn = this._getService.bind(this, componentName);

        return serviceFxn.apply(this, component.multipleInstances ? args : []);
      };
    }

    try {
      // add the component to existing app instances
      for (var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__values)(Object.keys(apps)), _c = _b.next(); !_c.done; _c = _b.next()) {
        var appName = _c.value;

        apps[appName]._addComponent(component);
      }
    } catch (e_1_1) {
      e_1 = {
        error: e_1_1
      };
    } finally {
      try {
        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
      } finally {
        if (e_1) throw e_1.error;
      }
    }

    return component.type === "PUBLIC"
    /* PUBLIC */
    ? // eslint-disable-next-line @typescript-eslint/no-explicit-any
    namespace[componentName] : null;
  }

  function registerVersion(libraryKeyOrName, version, variant) {
    var _a; // TODO: We can use this check to whitelist strings when/if we set up
    // a good whitelist system.


    var library = (_a = PLATFORM_LOG_STRING[libraryKeyOrName]) !== null && _a !== void 0 ? _a : libraryKeyOrName;

    if (variant) {
      library += "-" + variant;
    }

    var libraryMismatch = library.match(/\s|\//);
    var versionMismatch = version.match(/\s|\//);

    if (libraryMismatch || versionMismatch) {
      var warning = ["Unable to register library \"" + library + "\" with version \"" + version + "\":"];

      if (libraryMismatch) {
        warning.push("library name \"" + library + "\" contains illegal characters (whitespace or \"/\")");
      }

      if (libraryMismatch && versionMismatch) {
        warning.push('and');
      }

      if (versionMismatch) {
        warning.push("version name \"" + version + "\" contains illegal characters (whitespace or \"/\")");
      }

      logger.warn(warning.join(' '));
      return;
    }

    registerComponent(new _firebase_component__WEBPACK_IMPORTED_MODULE_1__.Component(library + "-version", function () {
      return {
        library: library,
        version: version
      };
    }, "VERSION"
    /* VERSION */
    ));
  }

  function onLog(logCallback, options) {
    if (logCallback !== null && typeof logCallback !== 'function') {
      throw ERROR_FACTORY.create("invalid-log-argument"
      /* INVALID_LOG_ARGUMENT */
      , {
        appName: name
      });
    }

    (0,_firebase_logger__WEBPACK_IMPORTED_MODULE_2__.setUserLogHandler)(logCallback, options);
  } // Map the requested service to a registered service name
  // (used to map auth to serverAuth service when needed).


  function useAsService(app, name) {
    if (name === 'serverAuth') {
      return null;
    }

    var useService = name;
    return useService;
  }

  return namespace;
}
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Return a firebase namespace object.
 *
 * In production, this will be called exactly once and the result
 * assigned to the 'firebase' global.  It may be called multiple times
 * in unit tests.
 */


function createFirebaseNamespace() {
  var namespace = createFirebaseNamespaceCore(FirebaseAppImpl);
  namespace.INTERNAL = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_3__.__assign)({}, namespace.INTERNAL), {
    createFirebaseNamespace: createFirebaseNamespace,
    extendNamespace: extendNamespace,
    createSubscribe: _firebase_util__WEBPACK_IMPORTED_MODULE_0__.createSubscribe,
    ErrorFactory: _firebase_util__WEBPACK_IMPORTED_MODULE_0__.ErrorFactory,
    deepExtend: _firebase_util__WEBPACK_IMPORTED_MODULE_0__.deepExtend
  });
  /**
   * Patch the top-level firebase namespace with additional properties.
   *
   * firebase.INTERNAL.extendNamespace()
   */

  function extendNamespace(props) {
    (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.deepExtend)(namespace, props);
  }

  return namespace;
}

var firebase = createFirebaseNamespace();
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var PlatformLoggerService =
/** @class */
function () {
  function PlatformLoggerService(container) {
    this.container = container;
  } // In initial implementation, this will be called by installations on
  // auth token refresh, and installations will send this string.


  PlatformLoggerService.prototype.getPlatformInfoString = function () {
    var providers = this.container.getProviders(); // Loop through providers and get library/version pairs from any that are
    // version components.

    return providers.map(function (provider) {
      if (isVersionServiceProvider(provider)) {
        var service = provider.getImmediate();
        return service.library + "/" + service.version;
      } else {
        return null;
      }
    }).filter(function (logString) {
      return logString;
    }).join(' ');
  };

  return PlatformLoggerService;
}();
/**
 *
 * @param provider check if this provider provides a VersionService
 *
 * NOTE: Using Provider<'app-version'> is a hack to indicate that the provider
 * provides VersionService. The provider is not necessarily a 'app-version'
 * provider.
 */


function isVersionServiceProvider(provider) {
  var component = provider.getComponent();
  return (component === null || component === void 0 ? void 0 : component.type) === "VERSION"
  /* VERSION */
  ;
}
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


function registerCoreComponents(firebase, variant) {
  firebase.INTERNAL.registerComponent(new _firebase_component__WEBPACK_IMPORTED_MODULE_1__.Component('platform-logger', function (container) {
    return new PlatformLoggerService(container);
  }, "PRIVATE"
  /* PRIVATE */
  )); // Register `app` package.

  firebase.registerVersion(name$1, version, variant); // Register platform SDK identifier (no version).

  firebase.registerVersion('fire-js', '');
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Firebase Lite detection test
// eslint-disable-next-line @typescript-eslint/no-explicit-any


if ((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.isBrowser)() && self.firebase !== undefined) {
  logger.warn("\n    Warning: Firebase is already defined in the global scope. Please make sure\n    Firebase library is only loaded once.\n  "); // eslint-disable-next-line

  var sdkVersion = self.firebase.SDK_VERSION;

  if (sdkVersion && sdkVersion.indexOf('LITE') >= 0) {
    logger.warn("\n    Warning: You are trying to load Firebase while using Firebase Performance standalone script.\n    You should load Firebase Performance with this instance of Firebase to avoid loading duplicate code.\n    ");
  }
}

var initializeApp = firebase.initializeApp; // TODO: This disable can be removed and the 'ignoreRestArgs' option added to
// the no-explicit-any rule when ESlint releases it.
// eslint-disable-next-line @typescript-eslint/no-explicit-any

firebase.initializeApp = function () {
  var args = [];

  for (var _i = 0; _i < arguments.length; _i++) {
    args[_i] = arguments[_i];
  } // Environment check before initializing app
  // Do the check in initializeApp, so people have a chance to disable it by setting logLevel
  // in @firebase/logger


  if ((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.isNode)()) {
    logger.warn("\n      Warning: This is a browser-targeted Firebase bundle but it appears it is being\n      run in a Node environment.  If running in a Node environment, make sure you\n      are using the bundle specified by the \"main\" field in package.json.\n      \n      If you are using Webpack, you can specify \"main\" as the first item in\n      \"resolve.mainFields\":\n      https://webpack.js.org/configuration/resolve/#resolvemainfields\n      \n      If using Rollup, use the @rollup/plugin-node-resolve plugin and specify \"main\"\n      as the first item in \"mainFields\", e.g. ['main', 'module'].\n      https://github.com/rollup/@rollup/plugin-node-resolve\n      ");
  }

  return initializeApp.apply(undefined, args);
};

var firebase$1 = firebase;
registerCoreComponents(firebase$1);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (firebase$1);


/***/ }),

/***/ 45947:
/*!************************************************************!*\
  !*** ./node_modules/@firebase/component/dist/index.esm.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Component": () => (/* binding */ Component),
/* harmony export */   "ComponentContainer": () => (/* binding */ ComponentContainer),
/* harmony export */   "Provider": () => (/* binding */ Provider)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 94488);
/* harmony import */ var _firebase_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @firebase/util */ 57541);


/**
 * Component for service name T, e.g. `auth`, `auth-internal`
 */

var Component =
/** @class */
function () {
  /**
   *
   * @param name The public service name, e.g. app, auth, firestore, database
   * @param instanceFactory Service factory responsible for creating the public interface
   * @param type whether the service provided by the component is public or private
   */
  function Component(name, instanceFactory, type) {
    this.name = name;
    this.instanceFactory = instanceFactory;
    this.type = type;
    this.multipleInstances = false;
    /**
     * Properties to be added to the service namespace
     */

    this.serviceProps = {};
    this.instantiationMode = "LAZY"
    /* LAZY */
    ;
  }

  Component.prototype.setInstantiationMode = function (mode) {
    this.instantiationMode = mode;
    return this;
  };

  Component.prototype.setMultipleInstances = function (multipleInstances) {
    this.multipleInstances = multipleInstances;
    return this;
  };

  Component.prototype.setServiceProps = function (props) {
    this.serviceProps = props;
    return this;
  };

  return Component;
}();
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var DEFAULT_ENTRY_NAME = '[DEFAULT]';
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Provider for instance for service name T, e.g. 'auth', 'auth-internal'
 * NameServiceMapping[T] is an alias for the type of the instance
 */

var Provider =
/** @class */
function () {
  function Provider(name, container) {
    this.name = name;
    this.container = container;
    this.component = null;
    this.instances = new Map();
    this.instancesDeferred = new Map();
  }
  /**
   * @param identifier A provider can provide mulitple instances of a service
   * if this.component.multipleInstances is true.
   */


  Provider.prototype.get = function (identifier) {
    if (identifier === void 0) {
      identifier = DEFAULT_ENTRY_NAME;
    } // if multipleInstances is not supported, use the default name


    var normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);

    if (!this.instancesDeferred.has(normalizedIdentifier)) {
      var deferred = new _firebase_util__WEBPACK_IMPORTED_MODULE_0__.Deferred();
      this.instancesDeferred.set(normalizedIdentifier, deferred); // If the service instance is available, resolve the promise with it immediately

      try {
        var instance = this.getOrInitializeService(normalizedIdentifier);

        if (instance) {
          deferred.resolve(instance);
        }
      } catch (e) {// when the instance factory throws an exception during get(), it should not cause
        // a fatal error. We just return the unresolved promise in this case.
      }
    }

    return this.instancesDeferred.get(normalizedIdentifier).promise;
  };

  Provider.prototype.getImmediate = function (options) {
    var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({
      identifier: DEFAULT_ENTRY_NAME,
      optional: false
    }, options),
        identifier = _a.identifier,
        optional = _a.optional; // if multipleInstances is not supported, use the default name


    var normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);

    try {
      var instance = this.getOrInitializeService(normalizedIdentifier);

      if (!instance) {
        if (optional) {
          return null;
        }

        throw Error("Service " + this.name + " is not available");
      }

      return instance;
    } catch (e) {
      if (optional) {
        return null;
      } else {
        throw e;
      }
    }
  };

  Provider.prototype.getComponent = function () {
    return this.component;
  };

  Provider.prototype.setComponent = function (component) {
    var e_1, _a;

    if (component.name !== this.name) {
      throw Error("Mismatching Component " + component.name + " for Provider " + this.name + ".");
    }

    if (this.component) {
      throw Error("Component for " + this.name + " has already been provided");
    }

    this.component = component; // if the service is eager, initialize the default instance

    if (isComponentEager(component)) {
      try {
        this.getOrInitializeService(DEFAULT_ENTRY_NAME);
      } catch (e) {// when the instance factory for an eager Component throws an exception during the eager
        // initialization, it should not cause a fatal error.
        // TODO: Investigate if we need to make it configurable, because some component may want to cause
        // a fatal error in this case?
      }
    }

    try {
      // Create service instances for the pending promises and resolve them
      // NOTE: if this.multipleInstances is false, only the default instance will be created
      // and all promises with resolve with it regardless of the identifier.
      for (var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__values)(this.instancesDeferred.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
        var _d = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__read)(_c.value, 2),
            instanceIdentifier = _d[0],
            instanceDeferred = _d[1];

        var normalizedIdentifier = this.normalizeInstanceIdentifier(instanceIdentifier);

        try {
          // `getOrInitializeService()` should always return a valid instance since a component is guaranteed. use ! to make typescript happy.
          var instance = this.getOrInitializeService(normalizedIdentifier);
          instanceDeferred.resolve(instance);
        } catch (e) {// when the instance factory throws an exception, it should not cause
          // a fatal error. We just leave the promise unresolved.
        }
      }
    } catch (e_1_1) {
      e_1 = {
        error: e_1_1
      };
    } finally {
      try {
        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
      } finally {
        if (e_1) throw e_1.error;
      }
    }
  };

  Provider.prototype.clearInstance = function (identifier) {
    if (identifier === void 0) {
      identifier = DEFAULT_ENTRY_NAME;
    }

    this.instancesDeferred.delete(identifier);
    this.instances.delete(identifier);
  }; // app.delete() will call this method on every provider to delete the services
  // TODO: should we mark the provider as deleted?


  Provider.prototype.delete = function () {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__awaiter)(this, void 0, void 0, function () {
      var services;
      return (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__generator)(this, function (_a) {
        switch (_a.label) {
          case 0:
            services = Array.from(this.instances.values());
            return [4
            /*yield*/
            , Promise.all((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__spread)(services.filter(function (service) {
              return 'INTERNAL' in service;
            }) // legacy services
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            .map(function (service) {
              return service.INTERNAL.delete();
            }), services.filter(function (service) {
              return '_delete' in service;
            }) // modularized services
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            .map(function (service) {
              return service._delete();
            })))];

          case 1:
            _a.sent();

            return [2
            /*return*/
            ];
        }
      });
    });
  };

  Provider.prototype.isComponentSet = function () {
    return this.component != null;
  };

  Provider.prototype.getOrInitializeService = function (identifier) {
    var instance = this.instances.get(identifier);

    if (!instance && this.component) {
      instance = this.component.instanceFactory(this.container, normalizeIdentifierForFactory(identifier));
      this.instances.set(identifier, instance);
    }

    return instance || null;
  };

  Provider.prototype.normalizeInstanceIdentifier = function (identifier) {
    if (this.component) {
      return this.component.multipleInstances ? identifier : DEFAULT_ENTRY_NAME;
    } else {
      return identifier; // assume multiple instances are supported before the component is provided.
    }
  };

  return Provider;
}(); // undefined should be passed to the service factory for the default instance


function normalizeIdentifierForFactory(identifier) {
  return identifier === DEFAULT_ENTRY_NAME ? undefined : identifier;
}

function isComponentEager(component) {
  return component.instantiationMode === "EAGER"
  /* EAGER */
  ;
}
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * ComponentContainer that provides Providers for service name T, e.g. `auth`, `auth-internal`
 */


var ComponentContainer =
/** @class */
function () {
  function ComponentContainer(name) {
    this.name = name;
    this.providers = new Map();
  }
  /**
   *
   * @param component Component being added
   * @param overwrite When a component with the same name has already been registered,
   * if overwrite is true: overwrite the existing component with the new component and create a new
   * provider with the new component. It can be useful in tests where you want to use different mocks
   * for different tests.
   * if overwrite is false: throw an exception
   */


  ComponentContainer.prototype.addComponent = function (component) {
    var provider = this.getProvider(component.name);

    if (provider.isComponentSet()) {
      throw new Error("Component " + component.name + " has already been registered with " + this.name);
    }

    provider.setComponent(component);
  };

  ComponentContainer.prototype.addOrOverwriteComponent = function (component) {
    var provider = this.getProvider(component.name);

    if (provider.isComponentSet()) {
      // delete the existing provider from the container, so we can register the new component
      this.providers.delete(component.name);
    }

    this.addComponent(component);
  };
  /**
   * getProvider provides a type safe interface where it can only be called with a field name
   * present in NameServiceMapping interface.
   *
   * Firebase SDKs providing services should extend NameServiceMapping interface to register
   * themselves.
   */


  ComponentContainer.prototype.getProvider = function (name) {
    if (this.providers.has(name)) {
      return this.providers.get(name);
    } // create a Provider for a service that hasn't registered with Firebase


    var provider = new Provider(name, this);
    this.providers.set(name, provider);
    return provider;
  };

  ComponentContainer.prototype.getProviders = function () {
    return Array.from(this.providers.values());
  };

  return ComponentContainer;
}();



/***/ }),

/***/ 66265:
/*!*********************************************************!*\
  !*** ./node_modules/@firebase/logger/dist/index.esm.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LogLevel": () => (/* binding */ LogLevel),
/* harmony export */   "Logger": () => (/* binding */ Logger),
/* harmony export */   "setLogLevel": () => (/* binding */ setLogLevel),
/* harmony export */   "setUserLogHandler": () => (/* binding */ setUserLogHandler)
/* harmony export */ });
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;

  for (var r = Array(s), k = 0, i = 0; i < il; i++) for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++) r[k] = a[j];

  return r;
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var _a;
/**
 * A container for all of the Logger instances
 */


var instances = [];
/**
 * The JS SDK supports 5 log levels and also allows a user the ability to
 * silence the logs altogether.
 *
 * The order is a follows:
 * DEBUG < VERBOSE < INFO < WARN < ERROR
 *
 * All of the log types above the current log level will be captured (i.e. if
 * you set the log level to `INFO`, errors will still be logged, but `DEBUG` and
 * `VERBOSE` logs will not)
 */

var LogLevel = /*#__PURE__*/(() => {
  (function (LogLevel) {
    LogLevel[LogLevel["DEBUG"] = 0] = "DEBUG";
    LogLevel[LogLevel["VERBOSE"] = 1] = "VERBOSE";
    LogLevel[LogLevel["INFO"] = 2] = "INFO";
    LogLevel[LogLevel["WARN"] = 3] = "WARN";
    LogLevel[LogLevel["ERROR"] = 4] = "ERROR";
    LogLevel[LogLevel["SILENT"] = 5] = "SILENT";
  })(LogLevel || (LogLevel = {}));

  return LogLevel;
})();
var levelStringToEnum = {
  'debug': LogLevel.DEBUG,
  'verbose': LogLevel.VERBOSE,
  'info': LogLevel.INFO,
  'warn': LogLevel.WARN,
  'error': LogLevel.ERROR,
  'silent': LogLevel.SILENT
};
/**
 * The default log level
 */

var defaultLogLevel = LogLevel.INFO;
/**
 * By default, `console.debug` is not displayed in the developer console (in
 * chrome). To avoid forcing users to have to opt-in to these logs twice
 * (i.e. once for firebase, and once in the console), we are sending `DEBUG`
 * logs to the `console.log` function.
 */

var ConsoleMethod = (_a = {}, _a[LogLevel.DEBUG] = 'log', _a[LogLevel.VERBOSE] = 'log', _a[LogLevel.INFO] = 'info', _a[LogLevel.WARN] = 'warn', _a[LogLevel.ERROR] = 'error', _a);
/**
 * The default log handler will forward DEBUG, VERBOSE, INFO, WARN, and ERROR
 * messages on to their corresponding console counterparts (if the log method
 * is supported by the current log level)
 */

var defaultLogHandler = function (instance, logType) {
  var args = [];

  for (var _i = 2; _i < arguments.length; _i++) {
    args[_i - 2] = arguments[_i];
  }

  if (logType < instance.logLevel) {
    return;
  }

  var now = new Date().toISOString();
  var method = ConsoleMethod[logType];

  if (method) {
    console[method].apply(console, __spreadArrays(["[" + now + "]  " + instance.name + ":"], args));
  } else {
    throw new Error("Attempted to log a message with an invalid logType (value: " + logType + ")");
  }
};

var Logger =
/** @class */
function () {
  /**
   * Gives you an instance of a Logger to capture messages according to
   * Firebase's logging scheme.
   *
   * @param name The name that the logs will be associated with
   */
  function Logger(name) {
    this.name = name;
    /**
     * The log level of the given Logger instance.
     */

    this._logLevel = defaultLogLevel;
    /**
     * The main (internal) log handler for the Logger instance.
     * Can be set to a new function in internal package code but not by user.
     */

    this._logHandler = defaultLogHandler;
    /**
     * The optional, additional, user-defined log handler for the Logger instance.
     */

    this._userLogHandler = null;
    /**
     * Capture the current instance for later use
     */

    instances.push(this);
  }

  Object.defineProperty(Logger.prototype, "logLevel", {
    get: function () {
      return this._logLevel;
    },
    set: function (val) {
      if (!(val in LogLevel)) {
        throw new TypeError("Invalid value \"" + val + "\" assigned to `logLevel`");
      }

      this._logLevel = val;
    },
    enumerable: false,
    configurable: true
  }); // Workaround for setter/getter having to be the same type.

  Logger.prototype.setLogLevel = function (val) {
    this._logLevel = typeof val === 'string' ? levelStringToEnum[val] : val;
  };

  Object.defineProperty(Logger.prototype, "logHandler", {
    get: function () {
      return this._logHandler;
    },
    set: function (val) {
      if (typeof val !== 'function') {
        throw new TypeError('Value assigned to `logHandler` must be a function');
      }

      this._logHandler = val;
    },
    enumerable: false,
    configurable: true
  });
  Object.defineProperty(Logger.prototype, "userLogHandler", {
    get: function () {
      return this._userLogHandler;
    },
    set: function (val) {
      this._userLogHandler = val;
    },
    enumerable: false,
    configurable: true
  });
  /**
   * The functions below are all based on the `console` interface
   */

  Logger.prototype.debug = function () {
    var args = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }

    this._userLogHandler && this._userLogHandler.apply(this, __spreadArrays([this, LogLevel.DEBUG], args));

    this._logHandler.apply(this, __spreadArrays([this, LogLevel.DEBUG], args));
  };

  Logger.prototype.log = function () {
    var args = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }

    this._userLogHandler && this._userLogHandler.apply(this, __spreadArrays([this, LogLevel.VERBOSE], args));

    this._logHandler.apply(this, __spreadArrays([this, LogLevel.VERBOSE], args));
  };

  Logger.prototype.info = function () {
    var args = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }

    this._userLogHandler && this._userLogHandler.apply(this, __spreadArrays([this, LogLevel.INFO], args));

    this._logHandler.apply(this, __spreadArrays([this, LogLevel.INFO], args));
  };

  Logger.prototype.warn = function () {
    var args = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }

    this._userLogHandler && this._userLogHandler.apply(this, __spreadArrays([this, LogLevel.WARN], args));

    this._logHandler.apply(this, __spreadArrays([this, LogLevel.WARN], args));
  };

  Logger.prototype.error = function () {
    var args = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }

    this._userLogHandler && this._userLogHandler.apply(this, __spreadArrays([this, LogLevel.ERROR], args));

    this._logHandler.apply(this, __spreadArrays([this, LogLevel.ERROR], args));
  };

  return Logger;
}();

function setLogLevel(level) {
  instances.forEach(function (inst) {
    inst.setLogLevel(level);
  });
}

function setUserLogHandler(logCallback, options) {
  var _loop_1 = function (instance) {
    var customLogLevel = null;

    if (options && options.level) {
      customLogLevel = levelStringToEnum[options.level];
    }

    if (logCallback === null) {
      instance.userLogHandler = null;
    } else {
      instance.userLogHandler = function (instance, level) {
        var args = [];

        for (var _i = 2; _i < arguments.length; _i++) {
          args[_i - 2] = arguments[_i];
        }

        var message = args.map(function (arg) {
          if (arg == null) {
            return null;
          } else if (typeof arg === 'string') {
            return arg;
          } else if (typeof arg === 'number' || typeof arg === 'boolean') {
            return arg.toString();
          } else if (arg instanceof Error) {
            return arg.message;
          } else {
            try {
              return JSON.stringify(arg);
            } catch (ignored) {
              return null;
            }
          }
        }).filter(function (arg) {
          return arg;
        }).join(' ');

        if (level >= (customLogLevel !== null && customLogLevel !== void 0 ? customLogLevel : instance.logLevel)) {
          logCallback({
            level: LogLevel[level].toLowerCase(),
            message: message,
            args: args,
            type: instance.name
          });
        }
      };
    }
  };

  for (var _i = 0, instances_1 = instances; _i < instances_1.length; _i++) {
    var instance = instances_1[_i];

    _loop_1(instance);
  }
}



/***/ }),

/***/ 57541:
/*!*******************************************************!*\
  !*** ./node_modules/@firebase/util/dist/index.esm.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CONSTANTS": () => (/* binding */ CONSTANTS),
/* harmony export */   "Deferred": () => (/* binding */ Deferred),
/* harmony export */   "ErrorFactory": () => (/* binding */ ErrorFactory),
/* harmony export */   "FirebaseError": () => (/* binding */ FirebaseError),
/* harmony export */   "MAX_VALUE_MILLIS": () => (/* binding */ MAX_VALUE_MILLIS),
/* harmony export */   "RANDOM_FACTOR": () => (/* binding */ RANDOM_FACTOR),
/* harmony export */   "Sha1": () => (/* binding */ Sha1),
/* harmony export */   "areCookiesEnabled": () => (/* binding */ areCookiesEnabled),
/* harmony export */   "assert": () => (/* binding */ assert),
/* harmony export */   "assertionError": () => (/* binding */ assertionError),
/* harmony export */   "async": () => (/* binding */ async),
/* harmony export */   "base64": () => (/* binding */ base64),
/* harmony export */   "base64Decode": () => (/* binding */ base64Decode),
/* harmony export */   "base64Encode": () => (/* binding */ base64Encode),
/* harmony export */   "calculateBackoffMillis": () => (/* binding */ calculateBackoffMillis),
/* harmony export */   "contains": () => (/* binding */ contains),
/* harmony export */   "createSubscribe": () => (/* binding */ createSubscribe),
/* harmony export */   "decode": () => (/* binding */ decode),
/* harmony export */   "deepCopy": () => (/* binding */ deepCopy),
/* harmony export */   "deepExtend": () => (/* binding */ deepExtend),
/* harmony export */   "errorPrefix": () => (/* binding */ errorPrefix),
/* harmony export */   "getUA": () => (/* binding */ getUA),
/* harmony export */   "isAdmin": () => (/* binding */ isAdmin),
/* harmony export */   "isBrowser": () => (/* binding */ isBrowser),
/* harmony export */   "isBrowserExtension": () => (/* binding */ isBrowserExtension),
/* harmony export */   "isElectron": () => (/* binding */ isElectron),
/* harmony export */   "isEmpty": () => (/* binding */ isEmpty),
/* harmony export */   "isIE": () => (/* binding */ isIE),
/* harmony export */   "isIndexedDBAvailable": () => (/* binding */ isIndexedDBAvailable),
/* harmony export */   "isMobileCordova": () => (/* binding */ isMobileCordova),
/* harmony export */   "isNode": () => (/* binding */ isNode),
/* harmony export */   "isNodeSdk": () => (/* binding */ isNodeSdk),
/* harmony export */   "isReactNative": () => (/* binding */ isReactNative),
/* harmony export */   "isSafari": () => (/* binding */ isSafari),
/* harmony export */   "isUWP": () => (/* binding */ isUWP),
/* harmony export */   "isValidFormat": () => (/* binding */ isValidFormat),
/* harmony export */   "isValidTimestamp": () => (/* binding */ isValidTimestamp),
/* harmony export */   "issuedAtTime": () => (/* binding */ issuedAtTime),
/* harmony export */   "jsonEval": () => (/* binding */ jsonEval),
/* harmony export */   "map": () => (/* binding */ map),
/* harmony export */   "ordinal": () => (/* binding */ ordinal),
/* harmony export */   "querystring": () => (/* binding */ querystring),
/* harmony export */   "querystringDecode": () => (/* binding */ querystringDecode),
/* harmony export */   "safeGet": () => (/* binding */ safeGet),
/* harmony export */   "stringLength": () => (/* binding */ stringLength),
/* harmony export */   "stringToByteArray": () => (/* binding */ stringToByteArray$1),
/* harmony export */   "stringify": () => (/* binding */ stringify),
/* harmony export */   "validateArgCount": () => (/* binding */ validateArgCount),
/* harmony export */   "validateCallback": () => (/* binding */ validateCallback),
/* harmony export */   "validateContextObject": () => (/* binding */ validateContextObject),
/* harmony export */   "validateIndexedDBOpenable": () => (/* binding */ validateIndexedDBOpenable),
/* harmony export */   "validateNamespace": () => (/* binding */ validateNamespace)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 96775);

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Firebase constants.  Some of these (@defines) can be overridden at compile-time.
 */

var CONSTANTS = {
  /**
   * @define {boolean} Whether this is the client Node.js SDK.
   */
  NODE_CLIENT: false,

  /**
   * @define {boolean} Whether this is the Admin Node.js SDK.
   */
  NODE_ADMIN: false,

  /**
   * Firebase SDK Version
   */
  SDK_VERSION: '${JSCORE_VERSION}'
};
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Throws an error if the provided assertion is falsy
 */

var assert = function (assertion, message) {
  if (!assertion) {
    throw assertionError(message);
  }
};
/**
 * Returns an Error object suitable for throwing.
 */


var assertionError = function (message) {
  return new Error('Firebase Database (' + CONSTANTS.SDK_VERSION + ') INTERNAL ASSERT FAILED: ' + message);
};
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var stringToByteArray = function (str) {
  // TODO(user): Use native implementations if/when available
  var out = [];
  var p = 0;

  for (var i = 0; i < str.length; i++) {
    var c = str.charCodeAt(i);

    if (c < 128) {
      out[p++] = c;
    } else if (c < 2048) {
      out[p++] = c >> 6 | 192;
      out[p++] = c & 63 | 128;
    } else if ((c & 0xfc00) === 0xd800 && i + 1 < str.length && (str.charCodeAt(i + 1) & 0xfc00) === 0xdc00) {
      // Surrogate Pair
      c = 0x10000 + ((c & 0x03ff) << 10) + (str.charCodeAt(++i) & 0x03ff);
      out[p++] = c >> 18 | 240;
      out[p++] = c >> 12 & 63 | 128;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    } else {
      out[p++] = c >> 12 | 224;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    }
  }

  return out;
};
/**
 * Turns an array of numbers into the string given by the concatenation of the
 * characters to which the numbers correspond.
 * @param bytes Array of numbers representing characters.
 * @return Stringification of the array.
 */


var byteArrayToString = function (bytes) {
  // TODO(user): Use native implementations if/when available
  var out = [];
  var pos = 0,
      c = 0;

  while (pos < bytes.length) {
    var c1 = bytes[pos++];

    if (c1 < 128) {
      out[c++] = String.fromCharCode(c1);
    } else if (c1 > 191 && c1 < 224) {
      var c2 = bytes[pos++];
      out[c++] = String.fromCharCode((c1 & 31) << 6 | c2 & 63);
    } else if (c1 > 239 && c1 < 365) {
      // Surrogate Pair
      var c2 = bytes[pos++];
      var c3 = bytes[pos++];
      var c4 = bytes[pos++];
      var u = ((c1 & 7) << 18 | (c2 & 63) << 12 | (c3 & 63) << 6 | c4 & 63) - 0x10000;
      out[c++] = String.fromCharCode(0xd800 + (u >> 10));
      out[c++] = String.fromCharCode(0xdc00 + (u & 1023));
    } else {
      var c2 = bytes[pos++];
      var c3 = bytes[pos++];
      out[c++] = String.fromCharCode((c1 & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
    }
  }

  return out.join('');
}; // We define it as an object literal instead of a class because a class compiled down to es5 can't
// be treeshaked. https://github.com/rollup/rollup/issues/1691
// Static lookup maps, lazily populated by init_()


var base64 = {
  /**
   * Maps bytes to characters.
   */
  byteToCharMap_: null,

  /**
   * Maps characters to bytes.
   */
  charToByteMap_: null,

  /**
   * Maps bytes to websafe characters.
   * @private
   */
  byteToCharMapWebSafe_: null,

  /**
   * Maps websafe characters to bytes.
   * @private
   */
  charToByteMapWebSafe_: null,

  /**
   * Our default alphabet, shared between
   * ENCODED_VALS and ENCODED_VALS_WEBSAFE
   */
  ENCODED_VALS_BASE: 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' + 'abcdefghijklmnopqrstuvwxyz' + '0123456789',

  /**
   * Our default alphabet. Value 64 (=) is special; it means "nothing."
   */
  get ENCODED_VALS() {
    return this.ENCODED_VALS_BASE + '+/=';
  },

  /**
   * Our websafe alphabet.
   */
  get ENCODED_VALS_WEBSAFE() {
    return this.ENCODED_VALS_BASE + '-_.';
  },

  /**
   * Whether this browser supports the atob and btoa functions. This extension
   * started at Mozilla but is now implemented by many browsers. We use the
   * ASSUME_* variables to avoid pulling in the full useragent detection library
   * but still allowing the standard per-browser compilations.
   *
   */
  HAS_NATIVE_SUPPORT: typeof atob === 'function',

  /**
   * Base64-encode an array of bytes.
   *
   * @param input An array of bytes (numbers with
   *     value in [0, 255]) to encode.
   * @param webSafe Boolean indicating we should use the
   *     alternative alphabet.
   * @return The base64 encoded string.
   */
  encodeByteArray: function (input, webSafe) {
    if (!Array.isArray(input)) {
      throw Error('encodeByteArray takes an array as a parameter');
    }

    this.init_();
    var byteToCharMap = webSafe ? this.byteToCharMapWebSafe_ : this.byteToCharMap_;
    var output = [];

    for (var i = 0; i < input.length; i += 3) {
      var byte1 = input[i];
      var haveByte2 = i + 1 < input.length;
      var byte2 = haveByte2 ? input[i + 1] : 0;
      var haveByte3 = i + 2 < input.length;
      var byte3 = haveByte3 ? input[i + 2] : 0;
      var outByte1 = byte1 >> 2;
      var outByte2 = (byte1 & 0x03) << 4 | byte2 >> 4;
      var outByte3 = (byte2 & 0x0f) << 2 | byte3 >> 6;
      var outByte4 = byte3 & 0x3f;

      if (!haveByte3) {
        outByte4 = 64;

        if (!haveByte2) {
          outByte3 = 64;
        }
      }

      output.push(byteToCharMap[outByte1], byteToCharMap[outByte2], byteToCharMap[outByte3], byteToCharMap[outByte4]);
    }

    return output.join('');
  },

  /**
   * Base64-encode a string.
   *
   * @param input A string to encode.
   * @param webSafe If true, we should use the
   *     alternative alphabet.
   * @return The base64 encoded string.
   */
  encodeString: function (input, webSafe) {
    // Shortcut for Mozilla browsers that implement
    // a native base64 encoder in the form of "btoa/atob"
    if (this.HAS_NATIVE_SUPPORT && !webSafe) {
      return btoa(input);
    }

    return this.encodeByteArray(stringToByteArray(input), webSafe);
  },

  /**
   * Base64-decode a string.
   *
   * @param input to decode.
   * @param webSafe True if we should use the
   *     alternative alphabet.
   * @return string representing the decoded value.
   */
  decodeString: function (input, webSafe) {
    // Shortcut for Mozilla browsers that implement
    // a native base64 encoder in the form of "btoa/atob"
    if (this.HAS_NATIVE_SUPPORT && !webSafe) {
      return atob(input);
    }

    return byteArrayToString(this.decodeStringToByteArray(input, webSafe));
  },

  /**
   * Base64-decode a string.
   *
   * In base-64 decoding, groups of four characters are converted into three
   * bytes.  If the encoder did not apply padding, the input length may not
   * be a multiple of 4.
   *
   * In this case, the last group will have fewer than 4 characters, and
   * padding will be inferred.  If the group has one or two characters, it decodes
   * to one byte.  If the group has three characters, it decodes to two bytes.
   *
   * @param input Input to decode.
   * @param webSafe True if we should use the web-safe alphabet.
   * @return bytes representing the decoded value.
   */
  decodeStringToByteArray: function (input, webSafe) {
    this.init_();
    var charToByteMap = webSafe ? this.charToByteMapWebSafe_ : this.charToByteMap_;
    var output = [];

    for (var i = 0; i < input.length;) {
      var byte1 = charToByteMap[input.charAt(i++)];
      var haveByte2 = i < input.length;
      var byte2 = haveByte2 ? charToByteMap[input.charAt(i)] : 0;
      ++i;
      var haveByte3 = i < input.length;
      var byte3 = haveByte3 ? charToByteMap[input.charAt(i)] : 64;
      ++i;
      var haveByte4 = i < input.length;
      var byte4 = haveByte4 ? charToByteMap[input.charAt(i)] : 64;
      ++i;

      if (byte1 == null || byte2 == null || byte3 == null || byte4 == null) {
        throw Error();
      }

      var outByte1 = byte1 << 2 | byte2 >> 4;
      output.push(outByte1);

      if (byte3 !== 64) {
        var outByte2 = byte2 << 4 & 0xf0 | byte3 >> 2;
        output.push(outByte2);

        if (byte4 !== 64) {
          var outByte3 = byte3 << 6 & 0xc0 | byte4;
          output.push(outByte3);
        }
      }
    }

    return output;
  },

  /**
   * Lazy static initialization function. Called before
   * accessing any of the static map variables.
   * @private
   */
  init_: function () {
    if (!this.byteToCharMap_) {
      this.byteToCharMap_ = {};
      this.charToByteMap_ = {};
      this.byteToCharMapWebSafe_ = {};
      this.charToByteMapWebSafe_ = {}; // We want quick mappings back and forth, so we precompute two maps.

      for (var i = 0; i < this.ENCODED_VALS.length; i++) {
        this.byteToCharMap_[i] = this.ENCODED_VALS.charAt(i);
        this.charToByteMap_[this.byteToCharMap_[i]] = i;
        this.byteToCharMapWebSafe_[i] = this.ENCODED_VALS_WEBSAFE.charAt(i);
        this.charToByteMapWebSafe_[this.byteToCharMapWebSafe_[i]] = i; // Be forgiving when decoding and correctly decode both encodings.

        if (i >= this.ENCODED_VALS_BASE.length) {
          this.charToByteMap_[this.ENCODED_VALS_WEBSAFE.charAt(i)] = i;
          this.charToByteMapWebSafe_[this.ENCODED_VALS.charAt(i)] = i;
        }
      }
    }
  }
};
/**
 * URL-safe base64 encoding
 */

var base64Encode = function (str) {
  var utf8Bytes = stringToByteArray(str);
  return base64.encodeByteArray(utf8Bytes, true);
};
/**
 * URL-safe base64 decoding
 *
 * NOTE: DO NOT use the global atob() function - it does NOT support the
 * base64Url variant encoding.
 *
 * @param str To be decoded
 * @return Decoded result, if possible
 */


var base64Decode = function (str) {
  try {
    return base64.decodeString(str, true);
  } catch (e) {
    console.error('base64Decode failed: ', e);
  }

  return null;
};
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Do a deep-copy of basic JavaScript Objects or Arrays.
 */


function deepCopy(value) {
  return deepExtend(undefined, value);
}
/**
 * Copy properties from source to target (recursively allows extension
 * of Objects and Arrays).  Scalar values in the target are over-written.
 * If target is undefined, an object of the appropriate type will be created
 * (and returned).
 *
 * We recursively copy all child properties of plain Objects in the source- so
 * that namespace- like dictionaries are merged.
 *
 * Note that the target can be a function, in which case the properties in
 * the source Object are copied onto it as static properties of the Function.
 *
 * Note: we don't merge __proto__ to prevent prototype pollution
 */


function deepExtend(target, source) {
  if (!(source instanceof Object)) {
    return source;
  }

  switch (source.constructor) {
    case Date:
      // Treat Dates like scalars; if the target date object had any child
      // properties - they will be lost!
      var dateValue = source;
      return new Date(dateValue.getTime());

    case Object:
      if (target === undefined) {
        target = {};
      }

      break;

    case Array:
      // Always copy the array source and overwrite the target.
      target = [];
      break;

    default:
      // Not a plain Object - treat it as a scalar.
      return source;
  }

  for (var prop in source) {
    // use isValidKey to guard against prototype pollution. See https://snyk.io/vuln/SNYK-JS-LODASH-450202
    if (!source.hasOwnProperty(prop) || !isValidKey(prop)) {
      continue;
    }

    target[prop] = deepExtend(target[prop], source[prop]);
  }

  return target;
}

function isValidKey(key) {
  return key !== '__proto__';
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var Deferred =
/** @class */
function () {
  function Deferred() {
    var _this = this;

    this.reject = function () {};

    this.resolve = function () {};

    this.promise = new Promise(function (resolve, reject) {
      _this.resolve = resolve;
      _this.reject = reject;
    });
  }
  /**
   * Our API internals are not promiseified and cannot because our callback APIs have subtle expectations around
   * invoking promises inline, which Promises are forbidden to do. This method accepts an optional node-style callback
   * and returns a node-style callback which will resolve or reject the Deferred's promise.
   */


  Deferred.prototype.wrapCallback = function (callback) {
    var _this = this;

    return function (error, value) {
      if (error) {
        _this.reject(error);
      } else {
        _this.resolve(value);
      }

      if (typeof callback === 'function') {
        // Attaching noop handler just in case developer wasn't expecting
        // promises
        _this.promise.catch(function () {}); // Some of our callbacks don't expect a value and our own tests
        // assert that the parameter length is 1


        if (callback.length === 1) {
          callback(error);
        } else {
          callback(error, value);
        }
      }
    };
  };

  return Deferred;
}();
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Returns navigator.userAgent string or '' if it's not defined.
 * @return user agent string
 */


function getUA() {
  if (typeof navigator !== 'undefined' && typeof navigator['userAgent'] === 'string') {
    return navigator['userAgent'];
  } else {
    return '';
  }
}
/**
 * Detect Cordova / PhoneGap / Ionic frameworks on a mobile device.
 *
 * Deliberately does not rely on checking `file://` URLs (as this fails PhoneGap
 * in the Ripple emulator) nor Cordova `onDeviceReady`, which would normally
 * wait for a callback.
 */


function isMobileCordova() {
  return typeof window !== 'undefined' && // @ts-ignore Setting up an broadly applicable index signature for Window
  // just to deal with this case would probably be a bad idea.
  !!(window['cordova'] || window['phonegap'] || window['PhoneGap']) && /ios|iphone|ipod|ipad|android|blackberry|iemobile/i.test(getUA());
}
/**
 * Detect Node.js.
 *
 * @return true if Node.js environment is detected.
 */
// Node detection logic from: https://github.com/iliakan/detect-node/


function isNode() {
  try {
    return Object.prototype.toString.call(global.process) === '[object process]';
  } catch (e) {
    return false;
  }
}
/**
 * Detect Browser Environment
 */


function isBrowser() {
  return typeof self === 'object' && self.self === self;
}

function isBrowserExtension() {
  var runtime = typeof chrome === 'object' ? chrome.runtime : typeof browser === 'object' ? browser.runtime : undefined;
  return typeof runtime === 'object' && runtime.id !== undefined;
}
/**
 * Detect React Native.
 *
 * @return true if ReactNative environment is detected.
 */


function isReactNative() {
  return typeof navigator === 'object' && navigator['product'] === 'ReactNative';
}
/** Detects Electron apps. */


function isElectron() {
  return getUA().indexOf('Electron/') >= 0;
}
/** Detects Internet Explorer. */


function isIE() {
  var ua = getUA();
  return ua.indexOf('MSIE ') >= 0 || ua.indexOf('Trident/') >= 0;
}
/** Detects Universal Windows Platform apps. */


function isUWP() {
  return getUA().indexOf('MSAppHost/') >= 0;
}
/**
 * Detect whether the current SDK build is the Node version.
 *
 * @return true if it's the Node SDK build.
 */


function isNodeSdk() {
  return CONSTANTS.NODE_CLIENT === true || CONSTANTS.NODE_ADMIN === true;
}
/** Returns true if we are running in Safari. */


function isSafari() {
  return !isNode() && navigator.userAgent.includes('Safari') && !navigator.userAgent.includes('Chrome');
}
/**
 * This method checks if indexedDB is supported by current browser/service worker context
 * @return true if indexedDB is supported by current browser/service worker context
 */


function isIndexedDBAvailable() {
  return 'indexedDB' in self && indexedDB != null;
}
/**
 * This method validates browser context for indexedDB by opening a dummy indexedDB database and reject
 * if errors occur during the database open operation.
 */


function validateIndexedDBOpenable() {
  return new Promise(function (resolve, reject) {
    try {
      var preExist_1 = true;
      var DB_CHECK_NAME_1 = 'validate-browser-context-for-indexeddb-analytics-module';
      var request_1 = window.indexedDB.open(DB_CHECK_NAME_1);

      request_1.onsuccess = function () {
        request_1.result.close(); // delete database only when it doesn't pre-exist

        if (!preExist_1) {
          window.indexedDB.deleteDatabase(DB_CHECK_NAME_1);
        }

        resolve(true);
      };

      request_1.onupgradeneeded = function () {
        preExist_1 = false;
      };

      request_1.onerror = function () {
        var _a;

        reject(((_a = request_1.error) === null || _a === void 0 ? void 0 : _a.message) || '');
      };
    } catch (error) {
      reject(error);
    }
  });
}
/**
 *
 * This method checks whether cookie is enabled within current browser
 * @return true if cookie is enabled within current browser
 */


function areCookiesEnabled() {
  if (!navigator || !navigator.cookieEnabled) {
    return false;
  }

  return true;
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var ERROR_NAME = 'FirebaseError'; // Based on code from:
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error#Custom_Error_Types

var FirebaseError =
/** @class */
function (_super) {
  (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(FirebaseError, _super);

  function FirebaseError(code, message, customData) {
    var _this = _super.call(this, message) || this;

    _this.code = code;
    _this.customData = customData;
    _this.name = ERROR_NAME; // Fix For ES5
    // https://github.com/Microsoft/TypeScript-wiki/blob/master/Breaking-Changes.md#extending-built-ins-like-error-array-and-map-may-no-longer-work

    Object.setPrototypeOf(_this, FirebaseError.prototype); // Maintains proper stack trace for where our error was thrown.
    // Only available on V8.

    if (Error.captureStackTrace) {
      Error.captureStackTrace(_this, ErrorFactory.prototype.create);
    }

    return _this;
  }

  return FirebaseError;
}(Error);

var ErrorFactory =
/** @class */
function () {
  function ErrorFactory(service, serviceName, errors) {
    this.service = service;
    this.serviceName = serviceName;
    this.errors = errors;
  }

  ErrorFactory.prototype.create = function (code) {
    var data = [];

    for (var _i = 1; _i < arguments.length; _i++) {
      data[_i - 1] = arguments[_i];
    }

    var customData = data[0] || {};
    var fullCode = this.service + "/" + code;
    var template = this.errors[code];
    var message = template ? replaceTemplate(template, customData) : 'Error'; // Service Name: Error message (service/code).

    var fullMessage = this.serviceName + ": " + message + " (" + fullCode + ").";
    var error = new FirebaseError(fullCode, fullMessage, customData);
    return error;
  };

  return ErrorFactory;
}();

function replaceTemplate(template, data) {
  return template.replace(PATTERN, function (_, key) {
    var value = data[key];
    return value != null ? String(value) : "<" + key + "?>";
  });
}

var PATTERN = /\{\$([^}]+)}/g;
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Evaluates a JSON string into a javascript object.
 *
 * @param {string} str A string containing JSON.
 * @return {*} The javascript object representing the specified JSON.
 */

function jsonEval(str) {
  return JSON.parse(str);
}
/**
 * Returns JSON representing a javascript object.
 * @param {*} data Javascript object to be stringified.
 * @return {string} The JSON contents of the object.
 */


function stringify(data) {
  return JSON.stringify(data);
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Decodes a Firebase auth. token into constituent parts.
 *
 * Notes:
 * - May return with invalid / incomplete claims if there's no native base64 decoding support.
 * - Doesn't check if the token is actually valid.
 */


var decode = function (token) {
  var header = {},
      claims = {},
      data = {},
      signature = '';

  try {
    var parts = token.split('.');
    header = jsonEval(base64Decode(parts[0]) || '');
    claims = jsonEval(base64Decode(parts[1]) || '');
    signature = parts[2];
    data = claims['d'] || {};
    delete claims['d'];
  } catch (e) {}

  return {
    header: header,
    claims: claims,
    data: data,
    signature: signature
  };
};
/**
 * Decodes a Firebase auth. token and checks the validity of its time-based claims. Will return true if the
 * token is within the time window authorized by the 'nbf' (not-before) and 'iat' (issued-at) claims.
 *
 * Notes:
 * - May return a false negative if there's no native base64 decoding support.
 * - Doesn't check if the token is actually valid.
 */


var isValidTimestamp = function (token) {
  var claims = decode(token).claims;
  var now = Math.floor(new Date().getTime() / 1000);
  var validSince = 0,
      validUntil = 0;

  if (typeof claims === 'object') {
    if (claims.hasOwnProperty('nbf')) {
      validSince = claims['nbf'];
    } else if (claims.hasOwnProperty('iat')) {
      validSince = claims['iat'];
    }

    if (claims.hasOwnProperty('exp')) {
      validUntil = claims['exp'];
    } else {
      // token will expire after 24h by default
      validUntil = validSince + 86400;
    }
  }

  return !!now && !!validSince && !!validUntil && now >= validSince && now <= validUntil;
};
/**
 * Decodes a Firebase auth. token and returns its issued at time if valid, null otherwise.
 *
 * Notes:
 * - May return null if there's no native base64 decoding support.
 * - Doesn't check if the token is actually valid.
 */


var issuedAtTime = function (token) {
  var claims = decode(token).claims;

  if (typeof claims === 'object' && claims.hasOwnProperty('iat')) {
    return claims['iat'];
  }

  return null;
};
/**
 * Decodes a Firebase auth. token and checks the validity of its format. Expects a valid issued-at time.
 *
 * Notes:
 * - May return a false negative if there's no native base64 decoding support.
 * - Doesn't check if the token is actually valid.
 */


var isValidFormat = function (token) {
  var decoded = decode(token),
      claims = decoded.claims;
  return !!claims && typeof claims === 'object' && claims.hasOwnProperty('iat');
};
/**
 * Attempts to peer into an auth token and determine if it's an admin auth token by looking at the claims portion.
 *
 * Notes:
 * - May return a false negative if there's no native base64 decoding support.
 * - Doesn't check if the token is actually valid.
 */


var isAdmin = function (token) {
  var claims = decode(token).claims;
  return typeof claims === 'object' && claims['admin'] === true;
};
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


function contains(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}

function safeGet(obj, key) {
  if (Object.prototype.hasOwnProperty.call(obj, key)) {
    return obj[key];
  } else {
    return undefined;
  }
}

function isEmpty(obj) {
  for (var key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      return false;
    }
  }

  return true;
}

function map(obj, fn, contextObj) {
  var res = {};

  for (var key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      res[key] = fn.call(contextObj, obj[key], key, obj);
    }
  }

  return res;
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Returns a querystring-formatted string (e.g. &arg=val&arg2=val2) from a
 * params object (e.g. {arg: 'val', arg2: 'val2'})
 * Note: You must prepend it with ? when adding it to a URL.
 */


function querystring(querystringParams) {
  var params = [];

  var _loop_1 = function (key, value) {
    if (Array.isArray(value)) {
      value.forEach(function (arrayVal) {
        params.push(encodeURIComponent(key) + '=' + encodeURIComponent(arrayVal));
      });
    } else {
      params.push(encodeURIComponent(key) + '=' + encodeURIComponent(value));
    }
  };

  for (var _i = 0, _a = Object.entries(querystringParams); _i < _a.length; _i++) {
    var _b = _a[_i],
        key = _b[0],
        value = _b[1];

    _loop_1(key, value);
  }

  return params.length ? '&' + params.join('&') : '';
}
/**
 * Decodes a querystring (e.g. ?arg=val&arg2=val2) into a params object
 * (e.g. {arg: 'val', arg2: 'val2'})
 */


function querystringDecode(querystring) {
  var obj = {};
  var tokens = querystring.replace(/^\?/, '').split('&');
  tokens.forEach(function (token) {
    if (token) {
      var key = token.split('=');
      obj[key[0]] = key[1];
    }
  });
  return obj;
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview SHA-1 cryptographic hash.
 * Variable names follow the notation in FIPS PUB 180-3:
 * http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf.
 *
 * Usage:
 *   var sha1 = new sha1();
 *   sha1.update(bytes);
 *   var hash = sha1.digest();
 *
 * Performance:
 *   Chrome 23:   ~400 Mbit/s
 *   Firefox 16:  ~250 Mbit/s
 *
 */

/**
 * SHA-1 cryptographic hash constructor.
 *
 * The properties declared here are discussed in the above algorithm document.
 * @constructor
 * @final
 * @struct
 */


var Sha1 =
/** @class */
function () {
  function Sha1() {
    /**
     * Holds the previous values of accumulated variables a-e in the compress_
     * function.
     * @private
     */
    this.chain_ = [];
    /**
     * A buffer holding the partially computed hash result.
     * @private
     */

    this.buf_ = [];
    /**
     * An array of 80 bytes, each a part of the message to be hashed.  Referred to
     * as the message schedule in the docs.
     * @private
     */

    this.W_ = [];
    /**
     * Contains data needed to pad messages less than 64 bytes.
     * @private
     */

    this.pad_ = [];
    /**
     * @private {number}
     */

    this.inbuf_ = 0;
    /**
     * @private {number}
     */

    this.total_ = 0;
    this.blockSize = 512 / 8;
    this.pad_[0] = 128;

    for (var i = 1; i < this.blockSize; ++i) {
      this.pad_[i] = 0;
    }

    this.reset();
  }

  Sha1.prototype.reset = function () {
    this.chain_[0] = 0x67452301;
    this.chain_[1] = 0xefcdab89;
    this.chain_[2] = 0x98badcfe;
    this.chain_[3] = 0x10325476;
    this.chain_[4] = 0xc3d2e1f0;
    this.inbuf_ = 0;
    this.total_ = 0;
  };
  /**
   * Internal compress helper function.
   * @param buf Block to compress.
   * @param offset Offset of the block in the buffer.
   * @private
   */


  Sha1.prototype.compress_ = function (buf, offset) {
    if (!offset) {
      offset = 0;
    }

    var W = this.W_; // get 16 big endian words

    if (typeof buf === 'string') {
      for (var i = 0; i < 16; i++) {
        // TODO(user): [bug 8140122] Recent versions of Safari for Mac OS and iOS
        // have a bug that turns the post-increment ++ operator into pre-increment
        // during JIT compilation.  We have code that depends heavily on SHA-1 for
        // correctness and which is affected by this bug, so I've removed all uses
        // of post-increment ++ in which the result value is used.  We can revert
        // this change once the Safari bug
        // (https://bugs.webkit.org/show_bug.cgi?id=109036) has been fixed and
        // most clients have been updated.
        W[i] = buf.charCodeAt(offset) << 24 | buf.charCodeAt(offset + 1) << 16 | buf.charCodeAt(offset + 2) << 8 | buf.charCodeAt(offset + 3);
        offset += 4;
      }
    } else {
      for (var i = 0; i < 16; i++) {
        W[i] = buf[offset] << 24 | buf[offset + 1] << 16 | buf[offset + 2] << 8 | buf[offset + 3];
        offset += 4;
      }
    } // expand to 80 words


    for (var i = 16; i < 80; i++) {
      var t = W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16];
      W[i] = (t << 1 | t >>> 31) & 0xffffffff;
    }

    var a = this.chain_[0];
    var b = this.chain_[1];
    var c = this.chain_[2];
    var d = this.chain_[3];
    var e = this.chain_[4];
    var f, k; // TODO(user): Try to unroll this loop to speed up the computation.

    for (var i = 0; i < 80; i++) {
      if (i < 40) {
        if (i < 20) {
          f = d ^ b & (c ^ d);
          k = 0x5a827999;
        } else {
          f = b ^ c ^ d;
          k = 0x6ed9eba1;
        }
      } else {
        if (i < 60) {
          f = b & c | d & (b | c);
          k = 0x8f1bbcdc;
        } else {
          f = b ^ c ^ d;
          k = 0xca62c1d6;
        }
      }

      var t = (a << 5 | a >>> 27) + f + e + k + W[i] & 0xffffffff;
      e = d;
      d = c;
      c = (b << 30 | b >>> 2) & 0xffffffff;
      b = a;
      a = t;
    }

    this.chain_[0] = this.chain_[0] + a & 0xffffffff;
    this.chain_[1] = this.chain_[1] + b & 0xffffffff;
    this.chain_[2] = this.chain_[2] + c & 0xffffffff;
    this.chain_[3] = this.chain_[3] + d & 0xffffffff;
    this.chain_[4] = this.chain_[4] + e & 0xffffffff;
  };

  Sha1.prototype.update = function (bytes, length) {
    // TODO(johnlenz): tighten the function signature and remove this check
    if (bytes == null) {
      return;
    }

    if (length === undefined) {
      length = bytes.length;
    }

    var lengthMinusBlock = length - this.blockSize;
    var n = 0; // Using local instead of member variables gives ~5% speedup on Firefox 16.

    var buf = this.buf_;
    var inbuf = this.inbuf_; // The outer while loop should execute at most twice.

    while (n < length) {
      // When we have no data in the block to top up, we can directly process the
      // input buffer (assuming it contains sufficient data). This gives ~25%
      // speedup on Chrome 23 and ~15% speedup on Firefox 16, but requires that
      // the data is provided in large chunks (or in multiples of 64 bytes).
      if (inbuf === 0) {
        while (n <= lengthMinusBlock) {
          this.compress_(bytes, n);
          n += this.blockSize;
        }
      }

      if (typeof bytes === 'string') {
        while (n < length) {
          buf[inbuf] = bytes.charCodeAt(n);
          ++inbuf;
          ++n;

          if (inbuf === this.blockSize) {
            this.compress_(buf);
            inbuf = 0; // Jump to the outer loop so we use the full-block optimization.

            break;
          }
        }
      } else {
        while (n < length) {
          buf[inbuf] = bytes[n];
          ++inbuf;
          ++n;

          if (inbuf === this.blockSize) {
            this.compress_(buf);
            inbuf = 0; // Jump to the outer loop so we use the full-block optimization.

            break;
          }
        }
      }
    }

    this.inbuf_ = inbuf;
    this.total_ += length;
  };
  /** @override */


  Sha1.prototype.digest = function () {
    var digest = [];
    var totalBits = this.total_ * 8; // Add pad 0x80 0x00*.

    if (this.inbuf_ < 56) {
      this.update(this.pad_, 56 - this.inbuf_);
    } else {
      this.update(this.pad_, this.blockSize - (this.inbuf_ - 56));
    } // Add # bits.


    for (var i = this.blockSize - 1; i >= 56; i--) {
      this.buf_[i] = totalBits & 255;
      totalBits /= 256; // Don't use bit-shifting here!
    }

    this.compress_(this.buf_);
    var n = 0;

    for (var i = 0; i < 5; i++) {
      for (var j = 24; j >= 0; j -= 8) {
        digest[n] = this.chain_[i] >> j & 255;
        ++n;
      }
    }

    return digest;
  };

  return Sha1;
}();
/**
 * Helper to make a Subscribe function (just like Promise helps make a
 * Thenable).
 *
 * @param executor Function which can make calls to a single Observer
 *     as a proxy.
 * @param onNoObservers Callback when count of Observers goes to zero.
 */


function createSubscribe(executor, onNoObservers) {
  var proxy = new ObserverProxy(executor, onNoObservers);
  return proxy.subscribe.bind(proxy);
}
/**
 * Implement fan-out for any number of Observers attached via a subscribe
 * function.
 */


var ObserverProxy =
/** @class */
function () {
  /**
   * @param executor Function which can make calls to a single Observer
   *     as a proxy.
   * @param onNoObservers Callback when count of Observers goes to zero.
   */
  function ObserverProxy(executor, onNoObservers) {
    var _this = this;

    this.observers = [];
    this.unsubscribes = [];
    this.observerCount = 0; // Micro-task scheduling by calling task.then().

    this.task = Promise.resolve();
    this.finalized = false;
    this.onNoObservers = onNoObservers; // Call the executor asynchronously so subscribers that are called
    // synchronously after the creation of the subscribe function
    // can still receive the very first value generated in the executor.

    this.task.then(function () {
      executor(_this);
    }).catch(function (e) {
      _this.error(e);
    });
  }

  ObserverProxy.prototype.next = function (value) {
    this.forEachObserver(function (observer) {
      observer.next(value);
    });
  };

  ObserverProxy.prototype.error = function (error) {
    this.forEachObserver(function (observer) {
      observer.error(error);
    });
    this.close(error);
  };

  ObserverProxy.prototype.complete = function () {
    this.forEachObserver(function (observer) {
      observer.complete();
    });
    this.close();
  };
  /**
   * Subscribe function that can be used to add an Observer to the fan-out list.
   *
   * - We require that no event is sent to a subscriber sychronously to their
   *   call to subscribe().
   */


  ObserverProxy.prototype.subscribe = function (nextOrObserver, error, complete) {
    var _this = this;

    var observer;

    if (nextOrObserver === undefined && error === undefined && complete === undefined) {
      throw new Error('Missing Observer.');
    } // Assemble an Observer object when passed as callback functions.


    if (implementsAnyMethods(nextOrObserver, ['next', 'error', 'complete'])) {
      observer = nextOrObserver;
    } else {
      observer = {
        next: nextOrObserver,
        error: error,
        complete: complete
      };
    }

    if (observer.next === undefined) {
      observer.next = noop;
    }

    if (observer.error === undefined) {
      observer.error = noop;
    }

    if (observer.complete === undefined) {
      observer.complete = noop;
    }

    var unsub = this.unsubscribeOne.bind(this, this.observers.length); // Attempt to subscribe to a terminated Observable - we
    // just respond to the Observer with the final error or complete
    // event.

    if (this.finalized) {
      // eslint-disable-next-line @typescript-eslint/no-floating-promises
      this.task.then(function () {
        try {
          if (_this.finalError) {
            observer.error(_this.finalError);
          } else {
            observer.complete();
          }
        } catch (e) {// nothing
        }

        return;
      });
    }

    this.observers.push(observer);
    return unsub;
  }; // Unsubscribe is synchronous - we guarantee that no events are sent to
  // any unsubscribed Observer.


  ObserverProxy.prototype.unsubscribeOne = function (i) {
    if (this.observers === undefined || this.observers[i] === undefined) {
      return;
    }

    delete this.observers[i];
    this.observerCount -= 1;

    if (this.observerCount === 0 && this.onNoObservers !== undefined) {
      this.onNoObservers(this);
    }
  };

  ObserverProxy.prototype.forEachObserver = function (fn) {
    if (this.finalized) {
      // Already closed by previous event....just eat the additional values.
      return;
    } // Since sendOne calls asynchronously - there is no chance that
    // this.observers will become undefined.


    for (var i = 0; i < this.observers.length; i++) {
      this.sendOne(i, fn);
    }
  }; // Call the Observer via one of it's callback function. We are careful to
  // confirm that the observe has not been unsubscribed since this asynchronous
  // function had been queued.


  ObserverProxy.prototype.sendOne = function (i, fn) {
    var _this = this; // Execute the callback asynchronously
    // eslint-disable-next-line @typescript-eslint/no-floating-promises


    this.task.then(function () {
      if (_this.observers !== undefined && _this.observers[i] !== undefined) {
        try {
          fn(_this.observers[i]);
        } catch (e) {
          // Ignore exceptions raised in Observers or missing methods of an
          // Observer.
          // Log error to console. b/31404806
          if (typeof console !== 'undefined' && console.error) {
            console.error(e);
          }
        }
      }
    });
  };

  ObserverProxy.prototype.close = function (err) {
    var _this = this;

    if (this.finalized) {
      return;
    }

    this.finalized = true;

    if (err !== undefined) {
      this.finalError = err;
    } // Proxy is no longer needed - garbage collect references
    // eslint-disable-next-line @typescript-eslint/no-floating-promises


    this.task.then(function () {
      _this.observers = undefined;
      _this.onNoObservers = undefined;
    });
  };

  return ObserverProxy;
}();
/** Turn synchronous function into one called asynchronously. */
// eslint-disable-next-line @typescript-eslint/ban-types


function async(fn, onError) {
  return function () {
    var args = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }

    Promise.resolve(true).then(function () {
      fn.apply(void 0, args);
    }).catch(function (error) {
      if (onError) {
        onError(error);
      }
    });
  };
}
/**
 * Return true if the object passed in implements any of the named methods.
 */


function implementsAnyMethods(obj, methods) {
  if (typeof obj !== 'object' || obj === null) {
    return false;
  }

  for (var _i = 0, methods_1 = methods; _i < methods_1.length; _i++) {
    var method = methods_1[_i];

    if (method in obj && typeof obj[method] === 'function') {
      return true;
    }
  }

  return false;
}

function noop() {// do nothing
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Check to make sure the appropriate number of arguments are provided for a public function.
 * Throws an error if it fails.
 *
 * @param fnName The function name
 * @param minCount The minimum number of arguments to allow for the function call
 * @param maxCount The maximum number of argument to allow for the function call
 * @param argCount The actual number of arguments provided.
 */


var validateArgCount = function (fnName, minCount, maxCount, argCount) {
  var argError;

  if (argCount < minCount) {
    argError = 'at least ' + minCount;
  } else if (argCount > maxCount) {
    argError = maxCount === 0 ? 'none' : 'no more than ' + maxCount;
  }

  if (argError) {
    var error = fnName + ' failed: Was called with ' + argCount + (argCount === 1 ? ' argument.' : ' arguments.') + ' Expects ' + argError + '.';
    throw new Error(error);
  }
};
/**
 * Generates a string to prefix an error message about failed argument validation
 *
 * @param fnName The function name
 * @param argumentNumber The index of the argument
 * @param optional Whether or not the argument is optional
 * @return The prefix to add to the error thrown for validation.
 */


function errorPrefix(fnName, argumentNumber, optional) {
  var argName = '';

  switch (argumentNumber) {
    case 1:
      argName = optional ? 'first' : 'First';
      break;

    case 2:
      argName = optional ? 'second' : 'Second';
      break;

    case 3:
      argName = optional ? 'third' : 'Third';
      break;

    case 4:
      argName = optional ? 'fourth' : 'Fourth';
      break;

    default:
      throw new Error('errorPrefix called with argumentNumber > 4.  Need to update it?');
  }

  var error = fnName + ' failed: ';
  error += argName + ' argument ';
  return error;
}
/**
 * @param fnName
 * @param argumentNumber
 * @param namespace
 * @param optional
 */


function validateNamespace(fnName, argumentNumber, namespace, optional) {
  if (optional && !namespace) {
    return;
  }

  if (typeof namespace !== 'string') {
    //TODO: I should do more validation here. We only allow certain chars in namespaces.
    throw new Error(errorPrefix(fnName, argumentNumber, optional) + 'must be a valid firebase namespace.');
  }
}

function validateCallback(fnName, argumentNumber, // eslint-disable-next-line @typescript-eslint/ban-types
callback, optional) {
  if (optional && !callback) {
    return;
  }

  if (typeof callback !== 'function') {
    throw new Error(errorPrefix(fnName, argumentNumber, optional) + 'must be a valid function.');
  }
}

function validateContextObject(fnName, argumentNumber, context, optional) {
  if (optional && !context) {
    return;
  }

  if (typeof context !== 'object' || context === null) {
    throw new Error(errorPrefix(fnName, argumentNumber, optional) + 'must be a valid context object.');
  }
}
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Code originally came from goog.crypt.stringToUtf8ByteArray, but for some reason they
// automatically replaced '\r\n' with '\n', and they didn't handle surrogate pairs,
// so it's been modified.
// Note that not all Unicode characters appear as single characters in JavaScript strings.
// fromCharCode returns the UTF-16 encoding of a character - so some Unicode characters
// use 2 characters in Javascript.  All 4-byte UTF-8 characters begin with a first
// character in the range 0xD800 - 0xDBFF (the first character of a so-called surrogate
// pair).
// See http://www.ecma-international.org/ecma-262/5.1/#sec-15.1.3

/**
 * @param {string} str
 * @return {Array}
 */


var stringToByteArray$1 = function (str) {
  var out = [];
  var p = 0;

  for (var i = 0; i < str.length; i++) {
    var c = str.charCodeAt(i); // Is this the lead surrogate in a surrogate pair?

    if (c >= 0xd800 && c <= 0xdbff) {
      var high = c - 0xd800; // the high 10 bits.

      i++;
      assert(i < str.length, 'Surrogate pair missing trail surrogate.');
      var low = str.charCodeAt(i) - 0xdc00; // the low 10 bits.

      c = 0x10000 + (high << 10) + low;
    }

    if (c < 128) {
      out[p++] = c;
    } else if (c < 2048) {
      out[p++] = c >> 6 | 192;
      out[p++] = c & 63 | 128;
    } else if (c < 65536) {
      out[p++] = c >> 12 | 224;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    } else {
      out[p++] = c >> 18 | 240;
      out[p++] = c >> 12 & 63 | 128;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    }
  }

  return out;
};
/**
 * Calculate length without actually converting; useful for doing cheaper validation.
 * @param {string} str
 * @return {number}
 */


var stringLength = function (str) {
  var p = 0;

  for (var i = 0; i < str.length; i++) {
    var c = str.charCodeAt(i);

    if (c < 128) {
      p++;
    } else if (c < 2048) {
      p += 2;
    } else if (c >= 0xd800 && c <= 0xdbff) {
      // Lead surrogate of a surrogate pair.  The pair together will take 4 bytes to represent.
      p += 4;
      i++; // skip trail surrogate.
    } else {
      p += 3;
    }
  }

  return p;
};
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * The amount of milliseconds to exponentially increase.
 */


var DEFAULT_INTERVAL_MILLIS = 1000;
/**
 * The factor to backoff by.
 * Should be a number greater than 1.
 */

var DEFAULT_BACKOFF_FACTOR = 2;
/**
 * The maximum milliseconds to increase to.
 *
 * <p>Visible for testing
 */

var MAX_VALUE_MILLIS = 4 * 60 * 60 * 1000; // Four hours, like iOS and Android.

/**
 * The percentage of backoff time to randomize by.
 * See
 * http://go/safe-client-behavior#step-1-determine-the-appropriate-retry-interval-to-handle-spike-traffic
 * for context.
 *
 * <p>Visible for testing
 */

var RANDOM_FACTOR = 0.5;
/**
 * Based on the backoff method from
 * https://github.com/google/closure-library/blob/master/closure/goog/math/exponentialbackoff.js.
 * Extracted here so we don't need to pass metadata and a stateful ExponentialBackoff object around.
 */

function calculateBackoffMillis(backoffCount, intervalMillis, backoffFactor) {
  if (intervalMillis === void 0) {
    intervalMillis = DEFAULT_INTERVAL_MILLIS;
  }

  if (backoffFactor === void 0) {
    backoffFactor = DEFAULT_BACKOFF_FACTOR;
  } // Calculates an exponentially increasing value.
  // Deviation: calculates value from count and a constant interval, so we only need to save value
  // and count to restore state.


  var currBaseValue = intervalMillis * Math.pow(backoffFactor, backoffCount); // A random "fuzz" to avoid waves of retries.
  // Deviation: randomFactor is required.

  var randomWait = Math.round( // A fraction of the backoff value to add/subtract.
  // Deviation: changes multiplication order to improve readability.
  RANDOM_FACTOR * currBaseValue * ( // A random float (rounded to int by Math.round above) in the range [-1, 1]. Determines
  // if we add or subtract.
  Math.random() - 0.5) * 2); // Limits backoff to max to avoid effectively permanent backoff.

  return Math.min(MAX_VALUE_MILLIS, currBaseValue + randomWait);
}
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Provide English ordinal letters after a number
 */


function ordinal(i) {
  if (!Number.isFinite(i)) {
    return "" + i;
  }

  return i + indicator(i);
}

function indicator(i) {
  i = Math.abs(i);
  var cent = i % 100;

  if (cent >= 10 && cent <= 20) {
    return 'th';
  }

  var dec = i % 10;

  if (dec === 1) {
    return 'st';
  }

  if (dec === 2) {
    return 'nd';
  }

  if (dec === 3) {
    return 'rd';
  }

  return 'th';
}



/***/ }),

/***/ 45365:
/*!**************************************************************************!*\
  !*** ./node_modules/@ng-bootstrap/ng-bootstrap/fesm2015/ng-bootstrap.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalDismissReasons": () => (/* binding */ ModalDismissReasons),
/* harmony export */   "NgbAccordion": () => (/* binding */ NgbAccordion),
/* harmony export */   "NgbAccordionConfig": () => (/* binding */ NgbAccordionConfig),
/* harmony export */   "NgbAccordionModule": () => (/* binding */ NgbAccordionModule),
/* harmony export */   "NgbActiveModal": () => (/* binding */ NgbActiveModal),
/* harmony export */   "NgbAlert": () => (/* binding */ NgbAlert),
/* harmony export */   "NgbAlertConfig": () => (/* binding */ NgbAlertConfig),
/* harmony export */   "NgbAlertModule": () => (/* binding */ NgbAlertModule),
/* harmony export */   "NgbButtonLabel": () => (/* binding */ NgbButtonLabel),
/* harmony export */   "NgbButtonsModule": () => (/* binding */ NgbButtonsModule),
/* harmony export */   "NgbCalendar": () => (/* binding */ NgbCalendar),
/* harmony export */   "NgbCalendarGregorian": () => (/* binding */ NgbCalendarGregorian),
/* harmony export */   "NgbCalendarHebrew": () => (/* binding */ NgbCalendarHebrew),
/* harmony export */   "NgbCalendarIslamicCivil": () => (/* binding */ NgbCalendarIslamicCivil),
/* harmony export */   "NgbCalendarIslamicUmalqura": () => (/* binding */ NgbCalendarIslamicUmalqura),
/* harmony export */   "NgbCalendarPersian": () => (/* binding */ NgbCalendarPersian),
/* harmony export */   "NgbCarousel": () => (/* binding */ NgbCarousel),
/* harmony export */   "NgbCarouselConfig": () => (/* binding */ NgbCarouselConfig),
/* harmony export */   "NgbCarouselModule": () => (/* binding */ NgbCarouselModule),
/* harmony export */   "NgbCheckBox": () => (/* binding */ NgbCheckBox),
/* harmony export */   "NgbCollapse": () => (/* binding */ NgbCollapse),
/* harmony export */   "NgbCollapseConfig": () => (/* binding */ NgbCollapseConfig),
/* harmony export */   "NgbCollapseModule": () => (/* binding */ NgbCollapseModule),
/* harmony export */   "NgbConfig": () => (/* binding */ NgbConfig),
/* harmony export */   "NgbDate": () => (/* binding */ NgbDate),
/* harmony export */   "NgbDateAdapter": () => (/* binding */ NgbDateAdapter),
/* harmony export */   "NgbDateNativeAdapter": () => (/* binding */ NgbDateNativeAdapter),
/* harmony export */   "NgbDateNativeUTCAdapter": () => (/* binding */ NgbDateNativeUTCAdapter),
/* harmony export */   "NgbDateParserFormatter": () => (/* binding */ NgbDateParserFormatter),
/* harmony export */   "NgbDatepicker": () => (/* binding */ NgbDatepicker),
/* harmony export */   "NgbDatepickerConfig": () => (/* binding */ NgbDatepickerConfig),
/* harmony export */   "NgbDatepickerContent": () => (/* binding */ NgbDatepickerContent),
/* harmony export */   "NgbDatepickerI18n": () => (/* binding */ NgbDatepickerI18n),
/* harmony export */   "NgbDatepickerI18nHebrew": () => (/* binding */ NgbDatepickerI18nHebrew),
/* harmony export */   "NgbDatepickerKeyboardService": () => (/* binding */ NgbDatepickerKeyboardService),
/* harmony export */   "NgbDatepickerModule": () => (/* binding */ NgbDatepickerModule),
/* harmony export */   "NgbDatepickerMonth": () => (/* binding */ NgbDatepickerMonth),
/* harmony export */   "NgbDropdown": () => (/* binding */ NgbDropdown),
/* harmony export */   "NgbDropdownAnchor": () => (/* binding */ NgbDropdownAnchor),
/* harmony export */   "NgbDropdownConfig": () => (/* binding */ NgbDropdownConfig),
/* harmony export */   "NgbDropdownItem": () => (/* binding */ NgbDropdownItem),
/* harmony export */   "NgbDropdownMenu": () => (/* binding */ NgbDropdownMenu),
/* harmony export */   "NgbDropdownModule": () => (/* binding */ NgbDropdownModule),
/* harmony export */   "NgbDropdownToggle": () => (/* binding */ NgbDropdownToggle),
/* harmony export */   "NgbHighlight": () => (/* binding */ NgbHighlight),
/* harmony export */   "NgbInputDatepicker": () => (/* binding */ NgbInputDatepicker),
/* harmony export */   "NgbInputDatepickerConfig": () => (/* binding */ NgbInputDatepickerConfig),
/* harmony export */   "NgbModal": () => (/* binding */ NgbModal),
/* harmony export */   "NgbModalConfig": () => (/* binding */ NgbModalConfig),
/* harmony export */   "NgbModalModule": () => (/* binding */ NgbModalModule),
/* harmony export */   "NgbModalRef": () => (/* binding */ NgbModalRef),
/* harmony export */   "NgbModule": () => (/* binding */ NgbModule),
/* harmony export */   "NgbNav": () => (/* binding */ NgbNav),
/* harmony export */   "NgbNavConfig": () => (/* binding */ NgbNavConfig),
/* harmony export */   "NgbNavContent": () => (/* binding */ NgbNavContent),
/* harmony export */   "NgbNavItem": () => (/* binding */ NgbNavItem),
/* harmony export */   "NgbNavLink": () => (/* binding */ NgbNavLink),
/* harmony export */   "NgbNavModule": () => (/* binding */ NgbNavModule),
/* harmony export */   "NgbNavOutlet": () => (/* binding */ NgbNavOutlet),
/* harmony export */   "NgbNavPane": () => (/* binding */ NgbNavPane),
/* harmony export */   "NgbNavbar": () => (/* binding */ NgbNavbar),
/* harmony export */   "NgbPagination": () => (/* binding */ NgbPagination),
/* harmony export */   "NgbPaginationConfig": () => (/* binding */ NgbPaginationConfig),
/* harmony export */   "NgbPaginationEllipsis": () => (/* binding */ NgbPaginationEllipsis),
/* harmony export */   "NgbPaginationFirst": () => (/* binding */ NgbPaginationFirst),
/* harmony export */   "NgbPaginationLast": () => (/* binding */ NgbPaginationLast),
/* harmony export */   "NgbPaginationModule": () => (/* binding */ NgbPaginationModule),
/* harmony export */   "NgbPaginationNext": () => (/* binding */ NgbPaginationNext),
/* harmony export */   "NgbPaginationNumber": () => (/* binding */ NgbPaginationNumber),
/* harmony export */   "NgbPaginationPrevious": () => (/* binding */ NgbPaginationPrevious),
/* harmony export */   "NgbPanel": () => (/* binding */ NgbPanel),
/* harmony export */   "NgbPanelContent": () => (/* binding */ NgbPanelContent),
/* harmony export */   "NgbPanelHeader": () => (/* binding */ NgbPanelHeader),
/* harmony export */   "NgbPanelTitle": () => (/* binding */ NgbPanelTitle),
/* harmony export */   "NgbPanelToggle": () => (/* binding */ NgbPanelToggle),
/* harmony export */   "NgbPopover": () => (/* binding */ NgbPopover),
/* harmony export */   "NgbPopoverConfig": () => (/* binding */ NgbPopoverConfig),
/* harmony export */   "NgbPopoverModule": () => (/* binding */ NgbPopoverModule),
/* harmony export */   "NgbProgressbar": () => (/* binding */ NgbProgressbar),
/* harmony export */   "NgbProgressbarConfig": () => (/* binding */ NgbProgressbarConfig),
/* harmony export */   "NgbProgressbarModule": () => (/* binding */ NgbProgressbarModule),
/* harmony export */   "NgbRadio": () => (/* binding */ NgbRadio),
/* harmony export */   "NgbRadioGroup": () => (/* binding */ NgbRadioGroup),
/* harmony export */   "NgbRating": () => (/* binding */ NgbRating),
/* harmony export */   "NgbRatingConfig": () => (/* binding */ NgbRatingConfig),
/* harmony export */   "NgbRatingModule": () => (/* binding */ NgbRatingModule),
/* harmony export */   "NgbSlide": () => (/* binding */ NgbSlide),
/* harmony export */   "NgbSlideEventDirection": () => (/* binding */ NgbSlideEventDirection),
/* harmony export */   "NgbSlideEventSource": () => (/* binding */ NgbSlideEventSource),
/* harmony export */   "NgbTimeAdapter": () => (/* binding */ NgbTimeAdapter),
/* harmony export */   "NgbTimepicker": () => (/* binding */ NgbTimepicker),
/* harmony export */   "NgbTimepickerConfig": () => (/* binding */ NgbTimepickerConfig),
/* harmony export */   "NgbTimepickerI18n": () => (/* binding */ NgbTimepickerI18n),
/* harmony export */   "NgbTimepickerModule": () => (/* binding */ NgbTimepickerModule),
/* harmony export */   "NgbToast": () => (/* binding */ NgbToast),
/* harmony export */   "NgbToastConfig": () => (/* binding */ NgbToastConfig),
/* harmony export */   "NgbToastHeader": () => (/* binding */ NgbToastHeader),
/* harmony export */   "NgbToastModule": () => (/* binding */ NgbToastModule),
/* harmony export */   "NgbTooltip": () => (/* binding */ NgbTooltip),
/* harmony export */   "NgbTooltipConfig": () => (/* binding */ NgbTooltipConfig),
/* harmony export */   "NgbTooltipModule": () => (/* binding */ NgbTooltipModule),
/* harmony export */   "NgbTypeahead": () => (/* binding */ NgbTypeahead),
/* harmony export */   "NgbTypeaheadConfig": () => (/* binding */ NgbTypeaheadConfig),
/* harmony export */   "NgbTypeaheadModule": () => (/* binding */ NgbTypeaheadModule),
/* harmony export */   "ɵa": () => (/* binding */ NGB_CAROUSEL_DIRECTIVES),
/* harmony export */   "ɵb": () => (/* binding */ NGB_DATEPICKER_CALENDAR_FACTORY),
/* harmony export */   "ɵba": () => (/* binding */ NgbCalendarHijri),
/* harmony export */   "ɵbb": () => (/* binding */ ContentRef),
/* harmony export */   "ɵc": () => (/* binding */ NgbDatepickerDayView),
/* harmony export */   "ɵd": () => (/* binding */ NgbDatepickerNavigation),
/* harmony export */   "ɵe": () => (/* binding */ NgbDatepickerNavigationSelect),
/* harmony export */   "ɵf": () => (/* binding */ NGB_DATEPICKER_18N_FACTORY),
/* harmony export */   "ɵg": () => (/* binding */ NgbDatepickerI18nDefault),
/* harmony export */   "ɵh": () => (/* binding */ NGB_DATEPICKER_DATE_ADAPTER_FACTORY),
/* harmony export */   "ɵi": () => (/* binding */ NgbDateStructAdapter),
/* harmony export */   "ɵj": () => (/* binding */ NGB_DATEPICKER_PARSER_FORMATTER_FACTORY),
/* harmony export */   "ɵk": () => (/* binding */ NgbDateISOParserFormatter),
/* harmony export */   "ɵl": () => (/* binding */ NgbPopoverWindow),
/* harmony export */   "ɵm": () => (/* binding */ NGB_DATEPICKER_TIME_ADAPTER_FACTORY),
/* harmony export */   "ɵn": () => (/* binding */ NgbTimeStructAdapter),
/* harmony export */   "ɵo": () => (/* binding */ NGB_TIMEPICKER_I18N_FACTORY),
/* harmony export */   "ɵp": () => (/* binding */ NgbTimepickerI18nDefault),
/* harmony export */   "ɵq": () => (/* binding */ NgbTooltipWindow),
/* harmony export */   "ɵr": () => (/* binding */ NgbTypeaheadWindow),
/* harmony export */   "ɵs": () => (/* binding */ NgbDatepickerService),
/* harmony export */   "ɵt": () => (/* binding */ NgbModalBackdrop),
/* harmony export */   "ɵu": () => (/* binding */ NgbModalWindow),
/* harmony export */   "ɵv": () => (/* binding */ NgbModalStack),
/* harmony export */   "ɵw": () => (/* binding */ ScrollBar),
/* harmony export */   "ɵx": () => (/* binding */ ARIA_LIVE_DELAY),
/* harmony export */   "ɵy": () => (/* binding */ ARIA_LIVE_DELAY_FACTORY),
/* harmony export */   "ɵz": () => (/* binding */ Live)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 12378);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 26439);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 64139);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 92218);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 36312);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 45398);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 65763);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs */ 84505);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs */ 19193);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! rxjs */ 48130);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! rxjs */ 49727);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! rxjs */ 88623);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ 17295);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 85921);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ 59151);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs/operators */ 83910);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs/operators */ 86942);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! rxjs/operators */ 25722);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! rxjs/operators */ 53298);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! rxjs/operators */ 59095);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! rxjs/operators */ 88759);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! rxjs/operators */ 61745);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! rxjs/operators */ 25843);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! rxjs/operators */ 80522);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! rxjs/operators */ 16276);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! rxjs/operators */ 24514);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/forms */ 2508);









function NgbAccordion_ng_template_0_ng_template_2_Template(rf, ctx) {}

function NgbAccordion_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbAccordion_ng_template_0_ng_template_2_Template, 0, 0, "ng-template", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const panel_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngbPanelToggle", panel_r3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", panel_r3.title, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", panel_r3.titleTpl == null ? null : panel_r3.titleTpl.templateRef);
  }
}

function NgbAccordion_ng_template_2_ng_template_2_Template(rf, ctx) {}

function NgbAccordion_ng_template_2_div_3_ng_template_2_Template(rf, ctx) {}

function NgbAccordion_ng_template_2_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 8)(1, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbAccordion_ng_template_2_div_3_ng_template_2_Template, 0, 0, "ng-template", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const panel_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate"]("id", panel_r5.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-labelledby", panel_r5.id + "-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (panel_r5.contentTpl == null ? null : panel_r5.contentTpl.templateRef) || null);
  }
}

const _c0 = function (a0, a1) {
  return {
    $implicit: a0,
    opened: a1
  };
};

function NgbAccordion_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div")(1, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbAccordion_ng_template_2_ng_template_2_Template, 0, 0, "ng-template", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbAccordion_ng_template_2_div_3_Template, 3, 3, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const panel_r5 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](1);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("card " + (panel_r5.cardClass || ""));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("card-header " + (panel_r5.type ? "bg-" + panel_r5.type : ctx_r2.type ? "bg-" + ctx_r2.type : ""));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpropertyInterpolate1"]("id", "", panel_r5.id, "-header");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (panel_r5.headerTpl == null ? null : panel_r5.headerTpl.templateRef) || _r0)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction2"](8, _c0, panel_r5, panel_r5.isOpen));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r2.destroyOnHide || panel_r5.isOpen || panel_r5.transitionRunning);
  }
}

function NgbAlert_button_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbAlert_button_1_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r1.close());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2, "\u00D7");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }
}

const _c3 = ["*"];

function NgbCarousel_li_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "li", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbCarousel_li_1_Template_li_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6);
      const slide_r4 = restoredCtx.$implicit;
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r5.focus();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r5.select(slide_r4.id, ctx_r5.NgbSlideEventSource.INDICATOR));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const slide_r4 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("active", slide_r4.id === ctx_r0.activeId);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-labelledby", "slide-" + slide_r4.id)("aria-controls", "slide-" + slide_r4.id)("aria-selected", slide_r4.id === ctx_r0.activeId);
  }
}

function NgbCarousel_div_3_ng_template_3_Template(rf, ctx) {}

function NgbCarousel_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 7)(1, "span", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](2, 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbCarousel_div_3_ng_template_3_Template, 0, 0, "ng-template", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const slide_r7 = ctx.$implicit;
    const i_r8 = ctx.index;
    const c_r9 = ctx.count;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("id", "slide-" + slide_r7.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nExp"](i_r8 + 1)(c_r9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nApply"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", slide_r7.tplRef);
  }
}

function NgbCarousel_a_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "a", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbCarousel_a_4_Template_a_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r12);
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r11.arrowLeft());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }
}

function NgbCarousel_a_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "a", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbCarousel_a_5_Template_a_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r14);
      const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r13.arrowRight());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }
}

const _c10 = ["defaultDayTemplate"];
const _c11 = ["content"];

function NgbDatepicker_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 7);
  }

  if (rf & 2) {
    const date_r8 = ctx.date;
    const currentMonth_r9 = ctx.currentMonth;
    const selected_r10 = ctx.selected;
    const disabled_r11 = ctx.disabled;
    const focused_r12 = ctx.focused;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("date", date_r8)("currentMonth", currentMonth_r9)("selected", selected_r10)("disabled", disabled_r11)("focused", focused_r12);
  }
}

function NgbDatepicker_ng_template_2_div_0_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const month_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"](" ", ctx_r16.i18n.getMonthFullName(month_r14.number, month_r14.year), " ", ctx_r16.i18n.getYearNumerals(month_r14.year), " ");
  }
}

function NgbDatepicker_ng_template_2_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbDatepicker_ng_template_2_div_0_div_1_Template, 2, 2, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "ngb-datepicker-month", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const month_r14 = ctx.$implicit;
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r13.navigation === "none" || ctx_r13.displayMonths > 1 && ctx_r13.navigation === "select");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("month", month_r14.firstDate);
  }
}

function NgbDatepicker_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbDatepicker_ng_template_2_div_0_Template, 3, 2, "div", 8);
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r3.model.months);
  }
}

function NgbDatepicker_ngb_datepicker_navigation_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ngb-datepicker-navigation", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("navigate", function NgbDatepicker_ngb_datepicker_navigation_5_Template_ngb_datepicker_navigation_navigate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r19);
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r18.onNavigateEvent($event));
    })("select", function NgbDatepicker_ngb_datepicker_navigation_5_Template_ngb_datepicker_navigation_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r19);
      const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r20.onNavigateDateSelect($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("date", ctx_r4.model.firstDate)("months", ctx_r4.model.months)("disabled", ctx_r4.model.disabled)("showSelect", ctx_r4.model.navigation === "select")("prevDisabled", ctx_r4.model.prevDisabled)("nextDisabled", ctx_r4.model.nextDisabled)("selectBoxes", ctx_r4.model.selectBoxes);
  }
}

function NgbDatepicker_ng_template_8_Template(rf, ctx) {}

function NgbDatepicker_ng_template_9_Template(rf, ctx) {}

function NgbDatepickerMonth_div_0_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 5);
  }
}

function NgbDatepickerMonth_div_0_div_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const w_r4 = ctx.$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", ctx_r3.i18n.getWeekdayShortName(w_r4), " ");
  }
}

function NgbDatepickerMonth_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbDatepickerMonth_div_0_div_1_Template, 1, 0, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbDatepickerMonth_div_0_div_2_Template, 2, 1, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.datepicker.showWeekNumbers);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r0.viewModel.weekdays);
  }
}

function NgbDatepickerMonth_ng_template_1_div_0_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const week_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2).$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r7.i18n.getWeekNumerals(week_r5.number));
  }
}

function NgbDatepickerMonth_ng_template_1_div_0_div_2_ng_template_1_ng_template_0_Template(rf, ctx) {}

function NgbDatepickerMonth_ng_template_1_div_0_div_2_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbDatepickerMonth_ng_template_1_div_0_div_2_ng_template_1_ng_template_0_Template, 0, 0, "ng-template", 14);
  }

  if (rf & 2) {
    const day_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r11.datepicker.dayTemplate)("ngTemplateOutletContext", day_r10.context);
  }
}

function NgbDatepickerMonth_ng_template_1_div_0_div_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbDatepickerMonth_ng_template_1_div_0_div_2_Template_div_click_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r15);
      const day_r10 = restoredCtx.$implicit;
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](3);
      ctx_r14.doSelect(day_r10);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbDatepickerMonth_ng_template_1_div_0_div_2_ng_template_1_Template, 1, 2, "ng-template", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const day_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("disabled", day_r10.context.disabled)("hidden", day_r10.hidden)("ngb-dp-today", day_r10.context.today);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("tabindex", day_r10.tabindex);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-label", day_r10.ariaLabel);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !day_r10.hidden);
  }
}

function NgbDatepickerMonth_ng_template_1_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbDatepickerMonth_ng_template_1_div_0_div_1_Template, 2, 1, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbDatepickerMonth_ng_template_1_div_0_div_2_Template, 2, 9, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const week_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r6.datepicker.showWeekNumbers);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", week_r5.days);
  }
}

function NgbDatepickerMonth_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbDatepickerMonth_ng_template_1_div_0_Template, 3, 2, "div", 7);
  }

  if (rf & 2) {
    const week_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !week_r5.collapsed);
  }
}

function NgbDatepickerNavigation_ngb_datepicker_navigation_select_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ngb-datepicker-navigation-select", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("select", function NgbDatepickerNavigation_ngb_datepicker_navigation_select_3_Template_ngb_datepicker_navigation_select_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r2.select.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("date", ctx_r0.date)("disabled", ctx_r0.disabled)("months", ctx_r0.selectBoxes.months)("years", ctx_r0.selectBoxes.years);
  }
}

function NgbDatepickerNavigation_4_ng_template_0_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 0);
  }
}

function NgbDatepickerNavigation_4_ng_template_0_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 0);
  }
}

function NgbDatepickerNavigation_4_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbDatepickerNavigation_4_ng_template_0_div_0_Template, 1, 0, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbDatepickerNavigation_4_ng_template_0_div_3_Template, 1, 0, "div", 9);
  }

  if (rf & 2) {
    const month_r5 = ctx.$implicit;
    const i_r6 = ctx.index;
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", i_r6 > 0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"](" ", ctx_r4.i18n.getMonthFullName(month_r5.number, month_r5.year), " ", ctx_r4.i18n.getYearNumerals(month_r5.year), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", i_r6 !== ctx_r4.months.length - 1);
  }
}

function NgbDatepickerNavigation_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbDatepickerNavigation_4_ng_template_0_Template, 4, 4, "ng-template", 8);
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r1.months);
  }
}

const _c20 = ["ngbDatepickerDayView", ""];
const _c21 = ["month"];
const _c22 = ["year"];

function NgbDatepickerNavigationSelect_option_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "option", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const m_r4 = ctx.$implicit;
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", m_r4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-label", ctx_r1.i18n.getMonthFullName(m_r4, ctx_r1.date == null ? null : ctx_r1.date.year));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r1.i18n.getMonthShortName(m_r4, ctx_r1.date == null ? null : ctx_r1.date.year));
  }
}

function NgbDatepickerNavigationSelect_option_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "option", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const y_r5 = ctx.$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", y_r5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r3.i18n.getYearNumerals(y_r5));
  }
}

const _c31 = ["dialog"];
const _c32 = ["ngbNavOutlet", ""];

function NgbNavOutlet_ng_template_0_div_0_ng_template_1_Template(rf, ctx) {}

const _c33 = function (a0) {
  return {
    $implicit: a0
  };
};

function NgbNavOutlet_ng_template_0_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbNavOutlet_ng_template_0_div_0_ng_template_1_Template, 0, 0, "ng-template", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const item_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("item", item_r1)("nav", ctx_r2.nav)("role", ctx_r2.paneRole);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (item_r1.contentTpl == null ? null : item_r1.contentTpl.templateRef) || null)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](5, _c33, item_r1.active || ctx_r2.isPanelTransitioning(item_r1)));
  }
}

function NgbNavOutlet_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbNavOutlet_ng_template_0_div_0_Template, 2, 7, "div", 1);
  }

  if (rf & 2) {
    const item_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", item_r1.isPanelInDom() || ctx_r0.isPanelTransitioning(item_r1));
  }
}

function NgbPagination_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](1, 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }
}

function NgbPagination_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](1, 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }
}

function NgbPagination_ng_template_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](1, 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }
}

function NgbPagination_ng_template_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](1, 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }
}

function NgbPagination_ng_template_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0, "...");
  }
}

function NgbPagination_ng_template_10_span_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, "(current)");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }
}

function NgbPagination_ng_template_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbPagination_ng_template_10_span_1_Template, 2, 0, "span", 13);
  }

  if (rf & 2) {
    const page_r17 = ctx.$implicit;
    const currentPage_r18 = ctx.currentPage;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", page_r17, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", page_r17 === currentPage_r18);
  }
}

function NgbPagination_li_13_ng_template_2_Template(rf, ctx) {}

const _c44 = function (a0, a1) {
  return {
    disabled: a0,
    currentPage: a1
  };
};

function NgbPagination_li_13_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "li", 15)(1, "a", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbPagination_li_13_Template_a_click_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r22);
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r21.selectPage(1);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbPagination_li_13_ng_template_2_Template, 0, 0, "ng-template", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](1);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("disabled", ctx_r12.previousDisabled());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("tabindex", ctx_r12.previousDisabled() ? "-1" : null)("aria-disabled", ctx_r12.previousDisabled() ? "true" : null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (ctx_r12.tplFirst == null ? null : ctx_r12.tplFirst.templateRef) || _r0)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction2"](6, _c44, ctx_r12.previousDisabled(), ctx_r12.page));
  }
}

function NgbPagination_li_14_ng_template_2_Template(rf, ctx) {}

const _c47 = function (a0) {
  return {
    disabled: a0
  };
};

function NgbPagination_li_14_Template(rf, ctx) {
  if (rf & 1) {
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "li", 15)(1, "a", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbPagination_li_14_Template_a_click_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r25);
      const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r24.selectPage(ctx_r24.page - 1);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbPagination_li_14_ng_template_2_Template, 0, 0, "ng-template", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](3);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("disabled", ctx_r13.previousDisabled());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("tabindex", ctx_r13.previousDisabled() ? "-1" : null)("aria-disabled", ctx_r13.previousDisabled() ? "true" : null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (ctx_r13.tplPrevious == null ? null : ctx_r13.tplPrevious.templateRef) || _r2)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](6, _c47, ctx_r13.previousDisabled()));
  }
}

function NgbPagination_li_15_a_1_ng_template_1_Template(rf, ctx) {}

const _c48 = function (a1) {
  return {
    disabled: true,
    currentPage: a1
  };
};

function NgbPagination_li_15_a_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "a", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbPagination_li_15_a_1_ng_template_1_Template, 0, 0, "ng-template", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);

    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](9);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (ctx_r27.tplEllipsis == null ? null : ctx_r27.tplEllipsis.templateRef) || _r8)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c48, ctx_r27.page));
  }
}

function NgbPagination_li_15_a_2_ng_template_1_Template(rf, ctx) {}

const _c49 = function (a0, a1, a2) {
  return {
    disabled: a0,
    $implicit: a1,
    currentPage: a2
  };
};

function NgbPagination_li_15_a_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r33 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "a", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbPagination_li_15_a_2_Template_a_click_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r33);
      const pageNumber_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
      const ctx_r31 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r31.selectPage(pageNumber_r26);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbPagination_li_15_a_2_ng_template_1_Template, 0, 0, "ng-template", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const pageNumber_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](11);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("tabindex", ctx_r28.disabled ? "-1" : null)("aria-disabled", ctx_r28.disabled ? "true" : null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (ctx_r28.tplNumber == null ? null : ctx_r28.tplNumber.templateRef) || _r10)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction3"](4, _c49, ctx_r28.disabled, pageNumber_r26, ctx_r28.page));
  }
}

function NgbPagination_li_15_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "li", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbPagination_li_15_a_1_Template, 2, 4, "a", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbPagination_li_15_a_2_Template, 2, 8, "a", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const pageNumber_r26 = ctx.$implicit;
    const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("active", pageNumber_r26 === ctx_r14.page)("disabled", ctx_r14.isEllipsis(pageNumber_r26) || ctx_r14.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-current", pageNumber_r26 === ctx_r14.page ? "page" : null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r14.isEllipsis(pageNumber_r26));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r14.isEllipsis(pageNumber_r26));
  }
}

function NgbPagination_li_16_ng_template_2_Template(rf, ctx) {}

function NgbPagination_li_16_Template(rf, ctx) {
  if (rf & 1) {
    const _r37 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "li", 15)(1, "a", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbPagination_li_16_Template_a_click_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r37);
      const ctx_r36 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r36.selectPage(ctx_r36.page + 1);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbPagination_li_16_ng_template_2_Template, 0, 0, "ng-template", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](5);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("disabled", ctx_r15.nextDisabled());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("tabindex", ctx_r15.nextDisabled() ? "-1" : null)("aria-disabled", ctx_r15.nextDisabled() ? "true" : null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (ctx_r15.tplNext == null ? null : ctx_r15.tplNext.templateRef) || _r4)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction2"](6, _c44, ctx_r15.nextDisabled(), ctx_r15.page));
  }
}

function NgbPagination_li_17_ng_template_2_Template(rf, ctx) {}

function NgbPagination_li_17_Template(rf, ctx) {
  if (rf & 1) {
    const _r40 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "li", 15)(1, "a", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbPagination_li_17_Template_a_click_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r40);
      const ctx_r39 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r39.selectPage(ctx_r39.pageCount);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbPagination_li_17_ng_template_2_Template, 0, 0, "ng-template", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](7);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("disabled", ctx_r16.nextDisabled());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("tabindex", ctx_r16.nextDisabled() ? "-1" : null)("aria-disabled", ctx_r16.nextDisabled() ? "true" : null);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (ctx_r16.tplLast == null ? null : ctx_r16.tplLast.templateRef) || _r6)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction2"](6, _c44, ctx_r16.nextDisabled(), ctx_r16.page));
  }
}

function NgbPopoverWindow_h3_1_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0);
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r2.title);
  }
}

function NgbPopoverWindow_h3_1_ng_template_3_Template(rf, ctx) {}

function NgbPopoverWindow_h3_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "h3", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbPopoverWindow_h3_1_ng_template_1_Template, 1, 1, "ng-template", null, 4, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbPopoverWindow_h3_1_ng_template_3_Template, 0, 0, "ng-template", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);

    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r0.isTitleTemplate() ? ctx_r0.title : _r1)("ngTemplateOutletContext", ctx_r0.context);
  }
}

function NgbProgressbar_span_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](1, 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](2, "percent");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nExp"](_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](2, 1, ctx_r0.getValue() / ctx_r0.max));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nApply"](1);
  }
}

function NgbRating_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0);
  }

  if (rf & 2) {
    const fill_r3 = ctx.fill;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](fill_r3 === 100 ? "\u2605" : "\u2606");
  }
}

function NgbRating_ng_template_2_ng_template_3_Template(rf, ctx) {}

function NgbRating_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("mouseenter", function NgbRating_ng_template_2_Template_span_mouseenter_2_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r7);
      const index_r4 = restoredCtx.index;
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r6.enter(index_r4 + 1));
    })("click", function NgbRating_ng_template_2_Template_span_click_2_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r7);
      const index_r4 = restoredCtx.index;
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r8.handleClick(index_r4 + 1));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbRating_ng_template_2_ng_template_3_Template, 0, 0, "ng-template", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const index_r4 = ctx.index;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](1);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"]("(", index_r4 < ctx_r2.nextRate ? "*" : " ", ")");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("cursor", ctx_r2.isInteractive() ? "pointer" : "default");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r2.starTemplate || ctx_r2.starTemplateFromContent || _r0)("ngTemplateOutletContext", ctx_r2.contexts[index_r4]);
  }
}

function NgbTimepicker_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbTimepicker_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r9);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r8.changeHour(ctx_r8.hourStep));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn-sm", ctx_r0.isSmallSize)("btn-lg", ctx_r0.isLargeSize)("disabled", ctx_r0.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r0.disabled);
  }
}

function NgbTimepicker_button_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbTimepicker_button_5_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r11);
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r10.changeHour(-ctx_r10.hourStep));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn-sm", ctx_r1.isSmallSize)("btn-lg", ctx_r1.isLargeSize)("disabled", ctx_r1.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r1.disabled);
  }
}

function NgbTimepicker_button_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbTimepicker_button_9_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r13);
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r12.changeMinute(ctx_r12.minuteStep));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn-sm", ctx_r2.isSmallSize)("btn-lg", ctx_r2.isLargeSize)("disabled", ctx_r2.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r2.disabled);
  }
}

function NgbTimepicker_button_11_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbTimepicker_button_11_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r15);
      const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r14.changeMinute(-ctx_r14.minuteStep));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn-sm", ctx_r3.isSmallSize)("btn-lg", ctx_r3.isLargeSize)("disabled", ctx_r3.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r3.disabled);
  }
}

function NgbTimepicker_div_12_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1, ":");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }
}

function NgbTimepicker_div_13_button_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbTimepicker_div_13_button_1_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r19);
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r18.changeSecond(ctx_r18.secondStep));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn-sm", ctx_r16.isSmallSize)("btn-lg", ctx_r16.isLargeSize)("disabled", ctx_r16.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r16.disabled);
  }
}

function NgbTimepicker_div_13_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbTimepicker_div_13_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r21);
      const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r20.changeSecond(-ctx_r20.secondStep));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](1, "span", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "span", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](3, 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r17 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn-sm", ctx_r17.isSmallSize)("btn-lg", ctx_r17.isLargeSize)("disabled", ctx_r17.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r17.disabled);
  }
}

function NgbTimepicker_div_13_Template(rf, ctx) {
  if (rf & 1) {
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbTimepicker_div_13_button_1_Template, 4, 7, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "input", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function NgbTimepicker_div_13_Template_input_change_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23);
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r22.updateSecond($event.target.value));
    })("input", function NgbTimepicker_div_13_Template_input_input_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23);
      const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r24.formatInput($event.target));
    })("keydown.ArrowUp", function NgbTimepicker_div_13_Template_input_keydown_ArrowUp_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23);
      const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r25.changeSecond(ctx_r25.secondStep);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    })("keydown.ArrowDown", function NgbTimepicker_div_13_Template_input_keydown_ArrowDown_2_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r23);
      const ctx_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      ctx_r26.changeSecond(-ctx_r26.secondStep);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"]($event.preventDefault());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbTimepicker_div_13_button_3_Template, 4, 7, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r5.spinners);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("form-control-sm", ctx_r5.isSmallSize)("form-control-lg", ctx_r5.isLargeSize);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx_r5.formatMinSec(ctx_r5.model == null ? null : ctx_r5.model.second))("readOnly", ctx_r5.readonlyInputs)("disabled", ctx_r5.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r5.spinners);
  }
}

function NgbTimepicker_div_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 5);
  }
}

function NgbTimepicker_div_15_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](1, 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
  }

  if (rf & 2) {
    const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nExp"](ctx_r27.i18n.getAfternoonPeriod());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nApply"](1);
  }
}

function NgbTimepicker_div_15_ng_template_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18n"](0, 28);
  }

  if (rf & 2) {
    const ctx_r29 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nExp"](ctx_r29.i18n.getMorningPeriod());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵi18nApply"](0);
  }
}

function NgbTimepicker_div_15_Template(rf, ctx) {
  if (rf & 1) {
    const _r31 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 23)(1, "button", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbTimepicker_div_15_Template_button_click_1_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r31);
      const ctx_r30 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r30.toggleMeridian());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbTimepicker_div_15_ng_container_2_Template, 2, 1, "ng-container", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbTimepicker_div_15_ng_template_3_Template, 1, 1, "ng-template", null, 26, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const _r28 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](4);

    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn-sm", ctx_r7.isSmallSize)("btn-lg", ctx_r7.isLargeSize)("disabled", ctx_r7.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r7.disabled);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r7.model && ctx_r7.model.hour >= 12)("ngIfElse", _r28);
  }
}

function NgbToast_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "strong", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx_r1.header);
  }
}

function NgbToast_ng_template_2_ng_template_1_Template(rf, ctx) {}

function NgbToast_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbToast_ng_template_2_ng_template_1_Template, 0, 0, "ng-template", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "button", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbToast_ng_template_2_Template_button_click_2_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r4.hide());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "span", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](4, "\u00D7");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()()();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](1);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r2.contentHeaderTpl || _r0);
  }
}

function NgbHighlight_ng_template_0_span_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const part_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"](ctx_r3.highlightClass);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](part_r1);
  }
}

function NgbHighlight_ng_template_0_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0);
  }

  if (rf & 2) {
    const part_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](part_r1);
  }
}

function NgbHighlight_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbHighlight_ng_template_0_span_0_Template, 2, 3, "span", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbHighlight_ng_template_0_ng_template_1_Template, 1, 1, "ng-template", null, 2, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
  }

  if (rf & 2) {
    const isOdd_r2 = ctx.odd;

    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", isOdd_r2)("ngIfElse", _r4);
  }
}

function NgbTypeaheadWindow_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "ngb-highlight", 2);
  }

  if (rf & 2) {
    const result_r3 = ctx.result;
    const term_r4 = ctx.term;
    const formatter_r5 = ctx.formatter;
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("result", formatter_r5(result_r3))("term", term_r4);
  }
}

function NgbTypeaheadWindow_ng_template_2_ng_template_1_Template(rf, ctx) {}

const _c86 = function (a0, a1, a2) {
  return {
    result: a0,
    term: a1,
    formatter: a2
  };
};

function NgbTypeaheadWindow_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("mouseenter", function NgbTypeaheadWindow_ng_template_2_Template_button_mouseenter_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r10);
      const idx_r7 = restoredCtx.index;
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r9.markActive(idx_r7));
    })("click", function NgbTypeaheadWindow_ng_template_2_Template_button_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r10);
      const result_r6 = restoredCtx.$implicit;
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r11.select(result_r6));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbTypeaheadWindow_ng_template_2_ng_template_1_Template, 0, 0, "ng-template", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const result_r6 = ctx.$implicit;
    const idx_r7 = ctx.index;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();

    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](1);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("active", idx_r7 === ctx_r2.activeIdx);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("id", ctx_r2.id + "-" + idx_r7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r2.resultTemplate || _r0)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction3"](5, _c86, result_r6, ctx_r2.term, ctx_r2.formatter));
  }
}

function toInteger(value) {
  return parseInt(`${value}`, 10);
}

function toString(value) {
  return value !== undefined && value !== null ? `${value}` : '';
}

function getValueInRange(value, max, min = 0) {
  return Math.max(Math.min(value, max), min);
}

function isString(value) {
  return typeof value === 'string';
}

function isNumber(value) {
  return !isNaN(toInteger(value));
}

function isInteger(value) {
  return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
}

function isDefined(value) {
  return value !== undefined && value !== null;
}

function padNumber(value) {
  if (isNumber(value)) {
    return `0${value}`.slice(-2);
  } else {
    return '';
  }
}

function regExpEscape(text) {
  return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}

function hasClassName(element, className) {
  return element && element.className && element.className.split && element.className.split(/\s+/).indexOf(className) >= 0;
}

if (typeof Element !== 'undefined' && !Element.prototype.closest) {
  // Polyfill for ie10+
  if (!Element.prototype.matches) {
    // IE uses the non-standard name: msMatchesSelector
    Element.prototype.matches = Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
  }

  Element.prototype.closest = function (s) {
    let el = this;

    if (!document.documentElement.contains(el)) {
      return null;
    }

    do {
      if (el.matches(s)) {
        return el;
      }

      el = el.parentElement || el.parentNode;
    } while (el !== null && el.nodeType === 1);

    return null;
  };
}

function closest(element, selector) {
  if (!selector) {
    return null;
  }
  /*
   * In certain browsers (e.g. Edge 44.18362.449.0) HTMLDocument does
   * not support `Element.prototype.closest`. To emulate the correct behaviour
   * we return null when the method is missing.
   *
   * Note that in evergreen browsers `closest(document.documentElement, 'html')`
   * will return the document element whilst in Edge null will be returned. This
   * compromise was deemed good enough.
   */


  if (typeof element.closest === 'undefined') {
    return null;
  }

  return element.closest(selector);
}
/**
 * Force a browser reflow
 * @param element element where to apply the reflow
 */


function reflow(element) {
  return (element || document.body).offsetHeight;
}
/**
 * Creates an observable where all callbacks are executed inside a given zone
 *
 * @param zone
 */


function runInZone(zone) {
  return source => {
    return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(observer => {
      const onNext = value => zone.run(() => observer.next(value));

      const onError = e => zone.run(() => observer.error(e));

      const onComplete = () => zone.run(() => observer.complete());

      return source.subscribe(onNext, onError, onComplete);
    });
  };
}

const environment = {
  animation: true,
  transitionTimerDelayMs: 5
};
/**
 * Global ng-bootstrap config
 *
 * @since 8.0.0
 */

let NgbConfig = /*#__PURE__*/(() => {
  class NgbConfig {
    constructor() {
      this.animation = environment.animation;
    }

  }

  NgbConfig.ɵfac = function NgbConfig_Factory(t) {
    return new (t || NgbConfig)();
  };

  NgbConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbConfig_Factory() {
      return new NgbConfig();
    },
    token: NgbConfig,
    providedIn: "root"
  });
  return NgbConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A configuration service for the [NgbAccordion](#/components/accordion/api#NgbAccordion) component.
 *
 * You can inject this service, typically in your root component, and customize its properties
 * to provide default values for all accordions used in the application.
 */


let NgbAccordionConfig = /*#__PURE__*/(() => {
  class NgbAccordionConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.closeOthers = false;
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbAccordionConfig.ɵfac = function NgbAccordionConfig_Factory(t) {
    return new (t || NgbAccordionConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbAccordionConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbAccordionConfig_Factory() {
      return new NgbAccordionConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbAccordionConfig,
    providedIn: "root"
  });
  return NgbAccordionConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

function getTransitionDurationMs(element) {
  const {
    transitionDelay,
    transitionDuration
  } = window.getComputedStyle(element);
  const transitionDelaySec = parseFloat(transitionDelay);
  const transitionDurationSec = parseFloat(transitionDuration);
  return (transitionDelaySec + transitionDurationSec) * 1000;
}

const noopFn = () => {};

const ɵ0 = noopFn;
const {
  transitionTimerDelayMs
} = environment;
const runningTransitions = new Map();

const ngbRunTransition = (zone, element, startFn, options) => {
  // Getting initial context from options
  let context = options.context || {}; // Checking if there are already running transitions on the given element.

  const running = runningTransitions.get(element);

  if (running) {
    switch (options.runningTransition) {
      // If there is one running and we want for it to 'continue' to run, we have to cancel the new one.
      // We're not emitting any values, but simply completing the observable (EMPTY).
      case 'continue':
        return rxjs__WEBPACK_IMPORTED_MODULE_2__.EMPTY;
      // If there is one running and we want for it to 'stop', we have to complete the running one.
      // We're simply completing the running one and not emitting any values and merging newly provided context
      // with the one coming from currently running transition.

      case 'stop':
        zone.run(() => running.transition$.complete());
        context = Object.assign(running.context, context);
        runningTransitions.delete(element);
    }
  } // Running the start function


  const endFn = startFn(element, options.animation, context) || noopFn; // If 'prefer-reduced-motion' is enabled, the 'transition' will be set to 'none'.
  // If animations are disabled, we have to emit a value and complete the observable
  // In this case we have to call the end function, but can finish immediately by emitting a value,
  // completing the observable and executing end functions synchronously.

  if (!options.animation || window.getComputedStyle(element).transitionProperty === 'none') {
    zone.run(() => endFn());
    return (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.of)(undefined).pipe(runInZone(zone));
  } // Starting a new transition


  const transition$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
  const finishTransition$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
  const stop$ = transition$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.endWith)(true));
  runningTransitions.set(element, {
    transition$,
    complete: () => {
      finishTransition$.next();
      finishTransition$.complete();
    },
    context
  });
  const transitionDurationMs = getTransitionDurationMs(element); // 1. We have to both listen for the 'transitionend' event and have a 'just-in-case' timer,
  // because 'transitionend' event might not be fired in some browsers, if the transitioning
  // element becomes invisible (ex. when scrolling, making browser tab inactive, etc.). The timer
  // guarantees, that we'll release the DOM element and complete 'ngbRunTransition'.
  // 2. We need to filter transition end events, because they might bubble from shorter transitions
  // on inner DOM elements. We're only interested in the transition on the 'element' itself.

  zone.runOutsideAngular(() => {
    const transitionEnd$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(element, 'transitionend').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(stop$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(({
      target
    }) => target === element));
    const timer$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.timer)(transitionDurationMs + transitionTimerDelayMs).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(stop$));
    (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.race)(timer$, transitionEnd$, finishTransition$).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(stop$)).subscribe(() => {
      runningTransitions.delete(element);
      zone.run(() => {
        endFn();
        transition$.next();
        transition$.complete();
      });
    });
  });
  return transition$.asObservable();
};

const ngbCompleteTransition = element => {
  var _a;

  (_a = runningTransitions.get(element)) === null || _a === void 0 ? void 0 : _a.complete();
};

function measureCollapsingElementHeightPx(element) {
  // SSR fix for without injecting the PlatformId
  if (typeof navigator === 'undefined') {
    return '0px';
  }

  const {
    classList
  } = element;
  const hasShownClass = classList.contains('show');

  if (!hasShownClass) {
    classList.add('show');
  }

  element.style.height = '';
  const height = element.getBoundingClientRect().height + 'px';

  if (!hasShownClass) {
    classList.remove('show');
  }

  return height;
}

const ngbCollapsingTransition = (element, animation, context) => {
  let {
    direction,
    maxHeight
  } = context;
  const {
    classList
  } = element;

  function setInitialClasses() {
    classList.add('collapse');

    if (direction === 'show') {
      classList.add('show');
    } else {
      classList.remove('show');
    }
  } // without animations we just need to set initial classes


  if (!animation) {
    setInitialClasses();
    return;
  } // No maxHeight -> running the transition for the first time


  if (!maxHeight) {
    maxHeight = measureCollapsingElementHeightPx(element);
    context.maxHeight = maxHeight; // Fix the height before starting the animation

    element.style.height = direction !== 'show' ? maxHeight : '0px';
    classList.remove('collapse');
    classList.remove('collapsing');
    classList.remove('show');
    reflow(element); // Start the animation

    classList.add('collapsing');
  } // Start or revert the animation


  element.style.height = direction === 'show' ? maxHeight : '0px';
  return () => {
    setInitialClasses();
    classList.remove('collapsing');
    element.style.height = '';
  };
};

let nextId = 0;
/**
 * A directive that wraps an accordion panel header with any HTML markup and a toggling button
 * marked with [`NgbPanelToggle`](#/components/accordion/api#NgbPanelToggle).
 * See the [header customization demo](#/components/accordion/examples#header) for more details.
 *
 * You can also use [`NgbPanelTitle`](#/components/accordion/api#NgbPanelTitle) to customize only the panel title.
 *
 * @since 4.1.0
 */

let NgbPanelHeader = /*#__PURE__*/(() => {
  class NgbPanelHeader {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPanelHeader.ɵfac = function NgbPanelHeader_Factory(t) {
    return new (t || NgbPanelHeader)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPanelHeader.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPanelHeader,
    selectors: [["ng-template", "ngbPanelHeader", ""]]
  });
  return NgbPanelHeader;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that wraps only the panel title with HTML markup inside.
 *
 * You can also use [`NgbPanelHeader`](#/components/accordion/api#NgbPanelHeader) to customize the full panel header.
 */


let NgbPanelTitle = /*#__PURE__*/(() => {
  class NgbPanelTitle {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPanelTitle.ɵfac = function NgbPanelTitle_Factory(t) {
    return new (t || NgbPanelTitle)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPanelTitle.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPanelTitle,
    selectors: [["ng-template", "ngbPanelTitle", ""]]
  });
  return NgbPanelTitle;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that wraps the accordion panel content.
 */


let NgbPanelContent = /*#__PURE__*/(() => {
  class NgbPanelContent {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPanelContent.ɵfac = function NgbPanelContent_Factory(t) {
    return new (t || NgbPanelContent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPanelContent.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPanelContent,
    selectors: [["ng-template", "ngbPanelContent", ""]]
  });
  return NgbPanelContent;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that wraps an individual accordion panel with title and collapsible content.
 */


let NgbPanel = /*#__PURE__*/(() => {
  class NgbPanel {
    constructor() {
      /**
       *  If `true`, the panel is disabled an can't be toggled.
       */
      this.disabled = false;
      /**
       *  An optional id for the panel that must be unique on the page.
       *
       *  If not provided, it will be auto-generated in the `ngb-panel-xxx` format.
       */

      this.id = `ngb-panel-${nextId++}`;
      this.isOpen = false;
      /* A flag to specified that the transition panel classes have been initialized */

      this.initClassDone = false;
      /* A flag to specified if the panel is currently being animated, to ensure its presence in the dom */

      this.transitionRunning = false;
      /**
       * An event emitted when the panel is shown, after the transition. It has no payload.
       *
       * @since 8.0.0
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the panel is hidden, after the transition. It has no payload.
       *
       * @since 8.0.0
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }

    ngAfterContentChecked() {
      // We are using @ContentChildren instead of @ContentChild as in the Angular version being used
      // only @ContentChildren allows us to specify the {descendants: false} option.
      // Without {descendants: false} we are hitting bugs described in:
      // https://github.com/ng-bootstrap/ng-bootstrap/issues/2240
      this.titleTpl = this.titleTpls.first;
      this.headerTpl = this.headerTpls.first;
      this.contentTpl = this.contentTpls.first;
    }

  }

  NgbPanel.ɵfac = function NgbPanel_Factory(t) {
    return new (t || NgbPanel)();
  };

  NgbPanel.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPanel,
    selectors: [["ngb-panel"]],
    contentQueries: function NgbPanel_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPanelTitle, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPanelHeader, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPanelContent, 4);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.titleTpls = _t);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.headerTpls = _t);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.contentTpls = _t);
      }
    },
    inputs: {
      disabled: "disabled",
      id: "id",
      title: "title",
      type: "type",
      cardClass: "cardClass"
    },
    outputs: {
      shown: "shown",
      hidden: "hidden"
    }
  });
  return NgbPanel;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Accordion is a collection of collapsible panels (bootstrap cards).
 *
 * It can ensure only one panel is opened at a time and allows to customize panel
 * headers.
 */


let NgbAccordion = /*#__PURE__*/(() => {
  class NgbAccordion {
    constructor(config, _element, _ngZone, _changeDetector) {
      this._element = _element;
      this._ngZone = _ngZone;
      this._changeDetector = _changeDetector;
      /**
       * An array or comma separated strings of panel ids that should be opened **initially**.
       *
       * For subsequent changes use methods like `expand()`, `collapse()`, etc. and
       * the `(panelChange)` event.
       */

      this.activeIds = [];
      /**
       * If `true`, panel content will be detached from DOM and not simply hidden when the panel is collapsed.
       */

      this.destroyOnHide = true;
      /**
       * Event emitted right before the panel toggle happens.
       *
       * See [NgbPanelChangeEvent](#/components/accordion/api#NgbPanelChangeEvent) for payload details.
       */

      this.panelChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the expanding animation is finished on the panel. The payload is the panel id.
       *
       * @since 8.0.0
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the collapsing animation is finished on the panel, and before the panel element is removed.
       * The payload is the panel id.
       *
       * @since 8.0.0
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.animation = config.animation;
      this.type = config.type;
      this.closeOtherPanels = config.closeOthers;
    }
    /**
     * Checks if a panel with a given id is expanded.
     */


    isExpanded(panelId) {
      return this.activeIds.indexOf(panelId) > -1;
    }
    /**
     * Expands a panel with a given id.
     *
     * Has no effect if the panel is already expanded or disabled.
     */


    expand(panelId) {
      this._changeOpenState(this._findPanelById(panelId), true);
    }
    /**
     * Expands all panels, if `[closeOthers]` is `false`.
     *
     * If `[closeOthers]` is `true`, it will expand the first panel, unless there is already a panel opened.
     */


    expandAll() {
      if (this.closeOtherPanels) {
        if (this.activeIds.length === 0 && this.panels.length) {
          this._changeOpenState(this.panels.first, true);
        }
      } else {
        this.panels.forEach(panel => this._changeOpenState(panel, true));
      }
    }
    /**
     * Collapses a panel with the given id.
     *
     * Has no effect if the panel is already collapsed or disabled.
     */


    collapse(panelId) {
      this._changeOpenState(this._findPanelById(panelId), false);
    }
    /**
     * Collapses all opened panels.
     */


    collapseAll() {
      this.panels.forEach(panel => {
        this._changeOpenState(panel, false);
      });
    }
    /**
     * Toggles a panel with the given id.
     *
     * Has no effect if the panel is disabled.
     */


    toggle(panelId) {
      const panel = this._findPanelById(panelId);

      if (panel) {
        this._changeOpenState(panel, !panel.isOpen);
      }
    }

    ngAfterContentChecked() {
      // active id updates
      if (isString(this.activeIds)) {
        this.activeIds = this.activeIds.split(/\s*,\s*/);
      } // update panels open states


      this.panels.forEach(panel => {
        panel.isOpen = !panel.disabled && this.activeIds.indexOf(panel.id) > -1;
      }); // closeOthers updates

      if (this.activeIds.length > 1 && this.closeOtherPanels) {
        this._closeOthers(this.activeIds[0], false);

        this._updateActiveIds();
      } // Setup the initial classes here


      this._ngZone.onStable.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => {
        this.panels.forEach(panel => {
          const panelElement = this._getPanelElement(panel.id);

          if (panelElement) {
            if (!panel.initClassDone) {
              panel.initClassDone = true;
              ngbRunTransition(this._ngZone, panelElement, ngbCollapsingTransition, {
                animation: false,
                runningTransition: 'continue',
                context: {
                  direction: panel.isOpen ? 'show' : 'hide'
                }
              });
            }
          } else {
            // Classes must be initialized next time it will be in the dom
            panel.initClassDone = false;
          }
        });
      });
    }

    _changeOpenState(panel, nextState) {
      if (panel != null && !panel.disabled && panel.isOpen !== nextState) {
        let defaultPrevented = false;
        this.panelChange.emit({
          panelId: panel.id,
          nextState: nextState,
          preventDefault: () => {
            defaultPrevented = true;
          }
        });

        if (!defaultPrevented) {
          panel.isOpen = nextState;
          panel.transitionRunning = true;

          if (nextState && this.closeOtherPanels) {
            this._closeOthers(panel.id);
          }

          this._updateActiveIds();

          this._runTransitions(this.animation);
        }
      }
    }

    _closeOthers(panelId, enableTransition = true) {
      this.panels.forEach(panel => {
        if (panel.id !== panelId && panel.isOpen) {
          panel.isOpen = false;
          panel.transitionRunning = enableTransition;
        }
      });
    }

    _findPanelById(panelId) {
      return this.panels.find(p => p.id === panelId) || null;
    }

    _updateActiveIds() {
      this.activeIds = this.panels.filter(panel => panel.isOpen && !panel.disabled).map(panel => panel.id);
    }

    _runTransitions(animation) {
      // detectChanges is performed to ensure that all panels are in the dom (via transitionRunning = true)
      // before starting the animation
      this._changeDetector.detectChanges();

      this.panels.forEach(panel => {
        // When panel.transitionRunning is true, the transition needs to be started OR reversed,
        // The direction (show or hide) is choosen by each panel.isOpen state
        if (panel.transitionRunning) {
          const panelElement = this._getPanelElement(panel.id);

          ngbRunTransition(this._ngZone, panelElement, ngbCollapsingTransition, {
            animation,
            runningTransition: 'stop',
            context: {
              direction: panel.isOpen ? 'show' : 'hide'
            }
          }).subscribe(() => {
            panel.transitionRunning = false;
            const {
              id
            } = panel;

            if (panel.isOpen) {
              panel.shown.emit();
              this.shown.emit(id);
            } else {
              panel.hidden.emit();
              this.hidden.emit(id);
            }
          });
        }
      });
    }

    _getPanelElement(panelId) {
      return this._element.nativeElement.querySelector('#' + panelId);
    }

  }

  NgbAccordion.ɵfac = function NgbAccordion_Factory(t) {
    return new (t || NgbAccordion)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbAccordionConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef));
  };

  NgbAccordion.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbAccordion,
    selectors: [["ngb-accordion"]],
    contentQueries: function NgbAccordion_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPanel, 4);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.panels = _t);
      }
    },
    hostAttrs: ["role", "tablist", 1, "accordion"],
    hostVars: 1,
    hostBindings: function NgbAccordion_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-multiselectable", !ctx.closeOtherPanels);
      }
    },
    inputs: {
      activeIds: "activeIds",
      destroyOnHide: "destroyOnHide",
      animation: "animation",
      type: "type",
      closeOtherPanels: ["closeOthers", "closeOtherPanels"]
    },
    outputs: {
      panelChange: "panelChange",
      shown: "shown",
      hidden: "hidden"
    },
    exportAs: ["ngbAccordion"],
    decls: 3,
    vars: 1,
    consts: [["ngbPanelHeader", ""], ["t", ""], ["ngFor", "", 3, "ngForOf"], [1, "btn", "btn-link", 3, "ngbPanelToggle"], [3, "ngTemplateOutlet"], ["role", "tab", 3, "id"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"], ["role", "tabpanel", 3, "id", 4, "ngIf"], ["role", "tabpanel", 3, "id"], [1, "card-body"]],
    template: function NgbAccordion_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbAccordion_ng_template_0_Template, 3, 3, "ng-template", 0, 1, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbAccordion_ng_template_2_Template, 4, 11, "ng-template", 2);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.panels);
      }
    },
    dependencies: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet, NgbPanelHeader, NgbPanelToggle];
    },
    encapsulation: 2
  });
  return NgbAccordion;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to put on a button that toggles panel opening and closing.
 *
 * To be used inside the [`NgbPanelHeader`](#/components/accordion/api#NgbPanelHeader)
 *
 * @since 4.1.0
 */


let NgbPanelToggle = /*#__PURE__*/(() => {
  class NgbPanelToggle {
    constructor(accordion, panel) {
      this.accordion = accordion;
      this.panel = panel;
    }

    set ngbPanelToggle(panel) {
      if (panel) {
        this.panel = panel;
      }
    }

  }

  NgbPanelToggle.ɵfac = function NgbPanelToggle_Factory(t) {
    return new (t || NgbPanelToggle)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbAccordion), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbPanel, 9));
  };

  NgbPanelToggle.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPanelToggle,
    selectors: [["button", "ngbPanelToggle", ""]],
    hostAttrs: ["type", "button"],
    hostVars: 5,
    hostBindings: function NgbPanelToggle_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbPanelToggle_click_HostBindingHandler() {
          return ctx.accordion.toggle(ctx.panel.id);
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("disabled", ctx.panel.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-expanded", ctx.panel.isOpen)("aria-controls", ctx.panel.id);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("collapsed", !ctx.panel.isOpen);
      }
    },
    inputs: {
      ngbPanelToggle: "ngbPanelToggle"
    }
  });
  return NgbPanelToggle;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const NGB_ACCORDION_DIRECTIVES = [NgbAccordion, NgbPanel, NgbPanelTitle, NgbPanelContent, NgbPanelHeader, NgbPanelToggle];
let NgbAccordionModule = /*#__PURE__*/(() => {
  class NgbAccordionModule {}

  NgbAccordionModule.ɵfac = function NgbAccordionModule_Factory(t) {
    return new (t || NgbAccordionModule)();
  };

  NgbAccordionModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbAccordionModule
  });
  NgbAccordionModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbAccordionModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbAccordionModule, {
    declarations: function () {
      return [NgbAccordion, NgbPanel, NgbPanelTitle, NgbPanelContent, NgbPanelHeader, NgbPanelToggle];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbAccordion, NgbPanel, NgbPanelTitle, NgbPanelContent, NgbPanelHeader, NgbPanelToggle];
    }
  });
})();
/**
 * A configuration service for the [NgbAlert](#/components/alert/api#NgbAlert) component.
 *
 * You can inject this service, typically in your root component, and customize its properties
 * to provide default values for all alerts used in the application.
 */


let NgbAlertConfig = /*#__PURE__*/(() => {
  class NgbAlertConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.dismissible = true;
      this.type = 'warning';
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbAlertConfig.ɵfac = function NgbAlertConfig_Factory(t) {
    return new (t || NgbAlertConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbAlertConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbAlertConfig_Factory() {
      return new NgbAlertConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbAlertConfig,
    providedIn: "root"
  });
  return NgbAlertConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const ngbAlertFadingTransition = ({
  classList
}) => {
  classList.remove('show');
};
/**
 * Alert is a component to provide contextual feedback messages for user.
 *
 * It supports several alert types and can be dismissed.
 */


let NgbAlert = /*#__PURE__*/(() => {
  class NgbAlert {
    constructor(config, _renderer, _element, _zone) {
      this._renderer = _renderer;
      this._element = _element;
      this._zone = _zone;
      /**
       * An event emitted when the close button is clicked. It has no payload and only relevant for dismissible alerts.
       *
       * @since 8.0.0
       */

      this.closed = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.dismissible = config.dismissible;
      this.type = config.type;
      this.animation = config.animation;
    }
    /**
     * Triggers alert closing programmatically (same as clicking on the close button (×)).
     *
     * The returned observable will emit and be completed once the closing transition has finished.
     * If the animations are turned off this happens synchronously.
     *
     * Alternatively you could listen or subscribe to the `(closed)` output
     *
     * @since 8.0.0
     */


    close() {
      const transition = ngbRunTransition(this._zone, this._element.nativeElement, ngbAlertFadingTransition, {
        animation: this.animation,
        runningTransition: 'continue'
      });
      transition.subscribe(() => this.closed.emit());
      return transition;
    }

    ngOnChanges(changes) {
      const typeChange = changes['type'];

      if (typeChange && !typeChange.firstChange) {
        this._renderer.removeClass(this._element.nativeElement, `alert-${typeChange.previousValue}`);

        this._renderer.addClass(this._element.nativeElement, `alert-${typeChange.currentValue}`);
      }
    }

    ngOnInit() {
      this._renderer.addClass(this._element.nativeElement, `alert-${this.type}`);
    }

  }

  NgbAlert.ɵfac = function NgbAlert_Factory(t) {
    return new (t || NgbAlert)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbAlertConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  NgbAlert.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbAlert,
    selectors: [["ngb-alert"]],
    hostAttrs: ["role", "alert", 1, "alert", "show"],
    hostVars: 4,
    hostBindings: function NgbAlert_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("fade", ctx.animation)("alert-dismissible", ctx.dismissible);
      }
    },
    inputs: {
      dismissible: "dismissible",
      type: "type",
      animation: "animation"
    },
    outputs: {
      closed: "closed"
    },
    exportAs: ["ngbAlert"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
    ngContentSelectors: _c3,
    decls: 2,
    vars: 1,
    consts: function () {
      let i18n_1;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_alert_close$$FESM2015_NG_BOOTSTRAP_JS_2 = goog.getMsg("Close");
        i18n_1 = MSG_EXTERNAL_ngb_alert_close$$FESM2015_NG_BOOTSTRAP_JS_2;
      } else {
        i18n_1 = $localize`:@@ngb.alert.close␟f4e529ae5ffd73001d1ff4bbdeeb0a72e342e5c8␟7819314041543176992:Close`;
      }

      return [["type", "button", "class", "close", "aria-label", i18n_1, 3, "click", 4, "ngIf"], ["type", "button", "aria-label", i18n_1, 1, "close", 3, "click"], ["aria-hidden", "true"]];
    },
    template: function NgbAlert_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbAlert_button_1_Template, 3, 0, "button", 0);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.dismissible);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf],
    styles: ["ngb-alert{display:block}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbAlert;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbAlertModule = /*#__PURE__*/(() => {
  class NgbAlertModule {}

  NgbAlertModule.ɵfac = function NgbAlertModule_Factory(t) {
    return new (t || NgbAlertModule)();
  };

  NgbAlertModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbAlertModule
  });
  NgbAlertModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbAlertModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbAlertModule, {
    declarations: function () {
      return [NgbAlert];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbAlert];
    }
  });
})();

let NgbButtonLabel = /*#__PURE__*/(() => {
  class NgbButtonLabel {}

  NgbButtonLabel.ɵfac = function NgbButtonLabel_Factory(t) {
    return new (t || NgbButtonLabel)();
  };

  NgbButtonLabel.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbButtonLabel,
    selectors: [["", "ngbButtonLabel", ""]],
    hostVars: 8,
    hostBindings: function NgbButtonLabel_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("btn", true)("active", ctx.active)("disabled", ctx.disabled)("focus", ctx.focused);
      }
    }
  });
  return NgbButtonLabel;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Allows to easily create Bootstrap-style checkbox buttons.
 *
 * Integrates with forms, so the value of a checked button is bound to the underlying form control
 * either in a reactive or template-driven way.
 */


let NgbCheckBox = /*#__PURE__*/(() => {
  class NgbCheckBox {
    constructor(_label, _cd) {
      this._label = _label;
      this._cd = _cd;
      /**
       * If `true`, the checkbox button will be disabled
       */

      this.disabled = false;
      /**
       * The form control value when the checkbox is checked.
       */

      this.valueChecked = true;
      /**
       * The form control value when the checkbox is unchecked.
       */

      this.valueUnChecked = false;

      this.onChange = _ => {};

      this.onTouched = () => {};
    }

    set focused(isFocused) {
      this._label.focused = isFocused;

      if (!isFocused) {
        this.onTouched();
      }
    }

    onInputChange($event) {
      const modelToPropagate = $event.target.checked ? this.valueChecked : this.valueUnChecked;
      this.onChange(modelToPropagate);
      this.onTouched();
      this.writeValue(modelToPropagate);
    }

    registerOnChange(fn) {
      this.onChange = fn;
    }

    registerOnTouched(fn) {
      this.onTouched = fn;
    }

    setDisabledState(isDisabled) {
      this.disabled = isDisabled;
      this._label.disabled = isDisabled;
    }

    writeValue(value) {
      this.checked = value === this.valueChecked;
      this._label.active = this.checked; // label won't be updated, if it is inside the OnPush component when [ngModel] changes

      this._cd.markForCheck();
    }

  }

  NgbCheckBox.ɵfac = function NgbCheckBox_Factory(t) {
    return new (t || NgbCheckBox)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbButtonLabel), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef));
  };

  NgbCheckBox.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbCheckBox,
    selectors: [["", "ngbButton", "", "type", "checkbox"]],
    hostVars: 2,
    hostBindings: function NgbCheckBox_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function NgbCheckBox_change_HostBindingHandler($event) {
          return ctx.onInputChange($event);
        })("focus", function NgbCheckBox_focus_HostBindingHandler() {
          return ctx.focused = true;
        })("blur", function NgbCheckBox_blur_HostBindingHandler() {
          return ctx.focused = false;
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("checked", ctx.checked)("disabled", ctx.disabled);
      }
    },
    inputs: {
      disabled: "disabled",
      valueChecked: "valueChecked",
      valueUnChecked: "valueUnChecked"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALUE_ACCESSOR,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbCheckBox),
      multi: true
    }])]
  });
  return NgbCheckBox;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let nextId$1 = 0;
/**
 * Allows to easily create Bootstrap-style radio buttons.
 *
 * Integrates with forms, so the value of a checked button is bound to the underlying form control
 * either in a reactive or template-driven way.
 */

let NgbRadioGroup = /*#__PURE__*/(() => {
  class NgbRadioGroup {
    constructor() {
      this._radios = new Set();
      this._value = null;
      /**
       * Name of the radio group applied to radio input elements.
       *
       * Will be applied to all radio input elements inside the group,
       * unless [`NgbRadio`](#/components/buttons/api#NgbRadio)'s specify names themselves.
       *
       * If not provided, will be generated in the `ngb-radio-xx` format.
       */

      this.name = `ngb-radio-${nextId$1++}`;

      this.onChange = _ => {};

      this.onTouched = () => {};
    }

    get disabled() {
      return this._disabled;
    }

    set disabled(isDisabled) {
      this.setDisabledState(isDisabled);
    }

    onRadioChange(radio) {
      this.writeValue(radio.value);
      this.onChange(radio.value);
    }

    onRadioValueUpdate() {
      this._updateRadiosValue();
    }

    register(radio) {
      this._radios.add(radio);
    }

    registerOnChange(fn) {
      this.onChange = fn;
    }

    registerOnTouched(fn) {
      this.onTouched = fn;
    }

    setDisabledState(isDisabled) {
      this._disabled = isDisabled;

      this._updateRadiosDisabled();
    }

    unregister(radio) {
      this._radios.delete(radio);
    }

    writeValue(value) {
      this._value = value;

      this._updateRadiosValue();
    }

    _updateRadiosValue() {
      this._radios.forEach(radio => radio.updateValue(this._value));
    }

    _updateRadiosDisabled() {
      this._radios.forEach(radio => radio.updateDisabled());
    }

  }

  NgbRadioGroup.ɵfac = function NgbRadioGroup_Factory(t) {
    return new (t || NgbRadioGroup)();
  };

  NgbRadioGroup.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbRadioGroup,
    selectors: [["", "ngbRadioGroup", ""]],
    hostAttrs: ["role", "radiogroup"],
    inputs: {
      name: "name"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALUE_ACCESSOR,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbRadioGroup),
      multi: true
    }])]
  });
  return NgbRadioGroup;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that marks an input of type "radio" as a part of the
 * [`NgbRadioGroup`](#/components/buttons/api#NgbRadioGroup).
 */


let NgbRadio = /*#__PURE__*/(() => {
  class NgbRadio {
    constructor(_group, _label, _renderer, _element, _cd) {
      this._group = _group;
      this._label = _label;
      this._renderer = _renderer;
      this._element = _element;
      this._cd = _cd;
      this._value = null;

      this._group.register(this);

      this.updateDisabled();
    }
    /**
     * The form control value when current radio button is checked.
     */


    set value(value) {
      this._value = value;
      const stringValue = value ? value.toString() : '';

      this._renderer.setProperty(this._element.nativeElement, 'value', stringValue);

      this._group.onRadioValueUpdate();
    }
    /**
     * If `true`, current radio button will be disabled.
     */


    set disabled(isDisabled) {
      this._disabled = isDisabled !== false;
      this.updateDisabled();
    }

    set focused(isFocused) {
      if (this._label) {
        this._label.focused = isFocused;
      }

      if (!isFocused) {
        this._group.onTouched();
      }
    }

    get checked() {
      return this._checked;
    }

    get disabled() {
      return this._group.disabled || this._disabled;
    }

    get value() {
      return this._value;
    }

    get nameAttr() {
      return this.name || this._group.name;
    }

    ngOnDestroy() {
      this._group.unregister(this);
    }

    onChange() {
      this._group.onRadioChange(this);
    }

    updateValue(value) {
      // label won't be updated, if it is inside the OnPush component when [ngModel] changes
      if (this.value !== value) {
        this._cd.markForCheck();
      }

      this._checked = this.value === value;
      this._label.active = this._checked;
    }

    updateDisabled() {
      this._label.disabled = this.disabled;
    }

  }

  NgbRadio.ɵfac = function NgbRadio_Factory(t) {
    return new (t || NgbRadio)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbRadioGroup), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbButtonLabel), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef));
  };

  NgbRadio.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbRadio,
    selectors: [["", "ngbButton", "", "type", "radio"]],
    hostVars: 3,
    hostBindings: function NgbRadio_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function NgbRadio_change_HostBindingHandler() {
          return ctx.onChange();
        })("focus", function NgbRadio_focus_HostBindingHandler() {
          return ctx.focused = true;
        })("blur", function NgbRadio_blur_HostBindingHandler() {
          return ctx.focused = false;
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("checked", ctx.checked)("disabled", ctx.disabled)("name", ctx.nameAttr);
      }
    },
    inputs: {
      value: "value",
      disabled: "disabled",
      name: "name"
    }
  });
  return NgbRadio;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const NGB_BUTTON_DIRECTIVES = [NgbButtonLabel, NgbCheckBox, NgbRadioGroup, NgbRadio];
let NgbButtonsModule = /*#__PURE__*/(() => {
  class NgbButtonsModule {}

  NgbButtonsModule.ɵfac = function NgbButtonsModule_Factory(t) {
    return new (t || NgbButtonsModule)();
  };

  NgbButtonsModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbButtonsModule
  });
  NgbButtonsModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({});
  return NgbButtonsModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbButtonsModule, {
    declarations: [NgbButtonLabel, NgbCheckBox, NgbRadioGroup, NgbRadio],
    exports: [NgbButtonLabel, NgbCheckBox, NgbRadioGroup, NgbRadio]
  });
})();
/**
 * A configuration service for the [NgbCarousel](#/components/carousel/api#NgbCarousel) component.
 *
 * You can inject this service, typically in your root component, and customize its properties
 * to provide default values for all carousels used in the application.
 */


let NgbCarouselConfig = /*#__PURE__*/(() => {
  class NgbCarouselConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.interval = 5000;
      this.wrap = true;
      this.keyboard = true;
      this.pauseOnHover = true;
      this.pauseOnFocus = true;
      this.showNavigationArrows = true;
      this.showNavigationIndicators = true;
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbCarouselConfig.ɵfac = function NgbCarouselConfig_Factory(t) {
    return new (t || NgbCarouselConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbCarouselConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbCarouselConfig_Factory() {
      return new NgbCarouselConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbCarouselConfig,
    providedIn: "root"
  });
  return NgbCarouselConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Defines the carousel slide transition direction.
 */


var NgbSlideEventDirection = /*#__PURE__*/(() => {
  (function (NgbSlideEventDirection) {
    NgbSlideEventDirection["LEFT"] = "left";
    NgbSlideEventDirection["RIGHT"] = "right";
  })(NgbSlideEventDirection || (NgbSlideEventDirection = {}));

  return NgbSlideEventDirection;
})();

const isBeingAnimated = ({
  classList
}) => {
  return classList.contains('carousel-item-left') || classList.contains('carousel-item-right');
};

const ɵ0$1 = isBeingAnimated;

const removeDirectionClasses = classList => {
  classList.remove('carousel-item-left');
  classList.remove('carousel-item-right');
};

const ɵ1 = removeDirectionClasses;

const removeClasses = classList => {
  removeDirectionClasses(classList);
  classList.remove('carousel-item-prev');
  classList.remove('carousel-item-next');
};

const ɵ2 = removeClasses;

const ngbCarouselTransitionIn = (element, animation, {
  direction
}) => {
  const {
    classList
  } = element;

  if (!animation) {
    removeDirectionClasses(classList);
    removeClasses(classList);
    classList.add('active');
    return;
  }

  if (isBeingAnimated(element)) {
    // Revert the transition
    removeDirectionClasses(classList);
  } else {
    // For the 'in' transition, a 'pre-class' is applied to the element to ensure its visibility
    classList.add('carousel-item-' + (direction === NgbSlideEventDirection.LEFT ? 'next' : 'prev'));
    reflow(element);
    classList.add('carousel-item-' + direction);
  }

  return () => {
    removeClasses(classList);
    classList.add('active');
  };
};

const ngbCarouselTransitionOut = (element, animation, {
  direction
}) => {
  const {
    classList
  } = element;

  if (!animation) {
    removeDirectionClasses(classList);
    removeClasses(classList);
    classList.remove('active');
    return;
  } //  direction is left or right, depending on the way the slide goes out.


  if (isBeingAnimated(element)) {
    // Revert the transition
    removeDirectionClasses(classList);
  } else {
    classList.add('carousel-item-' + direction);
  }

  return () => {
    removeClasses(classList);
    classList.remove('active');
  };
};

let nextId$2 = 0;
/**
 * A directive that wraps the individual carousel slide.
 */

let NgbSlide = /*#__PURE__*/(() => {
  class NgbSlide {
    constructor(tplRef) {
      this.tplRef = tplRef;
      /**
       * Slide id that must be unique for the entire document.
       *
       * If not provided, will be generated in the `ngb-slide-xx` format.
       */

      this.id = `ngb-slide-${nextId$2++}`;
      /**
       * An event emitted when the slide transition is finished
       *
       * @since 8.0.0
       */

      this.slid = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }

  }

  NgbSlide.ɵfac = function NgbSlide_Factory(t) {
    return new (t || NgbSlide)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbSlide.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbSlide,
    selectors: [["ng-template", "ngbSlide", ""]],
    inputs: {
      id: "id"
    },
    outputs: {
      slid: "slid"
    }
  });
  return NgbSlide;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Carousel is a component to easily create and control slideshows.
 *
 * Allows to set intervals, change the way user interacts with the slides and provides a programmatic API.
 */


let NgbCarousel = /*#__PURE__*/(() => {
  class NgbCarousel {
    constructor(config, _platformId, _ngZone, _cd, _container) {
      this._platformId = _platformId;
      this._ngZone = _ngZone;
      this._cd = _cd;
      this._container = _container;
      this.NgbSlideEventSource = NgbSlideEventSource;
      this._destroy$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._interval$ = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(0);
      this._mouseHover$ = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(false);
      this._focused$ = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(false);
      this._pauseOnHover$ = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(false);
      this._pauseOnFocus$ = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(false);
      this._pause$ = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(false);
      this._wrap$ = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(false);
      /**
       * An event emitted just before the slide transition starts.
       *
       * See [`NgbSlideEvent`](#/components/carousel/api#NgbSlideEvent) for payload details.
       */

      this.slide = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted right after the slide transition is completed.
       *
       * See [`NgbSlideEvent`](#/components/carousel/api#NgbSlideEvent) for payload details.
       *
       * @since 8.0.0
       */

      this.slid = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /*
       * Keep the ids of the panels currently transitionning
       * in order to allow only the transition revertion
       */

      this._transitionIds = null;
      this.animation = config.animation;
      this.interval = config.interval;
      this.wrap = config.wrap;
      this.keyboard = config.keyboard;
      this.pauseOnHover = config.pauseOnHover;
      this.pauseOnFocus = config.pauseOnFocus;
      this.showNavigationArrows = config.showNavigationArrows;
      this.showNavigationIndicators = config.showNavigationIndicators;
    }
    /**
     * Time in milliseconds before the next slide is shown.
     */


    set interval(value) {
      this._interval$.next(value);
    }

    get interval() {
      return this._interval$.value;
    }
    /**
     * If `true`, will 'wrap' the carousel by switching from the last slide back to the first.
     */


    set wrap(value) {
      this._wrap$.next(value);
    }

    get wrap() {
      return this._wrap$.value;
    }
    /**
     * If `true`, will pause slide switching when mouse cursor hovers the slide.
     *
     * @since 2.2.0
     */


    set pauseOnHover(value) {
      this._pauseOnHover$.next(value);
    }

    get pauseOnHover() {
      return this._pauseOnHover$.value;
    }
    /**
     * If `true`, will pause slide switching when the focus is inside the carousel.
     */


    set pauseOnFocus(value) {
      this._pauseOnFocus$.next(value);
    }

    get pauseOnFocus() {
      return this._pauseOnFocus$.value;
    }

    set mouseHover(value) {
      this._mouseHover$.next(value);
    }

    get mouseHover() {
      return this._mouseHover$.value;
    }

    set focused(value) {
      this._focused$.next(value);
    }

    get focused() {
      return this._focused$.value;
    }

    arrowLeft() {
      this.focus();
      this.prev(NgbSlideEventSource.ARROW_LEFT);
    }

    arrowRight() {
      this.focus();
      this.next(NgbSlideEventSource.ARROW_RIGHT);
    }

    ngAfterContentInit() {
      // setInterval() doesn't play well with SSR and protractor,
      // so we should run it in the browser and outside Angular
      if ((0,_angular_common__WEBPACK_IMPORTED_MODULE_12__.isPlatformBrowser)(this._platformId)) {
        this._ngZone.runOutsideAngular(() => {
          const hasNextSlide$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.combineLatest)([this.slide.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(slideEvent => slideEvent.current), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.startWith)(this.activeId)), this._wrap$, this.slides.changes.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.startWith)(null))]).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(([currentSlideId, wrap]) => {
            const slideArr = this.slides.toArray();

            const currentSlideIdx = this._getSlideIdxById(currentSlideId);

            return wrap ? slideArr.length > 1 : currentSlideIdx < slideArr.length - 1;
          }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_18__.distinctUntilChanged)());
          (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.combineLatest)([this._pause$, this._pauseOnHover$, this._mouseHover$, this._pauseOnFocus$, this._focused$, this._interval$, hasNextSlide$]).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(([pause, pauseOnHover, mouseHover, pauseOnFocus, focused, interval, hasNextSlide]) => pause || pauseOnHover && mouseHover || pauseOnFocus && focused || !hasNextSlide ? 0 : interval), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_18__.distinctUntilChanged)(), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_19__.switchMap)(interval => interval > 0 ? (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.timer)(interval, interval) : rxjs__WEBPACK_IMPORTED_MODULE_20__.NEVER), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._destroy$)).subscribe(() => this._ngZone.run(() => this.next(NgbSlideEventSource.TIMER)));
        });
      }

      this.slides.changes.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._destroy$)).subscribe(() => {
        var _a;

        (_a = this._transitionIds) === null || _a === void 0 ? void 0 : _a.forEach(id => ngbCompleteTransition(this._getSlideElement(id)));
        this._transitionIds = null;

        this._cd.markForCheck(); // The following code need to be done asynchronously, after the dom becomes stable,
        // otherwise all changes will be undone.


        this._ngZone.onStable.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => {
          for (const {
            id
          } of this.slides) {
            const element = this._getSlideElement(id);

            if (id === this.activeId) {
              element.classList.add('active');
            } else {
              element.classList.remove('active');
            }
          }
        });
      });
    }

    ngAfterContentChecked() {
      let activeSlide = this._getSlideById(this.activeId);

      this.activeId = activeSlide ? activeSlide.id : this.slides.length ? this.slides.first.id : '';
    }

    ngAfterViewInit() {
      // Initialize the 'active' class (not managed by the template)
      if (this.activeId) {
        const element = this._getSlideElement(this.activeId);

        if (element) {
          element.classList.add('active');
        }
      }
    }

    ngOnDestroy() {
      this._destroy$.next();
    }
    /**
     * Navigates to a slide with the specified identifier.
     */


    select(slideId, source) {
      this._cycleToSelected(slideId, this._getSlideEventDirection(this.activeId, slideId), source);
    }
    /**
     * Navigates to the previous slide.
     */


    prev(source) {
      this._cycleToSelected(this._getPrevSlide(this.activeId), NgbSlideEventDirection.RIGHT, source);
    }
    /**
     * Navigates to the next slide.
     */


    next(source) {
      this._cycleToSelected(this._getNextSlide(this.activeId), NgbSlideEventDirection.LEFT, source);
    }
    /**
     * Pauses cycling through the slides.
     */


    pause() {
      this._pause$.next(true);
    }
    /**
     * Restarts cycling through the slides from left to right.
     */


    cycle() {
      this._pause$.next(false);
    }
    /**
     * Set the focus on the carousel.
     */


    focus() {
      this._container.nativeElement.focus();
    }

    _cycleToSelected(slideIdx, direction, source) {
      const transitionIds = this._transitionIds;

      if (transitionIds && (transitionIds[0] !== slideIdx || transitionIds[1] !== this.activeId)) {
        // Revert prevented
        return;
      }

      let selectedSlide = this._getSlideById(slideIdx);

      if (selectedSlide && selectedSlide.id !== this.activeId) {
        this._transitionIds = [this.activeId, slideIdx];
        this.slide.emit({
          prev: this.activeId,
          current: selectedSlide.id,
          direction: direction,
          paused: this._pause$.value,
          source
        });
        const options = {
          animation: this.animation,
          runningTransition: 'stop',
          context: {
            direction
          }
        };
        const transitions = [];

        const activeSlide = this._getSlideById(this.activeId);

        if (activeSlide) {
          const activeSlideTransition = ngbRunTransition(this._ngZone, this._getSlideElement(activeSlide.id), ngbCarouselTransitionOut, options);
          activeSlideTransition.subscribe(() => {
            activeSlide.slid.emit({
              isShown: false,
              direction,
              source
            });
          });
          transitions.push(activeSlideTransition);
        }

        const previousId = this.activeId;
        this.activeId = selectedSlide.id;

        const nextSlide = this._getSlideById(this.activeId);

        const transition = ngbRunTransition(this._ngZone, this._getSlideElement(selectedSlide.id), ngbCarouselTransitionIn, options);
        transition.subscribe(() => {
          nextSlide === null || nextSlide === void 0 ? void 0 : nextSlide.slid.emit({
            isShown: true,
            direction,
            source
          });
        });
        transitions.push(transition);
        (0,rxjs__WEBPACK_IMPORTED_MODULE_21__.zip)(...transitions).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => {
          this._transitionIds = null;
          this.slid.emit({
            prev: previousId,
            current: selectedSlide.id,
            direction: direction,
            paused: this._pause$.value,
            source
          });
        });
      } // we get here after the interval fires or any external API call like next(), prev() or select()


      this._cd.markForCheck();
    }

    _getSlideEventDirection(currentActiveSlideId, nextActiveSlideId) {
      const currentActiveSlideIdx = this._getSlideIdxById(currentActiveSlideId);

      const nextActiveSlideIdx = this._getSlideIdxById(nextActiveSlideId);

      return currentActiveSlideIdx > nextActiveSlideIdx ? NgbSlideEventDirection.RIGHT : NgbSlideEventDirection.LEFT;
    }

    _getSlideById(slideId) {
      return this.slides.find(slide => slide.id === slideId) || null;
    }

    _getSlideIdxById(slideId) {
      const slide = this._getSlideById(slideId);

      return slide != null ? this.slides.toArray().indexOf(slide) : -1;
    }

    _getNextSlide(currentSlideId) {
      const slideArr = this.slides.toArray();

      const currentSlideIdx = this._getSlideIdxById(currentSlideId);

      const isLastSlide = currentSlideIdx === slideArr.length - 1;
      return isLastSlide ? this.wrap ? slideArr[0].id : slideArr[slideArr.length - 1].id : slideArr[currentSlideIdx + 1].id;
    }

    _getPrevSlide(currentSlideId) {
      const slideArr = this.slides.toArray();

      const currentSlideIdx = this._getSlideIdxById(currentSlideId);

      const isFirstSlide = currentSlideIdx === 0;
      return isFirstSlide ? this.wrap ? slideArr[slideArr.length - 1].id : slideArr[0].id : slideArr[currentSlideIdx - 1].id;
    }

    _getSlideElement(slideId) {
      return this._container.nativeElement.querySelector(`#slide-${slideId}`);
    }

  }

  NgbCarousel.ɵfac = function NgbCarousel_Factory(t) {
    return new (t || NgbCarousel)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbCarouselConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.PLATFORM_ID), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbCarousel.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbCarousel,
    selectors: [["ngb-carousel"]],
    contentQueries: function NgbCarousel_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbSlide, 4);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.slides = _t);
      }
    },
    hostAttrs: ["tabIndex", "0", 1, "carousel", "slide"],
    hostVars: 3,
    hostBindings: function NgbCarousel_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("keydown.arrowLeft", function NgbCarousel_keydown_arrowLeft_HostBindingHandler() {
          return ctx.keyboard && ctx.arrowLeft();
        })("keydown.arrowRight", function NgbCarousel_keydown_arrowRight_HostBindingHandler() {
          return ctx.keyboard && ctx.arrowRight();
        })("mouseenter", function NgbCarousel_mouseenter_HostBindingHandler() {
          return ctx.mouseHover = true;
        })("mouseleave", function NgbCarousel_mouseleave_HostBindingHandler() {
          return ctx.mouseHover = false;
        })("focusin", function NgbCarousel_focusin_HostBindingHandler() {
          return ctx.focused = true;
        })("focusout", function NgbCarousel_focusout_HostBindingHandler() {
          return ctx.focused = false;
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-activedescendant", ctx.activeId);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("display", "block");
      }
    },
    inputs: {
      animation: "animation",
      interval: "interval",
      wrap: "wrap",
      keyboard: "keyboard",
      pauseOnHover: "pauseOnHover",
      pauseOnFocus: "pauseOnFocus",
      showNavigationArrows: "showNavigationArrows",
      showNavigationIndicators: "showNavigationIndicators",
      activeId: "activeId"
    },
    outputs: {
      slide: "slide",
      slid: "slid"
    },
    exportAs: ["ngbCarousel"],
    decls: 6,
    vars: 6,
    consts: function () {
      let i18n_4;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @desc Currently selected slide number read by screen reader
         */
        const MSG_EXTERNAL_ngb_carousel_slide_number$$FESM2015_NG_BOOTSTRAP_JS__5 = goog.getMsg(" Slide {$interpolation} of {$interpolation_1} ", {
          "interpolation": "\uFFFD0\uFFFD",
          "interpolation_1": "\uFFFD1\uFFFD"
        }, {
          original_code: {
            "interpolation": "{{i + 1}}",
            "interpolation_1": "{{c}}"
          }
        });
        i18n_4 = MSG_EXTERNAL_ngb_carousel_slide_number$$FESM2015_NG_BOOTSTRAP_JS__5;
      } else {
        i18n_4 = $localize`:Currently selected slide number read by screen reader@@ngb.carousel.slide-number␟a65b1b49aa7dd8c4f3004da6a8c2241814dae621␟783273603869937627: Slide ${"\uFFFD0\uFFFD"}:INTERPOLATION: of ${"\uFFFD1\uFFFD"}:INTERPOLATION_1: `;
      }

      let i18n_6;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_carousel_previous$$FESM2015_NG_BOOTSTRAP_JS__7 = goog.getMsg("Previous");
        i18n_6 = MSG_EXTERNAL_ngb_carousel_previous$$FESM2015_NG_BOOTSTRAP_JS__7;
      } else {
        i18n_6 = $localize`:@@ngb.carousel.previous␟680d5c75b7fd8d37961083608b9fcdc4167b4c43␟4452427314943113135:Previous`;
      }

      let i18n_8;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_carousel_next$$FESM2015_NG_BOOTSTRAP_JS__9 = goog.getMsg("Next");
        i18n_8 = MSG_EXTERNAL_ngb_carousel_next$$FESM2015_NG_BOOTSTRAP_JS__9;
      } else {
        i18n_8 = $localize`:@@ngb.carousel.next␟f732c304c7433e5a83ffcd862c3dce709a0f4982␟3885497195825665706:Next`;
      }

      return [["role", "tablist", 1, "carousel-indicators"], ["role", "tab", 3, "active", "click", 4, "ngFor", "ngForOf"], [1, "carousel-inner"], ["class", "carousel-item", "role", "tabpanel", 3, "id", 4, "ngFor", "ngForOf"], ["class", "carousel-control-prev", "role", "button", 3, "click", 4, "ngIf"], ["class", "carousel-control-next", "role", "button", 3, "click", 4, "ngIf"], ["role", "tab", 3, "click"], ["role", "tabpanel", 1, "carousel-item", 3, "id"], [1, "sr-only"], i18n_4, [3, "ngTemplateOutlet"], ["role", "button", 1, "carousel-control-prev", 3, "click"], ["aria-hidden", "true", 1, "carousel-control-prev-icon"], i18n_6, ["role", "button", 1, "carousel-control-next", 3, "click"], ["aria-hidden", "true", 1, "carousel-control-next-icon"], i18n_8];
    },
    template: function NgbCarousel_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "ol", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbCarousel_li_1_Template, 1, 5, "li", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbCarousel_div_3_Template, 4, 4, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, NgbCarousel_a_4_Template, 4, 0, "a", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, NgbCarousel_a_5_Template, 4, 0, "a", 5);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("sr-only", !ctx.showNavigationIndicators);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.slides);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.slides);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showNavigationArrows);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showNavigationArrows);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbCarousel;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

var NgbSlideEventSource = /*#__PURE__*/(() => {
  (function (NgbSlideEventSource) {
    NgbSlideEventSource["TIMER"] = "timer";
    NgbSlideEventSource["ARROW_LEFT"] = "arrowLeft";
    NgbSlideEventSource["ARROW_RIGHT"] = "arrowRight";
    NgbSlideEventSource["INDICATOR"] = "indicator";
  })(NgbSlideEventSource || (NgbSlideEventSource = {}));

  return NgbSlideEventSource;
})();
const NGB_CAROUSEL_DIRECTIVES = [NgbCarousel, NgbSlide];
let NgbCarouselModule = /*#__PURE__*/(() => {
  class NgbCarouselModule {}

  NgbCarouselModule.ɵfac = function NgbCarouselModule_Factory(t) {
    return new (t || NgbCarouselModule)();
  };

  NgbCarouselModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbCarouselModule
  });
  NgbCarouselModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbCarouselModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbCarouselModule, {
    declarations: function () {
      return [NgbCarousel, NgbSlide];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbCarousel, NgbSlide];
    }
  });
})();
/**
 * A configuration service for the [NgbCollapse](#/components/collapse/api#NgbCollapse) component.
 *
 * You can inject this service, typically in your root component, and customize its properties
 * to provide default values for all collapses used in the application.
 */


let NgbCollapseConfig = /*#__PURE__*/(() => {
  class NgbCollapseConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbCollapseConfig.ɵfac = function NgbCollapseConfig_Factory(t) {
    return new (t || NgbCollapseConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbCollapseConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbCollapseConfig_Factory() {
      return new NgbCollapseConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbCollapseConfig,
    providedIn: "root"
  });
  return NgbCollapseConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to provide a simple way of hiding and showing elements on the page.
 */


let NgbCollapse = /*#__PURE__*/(() => {
  class NgbCollapse {
    constructor(_element, config, _zone) {
      this._element = _element;
      this._zone = _zone;
      /**
       * If `true`, will collapse the element or show it otherwise.
       */

      this.collapsed = false;
      this.ngbCollapseChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the collapse element is shown, after the transition. It has no payload.
       *
       * @since 8.0.0
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the collapse element is hidden, after the transition. It has no payload.
       *
       * @since 8.0.0
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.animation = config.animation;
    }

    ngOnInit() {
      this._runTransition(this.collapsed, false);
    }

    ngOnChanges({
      collapsed
    }) {
      if (!collapsed.firstChange) {
        this._runTransitionWithEvents(this.collapsed, this.animation);
      }
    }
    /**
     * Triggers collapsing programmatically.
     *
     * If there is a collapsing transition running already, it will be reversed.
     * If the animations are turned off this happens synchronously.
     *
     * @since 8.0.0
     */


    toggle(open = this.collapsed) {
      this.collapsed = !open;
      this.ngbCollapseChange.next(this.collapsed);

      this._runTransitionWithEvents(this.collapsed, this.animation);
    }

    _runTransition(collapsed, animation) {
      return ngbRunTransition(this._zone, this._element.nativeElement, ngbCollapsingTransition, {
        animation,
        runningTransition: 'stop',
        context: {
          direction: collapsed ? 'hide' : 'show'
        }
      });
    }

    _runTransitionWithEvents(collapsed, animation) {
      this._runTransition(collapsed, animation).subscribe(() => {
        if (collapsed) {
          this.hidden.emit();
        } else {
          this.shown.emit();
        }
      });
    }

  }

  NgbCollapse.ɵfac = function NgbCollapse_Factory(t) {
    return new (t || NgbCollapse)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbCollapseConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  NgbCollapse.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbCollapse,
    selectors: [["", "ngbCollapse", ""]],
    inputs: {
      collapsed: ["ngbCollapse", "collapsed"],
      animation: "animation"
    },
    outputs: {
      ngbCollapseChange: "ngbCollapseChange",
      shown: "shown",
      hidden: "hidden"
    },
    exportAs: ["ngbCollapse"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });
  return NgbCollapse;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbCollapseModule = /*#__PURE__*/(() => {
  class NgbCollapseModule {}

  NgbCollapseModule.ɵfac = function NgbCollapseModule_Factory(t) {
    return new (t || NgbCollapseModule)();
  };

  NgbCollapseModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbCollapseModule
  });
  NgbCollapseModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({});
  return NgbCollapseModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbCollapseModule, {
    declarations: [NgbCollapse],
    exports: [NgbCollapse]
  });
})();
/**
 * A simple class that represents a date that datepicker also uses internally.
 *
 * It is the implementation of the `NgbDateStruct` interface that adds some convenience methods,
 * like `.equals()`, `.before()`, etc.
 *
 * All datepicker APIs consume `NgbDateStruct`, but return `NgbDate`.
 *
 * In many cases it is simpler to manipulate these objects together with
 * [`NgbCalendar`](#/components/datepicker/api#NgbCalendar) than native JS Dates.
 *
 * See the [date format overview](#/components/datepicker/overview#date-model) for more details.
 *
 * @since 3.0.0
 */


class NgbDate {
  constructor(year, month, day) {
    this.year = isInteger(year) ? year : null;
    this.month = isInteger(month) ? month : null;
    this.day = isInteger(day) ? day : null;
  }
  /**
   * A **static method** that creates a new date object from the `NgbDateStruct`,
   *
   * ex. `NgbDate.from({year: 2000, month: 5, day: 1})`.
   *
   * If the `date` is already of `NgbDate` type, the method will return the same object.
   */


  static from(date) {
    if (date instanceof NgbDate) {
      return date;
    }

    return date ? new NgbDate(date.year, date.month, date.day) : null;
  }
  /**
   * Checks if the current date is equal to another date.
   */


  equals(other) {
    return other != null && this.year === other.year && this.month === other.month && this.day === other.day;
  }
  /**
   * Checks if the current date is before another date.
   */


  before(other) {
    if (!other) {
      return false;
    }

    if (this.year === other.year) {
      if (this.month === other.month) {
        return this.day === other.day ? false : this.day < other.day;
      } else {
        return this.month < other.month;
      }
    } else {
      return this.year < other.year;
    }
  }
  /**
   * Checks if the current date is after another date.
   */


  after(other) {
    if (!other) {
      return false;
    }

    if (this.year === other.year) {
      if (this.month === other.month) {
        return this.day === other.day ? false : this.day > other.day;
      } else {
        return this.month > other.month;
      }
    } else {
      return this.year > other.year;
    }
  }

}

function fromJSDate(jsDate) {
  return new NgbDate(jsDate.getFullYear(), jsDate.getMonth() + 1, jsDate.getDate());
}

function toJSDate(date) {
  const jsDate = new Date(date.year, date.month - 1, date.day, 12); // this is done avoid 30 -> 1930 conversion

  if (!isNaN(jsDate.getTime())) {
    jsDate.setFullYear(date.year);
  }

  return jsDate;
}

function NGB_DATEPICKER_CALENDAR_FACTORY() {
  return new NgbCalendarGregorian();
}
/**
 * A service that represents the calendar used by the datepicker.
 *
 * The default implementation uses the Gregorian calendar. You can inject it in your own
 * implementations if necessary to simplify `NgbDate` calculations.
 */


let NgbCalendar = /*#__PURE__*/(() => {
  class NgbCalendar {}

  NgbCalendar.ɵfac = function NgbCalendar_Factory(t) {
    return new (t || NgbCalendar)();
  };

  NgbCalendar.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: NGB_DATEPICKER_CALENDAR_FACTORY,
    token: NgbCalendar,
    providedIn: "root"
  });
  return NgbCalendar;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbCalendarGregorian = /*#__PURE__*/(() => {
  class NgbCalendarGregorian extends NgbCalendar {
    getDaysPerWeek() {
      return 7;
    }

    getMonths() {
      return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
    }

    getWeeksPerMonth() {
      return 6;
    }

    getNext(date, period = 'd', number = 1) {
      let jsDate = toJSDate(date);
      let checkMonth = true;
      let expectedMonth = jsDate.getMonth();

      switch (period) {
        case 'y':
          jsDate.setFullYear(jsDate.getFullYear() + number);
          break;

        case 'm':
          expectedMonth += number;
          jsDate.setMonth(expectedMonth);
          expectedMonth = expectedMonth % 12;

          if (expectedMonth < 0) {
            expectedMonth = expectedMonth + 12;
          }

          break;

        case 'd':
          jsDate.setDate(jsDate.getDate() + number);
          checkMonth = false;
          break;

        default:
          return date;
      }

      if (checkMonth && jsDate.getMonth() !== expectedMonth) {
        // this means the destination month has less days than the initial month
        // let's go back to the end of the previous month:
        jsDate.setDate(0);
      }

      return fromJSDate(jsDate);
    }

    getPrev(date, period = 'd', number = 1) {
      return this.getNext(date, period, -number);
    }

    getWeekday(date) {
      let jsDate = toJSDate(date);
      let day = jsDate.getDay(); // in JS Date Sun=0, in ISO 8601 Sun=7

      return day === 0 ? 7 : day;
    }

    getWeekNumber(week, firstDayOfWeek) {
      // in JS Date Sun=0, in ISO 8601 Sun=7
      if (firstDayOfWeek === 7) {
        firstDayOfWeek = 0;
      }

      const thursdayIndex = (4 + 7 - firstDayOfWeek) % 7;
      let date = week[thursdayIndex];
      const jsDate = toJSDate(date);
      jsDate.setDate(jsDate.getDate() + 4 - (jsDate.getDay() || 7)); // Thursday

      const time = jsDate.getTime();
      jsDate.setMonth(0); // Compare with Jan 1

      jsDate.setDate(1);
      return Math.floor(Math.round((time - jsDate.getTime()) / 86400000) / 7) + 1;
    }

    getToday() {
      return fromJSDate(new Date());
    }

    isValid(date) {
      if (!date || !isInteger(date.year) || !isInteger(date.month) || !isInteger(date.day)) {
        return false;
      } // year 0 doesn't exist in Gregorian calendar


      if (date.year === 0) {
        return false;
      }

      const jsDate = toJSDate(date);
      return !isNaN(jsDate.getTime()) && jsDate.getFullYear() === date.year && jsDate.getMonth() + 1 === date.month && jsDate.getDate() === date.day;
    }

  }

  NgbCalendarGregorian.ɵfac = /*@__PURE__*/function () {
    let ɵNgbCalendarGregorian_BaseFactory;
    return function NgbCalendarGregorian_Factory(t) {
      return (ɵNgbCalendarGregorian_BaseFactory || (ɵNgbCalendarGregorian_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbCalendarGregorian)))(t || NgbCalendarGregorian);
    };
  }();

  NgbCalendarGregorian.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbCalendarGregorian,
    factory: NgbCalendarGregorian.ɵfac
  });
  return NgbCalendarGregorian;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

function isChangedDate(prev, next) {
  return !dateComparator(prev, next);
}

function isChangedMonth(prev, next) {
  return !prev && !next ? false : !prev || !next ? true : prev.year !== next.year || prev.month !== next.month;
}

function dateComparator(prev, next) {
  return !prev && !next || !!prev && !!next && prev.equals(next);
}

function checkMinBeforeMax(minDate, maxDate) {
  if (maxDate && minDate && maxDate.before(minDate)) {
    throw new Error(`'maxDate' ${maxDate} should be greater than 'minDate' ${minDate}`);
  }
}

function checkDateInRange(date, minDate, maxDate) {
  if (date && minDate && date.before(minDate)) {
    return minDate;
  }

  if (date && maxDate && date.after(maxDate)) {
    return maxDate;
  }

  return date || null;
}

function isDateSelectable(date, state) {
  const {
    minDate,
    maxDate,
    disabled,
    markDisabled
  } = state; // clang-format off

  return !(date === null || date === undefined || disabled || markDisabled && markDisabled(date, {
    year: date.year,
    month: date.month
  }) || minDate && date.before(minDate) || maxDate && date.after(maxDate)); // clang-format on
}

function generateSelectBoxMonths(calendar, date, minDate, maxDate) {
  if (!date) {
    return [];
  }

  let months = calendar.getMonths(date.year);

  if (minDate && date.year === minDate.year) {
    const index = months.findIndex(month => month === minDate.month);
    months = months.slice(index);
  }

  if (maxDate && date.year === maxDate.year) {
    const index = months.findIndex(month => month === maxDate.month);
    months = months.slice(0, index + 1);
  }

  return months;
}

function generateSelectBoxYears(date, minDate, maxDate) {
  if (!date) {
    return [];
  }

  const start = minDate ? Math.max(minDate.year, date.year - 500) : date.year - 10;
  const end = maxDate ? Math.min(maxDate.year, date.year + 500) : date.year + 10;
  const length = end - start + 1;
  const numbers = Array(length);

  for (let i = 0; i < length; i++) {
    numbers[i] = start + i;
  }

  return numbers;
}

function nextMonthDisabled(calendar, date, maxDate) {
  const nextDate = Object.assign(calendar.getNext(date, 'm'), {
    day: 1
  });
  return maxDate != null && nextDate.after(maxDate);
}

function prevMonthDisabled(calendar, date, minDate) {
  const prevDate = Object.assign(calendar.getPrev(date, 'm'), {
    day: 1
  });
  return minDate != null && (prevDate.year === minDate.year && prevDate.month < minDate.month || prevDate.year < minDate.year && minDate.month === 1);
}

function buildMonths(calendar, date, state, i18n, force) {
  const {
    displayMonths,
    months
  } = state; // move old months to a temporary array

  const monthsToReuse = months.splice(0, months.length); // generate new first dates, nullify or reuse months

  const firstDates = Array.from({
    length: displayMonths
  }, (_, i) => {
    const firstDate = Object.assign(calendar.getNext(date, 'm', i), {
      day: 1
    });
    months[i] = null;

    if (!force) {
      const reusedIndex = monthsToReuse.findIndex(month => month.firstDate.equals(firstDate)); // move reused month back to months

      if (reusedIndex !== -1) {
        months[i] = monthsToReuse.splice(reusedIndex, 1)[0];
      }
    }

    return firstDate;
  }); // rebuild nullified months

  firstDates.forEach((firstDate, i) => {
    if (months[i] === null) {
      months[i] = buildMonth(calendar, firstDate, state, i18n, monthsToReuse.shift() || {});
    }
  });
  return months;
}

function buildMonth(calendar, date, state, i18n, month = {}) {
  const {
    dayTemplateData,
    minDate,
    maxDate,
    firstDayOfWeek,
    markDisabled,
    outsideDays
  } = state;
  const calendarToday = calendar.getToday();
  month.firstDate = null;
  month.lastDate = null;
  month.number = date.month;
  month.year = date.year;
  month.weeks = month.weeks || [];
  month.weekdays = month.weekdays || [];
  date = getFirstViewDate(calendar, date, firstDayOfWeek); // month has weeks

  for (let week = 0; week < calendar.getWeeksPerMonth(); week++) {
    let weekObject = month.weeks[week];

    if (!weekObject) {
      weekObject = month.weeks[week] = {
        number: 0,
        days: [],
        collapsed: true
      };
    }

    const days = weekObject.days; // week has days

    for (let day = 0; day < calendar.getDaysPerWeek(); day++) {
      if (week === 0) {
        month.weekdays[day] = calendar.getWeekday(date);
      }

      const newDate = new NgbDate(date.year, date.month, date.day);
      const nextDate = calendar.getNext(newDate);
      const ariaLabel = i18n.getDayAriaLabel(newDate); // marking date as disabled

      let disabled = !!(minDate && newDate.before(minDate) || maxDate && newDate.after(maxDate));

      if (!disabled && markDisabled) {
        disabled = markDisabled(newDate, {
          month: month.number,
          year: month.year
        });
      } // today


      let today = newDate.equals(calendarToday); // adding user-provided data to the context

      let contextUserData = dayTemplateData ? dayTemplateData(newDate, {
        month: month.number,
        year: month.year
      }) : undefined; // saving first date of the month

      if (month.firstDate === null && newDate.month === month.number) {
        month.firstDate = newDate;
      } // saving last date of the month


      if (newDate.month === month.number && nextDate.month !== month.number) {
        month.lastDate = newDate;
      }

      let dayObject = days[day];

      if (!dayObject) {
        dayObject = days[day] = {};
      }

      dayObject.date = newDate;
      dayObject.context = Object.assign(dayObject.context || {}, {
        $implicit: newDate,
        date: newDate,
        data: contextUserData,
        currentMonth: month.number,
        currentYear: month.year,
        disabled,
        focused: false,
        selected: false,
        today
      });
      dayObject.tabindex = -1;
      dayObject.ariaLabel = ariaLabel;
      dayObject.hidden = false;
      date = nextDate;
    }

    weekObject.number = calendar.getWeekNumber(days.map(day => day.date), firstDayOfWeek); // marking week as collapsed

    weekObject.collapsed = outsideDays === 'collapsed' && days[0].date.month !== month.number && days[days.length - 1].date.month !== month.number;
  }

  return month;
}

function getFirstViewDate(calendar, date, firstDayOfWeek) {
  const daysPerWeek = calendar.getDaysPerWeek();
  const firstMonthDate = new NgbDate(date.year, date.month, 1);
  const dayOfWeek = calendar.getWeekday(firstMonthDate) % daysPerWeek;
  return calendar.getPrev(firstMonthDate, 'd', (daysPerWeek + dayOfWeek - firstDayOfWeek) % daysPerWeek);
}

function NGB_DATEPICKER_18N_FACTORY(locale) {
  return new NgbDatepickerI18nDefault(locale);
}
/**
 * A service supplying i18n data to the datepicker component.
 *
 * The default implementation of this service uses the Angular locale and registered locale data for
 * weekdays and month names (as explained in the Angular i18n guide).
 *
 * It also provides a way to i18n data that depends on calendar calculations, like aria labels, day, week and year
 * numerals. For other static labels the datepicker uses the default Angular i18n.
 *
 * See the [i18n demo](#/components/datepicker/examples#i18n) and
 * [Hebrew calendar demo](#/components/datepicker/calendars#hebrew) on how to extend this class and define
 * a custom provider for i18n.
 */


let NgbDatepickerI18n = /*#__PURE__*/(() => {
  class NgbDatepickerI18n {
    /**
     * Returns the textual representation of a day that is rendered in a day cell.
     *
     * @since 3.0.0
     */
    getDayNumerals(date) {
      return `${date.day}`;
    }
    /**
     * Returns the textual representation of a week number rendered by datepicker.
     *
     * @since 3.0.0
     */


    getWeekNumerals(weekNumber) {
      return `${weekNumber}`;
    }
    /**
     * Returns the textual representation of a year that is rendered in the datepicker year select box.
     *
     * @since 3.0.0
     */


    getYearNumerals(year) {
      return `${year}`;
    }

  }

  NgbDatepickerI18n.ɵfac = function NgbDatepickerI18n_Factory(t) {
    return new (t || NgbDatepickerI18n)();
  };

  NgbDatepickerI18n.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbDatepickerI18n_Factory() {
      return NGB_DATEPICKER_18N_FACTORY((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.LOCALE_ID));
    },
    token: NgbDatepickerI18n,
    providedIn: "root"
  });
  return NgbDatepickerI18n;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDatepickerI18nDefault = /*#__PURE__*/(() => {
  class NgbDatepickerI18nDefault extends NgbDatepickerI18n {
    constructor(_locale) {
      super();
      this._locale = _locale;
      const weekdaysStartingOnSunday = (0,_angular_common__WEBPACK_IMPORTED_MODULE_12__.getLocaleDayNames)(_locale, _angular_common__WEBPACK_IMPORTED_MODULE_12__.FormStyle.Standalone, _angular_common__WEBPACK_IMPORTED_MODULE_12__.TranslationWidth.Short);
      this._weekdaysShort = weekdaysStartingOnSunday.map((day, index) => weekdaysStartingOnSunday[(index + 1) % 7]);
      this._monthsShort = (0,_angular_common__WEBPACK_IMPORTED_MODULE_12__.getLocaleMonthNames)(_locale, _angular_common__WEBPACK_IMPORTED_MODULE_12__.FormStyle.Standalone, _angular_common__WEBPACK_IMPORTED_MODULE_12__.TranslationWidth.Abbreviated);
      this._monthsFull = (0,_angular_common__WEBPACK_IMPORTED_MODULE_12__.getLocaleMonthNames)(_locale, _angular_common__WEBPACK_IMPORTED_MODULE_12__.FormStyle.Standalone, _angular_common__WEBPACK_IMPORTED_MODULE_12__.TranslationWidth.Wide);
    }

    getWeekdayShortName(weekday) {
      return this._weekdaysShort[weekday - 1] || '';
    }

    getMonthShortName(month) {
      return this._monthsShort[month - 1] || '';
    }

    getMonthFullName(month) {
      return this._monthsFull[month - 1] || '';
    }

    getDayAriaLabel(date) {
      const jsDate = new Date(date.year, date.month - 1, date.day);
      return (0,_angular_common__WEBPACK_IMPORTED_MODULE_12__.formatDate)(jsDate, 'fullDate', this._locale);
    }

  }

  NgbDatepickerI18nDefault.ɵfac = function NgbDatepickerI18nDefault_Factory(t) {
    return new (t || NgbDatepickerI18nDefault)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.LOCALE_ID));
  };

  NgbDatepickerI18nDefault.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbDatepickerI18nDefault,
    factory: NgbDatepickerI18nDefault.ɵfac
  });
  return NgbDatepickerI18nDefault;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDatepickerService = /*#__PURE__*/(() => {
  class NgbDatepickerService {
    constructor(_calendar, _i18n) {
      this._calendar = _calendar;
      this._i18n = _i18n;
      this._VALIDATORS = {
        dayTemplateData: dayTemplateData => {
          if (this._state.dayTemplateData !== dayTemplateData) {
            return {
              dayTemplateData
            };
          }
        },
        displayMonths: displayMonths => {
          displayMonths = toInteger(displayMonths);

          if (isInteger(displayMonths) && displayMonths > 0 && this._state.displayMonths !== displayMonths) {
            return {
              displayMonths
            };
          }
        },
        disabled: disabled => {
          if (this._state.disabled !== disabled) {
            return {
              disabled
            };
          }
        },
        firstDayOfWeek: firstDayOfWeek => {
          firstDayOfWeek = toInteger(firstDayOfWeek);

          if (isInteger(firstDayOfWeek) && firstDayOfWeek >= 0 && this._state.firstDayOfWeek !== firstDayOfWeek) {
            return {
              firstDayOfWeek
            };
          }
        },
        focusVisible: focusVisible => {
          if (this._state.focusVisible !== focusVisible && !this._state.disabled) {
            return {
              focusVisible
            };
          }
        },
        markDisabled: markDisabled => {
          if (this._state.markDisabled !== markDisabled) {
            return {
              markDisabled
            };
          }
        },
        maxDate: date => {
          const maxDate = this.toValidDate(date, null);

          if (isChangedDate(this._state.maxDate, maxDate)) {
            return {
              maxDate
            };
          }
        },
        minDate: date => {
          const minDate = this.toValidDate(date, null);

          if (isChangedDate(this._state.minDate, minDate)) {
            return {
              minDate
            };
          }
        },
        navigation: navigation => {
          if (this._state.navigation !== navigation) {
            return {
              navigation
            };
          }
        },
        outsideDays: outsideDays => {
          if (this._state.outsideDays !== outsideDays) {
            return {
              outsideDays
            };
          }
        }
      };
      this._model$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._dateSelect$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._state = {
        dayTemplateData: null,
        markDisabled: null,
        maxDate: null,
        minDate: null,
        disabled: false,
        displayMonths: 1,
        firstDate: null,
        firstDayOfWeek: 1,
        lastDate: null,
        focusDate: null,
        focusVisible: false,
        months: [],
        navigation: 'select',
        outsideDays: 'visible',
        prevDisabled: false,
        nextDisabled: false,
        selectedDate: null,
        selectBoxes: {
          years: [],
          months: []
        }
      };
    }

    get model$() {
      return this._model$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(model => model.months.length > 0));
    }

    get dateSelect$() {
      return this._dateSelect$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(date => date !== null));
    }

    set(options) {
      let patch = Object.keys(options).map(key => this._VALIDATORS[key](options[key])).reduce((obj, part) => Object.assign(Object.assign({}, obj), part), {});

      if (Object.keys(patch).length > 0) {
        this._nextState(patch);
      }
    }

    focus(date) {
      const focusedDate = this.toValidDate(date, null);

      if (focusedDate != null && !this._state.disabled && isChangedDate(this._state.focusDate, focusedDate)) {
        this._nextState({
          focusDate: date
        });
      }
    }

    focusSelect() {
      if (isDateSelectable(this._state.focusDate, this._state)) {
        this.select(this._state.focusDate, {
          emitEvent: true
        });
      }
    }

    open(date) {
      const firstDate = this.toValidDate(date, this._calendar.getToday());

      if (firstDate != null && !this._state.disabled && (!this._state.firstDate || isChangedMonth(this._state.firstDate, firstDate))) {
        this._nextState({
          firstDate
        });
      }
    }

    select(date, options = {}) {
      const selectedDate = this.toValidDate(date, null);

      if (selectedDate != null && !this._state.disabled) {
        if (isChangedDate(this._state.selectedDate, selectedDate)) {
          this._nextState({
            selectedDate
          });
        }

        if (options.emitEvent && isDateSelectable(selectedDate, this._state)) {
          this._dateSelect$.next(selectedDate);
        }
      }
    }

    toValidDate(date, defaultValue) {
      const ngbDate = NgbDate.from(date);

      if (defaultValue === undefined) {
        defaultValue = this._calendar.getToday();
      }

      return this._calendar.isValid(ngbDate) ? ngbDate : defaultValue;
    }

    getMonth(struct) {
      for (let month of this._state.months) {
        if (struct.month === month.number && struct.year === month.year) {
          return month;
        }
      }

      throw new Error(`month ${struct.month} of year ${struct.year} not found`);
    }

    _nextState(patch) {
      const newState = this._updateState(patch);

      this._patchContexts(newState);

      this._state = newState;

      this._model$.next(this._state);
    }

    _patchContexts(state) {
      const {
        months,
        displayMonths,
        selectedDate,
        focusDate,
        focusVisible,
        disabled,
        outsideDays
      } = state;
      state.months.forEach(month => {
        month.weeks.forEach(week => {
          week.days.forEach(day => {
            // patch focus flag
            if (focusDate) {
              day.context.focused = focusDate.equals(day.date) && focusVisible;
            } // calculating tabindex


            day.tabindex = !disabled && focusDate && day.date.equals(focusDate) && focusDate.month === month.number ? 0 : -1; // override context disabled

            if (disabled === true) {
              day.context.disabled = true;
            } // patch selection flag


            if (selectedDate !== undefined) {
              day.context.selected = selectedDate !== null && selectedDate.equals(day.date);
            } // visibility


            if (month.number !== day.date.month) {
              day.hidden = outsideDays === 'hidden' || outsideDays === 'collapsed' || displayMonths > 1 && day.date.after(months[0].firstDate) && day.date.before(months[displayMonths - 1].lastDate);
            }
          });
        });
      });
    }

    _updateState(patch) {
      // patching fields
      const state = Object.assign({}, this._state, patch);
      let startDate = state.firstDate; // min/max dates changed

      if ('minDate' in patch || 'maxDate' in patch) {
        checkMinBeforeMax(state.minDate, state.maxDate);
        state.focusDate = checkDateInRange(state.focusDate, state.minDate, state.maxDate);
        state.firstDate = checkDateInRange(state.firstDate, state.minDate, state.maxDate);
        startDate = state.focusDate;
      } // disabled


      if ('disabled' in patch) {
        state.focusVisible = false;
      } // initial rebuild via 'select()'


      if ('selectedDate' in patch && this._state.months.length === 0) {
        startDate = state.selectedDate;
      } // terminate early if only focus visibility was changed


      if ('focusVisible' in patch) {
        return state;
      } // focus date changed


      if ('focusDate' in patch) {
        state.focusDate = checkDateInRange(state.focusDate, state.minDate, state.maxDate);
        startDate = state.focusDate; // nothing to rebuild if only focus changed and it is still visible

        if (state.months.length !== 0 && state.focusDate && !state.focusDate.before(state.firstDate) && !state.focusDate.after(state.lastDate)) {
          return state;
        }
      } // first date changed


      if ('firstDate' in patch) {
        state.firstDate = checkDateInRange(state.firstDate, state.minDate, state.maxDate);
        startDate = state.firstDate;
      } // rebuilding months


      if (startDate) {
        const forceRebuild = 'dayTemplateData' in patch || 'firstDayOfWeek' in patch || 'markDisabled' in patch || 'minDate' in patch || 'maxDate' in patch || 'disabled' in patch || 'outsideDays' in patch;
        const months = buildMonths(this._calendar, startDate, state, this._i18n, forceRebuild); // updating months and boundary dates

        state.months = months;
        state.firstDate = months[0].firstDate;
        state.lastDate = months[months.length - 1].lastDate; // reset selected date if 'markDisabled' returns true

        if ('selectedDate' in patch && !isDateSelectable(state.selectedDate, state)) {
          state.selectedDate = null;
        } // adjusting focus after months were built


        if ('firstDate' in patch) {
          if (!state.focusDate || state.focusDate.before(state.firstDate) || state.focusDate.after(state.lastDate)) {
            state.focusDate = startDate;
          }
        } // adjusting months/years for the select box navigation


        const yearChanged = !this._state.firstDate || this._state.firstDate.year !== state.firstDate.year;
        const monthChanged = !this._state.firstDate || this._state.firstDate.month !== state.firstDate.month;

        if (state.navigation === 'select') {
          // years ->  boundaries (min/max were changed)
          if ('minDate' in patch || 'maxDate' in patch || state.selectBoxes.years.length === 0 || yearChanged) {
            state.selectBoxes.years = generateSelectBoxYears(state.firstDate, state.minDate, state.maxDate);
          } // months -> when current year or boundaries change


          if ('minDate' in patch || 'maxDate' in patch || state.selectBoxes.months.length === 0 || yearChanged) {
            state.selectBoxes.months = generateSelectBoxMonths(this._calendar, state.firstDate, state.minDate, state.maxDate);
          }
        } else {
          state.selectBoxes = {
            years: [],
            months: []
          };
        } // updating navigation arrows -> boundaries change (min/max) or month/year changes


        if ((state.navigation === 'arrows' || state.navigation === 'select') && (monthChanged || yearChanged || 'minDate' in patch || 'maxDate' in patch || 'disabled' in patch)) {
          state.prevDisabled = state.disabled || prevMonthDisabled(this._calendar, state.firstDate, state.minDate);
          state.nextDisabled = state.disabled || nextMonthDisabled(this._calendar, state.lastDate, state.maxDate);
        }
      }

      return state;
    }

  }

  NgbDatepickerService.ɵfac = function NgbDatepickerService_Factory(t) {
    return new (t || NgbDatepickerService)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbCalendar), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbDatepickerI18n));
  };

  NgbDatepickerService.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbDatepickerService,
    factory: NgbDatepickerService.ɵfac
  });
  return NgbDatepickerService;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})(); // clang-format on


var NavigationEvent = /*#__PURE__*/(() => {
  (function (NavigationEvent) {
    NavigationEvent[NavigationEvent["PREV"] = 0] = "PREV";
    NavigationEvent[NavigationEvent["NEXT"] = 1] = "NEXT";
  })(NavigationEvent || (NavigationEvent = {}));

  return NavigationEvent;
})();

/**
 * A configuration service for the [`NgbDatepicker`](#/components/datepicker/api#NgbDatepicker) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the datepickers used in the application.
 */
let NgbDatepickerConfig = /*#__PURE__*/(() => {
  class NgbDatepickerConfig {
    constructor() {
      this.displayMonths = 1;
      this.firstDayOfWeek = 1;
      this.navigation = 'select';
      this.outsideDays = 'visible';
      this.showWeekdays = true;
      this.showWeekNumbers = false;
    }

  }

  NgbDatepickerConfig.ɵfac = function NgbDatepickerConfig_Factory(t) {
    return new (t || NgbDatepickerConfig)();
  };

  NgbDatepickerConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbDatepickerConfig_Factory() {
      return new NgbDatepickerConfig();
    },
    token: NgbDatepickerConfig,
    providedIn: "root"
  });
  return NgbDatepickerConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

function NGB_DATEPICKER_DATE_ADAPTER_FACTORY() {
  return new NgbDateStructAdapter();
}
/**
 * An abstract service that does the conversion between the internal datepicker `NgbDateStruct` model and
 * any provided user date model `D`, ex. a string, a native date, etc.
 *
 * The adapter is used **only** for conversion when binding datepicker to a form control,
 * ex. `[(ngModel)]="userDateModel"`. Here `userDateModel` can be of any type.
 *
 * The default datepicker implementation assumes we use `NgbDateStruct` as a user model.
 *
 * See the [date format overview](#/components/datepicker/overview#date-model) for more details
 * and the [custom adapter demo](#/components/datepicker/examples#adapter) for an example.
 */


let NgbDateAdapter = /*#__PURE__*/(() => {
  class NgbDateAdapter {}

  NgbDateAdapter.ɵfac = function NgbDateAdapter_Factory(t) {
    return new (t || NgbDateAdapter)();
  };

  NgbDateAdapter.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: NGB_DATEPICKER_DATE_ADAPTER_FACTORY,
    token: NgbDateAdapter,
    providedIn: "root"
  });
  return NgbDateAdapter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDateStructAdapter = /*#__PURE__*/(() => {
  class NgbDateStructAdapter extends NgbDateAdapter {
    /**
     * Converts a NgbDateStruct value into NgbDateStruct value
     */
    fromModel(date) {
      return date && isInteger(date.year) && isInteger(date.month) && isInteger(date.day) ? {
        year: date.year,
        month: date.month,
        day: date.day
      } : null;
    }
    /**
     * Converts a NgbDateStruct value into NgbDateStruct value
     */


    toModel(date) {
      return date && isInteger(date.year) && isInteger(date.month) && isInteger(date.day) ? {
        year: date.year,
        month: date.month,
        day: date.day
      } : null;
    }

  }

  NgbDateStructAdapter.ɵfac = /*@__PURE__*/function () {
    let ɵNgbDateStructAdapter_BaseFactory;
    return function NgbDateStructAdapter_Factory(t) {
      return (ɵNgbDateStructAdapter_BaseFactory || (ɵNgbDateStructAdapter_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbDateStructAdapter)))(t || NgbDateStructAdapter);
    };
  }();

  NgbDateStructAdapter.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbDateStructAdapter,
    factory: NgbDateStructAdapter.ɵfac
  });
  return NgbDateStructAdapter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that marks the content template that customizes the way datepicker months are displayed
 *
 * @since 5.3.0
 */


let NgbDatepickerContent = /*#__PURE__*/(() => {
  class NgbDatepickerContent {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbDatepickerContent.ɵfac = function NgbDatepickerContent_Factory(t) {
    return new (t || NgbDatepickerContent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbDatepickerContent.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbDatepickerContent,
    selectors: [["ng-template", "ngbDatepickerContent", ""]]
  });
  return NgbDatepickerContent;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A highly configurable component that helps you with selecting calendar dates.
 *
 * `NgbDatepicker` is meant to be displayed inline on a page or put inside a popup.
 */


let NgbDatepicker = /*#__PURE__*/(() => {
  class NgbDatepicker {
    constructor(_service, _calendar, i18n, config, cd, _elementRef, _ngbDateAdapter, _ngZone) {
      this._service = _service;
      this._calendar = _calendar;
      this.i18n = i18n;
      this._elementRef = _elementRef;
      this._ngbDateAdapter = _ngbDateAdapter;
      this._ngZone = _ngZone;
      this._controlValue = null;
      this._destroyed$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._publicState = {};
      /**
       * An event emitted right before the navigation happens and displayed month changes.
       *
       * See [`NgbDatepickerNavigateEvent`](#/components/datepicker/api#NgbDatepickerNavigateEvent) for the payload info.
       */

      this.navigate = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when user selects a date using keyboard or mouse.
       *
       * The payload of the event is currently selected `NgbDate`.
       *
       * @since 5.2.0
       */

      this.dateSelect = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();

      this.onChange = _ => {};

      this.onTouched = () => {};

      ['dayTemplate', 'dayTemplateData', 'displayMonths', 'firstDayOfWeek', 'footerTemplate', 'markDisabled', 'minDate', 'maxDate', 'navigation', 'outsideDays', 'showWeekdays', 'showWeekNumbers', 'startDate'].forEach(input => this[input] = config[input]);

      _service.dateSelect$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._destroyed$)).subscribe(date => {
        this.dateSelect.emit(date);
      });

      _service.model$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._destroyed$)).subscribe(model => {
        const newDate = model.firstDate;
        const oldDate = this.model ? this.model.firstDate : null; // update public state

        this._publicState = {
          maxDate: model.maxDate,
          minDate: model.minDate,
          firstDate: model.firstDate,
          lastDate: model.lastDate,
          focusedDate: model.focusDate,
          months: model.months.map(viewModel => viewModel.firstDate)
        };
        let navigationPrevented = false; // emitting navigation event if the first month changes

        if (!newDate.equals(oldDate)) {
          this.navigate.emit({
            current: oldDate ? {
              year: oldDate.year,
              month: oldDate.month
            } : null,
            next: {
              year: newDate.year,
              month: newDate.month
            },
            preventDefault: () => navigationPrevented = true
          }); // can't prevent the very first navigation

          if (navigationPrevented && oldDate !== null) {
            this._service.open(oldDate);

            return;
          }
        }

        const newSelectedDate = model.selectedDate;
        const newFocusedDate = model.focusDate;
        const oldFocusedDate = this.model ? this.model.focusDate : null;
        this.model = model; // handling selection change

        if (isChangedDate(newSelectedDate, this._controlValue)) {
          this._controlValue = newSelectedDate;
          this.onTouched();
          this.onChange(this._ngbDateAdapter.toModel(newSelectedDate));
        } // handling focus change


        if (isChangedDate(newFocusedDate, oldFocusedDate) && oldFocusedDate && model.focusVisible) {
          this.focus();
        }

        cd.markForCheck();
      });
    }
    /**
     *  Returns the readonly public state of the datepicker
     *
     * @since 5.2.0
     */


    get state() {
      return this._publicState;
    }
    /**
     *  Returns the calendar service used in the specific datepicker instance.
     *
     *  @since 5.3.0
     */


    get calendar() {
      return this._calendar;
    }
    /**
     *  Focuses on given date.
     */


    focusDate(date) {
      this._service.focus(NgbDate.from(date));
    }
    /**
     *  Selects focused date.
     */


    focusSelect() {
      this._service.focusSelect();
    }

    focus() {
      this._ngZone.onStable.asObservable().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => {
        const elementToFocus = this._elementRef.nativeElement.querySelector('div.ngb-dp-day[tabindex="0"]');

        if (elementToFocus) {
          elementToFocus.focus();
        }
      });
    }
    /**
     * Navigates to the provided date.
     *
     * With the default calendar we use ISO 8601: 'month' is 1=Jan ... 12=Dec.
     * If nothing or invalid date provided calendar will open current month.
     *
     * Use the `[startDate]` input as an alternative.
     */


    navigateTo(date) {
      this._service.open(NgbDate.from(date ? date.day ? date : Object.assign(Object.assign({}, date), {
        day: 1
      }) : null));
    }

    ngAfterViewInit() {
      this._ngZone.runOutsideAngular(() => {
        const focusIns$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(this._contentEl.nativeElement, 'focusin');
        const focusOuts$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(this._contentEl.nativeElement, 'focusout');
        const {
          nativeElement
        } = this._elementRef; // we're changing 'focusVisible' only when entering or leaving months view
        // and ignoring all focus events where both 'target' and 'related' target are day cells

        (0,rxjs__WEBPACK_IMPORTED_MODULE_22__.merge)(focusIns$, focusOuts$).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(({
          target,
          relatedTarget
        }) => !(hasClassName(target, 'ngb-dp-day') && hasClassName(relatedTarget, 'ngb-dp-day') && nativeElement.contains(target) && nativeElement.contains(relatedTarget))), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._destroyed$)).subscribe(({
          type
        }) => this._ngZone.run(() => this._service.set({
          focusVisible: type === 'focusin'
        })));
      });
    }

    ngOnDestroy() {
      this._destroyed$.next();
    }

    ngOnInit() {
      if (this.model === undefined) {
        const inputs = {};
        ['dayTemplateData', 'displayMonths', 'markDisabled', 'firstDayOfWeek', 'navigation', 'minDate', 'maxDate', 'outsideDays'].forEach(name => inputs[name] = this[name]);

        this._service.set(inputs);

        this.navigateTo(this.startDate);
      }

      if (!this.dayTemplate) {
        this.dayTemplate = this._defaultDayTemplate;
      }
    }

    ngOnChanges(changes) {
      const inputs = {};
      ['dayTemplateData', 'displayMonths', 'markDisabled', 'firstDayOfWeek', 'navigation', 'minDate', 'maxDate', 'outsideDays'].filter(name => name in changes).forEach(name => inputs[name] = this[name]);

      this._service.set(inputs);

      if ('startDate' in changes) {
        const {
          currentValue,
          previousValue
        } = changes.startDate;

        if (isChangedMonth(previousValue, currentValue)) {
          this.navigateTo(this.startDate);
        }
      }
    }

    onDateSelect(date) {
      this._service.focus(date);

      this._service.select(date, {
        emitEvent: true
      });
    }

    onNavigateDateSelect(date) {
      this._service.open(date);
    }

    onNavigateEvent(event) {
      switch (event) {
        case NavigationEvent.PREV:
          this._service.open(this._calendar.getPrev(this.model.firstDate, 'm', 1));

          break;

        case NavigationEvent.NEXT:
          this._service.open(this._calendar.getNext(this.model.firstDate, 'm', 1));

          break;
      }
    }

    registerOnChange(fn) {
      this.onChange = fn;
    }

    registerOnTouched(fn) {
      this.onTouched = fn;
    }

    setDisabledState(disabled) {
      this._service.set({
        disabled
      });
    }

    writeValue(value) {
      this._controlValue = NgbDate.from(this._ngbDateAdapter.fromModel(value));

      this._service.select(this._controlValue);
    }

  }

  NgbDatepicker.ɵfac = function NgbDatepicker_Factory(t) {
    return new (t || NgbDatepicker)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbCalendar), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerI18n), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDateAdapter), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  NgbDatepicker.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbDatepicker,
    selectors: [["ngb-datepicker"]],
    contentQueries: function NgbDatepicker_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbDatepickerContent, 7);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.contentTemplate = _t.first);
      }
    },
    viewQuery: function NgbDatepicker_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c10, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c11, 7);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._defaultDayTemplate = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._contentEl = _t.first);
      }
    },
    inputs: {
      dayTemplate: "dayTemplate",
      dayTemplateData: "dayTemplateData",
      displayMonths: "displayMonths",
      firstDayOfWeek: "firstDayOfWeek",
      footerTemplate: "footerTemplate",
      markDisabled: "markDisabled",
      maxDate: "maxDate",
      minDate: "minDate",
      navigation: "navigation",
      outsideDays: "outsideDays",
      showWeekdays: "showWeekdays",
      showWeekNumbers: "showWeekNumbers",
      startDate: "startDate"
    },
    outputs: {
      navigate: "navigate",
      dateSelect: "dateSelect"
    },
    exportAs: ["ngbDatepicker"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALUE_ACCESSOR,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbDatepicker),
      multi: true
    }, NgbDatepickerService]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
    decls: 10,
    vars: 5,
    consts: [["defaultDayTemplate", ""], ["defaultContentTemplate", ""], [1, "ngb-dp-header"], [3, "date", "months", "disabled", "showSelect", "prevDisabled", "nextDisabled", "selectBoxes", "navigate", "select", 4, "ngIf"], [1, "ngb-dp-content"], ["content", ""], [3, "ngTemplateOutlet"], ["ngbDatepickerDayView", "", 3, "date", "currentMonth", "selected", "disabled", "focused"], ["class", "ngb-dp-month", 4, "ngFor", "ngForOf"], [1, "ngb-dp-month"], ["class", "ngb-dp-month-name", 4, "ngIf"], [3, "month"], [1, "ngb-dp-month-name"], [3, "date", "months", "disabled", "showSelect", "prevDisabled", "nextDisabled", "selectBoxes", "navigate", "select"]],
    template: function NgbDatepicker_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbDatepicker_ng_template_0_Template, 1, 5, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbDatepicker_ng_template_2_Template, 1, 1, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, NgbDatepicker_ngb_datepicker_navigation_5_Template, 1, 7, "ngb-datepicker-navigation", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 4, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, NgbDatepicker_ng_template_8_Template, 0, 0, "ng-template", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, NgbDatepicker_ng_template_9_Template, 0, 0, "ng-template", 6);
      }

      if (rf & 2) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](3);

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.navigation !== "none");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("ngb-dp-months", !ctx.contentTemplate);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", (ctx.contentTemplate == null ? null : ctx.contentTemplate.templateRef) || _r2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx.footerTemplate);
      }
    },
    dependencies: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet, NgbDatepickerMonth, NgbDatepickerNavigation, NgbDatepickerDayView];
    },
    styles: ["ngb-datepicker{border:1px solid #dfdfdf;border-radius:.25rem;display:inline-block}ngb-datepicker-month{pointer-events:auto}ngb-datepicker.dropdown-menu{padding:0}.ngb-dp-body{z-index:1050}.ngb-dp-header{background-color:#f8f9fa;background-color:var(--light);border-bottom:0;border-radius:.25rem .25rem 0 0;padding-top:.25rem}.ngb-dp-months{display:-ms-flexbox;display:flex}.ngb-dp-month{pointer-events:none}.ngb-dp-month-name{background-color:#f8f9fa;background-color:var(--light);font-size:larger;height:2rem;line-height:2rem;text-align:center}.ngb-dp-month+.ngb-dp-month .ngb-dp-month-name,.ngb-dp-month+.ngb-dp-month .ngb-dp-week{padding-left:1rem}.ngb-dp-month:last-child .ngb-dp-week{padding-right:.25rem}.ngb-dp-month:first-child .ngb-dp-week{padding-left:.25rem}.ngb-dp-month .ngb-dp-week:last-child{padding-bottom:.25rem}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbDatepicker;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

var Key = /*#__PURE__*/(() => {
  (function (Key) {
    Key[Key["Tab"] = 9] = "Tab";
    Key[Key["Enter"] = 13] = "Enter";
    Key[Key["Escape"] = 27] = "Escape";
    Key[Key["Space"] = 32] = "Space";
    Key[Key["PageUp"] = 33] = "PageUp";
    Key[Key["PageDown"] = 34] = "PageDown";
    Key[Key["End"] = 35] = "End";
    Key[Key["Home"] = 36] = "Home";
    Key[Key["ArrowLeft"] = 37] = "ArrowLeft";
    Key[Key["ArrowUp"] = 38] = "ArrowUp";
    Key[Key["ArrowRight"] = 39] = "ArrowRight";
    Key[Key["ArrowDown"] = 40] = "ArrowDown";
  })(Key || (Key = {}));

  return Key;
})();

/**
 * A service that represents the keyboard navigation.
 *
 * Default keyboard shortcuts [are documented in the overview](#/components/datepicker/overview#keyboard-shortcuts)
 *
 * @since 5.2.0
 */
let NgbDatepickerKeyboardService = /*#__PURE__*/(() => {
  class NgbDatepickerKeyboardService {
    /**
     * Processes a keyboard event.
     */
    processKey(event, datepicker) {
      const {
        state,
        calendar
      } = datepicker; // tslint:disable-next-line:deprecation

      switch (event.which) {
        case Key.PageUp:
          datepicker.focusDate(calendar.getPrev(state.focusedDate, event.shiftKey ? 'y' : 'm', 1));
          break;

        case Key.PageDown:
          datepicker.focusDate(calendar.getNext(state.focusedDate, event.shiftKey ? 'y' : 'm', 1));
          break;

        case Key.End:
          datepicker.focusDate(event.shiftKey ? state.maxDate : state.lastDate);
          break;

        case Key.Home:
          datepicker.focusDate(event.shiftKey ? state.minDate : state.firstDate);
          break;

        case Key.ArrowLeft:
          datepicker.focusDate(calendar.getPrev(state.focusedDate, 'd', 1));
          break;

        case Key.ArrowUp:
          datepicker.focusDate(calendar.getPrev(state.focusedDate, 'd', calendar.getDaysPerWeek()));
          break;

        case Key.ArrowRight:
          datepicker.focusDate(calendar.getNext(state.focusedDate, 'd', 1));
          break;

        case Key.ArrowDown:
          datepicker.focusDate(calendar.getNext(state.focusedDate, 'd', calendar.getDaysPerWeek()));
          break;

        case Key.Enter:
        case Key.Space:
          datepicker.focusSelect();
          break;

        default:
          return;
      }

      event.preventDefault();
      event.stopPropagation();
    }

  }

  NgbDatepickerKeyboardService.ɵfac = function NgbDatepickerKeyboardService_Factory(t) {
    return new (t || NgbDatepickerKeyboardService)();
  };

  NgbDatepickerKeyboardService.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbDatepickerKeyboardService_Factory() {
      return new NgbDatepickerKeyboardService();
    },
    token: NgbDatepickerKeyboardService,
    providedIn: "root"
  });
  return NgbDatepickerKeyboardService;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A component that renders one month including all the days, weekdays and week numbers. Can be used inside
 * the `<ng-template ngbDatepickerMonths></ng-template>` when you want to customize months layout.
 *
 * For a usage example, see [custom month layout demo](#/components/datepicker/examples#custommonth)
 *
 * @since 5.3.0
 */


let NgbDatepickerMonth = /*#__PURE__*/(() => {
  class NgbDatepickerMonth {
    constructor(i18n, datepicker, _keyboardService, _service) {
      this.i18n = i18n;
      this.datepicker = datepicker;
      this._keyboardService = _keyboardService;
      this._service = _service;
    }
    /**
     * The first date of month to be rendered.
     *
     * This month must one of the months present in the
     * [datepicker state](#/components/datepicker/api#NgbDatepickerState).
     */


    set month(month) {
      this.viewModel = this._service.getMonth(month);
    }

    onKeyDown(event) {
      this._keyboardService.processKey(event, this.datepicker);
    }

    doSelect(day) {
      if (!day.context.disabled && !day.hidden) {
        this.datepicker.onDateSelect(day.date);
      }
    }

  }

  NgbDatepickerMonth.ɵfac = function NgbDatepickerMonth_Factory(t) {
    return new (t || NgbDatepickerMonth)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerI18n), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepicker), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerKeyboardService), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerService));
  };

  NgbDatepickerMonth.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbDatepickerMonth,
    selectors: [["ngb-datepicker-month"]],
    hostAttrs: ["role", "grid"],
    hostBindings: function NgbDatepickerMonth_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("keydown", function NgbDatepickerMonth_keydown_HostBindingHandler($event) {
          return ctx.onKeyDown($event);
        });
      }
    },
    inputs: {
      month: "month"
    },
    decls: 2,
    vars: 2,
    consts: [["class", "ngb-dp-week ngb-dp-weekdays", "role", "row", 4, "ngIf"], ["ngFor", "", 3, "ngForOf"], ["role", "row", 1, "ngb-dp-week", "ngb-dp-weekdays"], ["class", "ngb-dp-weekday ngb-dp-showweek", 4, "ngIf"], ["class", "ngb-dp-weekday small", "role", "columnheader", 4, "ngFor", "ngForOf"], [1, "ngb-dp-weekday", "ngb-dp-showweek"], ["role", "columnheader", 1, "ngb-dp-weekday", "small"], ["class", "ngb-dp-week", "role", "row", 4, "ngIf"], ["role", "row", 1, "ngb-dp-week"], ["class", "ngb-dp-week-number small text-muted", 4, "ngIf"], ["class", "ngb-dp-day", "role", "gridcell", 3, "disabled", "tabindex", "hidden", "ngb-dp-today", "click", 4, "ngFor", "ngForOf"], [1, "ngb-dp-week-number", "small", "text-muted"], ["role", "gridcell", 1, "ngb-dp-day", 3, "tabindex", "click"], [3, "ngIf"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"]],
    template: function NgbDatepickerMonth_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbDatepickerMonth_div_0_Template, 3, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbDatepickerMonth_ng_template_1_Template, 1, 1, "ng-template", 1);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.datepicker.showWeekdays);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.viewModel.weeks);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet],
    styles: ["ngb-datepicker-month{display:block}.ngb-dp-week-number,.ngb-dp-weekday{font-style:italic;line-height:2rem;text-align:center}.ngb-dp-weekday{color:#5bc0de;color:var(--info)}.ngb-dp-week{border-radius:.25rem;display:-ms-flexbox;display:flex}.ngb-dp-weekdays{background-color:#f8f9fa;background-color:var(--light);border-bottom:1px solid rgba(0,0,0,.125);border-radius:0}.ngb-dp-day,.ngb-dp-week-number,.ngb-dp-weekday{height:2rem;width:2rem}.ngb-dp-day{cursor:pointer}.ngb-dp-day.disabled,.ngb-dp-day.hidden{cursor:default;pointer-events:none}.ngb-dp-day[tabindex=\"0\"]{z-index:1}"],
    encapsulation: 2
  });
  return NgbDatepickerMonth;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDatepickerNavigation = /*#__PURE__*/(() => {
  class NgbDatepickerNavigation {
    constructor(i18n) {
      this.i18n = i18n;
      this.navigation = NavigationEvent;
      this.months = [];
      this.navigate = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }

    onClickPrev(event) {
      event.currentTarget.focus();
      this.navigate.emit(this.navigation.PREV);
    }

    onClickNext(event) {
      event.currentTarget.focus();
      this.navigate.emit(this.navigation.NEXT);
    }

  }

  NgbDatepickerNavigation.ɵfac = function NgbDatepickerNavigation_Factory(t) {
    return new (t || NgbDatepickerNavigation)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerI18n));
  };

  NgbDatepickerNavigation.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbDatepickerNavigation,
    selectors: [["ngb-datepicker-navigation"]],
    inputs: {
      months: "months",
      date: "date",
      disabled: "disabled",
      showSelect: "showSelect",
      prevDisabled: "prevDisabled",
      nextDisabled: "nextDisabled",
      selectBoxes: "selectBoxes"
    },
    outputs: {
      navigate: "navigate",
      select: "select"
    },
    decls: 8,
    vars: 4,
    consts: function () {
      let i18n_12;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_previous_month$$FESM2015_NG_BOOTSTRAP_JS_13 = goog.getMsg("Previous month");
        i18n_12 = MSG_EXTERNAL_ngb_datepicker_previous_month$$FESM2015_NG_BOOTSTRAP_JS_13;
      } else {
        i18n_12 = $localize`:@@ngb.datepicker.previous-month␟c3b08b07b5ab98e7cdcf18df39355690ab7d3884␟8586908745456864217:Previous month`;
      }

      let i18n_14;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_previous_month$$FESM2015_NG_BOOTSTRAP_JS_15 = goog.getMsg("Previous month");
        i18n_14 = MSG_EXTERNAL_ngb_datepicker_previous_month$$FESM2015_NG_BOOTSTRAP_JS_15;
      } else {
        i18n_14 = $localize`:@@ngb.datepicker.previous-month␟c3b08b07b5ab98e7cdcf18df39355690ab7d3884␟8586908745456864217:Previous month`;
      }

      let i18n_16;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_next_month$$FESM2015_NG_BOOTSTRAP_JS_17 = goog.getMsg("Next month");
        i18n_16 = MSG_EXTERNAL_ngb_datepicker_next_month$$FESM2015_NG_BOOTSTRAP_JS_17;
      } else {
        i18n_16 = $localize`:@@ngb.datepicker.next-month␟4bd046985cfe13040d5ef0cd881edce0968a111a␟3628374603023447227:Next month`;
      }

      let i18n_18;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_next_month$$FESM2015_NG_BOOTSTRAP_JS_19 = goog.getMsg("Next month");
        i18n_18 = MSG_EXTERNAL_ngb_datepicker_next_month$$FESM2015_NG_BOOTSTRAP_JS_19;
      } else {
        i18n_18 = $localize`:@@ngb.datepicker.next-month␟4bd046985cfe13040d5ef0cd881edce0968a111a␟3628374603023447227:Next month`;
      }

      return [[1, "ngb-dp-arrow"], ["type", "button", "aria-label", i18n_12, "title", i18n_14, 1, "btn", "btn-link", "ngb-dp-arrow-btn", 3, "disabled", "click"], [1, "ngb-dp-navigation-chevron"], ["class", "ngb-dp-navigation-select", 3, "date", "disabled", "months", "years", "select", 4, "ngIf"], [4, "ngIf"], [1, "ngb-dp-arrow", "right"], ["type", "button", "aria-label", i18n_16, "title", i18n_18, 1, "btn", "btn-link", "ngb-dp-arrow-btn", 3, "disabled", "click"], [1, "ngb-dp-navigation-select", 3, "date", "disabled", "months", "years", "select"], ["ngFor", "", 3, "ngForOf"], ["class", "ngb-dp-arrow", 4, "ngIf"], [1, "ngb-dp-month-name"]];
    },
    template: function NgbDatepickerNavigation_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0)(1, "button", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbDatepickerNavigation_Template_button_click_1_listener($event) {
          return ctx.onClickPrev($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](2, "span", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbDatepickerNavigation_ngb_datepicker_navigation_select_3_Template, 1, 4, "ngb-datepicker-navigation-select", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, NgbDatepickerNavigation_4_Template, 1, 1, null, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](5, "div", 5)(6, "button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbDatepickerNavigation_Template_button_click_6_listener($event) {
          return ctx.onClickNext($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](7, "span", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx.prevDisabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showSelect);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx.showSelect);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx.nextDisabled);
      }
    },
    dependencies: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, NgbDatepickerNavigationSelect];
    },
    styles: ["ngb-datepicker-navigation{-ms-flex-align:center;align-items:center;display:-ms-flexbox;display:flex}.ngb-dp-navigation-chevron{-webkit-transform:rotate(-135deg);border-style:solid;border-width:.2em .2em 0 0;display:inline-block;height:.75em;margin-left:.25em;margin-right:.15em;transform:rotate(-135deg);width:.75em}.ngb-dp-arrow{-ms-flex:1 1 auto;display:-ms-flexbox;display:flex;flex:1 1 auto;height:2rem;margin:0;padding-left:0;padding-right:0;width:2rem}.ngb-dp-arrow.right{-ms-flex-pack:end;justify-content:flex-end}.ngb-dp-arrow.right .ngb-dp-navigation-chevron{-webkit-transform:rotate(45deg);margin-left:.15em;margin-right:.25em;transform:rotate(45deg)}.ngb-dp-arrow-btn{background-color:transparent;border:none;margin:0 .5rem;padding:0 .25rem;z-index:1}.ngb-dp-arrow-btn:focus{outline-style:auto;outline-width:1px}@media (-ms-high-contrast:active),(-ms-high-contrast:none){.ngb-dp-arrow-btn:focus{outline-style:solid}}.ngb-dp-month-name{font-size:larger;height:2rem;line-height:2rem;text-align:center}.ngb-dp-navigation-select{-ms-flex:1 1 9rem;display:-ms-flexbox;display:flex;flex:1 1 9rem}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbDatepickerNavigation;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const isContainedIn = (element, array) => array ? array.some(item => item.contains(element)) : false;

const ɵ0$2 = isContainedIn;

const matchesSelectorIfAny = (element, selector) => !selector || closest(element, selector) != null;

const ɵ1$1 = matchesSelectorIfAny;

const ɵ2$1 = () => {
  const isIOS = () => /iPad|iPhone|iPod/.test(navigator.userAgent) || /Macintosh/.test(navigator.userAgent) && navigator.maxTouchPoints && navigator.maxTouchPoints > 2;

  const isAndroid = () => /Android/.test(navigator.userAgent);

  return typeof navigator !== 'undefined' ? !!navigator.userAgent && (isIOS() || isAndroid()) : false;
}; // we have to add a more significant delay to avoid re-opening when handling (click) on a toggling element
// TODO: use proper Angular platform detection when NgbAutoClose becomes a service and we can inject PLATFORM_ID


const isMobile = ɵ2$1(); // setting 'ngbAutoClose' synchronously on mobile results in immediate popup closing
// when tapping on the triggering element

const wrapAsyncForMobile = fn => isMobile ? () => setTimeout(() => fn(), 100) : fn;

const ɵ3 = wrapAsyncForMobile;

function ngbAutoClose(zone, document, type, close, closed$, insideElements, ignoreElements, insideSelector) {
  // closing on ESC and outside clicks
  if (type) {
    zone.runOutsideAngular(wrapAsyncForMobile(() => {
      const shouldCloseOnClick = event => {
        const element = event.target;

        if (event.button === 2 || isContainedIn(element, ignoreElements)) {
          return false;
        }

        if (type === 'inside') {
          return isContainedIn(element, insideElements) && matchesSelectorIfAny(element, insideSelector);
        } else if (type === 'outside') {
          return !isContainedIn(element, insideElements);
        } else
          /* if (type === true) */
          {
            return matchesSelectorIfAny(element, insideSelector) || !isContainedIn(element, insideElements);
          }
      };

      const escapes$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(document, 'keydown').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(closed$), // tslint:disable-next-line:deprecation
      (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(e => e.which === Key.Escape), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_23__.tap)(e => e.preventDefault())); // we have to pre-calculate 'shouldCloseOnClick' on 'mousedown',
      // because on 'mouseup' DOM nodes might be detached

      const mouseDowns$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(document, 'mousedown').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(shouldCloseOnClick), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(closed$));
      const closeableClicks$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(document, 'mouseup').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_24__.withLatestFrom)(mouseDowns$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(([_, shouldClose]) => shouldClose), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_25__.delay)(0), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(closed$));
      (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.race)([escapes$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(_ => 0
      /* ESCAPE */
      )), closeableClicks$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(_ => 1
      /* CLICK */
      ))]).subscribe(source => zone.run(() => close(source)));
    }));
  }
}

const FOCUSABLE_ELEMENTS_SELECTOR = ['a[href]', 'button:not([disabled])', 'input:not([disabled]):not([type="hidden"])', 'select:not([disabled])', 'textarea:not([disabled])', '[contenteditable]', '[tabindex]:not([tabindex="-1"])'].join(', ');
/**
 * Returns first and last focusable elements inside of a given element based on specific CSS selector
 */

function getFocusableBoundaryElements(element) {
  const list = Array.from(element.querySelectorAll(FOCUSABLE_ELEMENTS_SELECTOR)).filter(el => el.tabIndex !== -1);
  return [list[0], list[list.length - 1]];
}
/**
 * Function that enforces browser focus to be trapped inside a DOM element.
 *
 * Works only for clicks inside the element and navigation with 'Tab', ignoring clicks outside of the element
 *
 * @param zone Angular zone
 * @param element The element around which focus will be trapped inside
 * @param stopFocusTrap$ The observable stream. When completed the focus trap will clean up listeners
 * and free internal resources
 * @param refocusOnClick Put the focus back to the last focused element whenever a click occurs on element (default to
 * false)
 */


const ngbFocusTrap = (zone, element, stopFocusTrap$, refocusOnClick = false) => {
  zone.runOutsideAngular(() => {
    // last focused element
    const lastFocusedElement$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(element, 'focusin').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(stopFocusTrap$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(e => e.target)); // 'tab' / 'shift+tab' stream

    (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(element, 'keydown').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(stopFocusTrap$), // tslint:disable:deprecation
    (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(e => e.which === Key.Tab), // tslint:enable:deprecation
    (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_24__.withLatestFrom)(lastFocusedElement$)).subscribe(([tabEvent, focusedElement]) => {
      const [first, last] = getFocusableBoundaryElements(element);

      if ((focusedElement === first || focusedElement === element) && tabEvent.shiftKey) {
        last.focus();
        tabEvent.preventDefault();
      }

      if (focusedElement === last && !tabEvent.shiftKey) {
        first.focus();
        tabEvent.preventDefault();
      }
    }); // inside click

    if (refocusOnClick) {
      (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(element, 'click').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(stopFocusTrap$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_24__.withLatestFrom)(lastFocusedElement$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(arr => arr[1])).subscribe(lastFocusedElement => lastFocusedElement.focus());
    }
  });
}; // previous version:
// https://github.com/angular-ui/bootstrap/blob/07c31d0731f7cb068a1932b8e01d2312b796b4ec/src/position/position.js


class Positioning {
  getAllStyles(element) {
    return window.getComputedStyle(element);
  }

  getStyle(element, prop) {
    return this.getAllStyles(element)[prop];
  }

  isStaticPositioned(element) {
    return (this.getStyle(element, 'position') || 'static') === 'static';
  }

  offsetParent(element) {
    let offsetParentEl = element.offsetParent || document.documentElement;

    while (offsetParentEl && offsetParentEl !== document.documentElement && this.isStaticPositioned(offsetParentEl)) {
      offsetParentEl = offsetParentEl.offsetParent;
    }

    return offsetParentEl || document.documentElement;
  }

  position(element, round = true) {
    let elPosition;
    let parentOffset = {
      width: 0,
      height: 0,
      top: 0,
      bottom: 0,
      left: 0,
      right: 0
    };

    if (this.getStyle(element, 'position') === 'fixed') {
      elPosition = element.getBoundingClientRect();
      elPosition = {
        top: elPosition.top,
        bottom: elPosition.bottom,
        left: elPosition.left,
        right: elPosition.right,
        height: elPosition.height,
        width: elPosition.width
      };
    } else {
      const offsetParentEl = this.offsetParent(element);
      elPosition = this.offset(element, false);

      if (offsetParentEl !== document.documentElement) {
        parentOffset = this.offset(offsetParentEl, false);
      }

      parentOffset.top += offsetParentEl.clientTop;
      parentOffset.left += offsetParentEl.clientLeft;
    }

    elPosition.top -= parentOffset.top;
    elPosition.bottom -= parentOffset.top;
    elPosition.left -= parentOffset.left;
    elPosition.right -= parentOffset.left;

    if (round) {
      elPosition.top = Math.round(elPosition.top);
      elPosition.bottom = Math.round(elPosition.bottom);
      elPosition.left = Math.round(elPosition.left);
      elPosition.right = Math.round(elPosition.right);
    }

    return elPosition;
  }

  offset(element, round = true) {
    const elBcr = element.getBoundingClientRect();
    const viewportOffset = {
      top: window.pageYOffset - document.documentElement.clientTop,
      left: window.pageXOffset - document.documentElement.clientLeft
    };
    let elOffset = {
      height: elBcr.height || element.offsetHeight,
      width: elBcr.width || element.offsetWidth,
      top: elBcr.top + viewportOffset.top,
      bottom: elBcr.bottom + viewportOffset.top,
      left: elBcr.left + viewportOffset.left,
      right: elBcr.right + viewportOffset.left
    };

    if (round) {
      elOffset.height = Math.round(elOffset.height);
      elOffset.width = Math.round(elOffset.width);
      elOffset.top = Math.round(elOffset.top);
      elOffset.bottom = Math.round(elOffset.bottom);
      elOffset.left = Math.round(elOffset.left);
      elOffset.right = Math.round(elOffset.right);
    }

    return elOffset;
  }
  /*
    Return false if the element to position is outside the viewport
  */


  positionElements(hostElement, targetElement, placement, appendToBody) {
    const [placementPrimary = 'top', placementSecondary = 'center'] = placement.split('-');
    const hostElPosition = appendToBody ? this.offset(hostElement, false) : this.position(hostElement, false);
    const targetElStyles = this.getAllStyles(targetElement);
    const marginTop = parseFloat(targetElStyles.marginTop);
    const marginBottom = parseFloat(targetElStyles.marginBottom);
    const marginLeft = parseFloat(targetElStyles.marginLeft);
    const marginRight = parseFloat(targetElStyles.marginRight);
    let topPosition = 0;
    let leftPosition = 0;

    switch (placementPrimary) {
      case 'top':
        topPosition = hostElPosition.top - (targetElement.offsetHeight + marginTop + marginBottom);
        break;

      case 'bottom':
        topPosition = hostElPosition.top + hostElPosition.height;
        break;

      case 'left':
        leftPosition = hostElPosition.left - (targetElement.offsetWidth + marginLeft + marginRight);
        break;

      case 'right':
        leftPosition = hostElPosition.left + hostElPosition.width;
        break;
    }

    switch (placementSecondary) {
      case 'top':
        topPosition = hostElPosition.top;
        break;

      case 'bottom':
        topPosition = hostElPosition.top + hostElPosition.height - targetElement.offsetHeight;
        break;

      case 'left':
        leftPosition = hostElPosition.left;
        break;

      case 'right':
        leftPosition = hostElPosition.left + hostElPosition.width - targetElement.offsetWidth;
        break;

      case 'center':
        if (placementPrimary === 'top' || placementPrimary === 'bottom') {
          leftPosition = hostElPosition.left + hostElPosition.width / 2 - targetElement.offsetWidth / 2;
        } else {
          topPosition = hostElPosition.top + hostElPosition.height / 2 - targetElement.offsetHeight / 2;
        }

        break;
    } /// The translate3d/gpu acceleration render a blurry text on chrome, the next line is commented until a browser fix
    // targetElement.style.transform = `translate3d(${Math.round(leftPosition)}px, ${Math.floor(topPosition)}px, 0px)`;


    targetElement.style.transform = `translate(${Math.round(leftPosition)}px, ${Math.round(topPosition)}px)`; // Check if the targetElement is inside the viewport

    const targetElBCR = targetElement.getBoundingClientRect();
    const html = document.documentElement;
    const windowHeight = window.innerHeight || html.clientHeight;
    const windowWidth = window.innerWidth || html.clientWidth;
    return targetElBCR.left >= 0 && targetElBCR.top >= 0 && targetElBCR.right <= windowWidth && targetElBCR.bottom <= windowHeight;
  }

}

const placementSeparator = /\s+/;
const positionService = new Positioning();
/*
 * Accept the placement array and applies the appropriate placement dependent on the viewport.
 * Returns the applied placement.
 * In case of auto placement, placements are selected in order
 *   'top', 'bottom', 'left', 'right',
 *   'top-left', 'top-right',
 *   'bottom-left', 'bottom-right',
 *   'left-top', 'left-bottom',
 *   'right-top', 'right-bottom'.
 * */

function positionElements(hostElement, targetElement, placement, appendToBody, baseClass) {
  let placementVals = Array.isArray(placement) ? placement : placement.split(placementSeparator);
  const allowedPlacements = ['top', 'bottom', 'left', 'right', 'top-left', 'top-right', 'bottom-left', 'bottom-right', 'left-top', 'left-bottom', 'right-top', 'right-bottom'];
  const classList = targetElement.classList;

  const addClassesToTarget = targetPlacement => {
    const [primary, secondary] = targetPlacement.split('-');
    const classes = [];

    if (baseClass) {
      classes.push(`${baseClass}-${primary}`);

      if (secondary) {
        classes.push(`${baseClass}-${primary}-${secondary}`);
      }

      classes.forEach(classname => {
        classList.add(classname);
      });
    }

    return classes;
  }; // Remove old placement classes to avoid issues


  if (baseClass) {
    allowedPlacements.forEach(placementToRemove => {
      classList.remove(`${baseClass}-${placementToRemove}`);
    });
  } // replace auto placement with other placements


  let hasAuto = placementVals.findIndex(val => val === 'auto');

  if (hasAuto >= 0) {
    allowedPlacements.forEach(function (obj) {
      if (placementVals.find(val => val.search('^' + obj) !== -1) == null) {
        placementVals.splice(hasAuto++, 1, obj);
      }
    });
  } // coordinates where to position
  // Required for transform:


  const style = targetElement.style;
  style.position = 'absolute';
  style.top = '0';
  style.left = '0';
  style['will-change'] = 'transform';
  let testPlacement = null;
  let isInViewport = false;

  for (testPlacement of placementVals) {
    let addedClasses = addClassesToTarget(testPlacement);

    if (positionService.positionElements(hostElement, targetElement, testPlacement, appendToBody)) {
      isInViewport = true;
      break;
    } // Remove the baseClasses for further calculation


    if (baseClass) {
      addedClasses.forEach(classname => {
        classList.remove(classname);
      });
    }
  }

  if (!isInViewport) {
    // If nothing match, the first placement is the default one
    testPlacement = placementVals[0];
    addClassesToTarget(testPlacement);
    positionService.positionElements(hostElement, targetElement, testPlacement, appendToBody);
  }

  return testPlacement;
}

function NGB_DATEPICKER_PARSER_FORMATTER_FACTORY() {
  return new NgbDateISOParserFormatter();
}
/**
 * An abstract service for parsing and formatting dates for the
 * [`NgbInputDatepicker`](#/components/datepicker/api#NgbInputDatepicker) directive.
 * Converts between the internal `NgbDateStruct` model presentation and a `string` that is displayed in the
 * input element.
 *
 * When user types something in the input this service attempts to parse it into a `NgbDateStruct` object.
 * And vice versa, when users selects a date in the calendar with the mouse, it must be displayed as a `string`
 * in the input.
 *
 * Default implementation uses the ISO 8601 format, but you can provide another implementation via DI
 * to use an alternative string format or a custom parsing logic.
 *
 * See the [date format overview](#/components/datepicker/overview#date-model) for more details.
 */


let NgbDateParserFormatter = /*#__PURE__*/(() => {
  class NgbDateParserFormatter {}

  NgbDateParserFormatter.ɵfac = function NgbDateParserFormatter_Factory(t) {
    return new (t || NgbDateParserFormatter)();
  };

  NgbDateParserFormatter.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: NGB_DATEPICKER_PARSER_FORMATTER_FACTORY,
    token: NgbDateParserFormatter,
    providedIn: "root"
  });
  return NgbDateParserFormatter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDateISOParserFormatter = /*#__PURE__*/(() => {
  class NgbDateISOParserFormatter extends NgbDateParserFormatter {
    parse(value) {
      if (value != null) {
        const dateParts = value.trim().split('-');

        if (dateParts.length === 1 && isNumber(dateParts[0])) {
          return {
            year: toInteger(dateParts[0]),
            month: null,
            day: null
          };
        } else if (dateParts.length === 2 && isNumber(dateParts[0]) && isNumber(dateParts[1])) {
          return {
            year: toInteger(dateParts[0]),
            month: toInteger(dateParts[1]),
            day: null
          };
        } else if (dateParts.length === 3 && isNumber(dateParts[0]) && isNumber(dateParts[1]) && isNumber(dateParts[2])) {
          return {
            year: toInteger(dateParts[0]),
            month: toInteger(dateParts[1]),
            day: toInteger(dateParts[2])
          };
        }
      }

      return null;
    }

    format(date) {
      return date ? `${date.year}-${isNumber(date.month) ? padNumber(date.month) : ''}-${isNumber(date.day) ? padNumber(date.day) : ''}` : '';
    }

  }

  NgbDateISOParserFormatter.ɵfac = /*@__PURE__*/function () {
    let ɵNgbDateISOParserFormatter_BaseFactory;
    return function NgbDateISOParserFormatter_Factory(t) {
      return (ɵNgbDateISOParserFormatter_BaseFactory || (ɵNgbDateISOParserFormatter_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbDateISOParserFormatter)))(t || NgbDateISOParserFormatter);
    };
  }();

  NgbDateISOParserFormatter.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbDateISOParserFormatter,
    factory: NgbDateISOParserFormatter.ɵfac
  });
  return NgbDateISOParserFormatter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A configuration service for the [`NgbDatepickerInput`](#/components/datepicker/api#NgbDatepicker) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the datepicker inputs used in the application.
 *
 * @since 5.2.0
 */


let NgbInputDatepickerConfig = /*#__PURE__*/(() => {
  class NgbInputDatepickerConfig extends NgbDatepickerConfig {
    constructor() {
      super(...arguments);
      this.autoClose = true;
      this.placement = ['bottom-left', 'bottom-right', 'top-left', 'top-right'];
      this.restoreFocus = true;
    }

  }

  NgbInputDatepickerConfig.ɵfac = /*@__PURE__*/function () {
    let ɵNgbInputDatepickerConfig_BaseFactory;
    return function NgbInputDatepickerConfig_Factory(t) {
      return (ɵNgbInputDatepickerConfig_BaseFactory || (ɵNgbInputDatepickerConfig_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbInputDatepickerConfig)))(t || NgbInputDatepickerConfig);
    };
  }();

  NgbInputDatepickerConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbInputDatepickerConfig_Factory() {
      return new NgbInputDatepickerConfig();
    },
    token: NgbInputDatepickerConfig,
    providedIn: "root"
  });
  return NgbInputDatepickerConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that allows to stick a datepicker popup to an input field.
 *
 * Manages interaction with the input field itself, does value formatting and provides forms integration.
 */


let NgbInputDatepicker = /*#__PURE__*/(() => {
  class NgbInputDatepicker {
    constructor(_parserFormatter, _elRef, _vcRef, _renderer, _cfr, _ngZone, _calendar, _dateAdapter, _document, _changeDetector, config) {
      this._parserFormatter = _parserFormatter;
      this._elRef = _elRef;
      this._vcRef = _vcRef;
      this._renderer = _renderer;
      this._cfr = _cfr;
      this._ngZone = _ngZone;
      this._calendar = _calendar;
      this._dateAdapter = _dateAdapter;
      this._document = _document;
      this._changeDetector = _changeDetector;
      this._cRef = null;
      this._disabled = false;
      this._elWithFocus = null;
      this._model = null;
      /**
       * An event emitted when user selects a date using keyboard or mouse.
       *
       * The payload of the event is currently selected `NgbDate`.
       *
       * @since 1.1.1
       */

      this.dateSelect = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * Event emitted right after the navigation happens and displayed month changes.
       *
       * See [`NgbDatepickerNavigateEvent`](#/components/datepicker/api#NgbDatepickerNavigateEvent) for the payload info.
       */

      this.navigate = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event fired after closing datepicker window.
       *
       * @since 4.2.0
       */

      this.closed = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();

      this._onChange = _ => {};

      this._onTouched = () => {};

      this._validatorChange = () => {};

      ['autoClose', 'container', 'positionTarget', 'placement'].forEach(input => this[input] = config[input]);
      this._zoneSubscription = _ngZone.onStable.subscribe(() => this._updatePopupPosition());
    }

    get disabled() {
      return this._disabled;
    }

    set disabled(value) {
      this._disabled = value === '' || value && value !== 'false';

      if (this.isOpen()) {
        this._cRef.instance.setDisabledState(this._disabled);
      }
    }

    registerOnChange(fn) {
      this._onChange = fn;
    }

    registerOnTouched(fn) {
      this._onTouched = fn;
    }

    registerOnValidatorChange(fn) {
      this._validatorChange = fn;
    }

    setDisabledState(isDisabled) {
      this.disabled = isDisabled;
    }

    validate(c) {
      const {
        value
      } = c;

      if (value != null) {
        const ngbDate = this._fromDateStruct(this._dateAdapter.fromModel(value));

        if (!ngbDate) {
          return {
            'ngbDate': {
              invalid: value
            }
          };
        }

        if (this.minDate && ngbDate.before(NgbDate.from(this.minDate))) {
          return {
            'ngbDate': {
              minDate: {
                minDate: this.minDate,
                actual: value
              }
            }
          };
        }

        if (this.maxDate && ngbDate.after(NgbDate.from(this.maxDate))) {
          return {
            'ngbDate': {
              maxDate: {
                maxDate: this.maxDate,
                actual: value
              }
            }
          };
        }
      }

      return null;
    }

    writeValue(value) {
      this._model = this._fromDateStruct(this._dateAdapter.fromModel(value));

      this._writeModelValue(this._model);
    }

    manualDateChange(value, updateView = false) {
      const inputValueChanged = value !== this._inputValue;

      if (inputValueChanged) {
        this._inputValue = value;
        this._model = this._fromDateStruct(this._parserFormatter.parse(value));
      }

      if (inputValueChanged || !updateView) {
        this._onChange(this._model ? this._dateAdapter.toModel(this._model) : value === '' ? null : value);
      }

      if (updateView && this._model) {
        this._writeModelValue(this._model);
      }
    }

    isOpen() {
      return !!this._cRef;
    }
    /**
     * Opens the datepicker popup.
     *
     * If the related form control contains a valid date, the corresponding month will be opened.
     */


    open() {
      if (!this.isOpen()) {
        const cf = this._cfr.resolveComponentFactory(NgbDatepicker);

        this._cRef = this._vcRef.createComponent(cf);

        this._applyPopupStyling(this._cRef.location.nativeElement);

        this._applyDatepickerInputs(this._cRef.instance);

        this._subscribeForDatepickerOutputs(this._cRef.instance);

        this._cRef.instance.ngOnInit();

        this._cRef.instance.writeValue(this._dateAdapter.toModel(this._model)); // date selection event handling


        this._cRef.instance.registerOnChange(selectedDate => {
          this.writeValue(selectedDate);

          this._onChange(selectedDate);

          this._onTouched();
        });

        this._cRef.changeDetectorRef.detectChanges();

        this._cRef.instance.setDisabledState(this.disabled);

        if (this.container === 'body') {
          this._document.querySelector(this.container).appendChild(this._cRef.location.nativeElement);
        } // focus handling


        this._elWithFocus = this._document.activeElement;
        ngbFocusTrap(this._ngZone, this._cRef.location.nativeElement, this.closed, true);

        this._cRef.instance.focus();

        ngbAutoClose(this._ngZone, this._document, this.autoClose, () => this.close(), this.closed, [], [this._elRef.nativeElement, this._cRef.location.nativeElement]);
      }
    }
    /**
     * Closes the datepicker popup.
     */


    close() {
      if (this.isOpen()) {
        this._vcRef.remove(this._vcRef.indexOf(this._cRef.hostView));

        this._cRef = null;
        this.closed.emit();

        this._changeDetector.markForCheck(); // restore focus


        let elementToFocus = this._elWithFocus;

        if (isString(this.restoreFocus)) {
          elementToFocus = this._document.querySelector(this.restoreFocus);
        } else if (this.restoreFocus !== undefined) {
          elementToFocus = this.restoreFocus;
        } // in IE document.activeElement can contain an object without 'focus()' sometimes


        if (elementToFocus && elementToFocus['focus']) {
          elementToFocus.focus();
        } else {
          this._document.body.focus();
        }
      }
    }
    /**
     * Toggles the datepicker popup.
     */


    toggle() {
      if (this.isOpen()) {
        this.close();
      } else {
        this.open();
      }
    }
    /**
     * Navigates to the provided date.
     *
     * With the default calendar we use ISO 8601: 'month' is 1=Jan ... 12=Dec.
     * If nothing or invalid date provided calendar will open current month.
     *
     * Use the `[startDate]` input as an alternative.
     */


    navigateTo(date) {
      if (this.isOpen()) {
        this._cRef.instance.navigateTo(date);
      }
    }

    onBlur() {
      this._onTouched();
    }

    onFocus() {
      this._elWithFocus = this._elRef.nativeElement;
    }

    ngOnChanges(changes) {
      if (changes['minDate'] || changes['maxDate']) {
        this._validatorChange();

        if (this.isOpen()) {
          if (changes['minDate']) {
            this._cRef.instance.minDate = this.minDate;
          }

          if (changes['maxDate']) {
            this._cRef.instance.maxDate = this.maxDate;
          }

          this._cRef.instance.ngOnChanges(changes);
        }
      }
    }

    ngOnDestroy() {
      this.close();

      this._zoneSubscription.unsubscribe();
    }

    _applyDatepickerInputs(datepickerInstance) {
      ['dayTemplate', 'dayTemplateData', 'displayMonths', 'firstDayOfWeek', 'footerTemplate', 'markDisabled', 'minDate', 'maxDate', 'navigation', 'outsideDays', 'showNavigation', 'showWeekdays', 'showWeekNumbers'].forEach(optionName => {
        if (this[optionName] !== undefined) {
          datepickerInstance[optionName] = this[optionName];
        }
      });
      datepickerInstance.startDate = this.startDate || this._model;
    }

    _applyPopupStyling(nativeElement) {
      this._renderer.addClass(nativeElement, 'dropdown-menu');

      this._renderer.addClass(nativeElement, 'show');

      if (this.container === 'body') {
        this._renderer.addClass(nativeElement, 'ngb-dp-body');
      }
    }

    _subscribeForDatepickerOutputs(datepickerInstance) {
      datepickerInstance.navigate.subscribe(navigateEvent => this.navigate.emit(navigateEvent));
      datepickerInstance.dateSelect.subscribe(date => {
        this.dateSelect.emit(date);

        if (this.autoClose === true || this.autoClose === 'inside') {
          this.close();
        }
      });
    }

    _writeModelValue(model) {
      const value = this._parserFormatter.format(model);

      this._inputValue = value;

      this._renderer.setProperty(this._elRef.nativeElement, 'value', value);

      if (this.isOpen()) {
        this._cRef.instance.writeValue(this._dateAdapter.toModel(model));

        this._onTouched();
      }
    }

    _fromDateStruct(date) {
      const ngbDate = date ? new NgbDate(date.year, date.month, date.day) : null;
      return this._calendar.isValid(ngbDate) ? ngbDate : null;
    }

    _updatePopupPosition() {
      if (!this._cRef) {
        return;
      }

      let hostElement;

      if (isString(this.positionTarget)) {
        hostElement = this._document.querySelector(this.positionTarget);
      } else if (this.positionTarget instanceof HTMLElement) {
        hostElement = this.positionTarget;
      } else {
        hostElement = this._elRef.nativeElement;
      }

      if (this.positionTarget && !hostElement) {
        throw new Error('ngbDatepicker could not find element declared in [positionTarget] to position against.');
      }

      positionElements(hostElement, this._cRef.location.nativeElement, this.placement, this.container === 'body');
    }

  }

  NgbInputDatepicker.ɵfac = function NgbInputDatepicker_Factory(t) {
    return new (t || NgbInputDatepicker)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDateParserFormatter), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentFactoryResolver), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbCalendar), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDateAdapter), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbInputDatepickerConfig));
  };

  NgbInputDatepicker.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbInputDatepicker,
    selectors: [["input", "ngbDatepicker", ""]],
    hostVars: 1,
    hostBindings: function NgbInputDatepicker_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("input", function NgbInputDatepicker_input_HostBindingHandler($event) {
          return ctx.manualDateChange($event.target.value);
        })("change", function NgbInputDatepicker_change_HostBindingHandler($event) {
          return ctx.manualDateChange($event.target.value, true);
        })("focus", function NgbInputDatepicker_focus_HostBindingHandler() {
          return ctx.onFocus();
        })("blur", function NgbInputDatepicker_blur_HostBindingHandler() {
          return ctx.onBlur();
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("disabled", ctx.disabled);
      }
    },
    inputs: {
      disabled: "disabled",
      autoClose: "autoClose",
      dayTemplate: "dayTemplate",
      dayTemplateData: "dayTemplateData",
      displayMonths: "displayMonths",
      firstDayOfWeek: "firstDayOfWeek",
      footerTemplate: "footerTemplate",
      markDisabled: "markDisabled",
      minDate: "minDate",
      maxDate: "maxDate",
      navigation: "navigation",
      outsideDays: "outsideDays",
      placement: "placement",
      restoreFocus: "restoreFocus",
      showWeekdays: "showWeekdays",
      showWeekNumbers: "showWeekNumbers",
      startDate: "startDate",
      container: "container",
      positionTarget: "positionTarget"
    },
    outputs: {
      dateSelect: "dateSelect",
      navigate: "navigate",
      closed: "closed"
    },
    exportAs: ["ngbDatepicker"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALUE_ACCESSOR,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbInputDatepicker),
      multi: true
    }, {
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALIDATORS,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbInputDatepicker),
      multi: true
    }, {
      provide: NgbDatepickerConfig,
      useExisting: NgbInputDatepickerConfig
    }]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });
  return NgbInputDatepicker;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDatepickerDayView = /*#__PURE__*/(() => {
  class NgbDatepickerDayView {
    constructor(i18n) {
      this.i18n = i18n;
    }

    isMuted() {
      return !this.selected && (this.date.month !== this.currentMonth || this.disabled);
    }

  }

  NgbDatepickerDayView.ɵfac = function NgbDatepickerDayView_Factory(t) {
    return new (t || NgbDatepickerDayView)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerI18n));
  };

  NgbDatepickerDayView.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbDatepickerDayView,
    selectors: [["", "ngbDatepickerDayView", ""]],
    hostAttrs: [1, "btn-light"],
    hostVars: 10,
    hostBindings: function NgbDatepickerDayView_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("bg-primary", ctx.selected)("text-white", ctx.selected)("text-muted", ctx.isMuted())("outside", ctx.isMuted())("active", ctx.focused);
      }
    },
    inputs: {
      currentMonth: "currentMonth",
      date: "date",
      disabled: "disabled",
      focused: "focused",
      selected: "selected"
    },
    attrs: _c20,
    decls: 1,
    vars: 1,
    template: function NgbDatepickerDayView_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate"](ctx.i18n.getDayNumerals(ctx.date));
      }
    },
    styles: ["[ngbDatepickerDayView]{background:transparent;border-radius:.25rem;height:2rem;line-height:2rem;text-align:center;width:2rem}[ngbDatepickerDayView].outside{opacity:.5}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbDatepickerDayView;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDatepickerNavigationSelect = /*#__PURE__*/(() => {
  class NgbDatepickerNavigationSelect {
    constructor(i18n, _renderer) {
      this.i18n = i18n;
      this._renderer = _renderer;
      this.select = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this._month = -1;
      this._year = -1;
    }

    changeMonth(month) {
      this.select.emit(new NgbDate(this.date.year, toInteger(month), 1));
    }

    changeYear(year) {
      this.select.emit(new NgbDate(toInteger(year), this.date.month, 1));
    }

    ngAfterViewChecked() {
      if (this.date) {
        if (this.date.month !== this._month) {
          this._month = this.date.month;

          this._renderer.setProperty(this.monthSelect.nativeElement, 'value', this._month);
        }

        if (this.date.year !== this._year) {
          this._year = this.date.year;

          this._renderer.setProperty(this.yearSelect.nativeElement, 'value', this._year);
        }
      }
    }

  }

  NgbDatepickerNavigationSelect.ɵfac = function NgbDatepickerNavigationSelect_Factory(t) {
    return new (t || NgbDatepickerNavigationSelect)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDatepickerI18n), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2));
  };

  NgbDatepickerNavigationSelect.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbDatepickerNavigationSelect,
    selectors: [["ngb-datepicker-navigation-select"]],
    viewQuery: function NgbDatepickerNavigationSelect_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c21, 7, _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c22, 7, _angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.monthSelect = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.yearSelect = _t.first);
      }
    },
    inputs: {
      date: "date",
      disabled: "disabled",
      months: "months",
      years: "years"
    },
    outputs: {
      select: "select"
    },
    decls: 6,
    vars: 4,
    consts: function () {
      let i18n_23;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_select_month$$FESM2015_NG_BOOTSTRAP_JS_24 = goog.getMsg("Select month");
        i18n_23 = MSG_EXTERNAL_ngb_datepicker_select_month$$FESM2015_NG_BOOTSTRAP_JS_24;
      } else {
        i18n_23 = $localize`:@@ngb.datepicker.select-month␟1dbc84807f35518112f62e5775d1daebd3d8462b␟2253869508135064750:Select month`;
      }

      let i18n_25;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_select_month$$FESM2015_NG_BOOTSTRAP_JS_26 = goog.getMsg("Select month");
        i18n_25 = MSG_EXTERNAL_ngb_datepicker_select_month$$FESM2015_NG_BOOTSTRAP_JS_26;
      } else {
        i18n_25 = $localize`:@@ngb.datepicker.select-month␟1dbc84807f35518112f62e5775d1daebd3d8462b␟2253869508135064750:Select month`;
      }

      let i18n_27;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_select_year$$FESM2015_NG_BOOTSTRAP_JS_28 = goog.getMsg("Select year");
        i18n_27 = MSG_EXTERNAL_ngb_datepicker_select_year$$FESM2015_NG_BOOTSTRAP_JS_28;
      } else {
        i18n_27 = $localize`:@@ngb.datepicker.select-year␟8ceb09d002bf0c5d1cac171dfbffe1805d2b3962␟8852264961585484321:Select year`;
      }

      let i18n_29;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_datepicker_select_year$$FESM2015_NG_BOOTSTRAP_JS_30 = goog.getMsg("Select year");
        i18n_29 = MSG_EXTERNAL_ngb_datepicker_select_year$$FESM2015_NG_BOOTSTRAP_JS_30;
      } else {
        i18n_29 = $localize`:@@ngb.datepicker.select-year␟8ceb09d002bf0c5d1cac171dfbffe1805d2b3962␟8852264961585484321:Select year`;
      }

      return [["aria-label", i18n_23, "title", i18n_25, 1, "custom-select", 3, "disabled", "change"], ["month", ""], [3, "value", 4, "ngFor", "ngForOf"], ["aria-label", i18n_27, "title", i18n_29, 1, "custom-select", 3, "disabled", "change"], ["year", ""], [3, "value"]];
    },
    template: function NgbDatepickerNavigationSelect_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "select", 0, 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function NgbDatepickerNavigationSelect_Template_select_change_0_listener($event) {
          return ctx.changeMonth($event.target.value);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbDatepickerNavigationSelect_option_2_Template, 2, 3, "option", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "select", 3, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function NgbDatepickerNavigationSelect_Template_select_change_3_listener($event) {
          return ctx.changeYear($event.target.value);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, NgbDatepickerNavigationSelect_option_5_Template, 2, 2, "option", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.months);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.years);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NgSelectOption, _angular_forms__WEBPACK_IMPORTED_MODULE_13__["ɵNgSelectMultipleOption"]],
    styles: ["ngb-datepicker-navigation-select>.custom-select{-ms-flex:1 1 auto;flex:1 1 auto;font-size:.875rem;height:1.85rem;padding:0 .5rem}ngb-datepicker-navigation-select>.custom-select:focus{z-index:1}ngb-datepicker-navigation-select>.custom-select::-ms-value{background-color:transparent!important}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbDatepickerNavigationSelect;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbCalendarHijri = /*#__PURE__*/(() => {
  class NgbCalendarHijri extends NgbCalendar {
    getDaysPerWeek() {
      return 7;
    }

    getMonths() {
      return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
    }

    getWeeksPerMonth() {
      return 6;
    }

    getNext(date, period = 'd', number = 1) {
      date = new NgbDate(date.year, date.month, date.day);

      switch (period) {
        case 'y':
          date = this._setYear(date, date.year + number);
          date.month = 1;
          date.day = 1;
          return date;

        case 'm':
          date = this._setMonth(date, date.month + number);
          date.day = 1;
          return date;

        case 'd':
          return this._setDay(date, date.day + number);

        default:
          return date;
      }
    }

    getPrev(date, period = 'd', number = 1) {
      return this.getNext(date, period, -number);
    }

    getWeekday(date) {
      const day = this.toGregorian(date).getDay(); // in JS Date Sun=0, in ISO 8601 Sun=7

      return day === 0 ? 7 : day;
    }

    getWeekNumber(week, firstDayOfWeek) {
      // in JS Date Sun=0, in ISO 8601 Sun=7
      if (firstDayOfWeek === 7) {
        firstDayOfWeek = 0;
      }

      const thursdayIndex = (4 + 7 - firstDayOfWeek) % 7;
      const date = week[thursdayIndex];
      const jsDate = this.toGregorian(date);
      jsDate.setDate(jsDate.getDate() + 4 - (jsDate.getDay() || 7)); // Thursday

      const time = jsDate.getTime();
      const MuhDate = this.toGregorian(new NgbDate(date.year, 1, 1)); // Compare with Muharram 1

      return Math.floor(Math.round((time - MuhDate.getTime()) / 86400000) / 7) + 1;
    }

    getToday() {
      return this.fromGregorian(new Date());
    }

    isValid(date) {
      return date != null && isNumber(date.year) && isNumber(date.month) && isNumber(date.day) && !isNaN(this.toGregorian(date).getTime());
    }

    _setDay(date, day) {
      day = +day;
      let mDays = this.getDaysPerMonth(date.month, date.year);

      if (day <= 0) {
        while (day <= 0) {
          date = this._setMonth(date, date.month - 1);
          mDays = this.getDaysPerMonth(date.month, date.year);
          day += mDays;
        }
      } else if (day > mDays) {
        while (day > mDays) {
          day -= mDays;
          date = this._setMonth(date, date.month + 1);
          mDays = this.getDaysPerMonth(date.month, date.year);
        }
      }

      date.day = day;
      return date;
    }

    _setMonth(date, month) {
      month = +month;
      date.year = date.year + Math.floor((month - 1) / 12);
      date.month = Math.floor(((month - 1) % 12 + 12) % 12) + 1;
      return date;
    }

    _setYear(date, year) {
      date.year = +year;
      return date;
    }

  }

  NgbCalendarHijri.ɵfac = /*@__PURE__*/function () {
    let ɵNgbCalendarHijri_BaseFactory;
    return function NgbCalendarHijri_Factory(t) {
      return (ɵNgbCalendarHijri_BaseFactory || (ɵNgbCalendarHijri_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbCalendarHijri)))(t || NgbCalendarHijri);
    };
  }();

  NgbCalendarHijri.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbCalendarHijri,
    factory: NgbCalendarHijri.ɵfac
  });
  return NgbCalendarHijri;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Checks if islamic year is a leap year
 */


function isIslamicLeapYear(hYear) {
  return (14 + 11 * hYear) % 30 < 11;
}
/**
 * Checks if gregorian years is a leap year
 */


function isGregorianLeapYear(gDate) {
  const year = gDate.getFullYear();
  return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
}
/**
 * Returns the start of Hijri Month.
 * `hMonth` is 0 for Muharram, 1 for Safar, etc.
 * `hYear` is any Hijri hYear.
 */


function getIslamicMonthStart(hYear, hMonth) {
  return Math.ceil(29.5 * hMonth) + (hYear - 1) * 354 + Math.floor((3 + 11 * hYear) / 30.0);
}
/**
 * Returns the start of Hijri year.
 * `year` is any Hijri year.
 */


function getIslamicYearStart(year) {
  return (year - 1) * 354 + Math.floor((3 + 11 * year) / 30.0);
}

function mod(a, b) {
  return a - b * Math.floor(a / b);
}
/**
 * The civil calendar is one type of Hijri calendars used in islamic countries.
 * Uses a fixed cycle of alternating 29- and 30-day months,
 * with a leap day added to the last month of 11 out of every 30 years.
 * http://cldr.unicode.org/development/development-process/design-proposals/islamic-calendar-types
 * All the calculations here are based on the equations from "Calendrical Calculations" By Edward M. Reingold, Nachum
 * Dershowitz.
 */


const GREGORIAN_EPOCH = 1721425.5;
const ISLAMIC_EPOCH = 1948439.5;
let NgbCalendarIslamicCivil = /*#__PURE__*/(() => {
  class NgbCalendarIslamicCivil extends NgbCalendarHijri {
    /**
     * Returns the equivalent islamic(civil) date value for a give input Gregorian date.
     * `gDate` is a JS Date to be converted to Hijri.
     */
    fromGregorian(gDate) {
      const gYear = gDate.getFullYear(),
            gMonth = gDate.getMonth(),
            gDay = gDate.getDate();
      let julianDay = GREGORIAN_EPOCH - 1 + 365 * (gYear - 1) + Math.floor((gYear - 1) / 4) + -Math.floor((gYear - 1) / 100) + Math.floor((gYear - 1) / 400) + Math.floor((367 * (gMonth + 1) - 362) / 12 + (gMonth + 1 <= 2 ? 0 : isGregorianLeapYear(gDate) ? -1 : -2) + gDay);
      julianDay = Math.floor(julianDay) + 0.5;
      const days = julianDay - ISLAMIC_EPOCH;
      const hYear = Math.floor((30 * days + 10646) / 10631.0);
      let hMonth = Math.ceil((days - 29 - getIslamicYearStart(hYear)) / 29.5);
      hMonth = Math.min(hMonth, 11);
      const hDay = Math.ceil(days - getIslamicMonthStart(hYear, hMonth)) + 1;
      return new NgbDate(hYear, hMonth + 1, hDay);
    }
    /**
     * Returns the equivalent JS date value for a give input islamic(civil) date.
     * `hDate` is an islamic(civil) date to be converted to Gregorian.
     */


    toGregorian(hDate) {
      const hYear = hDate.year;
      const hMonth = hDate.month - 1;
      const hDay = hDate.day;
      const julianDay = hDay + Math.ceil(29.5 * hMonth) + (hYear - 1) * 354 + Math.floor((3 + 11 * hYear) / 30) + ISLAMIC_EPOCH - 1;
      const wjd = Math.floor(julianDay - 0.5) + 0.5,
            depoch = wjd - GREGORIAN_EPOCH,
            quadricent = Math.floor(depoch / 146097),
            dqc = mod(depoch, 146097),
            cent = Math.floor(dqc / 36524),
            dcent = mod(dqc, 36524),
            quad = Math.floor(dcent / 1461),
            dquad = mod(dcent, 1461),
            yindex = Math.floor(dquad / 365);
      let year = quadricent * 400 + cent * 100 + quad * 4 + yindex;

      if (!(cent === 4 || yindex === 4)) {
        year++;
      }

      const gYearStart = GREGORIAN_EPOCH + 365 * (year - 1) + Math.floor((year - 1) / 4) - Math.floor((year - 1) / 100) + Math.floor((year - 1) / 400);
      const yearday = wjd - gYearStart;
      const tjd = GREGORIAN_EPOCH - 1 + 365 * (year - 1) + Math.floor((year - 1) / 4) - Math.floor((year - 1) / 100) + Math.floor((year - 1) / 400) + Math.floor(739 / 12 + (isGregorianLeapYear(new Date(year, 3, 1)) ? -1 : -2) + 1);
      const leapadj = wjd < tjd ? 0 : isGregorianLeapYear(new Date(year, 3, 1)) ? 1 : 2;
      const month = Math.floor(((yearday + leapadj) * 12 + 373) / 367);
      const tjd2 = GREGORIAN_EPOCH - 1 + 365 * (year - 1) + Math.floor((year - 1) / 4) - Math.floor((year - 1) / 100) + Math.floor((year - 1) / 400) + Math.floor((367 * month - 362) / 12 + (month <= 2 ? 0 : isGregorianLeapYear(new Date(year, month - 1, 1)) ? -1 : -2) + 1);
      const day = wjd - tjd2 + 1;
      return new Date(year, month - 1, day);
    }
    /**
     * Returns the number of days in a specific Hijri month.
     * `month` is 1 for Muharram, 2 for Safar, etc.
     * `year` is any Hijri year.
     */


    getDaysPerMonth(month, year) {
      year = year + Math.floor(month / 13);
      month = (month - 1) % 12 + 1;
      let length = 29 + month % 2;

      if (month === 12 && isIslamicLeapYear(year)) {
        length++;
      }

      return length;
    }

  }

  NgbCalendarIslamicCivil.ɵfac = /*@__PURE__*/function () {
    let ɵNgbCalendarIslamicCivil_BaseFactory;
    return function NgbCalendarIslamicCivil_Factory(t) {
      return (ɵNgbCalendarIslamicCivil_BaseFactory || (ɵNgbCalendarIslamicCivil_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbCalendarIslamicCivil)))(t || NgbCalendarIslamicCivil);
    };
  }();

  NgbCalendarIslamicCivil.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbCalendarIslamicCivil,
    factory: NgbCalendarIslamicCivil.ɵfac
  });
  return NgbCalendarIslamicCivil;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Umalqura calendar is one type of Hijri calendars used in islamic countries.
 * This Calendar is used by Saudi Arabia for administrative purpose.
 * Unlike tabular calendars, the algorithm involves astronomical calculation, but it's still deterministic.
 * http://cldr.unicode.org/development/development-process/design-proposals/islamic-calendar-types
 */


const GREGORIAN_FIRST_DATE = new Date(1882, 10, 12);
const GREGORIAN_LAST_DATE = new Date(2174, 10, 25);
const HIJRI_BEGIN = 1300;
const HIJRI_END = 1600;
const ONE_DAY = 1000 * 60 * 60 * 24;
const MONTH_LENGTH = [// 1300-1304
'101010101010', '110101010100', '111011001001', '011011010100', '011011101010', // 1305-1309
'001101101100', '101010101101', '010101010101', '011010101001', '011110010010', // 1310-1314
'101110101001', '010111010100', '101011011010', '010101011100', '110100101101', // 1315-1319
'011010010101', '011101001010', '101101010100', '101101101010', '010110101101', // 1320-1324
'010010101110', '101001001111', '010100010111', '011010001011', '011010100101', // 1325-1329
'101011010101', '001011010110', '100101011011', '010010011101', '101001001101', // 1330-1334
'110100100110', '110110010101', '010110101100', '100110110110', '001010111010', // 1335-1339
'101001011011', '010100101011', '101010010101', '011011001010', '101011101001', // 1340-1344
'001011110100', '100101110110', '001010110110', '100101010110', '101011001010', // 1345-1349
'101110100100', '101111010010', '010111011001', '001011011100', '100101101101', // 1350-1354
'010101001101', '101010100101', '101101010010', '101110100101', '010110110100', // 1355-1359
'100110110110', '010101010111', '001010010111', '010101001011', '011010100011', // 1360-1364
'011101010010', '101101100101', '010101101010', '101010101011', '010100101011', // 1365-1369
'110010010101', '110101001010', '110110100101', '010111001010', '101011010110', // 1370-1374
'100101010111', '010010101011', '100101001011', '101010100101', '101101010010', // 1375-1379
'101101101010', '010101110101', '001001110110', '100010110111', '010001011011', // 1380-1384
'010101010101', '010110101001', '010110110100', '100111011010', '010011011101', // 1385-1389
'001001101110', '100100110110', '101010101010', '110101010100', '110110110010', // 1390-1394
'010111010101', '001011011010', '100101011011', '010010101011', '101001010101', // 1395-1399
'101101001001', '101101100100', '101101110001', '010110110100', '101010110101', // 1400-1404
'101001010101', '110100100101', '111010010010', '111011001001', '011011010100', // 1405-1409
'101011101001', '100101101011', '010010101011', '101010010011', '110101001001', // 1410-1414
'110110100100', '110110110010', '101010111001', '010010111010', '101001011011', // 1415-1419
'010100101011', '101010010101', '101100101010', '101101010101', '010101011100', // 1420-1424
'010010111101', '001000111101', '100100011101', '101010010101', '101101001010', // 1425-1429
'101101011010', '010101101101', '001010110110', '100100111011', '010010011011', // 1430-1434
'011001010101', '011010101001', '011101010100', '101101101010', '010101101100', // 1435-1439
'101010101101', '010101010101', '101100101001', '101110010010', '101110101001', // 1440-1444
'010111010100', '101011011010', '010101011010', '101010101011', '010110010101', // 1445-1449
'011101001001', '011101100100', '101110101010', '010110110101', '001010110110', // 1450-1454
'101001010110', '111001001101', '101100100101', '101101010010', '101101101010', // 1455-1459
'010110101101', '001010101110', '100100101111', '010010010111', '011001001011', // 1460-1464
'011010100101', '011010101100', '101011010110', '010101011101', '010010011101', // 1465-1469
'101001001101', '110100010110', '110110010101', '010110101010', '010110110101', // 1470-1474
'001011011010', '100101011011', '010010101101', '010110010101', '011011001010', // 1475-1479
'011011100100', '101011101010', '010011110101', '001010110110', '100101010110', // 1480-1484
'101010101010', '101101010100', '101111010010', '010111011001', '001011101010', // 1485-1489
'100101101101', '010010101101', '101010010101', '101101001010', '101110100101', // 1490-1494
'010110110010', '100110110101', '010011010110', '101010010111', '010101000111', // 1495-1499
'011010010011', '011101001001', '101101010101', '010101101010', '101001101011', // 1500-1504
'010100101011', '101010001011', '110101000110', '110110100011', '010111001010', // 1505-1509
'101011010110', '010011011011', '001001101011', '100101001011', '101010100101', // 1510-1514
'101101010010', '101101101001', '010101110101', '000101110110', '100010110111', // 1515-1519
'001001011011', '010100101011', '010101100101', '010110110100', '100111011010', // 1520-1524
'010011101101', '000101101101', '100010110110', '101010100110', '110101010010', // 1525-1529
'110110101001', '010111010100', '101011011010', '100101011011', '010010101011', // 1530-1534
'011001010011', '011100101001', '011101100010', '101110101001', '010110110010', // 1535-1539
'101010110101', '010101010101', '101100100101', '110110010010', '111011001001', // 1540-1544
'011011010010', '101011101001', '010101101011', '010010101011', '101001010101', // 1545-1549
'110100101001', '110101010100', '110110101010', '100110110101', '010010111010', // 1550-1554
'101000111011', '010010011011', '101001001101', '101010101010', '101011010101', // 1555-1559
'001011011010', '100101011101', '010001011110', '101000101110', '110010011010', // 1560-1564
'110101010101', '011010110010', '011010111001', '010010111010', '101001011101', // 1565-1569
'010100101101', '101010010101', '101101010010', '101110101000', '101110110100', // 1570-1574
'010110111001', '001011011010', '100101011010', '101101001010', '110110100100', // 1575-1579
'111011010001', '011011101000', '101101101010', '010101101101', '010100110101', // 1580-1584
'011010010101', '110101001010', '110110101000', '110111010100', '011011011010', // 1585-1589
'010101011011', '001010011101', '011000101011', '101100010101', '101101001010', // 1590-1594
'101110010101', '010110101010', '101010101110', '100100101110', '110010001111', // 1595-1599
'010100100111', '011010010101', '011010101010', '101011010110', '010101011101', // 1600
'001010011101'];

function getDaysDiff(date1, date2) {
  // Ignores the time part in date1 and date2:
  const time1 = Date.UTC(date1.getFullYear(), date1.getMonth(), date1.getDate());
  const time2 = Date.UTC(date2.getFullYear(), date2.getMonth(), date2.getDate());
  const diff = Math.abs(time1 - time2);
  return Math.round(diff / ONE_DAY);
}

let NgbCalendarIslamicUmalqura = /*#__PURE__*/(() => {
  class NgbCalendarIslamicUmalqura extends NgbCalendarIslamicCivil {
    /**
    * Returns the equivalent islamic(Umalqura) date value for a give input Gregorian date.
    * `gdate` is s JS Date to be converted to Hijri.
    */
    fromGregorian(gDate) {
      let hDay = 1,
          hMonth = 0,
          hYear = 1300;
      let daysDiff = getDaysDiff(gDate, GREGORIAN_FIRST_DATE);

      if (gDate.getTime() - GREGORIAN_FIRST_DATE.getTime() >= 0 && gDate.getTime() - GREGORIAN_LAST_DATE.getTime() <= 0) {
        let year = 1300;

        for (let i = 0; i < MONTH_LENGTH.length; i++, year++) {
          for (let j = 0; j < 12; j++) {
            let numOfDays = +MONTH_LENGTH[i][j] + 29;

            if (daysDiff <= numOfDays) {
              hDay = daysDiff + 1;

              if (hDay > numOfDays) {
                hDay = 1;
                j++;
              }

              if (j > 11) {
                j = 0;
                year++;
              }

              hMonth = j;
              hYear = year;
              return new NgbDate(hYear, hMonth + 1, hDay);
            }

            daysDiff = daysDiff - numOfDays;
          }
        }

        return null;
      } else {
        return super.fromGregorian(gDate);
      }
    }
    /**
    * Converts the current Hijri date to Gregorian.
    */


    toGregorian(hDate) {
      const hYear = hDate.year;
      const hMonth = hDate.month - 1;
      const hDay = hDate.day;
      let gDate = new Date(GREGORIAN_FIRST_DATE);
      let dayDiff = hDay - 1;

      if (hYear >= HIJRI_BEGIN && hYear <= HIJRI_END) {
        for (let y = 0; y < hYear - HIJRI_BEGIN; y++) {
          for (let m = 0; m < 12; m++) {
            dayDiff += +MONTH_LENGTH[y][m] + 29;
          }
        }

        for (let m = 0; m < hMonth; m++) {
          dayDiff += +MONTH_LENGTH[hYear - HIJRI_BEGIN][m] + 29;
        }

        gDate.setDate(GREGORIAN_FIRST_DATE.getDate() + dayDiff);
      } else {
        gDate = super.toGregorian(hDate);
      }

      return gDate;
    }
    /**
    * Returns the number of days in a specific Hijri hMonth.
    * `hMonth` is 1 for Muharram, 2 for Safar, etc.
    * `hYear` is any Hijri hYear.
    */


    getDaysPerMonth(hMonth, hYear) {
      if (hYear >= HIJRI_BEGIN && hYear <= HIJRI_END) {
        const pos = hYear - HIJRI_BEGIN;
        return +MONTH_LENGTH[pos][hMonth - 1] + 29;
      }

      return super.getDaysPerMonth(hMonth, hYear);
    }

  }

  NgbCalendarIslamicUmalqura.ɵfac = /*@__PURE__*/function () {
    let ɵNgbCalendarIslamicUmalqura_BaseFactory;
    return function NgbCalendarIslamicUmalqura_Factory(t) {
      return (ɵNgbCalendarIslamicUmalqura_BaseFactory || (ɵNgbCalendarIslamicUmalqura_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbCalendarIslamicUmalqura)))(t || NgbCalendarIslamicUmalqura);
    };
  }();

  NgbCalendarIslamicUmalqura.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbCalendarIslamicUmalqura,
    factory: NgbCalendarIslamicUmalqura.ɵfac
  });
  return NgbCalendarIslamicUmalqura;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Returns the equivalent JS date value for a give input Jalali date.
 * `jalaliDate` is an Jalali date to be converted to Gregorian.
 */


function toGregorian(jalaliDate) {
  let jdn = jalaliToJulian(jalaliDate.year, jalaliDate.month, jalaliDate.day);
  let date = julianToGregorian(jdn);
  date.setHours(6, 30, 3, 200);
  return date;
}
/**
 * Returns the equivalent jalali date value for a give input Gregorian date.
 * `gdate` is a JS Date to be converted to jalali.
 * utc to local
 */


function fromGregorian(gdate) {
  let g2d = gregorianToJulian(gdate.getFullYear(), gdate.getMonth() + 1, gdate.getDate());
  return julianToJalali(g2d);
}

function setJalaliYear(date, yearValue) {
  date.year = +yearValue;
  return date;
}

function setJalaliMonth(date, month) {
  month = +month;
  date.year = date.year + Math.floor((month - 1) / 12);
  date.month = Math.floor(((month - 1) % 12 + 12) % 12) + 1;
  return date;
}

function setJalaliDay(date, day) {
  let mDays = getDaysPerMonth(date.month, date.year);

  if (day <= 0) {
    while (day <= 0) {
      date = setJalaliMonth(date, date.month - 1);
      mDays = getDaysPerMonth(date.month, date.year);
      day += mDays;
    }
  } else if (day > mDays) {
    while (day > mDays) {
      day -= mDays;
      date = setJalaliMonth(date, date.month + 1);
      mDays = getDaysPerMonth(date.month, date.year);
    }
  }

  date.day = day;
  return date;
}

function mod$1(a, b) {
  return a - b * Math.floor(a / b);
}

function div(a, b) {
  return Math.trunc(a / b);
}
/*
 This function determines if the Jalali (Persian) year is
 leap (366-day long) or is the common year (365 days), and
 finds the day in March (Gregorian calendar) of the first
 day of the Jalali year (jalaliYear).
 @param jalaliYear Jalali calendar year (-61 to 3177)
 @return
 leap: number of years since the last leap year (0 to 4)
 gYear: Gregorian year of the beginning of Jalali year
 march: the March day of Farvardin the 1st (1st day of jalaliYear)
 @see: http://www.astro.uni.torun.pl/~kb/Papers/EMP/PersianC-EMP.htm
 @see: http://www.fourmilab.ch/documents/calendar/
 */


function jalCal(jalaliYear) {
  // Jalali years starting the 33-year rule.
  let breaks = [-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178];
  const breaksLength = breaks.length;
  const gYear = jalaliYear + 621;
  let leapJ = -14;
  let jp = breaks[0];

  if (jalaliYear < jp || jalaliYear >= breaks[breaksLength - 1]) {
    throw new Error('Invalid Jalali year ' + jalaliYear);
  } // Find the limiting years for the Jalali year jalaliYear.


  let jump;

  for (let i = 1; i < breaksLength; i += 1) {
    const jm = breaks[i];
    jump = jm - jp;

    if (jalaliYear < jm) {
      break;
    }

    leapJ = leapJ + div(jump, 33) * 8 + div(mod$1(jump, 33), 4);
    jp = jm;
  }

  let n = jalaliYear - jp; // Find the number of leap years from AD 621 to the beginning
  // of the current Jalali year in the Persian calendar.

  leapJ = leapJ + div(n, 33) * 8 + div(mod$1(n, 33) + 3, 4);

  if (mod$1(jump, 33) === 4 && jump - n === 4) {
    leapJ += 1;
  } // And the same in the Gregorian calendar (until the year gYear).


  const leapG = div(gYear, 4) - div((div(gYear, 100) + 1) * 3, 4) - 150; // Determine the Gregorian date of Farvardin the 1st.

  const march = 20 + leapJ - leapG; // Find how many years have passed since the last leap year.

  if (jump - n < 6) {
    n = n - jump + div(jump + 4, 33) * 33;
  }

  let leap = mod$1(mod$1(n + 1, 33) - 1, 4);

  if (leap === -1) {
    leap = 4;
  }

  return {
    leap: leap,
    gy: gYear,
    march: march
  };
}
/*
 Calculates Gregorian and Julian calendar dates from the Julian Day number
 (jdn) for the period since jdn=-34839655 (i.e. the year -100100 of both
 calendars) to some millions years ahead of the present.
 @param jdn Julian Day number
 @return
 gYear: Calendar year (years BC numbered 0, -1, -2, ...)
 gMonth: Calendar month (1 to 12)
 gDay: Calendar day of the month M (1 to 28/29/30/31)
 */


function julianToGregorian(julianDayNumber) {
  let j = 4 * julianDayNumber + 139361631;
  j = j + div(div(4 * julianDayNumber + 183187720, 146097) * 3, 4) * 4 - 3908;
  const i = div(mod$1(j, 1461), 4) * 5 + 308;
  const gDay = div(mod$1(i, 153), 5) + 1;
  const gMonth = mod$1(div(i, 153), 12) + 1;
  const gYear = div(j, 1461) - 100100 + div(8 - gMonth, 6);
  return new Date(gYear, gMonth - 1, gDay);
}
/*
 Converts a date of the Jalali calendar to the Julian Day number.
 @param jy Jalali year (1 to 3100)
 @param jm Jalali month (1 to 12)
 @param jd Jalali day (1 to 29/31)
 @return Julian Day number
 */


function gregorianToJulian(gy, gm, gd) {
  let d = div((gy + div(gm - 8, 6) + 100100) * 1461, 4) + div(153 * mod$1(gm + 9, 12) + 2, 5) + gd - 34840408;
  d = d - div(div(gy + 100100 + div(gm - 8, 6), 100) * 3, 4) + 752;
  return d;
}
/*
 Converts the Julian Day number to a date in the Jalali calendar.
 @param julianDayNumber Julian Day number
 @return
 jalaliYear: Jalali year (1 to 3100)
 jalaliMonth: Jalali month (1 to 12)
 jalaliDay: Jalali day (1 to 29/31)
 */


function julianToJalali(julianDayNumber) {
  let gy = julianToGregorian(julianDayNumber).getFullYear() // Calculate Gregorian year (gy).
  ,
      jalaliYear = gy - 621,
      r = jalCal(jalaliYear),
      gregorianDay = gregorianToJulian(gy, 3, r.march),
      jalaliDay,
      jalaliMonth,
      numberOfDays; // Find number of days that passed since 1 Farvardin.

  numberOfDays = julianDayNumber - gregorianDay;

  if (numberOfDays >= 0) {
    if (numberOfDays <= 185) {
      // The first 6 months.
      jalaliMonth = 1 + div(numberOfDays, 31);
      jalaliDay = mod$1(numberOfDays, 31) + 1;
      return new NgbDate(jalaliYear, jalaliMonth, jalaliDay);
    } else {
      // The remaining months.
      numberOfDays -= 186;
    }
  } else {
    // Previous Jalali year.
    jalaliYear -= 1;
    numberOfDays += 179;

    if (r.leap === 1) {
      numberOfDays += 1;
    }
  }

  jalaliMonth = 7 + div(numberOfDays, 30);
  jalaliDay = mod$1(numberOfDays, 30) + 1;
  return new NgbDate(jalaliYear, jalaliMonth, jalaliDay);
}
/*
 Converts a date of the Jalali calendar to the Julian Day number.
 @param jYear Jalali year (1 to 3100)
 @param jMonth Jalali month (1 to 12)
 @param jDay Jalali day (1 to 29/31)
 @return Julian Day number
 */


function jalaliToJulian(jYear, jMonth, jDay) {
  let r = jalCal(jYear);
  return gregorianToJulian(r.gy, 3, r.march) + (jMonth - 1) * 31 - div(jMonth, 7) * (jMonth - 7) + jDay - 1;
}
/**
 * Returns the number of days in a specific jalali month.
 */


function getDaysPerMonth(month, year) {
  if (month <= 6) {
    return 31;
  }

  if (month <= 11) {
    return 30;
  }

  if (jalCal(year).leap === 0) {
    return 30;
  }

  return 29;
}

let NgbCalendarPersian = /*#__PURE__*/(() => {
  class NgbCalendarPersian extends NgbCalendar {
    getDaysPerWeek() {
      return 7;
    }

    getMonths() {
      return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
    }

    getWeeksPerMonth() {
      return 6;
    }

    getNext(date, period = 'd', number = 1) {
      date = new NgbDate(date.year, date.month, date.day);

      switch (period) {
        case 'y':
          date = setJalaliYear(date, date.year + number);
          date.month = 1;
          date.day = 1;
          return date;

        case 'm':
          date = setJalaliMonth(date, date.month + number);
          date.day = 1;
          return date;

        case 'd':
          return setJalaliDay(date, date.day + number);

        default:
          return date;
      }
    }

    getPrev(date, period = 'd', number = 1) {
      return this.getNext(date, period, -number);
    }

    getWeekday(date) {
      const day = toGregorian(date).getDay(); // in JS Date Sun=0, in ISO 8601 Sun=7

      return day === 0 ? 7 : day;
    }

    getWeekNumber(week, firstDayOfWeek) {
      // in JS Date Sun=0, in ISO 8601 Sun=7
      if (firstDayOfWeek === 7) {
        firstDayOfWeek = 0;
      }

      const thursdayIndex = (4 + 7 - firstDayOfWeek) % 7;
      const date = week[thursdayIndex];
      const jsDate = toGregorian(date);
      jsDate.setDate(jsDate.getDate() + 4 - (jsDate.getDay() || 7)); // Thursday

      const time = jsDate.getTime();
      const startDate = toGregorian(new NgbDate(date.year, 1, 1));
      return Math.floor(Math.round((time - startDate.getTime()) / 86400000) / 7) + 1;
    }

    getToday() {
      return fromGregorian(new Date());
    }

    isValid(date) {
      return date != null && isInteger(date.year) && isInteger(date.month) && isInteger(date.day) && !isNaN(toGregorian(date).getTime());
    }

  }

  NgbCalendarPersian.ɵfac = /*@__PURE__*/function () {
    let ɵNgbCalendarPersian_BaseFactory;
    return function NgbCalendarPersian_Factory(t) {
      return (ɵNgbCalendarPersian_BaseFactory || (ɵNgbCalendarPersian_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbCalendarPersian)))(t || NgbCalendarPersian);
    };
  }();

  NgbCalendarPersian.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbCalendarPersian,
    factory: NgbCalendarPersian.ɵfac
  });
  return NgbCalendarPersian;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const PARTS_PER_HOUR = 1080;
const PARTS_PER_DAY = 24 * PARTS_PER_HOUR;
const PARTS_FRACTIONAL_MONTH = 12 * PARTS_PER_HOUR + 793;
const PARTS_PER_MONTH = 29 * PARTS_PER_DAY + PARTS_FRACTIONAL_MONTH;
const BAHARAD = 11 * PARTS_PER_HOUR + 204;
const HEBREW_DAY_ON_JAN_1_1970 = 2092591;
const GREGORIAN_EPOCH$1 = 1721425.5;

function isGregorianLeapYear$1(year) {
  return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
}

function numberOfFirstDayInYear(year) {
  let monthsBeforeYear = Math.floor((235 * year - 234) / 19);
  let fractionalMonthsBeforeYear = monthsBeforeYear * PARTS_FRACTIONAL_MONTH + BAHARAD;
  let dayNumber = monthsBeforeYear * 29 + Math.floor(fractionalMonthsBeforeYear / PARTS_PER_DAY);
  let timeOfDay = fractionalMonthsBeforeYear % PARTS_PER_DAY;
  let dayOfWeek = dayNumber % 7; // 0 == Monday

  if (dayOfWeek === 2 || dayOfWeek === 4 || dayOfWeek === 6) {
    dayNumber++;
    dayOfWeek = dayNumber % 7;
  }

  if (dayOfWeek === 1 && timeOfDay > 15 * PARTS_PER_HOUR + 204 && !isHebrewLeapYear(year)) {
    dayNumber += 2;
  } else if (dayOfWeek === 0 && timeOfDay > 21 * PARTS_PER_HOUR + 589 && isHebrewLeapYear(year - 1)) {
    dayNumber++;
  }

  return dayNumber;
}

function getDaysInGregorianMonth(month, year) {
  let days = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

  if (isGregorianLeapYear$1(year)) {
    days[1]++;
  }

  return days[month - 1];
}

function getHebrewMonths(year) {
  return isHebrewLeapYear(year) ? 13 : 12;
}
/**
 * Returns the number of days in a specific Hebrew year.
 * `year` is any Hebrew year.
 */


function getDaysInHebrewYear(year) {
  return numberOfFirstDayInYear(year + 1) - numberOfFirstDayInYear(year);
}

function isHebrewLeapYear(year) {
  if (year != null) {
    let b = (year * 12 + 17) % 19;
    return b >= (b < 0 ? -7 : 12);
  }

  return false;
}
/**
 * Returns the number of days in a specific Hebrew month.
 * `month` is 1 for Nisan, 2 for Iyar etc. Note: Hebrew leap year contains 13 months.
 * `year` is any Hebrew year.
 */


function getDaysInHebrewMonth(month, year) {
  let yearLength = numberOfFirstDayInYear(year + 1) - numberOfFirstDayInYear(year);
  let yearType = (yearLength <= 380 ? yearLength : yearLength - 30) - 353;
  let leapYear = isHebrewLeapYear(year);
  let daysInMonth = leapYear ? [30, 29, 29, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29] : [30, 29, 29, 29, 30, 29, 30, 29, 30, 29, 30, 29];

  if (yearType > 0) {
    daysInMonth[2]++; // Kislev gets an extra day in normal or complete years.
  }

  if (yearType > 1) {
    daysInMonth[1]++; // Heshvan gets an extra day in complete years only.
  }

  return daysInMonth[month - 1];
}

function getDayNumberInHebrewYear(date) {
  let numberOfDay = 0;

  for (let i = 1; i < date.month; i++) {
    numberOfDay += getDaysInHebrewMonth(i, date.year);
  }

  return numberOfDay + date.day;
}

function setHebrewMonth(date, val) {
  let after = val >= 0;

  if (!after) {
    val = -val;
  }

  while (val > 0) {
    if (after) {
      if (val > getHebrewMonths(date.year) - date.month) {
        val -= getHebrewMonths(date.year) - date.month + 1;
        date.year++;
        date.month = 1;
      } else {
        date.month += val;
        val = 0;
      }
    } else {
      if (val >= date.month) {
        date.year--;
        val -= date.month;
        date.month = getHebrewMonths(date.year);
      } else {
        date.month -= val;
        val = 0;
      }
    }
  }

  return date;
}

function setHebrewDay(date, val) {
  let after = val >= 0;

  if (!after) {
    val = -val;
  }

  while (val > 0) {
    if (after) {
      if (val > getDaysInHebrewYear(date.year) - getDayNumberInHebrewYear(date)) {
        val -= getDaysInHebrewYear(date.year) - getDayNumberInHebrewYear(date) + 1;
        date.year++;
        date.month = 1;
        date.day = 1;
      } else if (val > getDaysInHebrewMonth(date.month, date.year) - date.day) {
        val -= getDaysInHebrewMonth(date.month, date.year) - date.day + 1;
        date.month++;
        date.day = 1;
      } else {
        date.day += val;
        val = 0;
      }
    } else {
      if (val >= date.day) {
        val -= date.day;
        date.month--;

        if (date.month === 0) {
          date.year--;
          date.month = getHebrewMonths(date.year);
        }

        date.day = getDaysInHebrewMonth(date.month, date.year);
      } else {
        date.day -= val;
        val = 0;
      }
    }
  }

  return date;
}
/**
 * Returns the equivalent Hebrew date value for a give input Gregorian date.
 * `gdate` is a JS Date to be converted to Hebrew date.
 */


function fromGregorian$1(gdate) {
  const date = new Date(gdate);
  const gYear = date.getFullYear(),
        gMonth = date.getMonth(),
        gDay = date.getDate();
  let julianDay = GREGORIAN_EPOCH$1 - 1 + 365 * (gYear - 1) + Math.floor((gYear - 1) / 4) - Math.floor((gYear - 1) / 100) + Math.floor((gYear - 1) / 400) + Math.floor((367 * (gMonth + 1) - 362) / 12 + (gMonth + 1 <= 2 ? 0 : isGregorianLeapYear$1(gYear) ? -1 : -2) + gDay);
  julianDay = Math.floor(julianDay + 0.5);
  let daysSinceHebEpoch = julianDay - 347997;
  let monthsSinceHebEpoch = Math.floor(daysSinceHebEpoch * PARTS_PER_DAY / PARTS_PER_MONTH);
  let hYear = Math.floor((monthsSinceHebEpoch * 19 + 234) / 235) + 1;
  let firstDayOfThisYear = numberOfFirstDayInYear(hYear);
  let dayOfYear = daysSinceHebEpoch - firstDayOfThisYear;

  while (dayOfYear < 1) {
    hYear--;
    firstDayOfThisYear = numberOfFirstDayInYear(hYear);
    dayOfYear = daysSinceHebEpoch - firstDayOfThisYear;
  }

  let hMonth = 1;
  let hDay = dayOfYear;

  while (hDay > getDaysInHebrewMonth(hMonth, hYear)) {
    hDay -= getDaysInHebrewMonth(hMonth, hYear);
    hMonth++;
  }

  return new NgbDate(hYear, hMonth, hDay);
}
/**
 * Returns the equivalent JS date value for a given Hebrew date.
 * `hebrewDate` is an Hebrew date to be converted to Gregorian.
 */


function toGregorian$1(hebrewDate) {
  const hYear = hebrewDate.year;
  const hMonth = hebrewDate.month;
  const hDay = hebrewDate.day;
  let days = numberOfFirstDayInYear(hYear);

  for (let i = 1; i < hMonth; i++) {
    days += getDaysInHebrewMonth(i, hYear);
  }

  days += hDay;
  let diffDays = days - HEBREW_DAY_ON_JAN_1_1970;
  let after = diffDays >= 0;

  if (!after) {
    diffDays = -diffDays;
  }

  let gYear = 1970;
  let gMonth = 1;
  let gDay = 1;

  while (diffDays > 0) {
    if (after) {
      if (diffDays >= (isGregorianLeapYear$1(gYear) ? 366 : 365)) {
        diffDays -= isGregorianLeapYear$1(gYear) ? 366 : 365;
        gYear++;
      } else if (diffDays >= getDaysInGregorianMonth(gMonth, gYear)) {
        diffDays -= getDaysInGregorianMonth(gMonth, gYear);
        gMonth++;
      } else {
        gDay += diffDays;
        diffDays = 0;
      }
    } else {
      if (diffDays >= (isGregorianLeapYear$1(gYear - 1) ? 366 : 365)) {
        diffDays -= isGregorianLeapYear$1(gYear - 1) ? 366 : 365;
        gYear--;
      } else {
        if (gMonth > 1) {
          gMonth--;
        } else {
          gMonth = 12;
          gYear--;
        }

        if (diffDays >= getDaysInGregorianMonth(gMonth, gYear)) {
          diffDays -= getDaysInGregorianMonth(gMonth, gYear);
        } else {
          gDay = getDaysInGregorianMonth(gMonth, gYear) - diffDays + 1;
          diffDays = 0;
        }
      }
    }
  }

  return new Date(gYear, gMonth - 1, gDay);
}

function hebrewNumerals(numerals) {
  if (!numerals) {
    return '';
  }

  const hArray0_9 = ['', '\u05d0', '\u05d1', '\u05d2', '\u05d3', '\u05d4', '\u05d5', '\u05d6', '\u05d7', '\u05d8'];
  const hArray10_19 = ['\u05d9', '\u05d9\u05d0', '\u05d9\u05d1', '\u05d9\u05d2', '\u05d9\u05d3', '\u05d8\u05d5', '\u05d8\u05d6', '\u05d9\u05d6', '\u05d9\u05d7', '\u05d9\u05d8'];
  const hArray20_90 = ['', '', '\u05db', '\u05dc', '\u05de', '\u05e0', '\u05e1', '\u05e2', '\u05e4', '\u05e6'];
  const hArray100_900 = ['', '\u05e7', '\u05e8', '\u05e9', '\u05ea', '\u05ea\u05e7', '\u05ea\u05e8', '\u05ea\u05e9', '\u05ea\u05ea', '\u05ea\u05ea\u05e7'];
  const hArray1000_9000 = ['', '\u05d0', '\u05d1', '\u05d1\u05d0', '\u05d1\u05d1', '\u05d4', '\u05d4\u05d0', '\u05d4\u05d1', '\u05d4\u05d1\u05d0', '\u05d4\u05d1\u05d1'];
  const geresh = '\u05f3',
        gershaim = '\u05f4';
  let mem = 0;
  let result = [];
  let step = 0;

  while (numerals > 0) {
    let m = numerals % 10;

    if (step === 0) {
      mem = m;
    } else if (step === 1) {
      if (m !== 1) {
        result.unshift(hArray20_90[m], hArray0_9[mem]);
      } else {
        result.unshift(hArray10_19[mem]);
      }
    } else if (step === 2) {
      result.unshift(hArray100_900[m]);
    } else {
      if (m !== 5) {
        result.unshift(hArray1000_9000[m], geresh, ' ');
      }

      break;
    }

    numerals = Math.floor(numerals / 10);

    if (step === 0 && numerals === 0) {
      result.unshift(hArray0_9[m]);
    }

    step++;
  }

  result = result.join('').split('');

  if (result.length === 1) {
    result.push(geresh);
  } else if (result.length > 1) {
    result.splice(result.length - 1, 0, gershaim);
  }

  return result.join('');
}
/**
 * @since 3.2.0
 */


let NgbCalendarHebrew = /*#__PURE__*/(() => {
  class NgbCalendarHebrew extends NgbCalendar {
    getDaysPerWeek() {
      return 7;
    }

    getMonths(year) {
      if (year && isHebrewLeapYear(year)) {
        return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13];
      } else {
        return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
      }
    }

    getWeeksPerMonth() {
      return 6;
    }

    isValid(date) {
      if (date != null) {
        let b = isNumber(date.year) && isNumber(date.month) && isNumber(date.day);
        b = b && date.month > 0 && date.month <= (isHebrewLeapYear(date.year) ? 13 : 12);
        b = b && date.day > 0 && date.day <= getDaysInHebrewMonth(date.month, date.year);
        return b && !isNaN(toGregorian$1(date).getTime());
      }

      return false;
    }

    getNext(date, period = 'd', number = 1) {
      date = new NgbDate(date.year, date.month, date.day);

      switch (period) {
        case 'y':
          date.year += number;
          date.month = 1;
          date.day = 1;
          return date;

        case 'm':
          date = setHebrewMonth(date, number);
          date.day = 1;
          return date;

        case 'd':
          return setHebrewDay(date, number);

        default:
          return date;
      }
    }

    getPrev(date, period = 'd', number = 1) {
      return this.getNext(date, period, -number);
    }

    getWeekday(date) {
      const day = toGregorian$1(date).getDay(); // in JS Date Sun=0, in ISO 8601 Sun=7

      return day === 0 ? 7 : day;
    }

    getWeekNumber(week, firstDayOfWeek) {
      const date = week[week.length - 1];
      return Math.ceil(getDayNumberInHebrewYear(date) / 7);
    }

    getToday() {
      return fromGregorian$1(new Date());
    }
    /**
     * @since 3.4.0
     */


    toGregorian(date) {
      return fromJSDate(toGregorian$1(date));
    }
    /**
     * @since 3.4.0
     */


    fromGregorian(date) {
      return fromGregorian$1(toJSDate(date));
    }

  }

  NgbCalendarHebrew.ɵfac = /*@__PURE__*/function () {
    let ɵNgbCalendarHebrew_BaseFactory;
    return function NgbCalendarHebrew_Factory(t) {
      return (ɵNgbCalendarHebrew_BaseFactory || (ɵNgbCalendarHebrew_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbCalendarHebrew)))(t || NgbCalendarHebrew);
    };
  }();

  NgbCalendarHebrew.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbCalendarHebrew,
    factory: NgbCalendarHebrew.ɵfac
  });
  return NgbCalendarHebrew;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const WEEKDAYS = ['שני', 'שלישי', 'רביעי', 'חמישי', 'שישי', 'שבת', 'ראשון'];
const MONTHS = ['תשרי', 'חשון', 'כסלו', 'טבת', 'שבט', 'אדר', 'ניסן', 'אייר', 'סיון', 'תמוז', 'אב', 'אלול'];
const MONTHS_LEAP = ['תשרי', 'חשון', 'כסלו', 'טבת', 'שבט', 'אדר א׳', 'אדר ב׳', 'ניסן', 'אייר', 'סיון', 'תמוז', 'אב', 'אלול'];
/**
 * @since 3.2.0
 */

let NgbDatepickerI18nHebrew = /*#__PURE__*/(() => {
  class NgbDatepickerI18nHebrew extends NgbDatepickerI18n {
    getMonthShortName(month, year) {
      return this.getMonthFullName(month, year);
    }

    getMonthFullName(month, year) {
      return isHebrewLeapYear(year) ? MONTHS_LEAP[month - 1] || '' : MONTHS[month - 1] || '';
    }

    getWeekdayShortName(weekday) {
      return WEEKDAYS[weekday - 1] || '';
    }

    getDayAriaLabel(date) {
      return `${hebrewNumerals(date.day)} ${this.getMonthFullName(date.month, date.year)} ${hebrewNumerals(date.year)}`;
    }

    getDayNumerals(date) {
      return hebrewNumerals(date.day);
    }

    getWeekNumerals(weekNumber) {
      return hebrewNumerals(weekNumber);
    }

    getYearNumerals(year) {
      return hebrewNumerals(year);
    }

  }

  NgbDatepickerI18nHebrew.ɵfac = /*@__PURE__*/function () {
    let ɵNgbDatepickerI18nHebrew_BaseFactory;
    return function NgbDatepickerI18nHebrew_Factory(t) {
      return (ɵNgbDatepickerI18nHebrew_BaseFactory || (ɵNgbDatepickerI18nHebrew_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbDatepickerI18nHebrew)))(t || NgbDatepickerI18nHebrew);
    };
  }();

  NgbDatepickerI18nHebrew.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbDatepickerI18nHebrew,
    factory: NgbDatepickerI18nHebrew.ɵfac
  });
  return NgbDatepickerI18nHebrew;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * [`NgbDateAdapter`](#/components/datepicker/api#NgbDateAdapter) implementation that uses
 * native javascript dates as a user date model.
 */


let NgbDateNativeAdapter = /*#__PURE__*/(() => {
  class NgbDateNativeAdapter extends NgbDateAdapter {
    /**
     * Converts a native `Date` to a `NgbDateStruct`.
     */
    fromModel(date) {
      return date instanceof Date && !isNaN(date.getTime()) ? this._fromNativeDate(date) : null;
    }
    /**
     * Converts a `NgbDateStruct` to a native `Date`.
     */


    toModel(date) {
      return date && isInteger(date.year) && isInteger(date.month) && isInteger(date.day) ? this._toNativeDate(date) : null;
    }

    _fromNativeDate(date) {
      return {
        year: date.getFullYear(),
        month: date.getMonth() + 1,
        day: date.getDate()
      };
    }

    _toNativeDate(date) {
      const jsDate = new Date(date.year, date.month - 1, date.day, 12); // avoid 30 -> 1930 conversion

      jsDate.setFullYear(date.year);
      return jsDate;
    }

  }

  NgbDateNativeAdapter.ɵfac = /*@__PURE__*/function () {
    let ɵNgbDateNativeAdapter_BaseFactory;
    return function NgbDateNativeAdapter_Factory(t) {
      return (ɵNgbDateNativeAdapter_BaseFactory || (ɵNgbDateNativeAdapter_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbDateNativeAdapter)))(t || NgbDateNativeAdapter);
    };
  }();

  NgbDateNativeAdapter.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbDateNativeAdapter,
    factory: NgbDateNativeAdapter.ɵfac
  });
  return NgbDateNativeAdapter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Same as [`NgbDateNativeAdapter`](#/components/datepicker/api#NgbDateNativeAdapter), but with UTC dates.
 *
 * @since 3.2.0
 */


let NgbDateNativeUTCAdapter = /*#__PURE__*/(() => {
  class NgbDateNativeUTCAdapter extends NgbDateNativeAdapter {
    _fromNativeDate(date) {
      return {
        year: date.getUTCFullYear(),
        month: date.getUTCMonth() + 1,
        day: date.getUTCDate()
      };
    }

    _toNativeDate(date) {
      const jsDate = new Date(Date.UTC(date.year, date.month - 1, date.day)); // avoid 30 -> 1930 conversion

      jsDate.setUTCFullYear(date.year);
      return jsDate;
    }

  }

  NgbDateNativeUTCAdapter.ɵfac = /*@__PURE__*/function () {
    let ɵNgbDateNativeUTCAdapter_BaseFactory;
    return function NgbDateNativeUTCAdapter_Factory(t) {
      return (ɵNgbDateNativeUTCAdapter_BaseFactory || (ɵNgbDateNativeUTCAdapter_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbDateNativeUTCAdapter)))(t || NgbDateNativeUTCAdapter);
    };
  }();

  NgbDateNativeUTCAdapter.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbDateNativeUTCAdapter,
    factory: NgbDateNativeUTCAdapter.ɵfac
  });
  return NgbDateNativeUTCAdapter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbDatepickerModule = /*#__PURE__*/(() => {
  class NgbDatepickerModule {}

  NgbDatepickerModule.ɵfac = function NgbDatepickerModule_Factory(t) {
    return new (t || NgbDatepickerModule)();
  };

  NgbDatepickerModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbDatepickerModule
  });
  NgbDatepickerModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_13__.FormsModule]
  });
  return NgbDatepickerModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbDatepickerModule, {
    declarations: function () {
      return [NgbDatepicker, NgbDatepickerContent, NgbDatepickerMonth, NgbDatepickerNavigation, NgbDatepickerNavigationSelect, NgbDatepickerDayView, NgbInputDatepicker];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_13__.FormsModule];
    },
    exports: function () {
      return [NgbDatepicker, NgbDatepickerContent, NgbInputDatepicker, NgbDatepickerMonth];
    }
  });
})();
/**
 * A configuration service for the [`NgbDropdown`](#/components/dropdown/api#NgbDropdown) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the dropdowns used in the application.
 */


let NgbDropdownConfig = /*#__PURE__*/(() => {
  class NgbDropdownConfig {
    constructor() {
      this.autoClose = true;
      this.placement = ['bottom-left', 'bottom-right', 'top-left', 'top-right'];
    }

  }

  NgbDropdownConfig.ɵfac = function NgbDropdownConfig_Factory(t) {
    return new (t || NgbDropdownConfig)();
  };

  NgbDropdownConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbDropdownConfig_Factory() {
      return new NgbDropdownConfig();
    },
    token: NgbDropdownConfig,
    providedIn: "root"
  });
  return NgbDropdownConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbNavbar = /*#__PURE__*/(() => {
  class NgbNavbar {}

  NgbNavbar.ɵfac = function NgbNavbar_Factory(t) {
    return new (t || NgbNavbar)();
  };

  NgbNavbar.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbNavbar,
    selectors: [["", 8, "navbar"]]
  });
  return NgbNavbar;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive you should put on a dropdown item to enable keyboard navigation.
 * Arrow keys will move focus between items marked with this directive.
 *
 * @since 4.1.0
 */


let NgbDropdownItem = /*#__PURE__*/(() => {
  class NgbDropdownItem {
    constructor(elementRef) {
      this.elementRef = elementRef;
      this._disabled = false;
    }

    set disabled(value) {
      this._disabled = value === '' || value === true; // accept an empty attribute as true
    }

    get disabled() {
      return this._disabled;
    }

  }

  NgbDropdownItem.ɵfac = function NgbDropdownItem_Factory(t) {
    return new (t || NgbDropdownItem)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbDropdownItem.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbDropdownItem,
    selectors: [["", "ngbDropdownItem", ""]],
    hostAttrs: [1, "dropdown-item"],
    hostVars: 2,
    hostBindings: function NgbDropdownItem_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("disabled", ctx.disabled);
      }
    },
    inputs: {
      disabled: "disabled"
    }
  });
  return NgbDropdownItem;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that wraps dropdown menu content and dropdown items.
 */


let NgbDropdownMenu = /*#__PURE__*/(() => {
  class NgbDropdownMenu {
    constructor(dropdown, _elementRef) {
      this.dropdown = dropdown;
      this.placement = 'bottom';
      this.isOpen = false;
      this.nativeElement = _elementRef.nativeElement;
    }

  }

  NgbDropdownMenu.ɵfac = function NgbDropdownMenu_Factory(t) {
    return new (t || NgbDropdownMenu)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"]((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbDropdown)), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbDropdownMenu.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbDropdownMenu,
    selectors: [["", "ngbDropdownMenu", ""]],
    contentQueries: function NgbDropdownMenu_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbDropdownItem, 4);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.menuItems = _t);
      }
    },
    hostVars: 5,
    hostBindings: function NgbDropdownMenu_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("keydown.ArrowUp", function NgbDropdownMenu_keydown_ArrowUp_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.ArrowDown", function NgbDropdownMenu_keydown_ArrowDown_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Home", function NgbDropdownMenu_keydown_Home_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.End", function NgbDropdownMenu_keydown_End_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Enter", function NgbDropdownMenu_keydown_Enter_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Space", function NgbDropdownMenu_keydown_Space_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Tab", function NgbDropdownMenu_keydown_Tab_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Shift.Tab", function NgbDropdownMenu_keydown_Shift_Tab_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("x-placement", ctx.placement);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("dropdown-menu", true)("show", ctx.dropdown.isOpen());
      }
    }
  });
  return NgbDropdownMenu;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to mark an element to which dropdown menu will be anchored.
 *
 * This is a simple version of the `NgbDropdownToggle` directive.
 * It plays the same role, but doesn't listen to click events to toggle dropdown menu thus enabling support
 * for events other than click.
 *
 * @since 1.1.0
 */


let NgbDropdownAnchor = /*#__PURE__*/(() => {
  class NgbDropdownAnchor {
    constructor(dropdown, _elementRef) {
      this.dropdown = dropdown;
      this.nativeElement = _elementRef.nativeElement;
    }

  }

  NgbDropdownAnchor.ɵfac = function NgbDropdownAnchor_Factory(t) {
    return new (t || NgbDropdownAnchor)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"]((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbDropdown)), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbDropdownAnchor.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbDropdownAnchor,
    selectors: [["", "ngbDropdownAnchor", ""]],
    hostAttrs: [1, "dropdown-toggle"],
    hostVars: 1,
    hostBindings: function NgbDropdownAnchor_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-expanded", ctx.dropdown.isOpen());
      }
    }
  });
  return NgbDropdownAnchor;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to mark an element that will toggle dropdown via the `click` event.
 *
 * You can also use `NgbDropdownAnchor` as an alternative.
 */


let NgbDropdownToggle = /*#__PURE__*/(() => {
  class NgbDropdownToggle extends NgbDropdownAnchor {
    constructor(dropdown, elementRef) {
      super(dropdown, elementRef);
    }

  }

  NgbDropdownToggle.ɵfac = function NgbDropdownToggle_Factory(t) {
    return new (t || NgbDropdownToggle)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"]((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbDropdown)), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbDropdownToggle.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbDropdownToggle,
    selectors: [["", "ngbDropdownToggle", ""]],
    hostAttrs: [1, "dropdown-toggle"],
    hostVars: 1,
    hostBindings: function NgbDropdownToggle_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbDropdownToggle_click_HostBindingHandler() {
          return ctx.dropdown.toggle();
        })("keydown.ArrowUp", function NgbDropdownToggle_keydown_ArrowUp_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.ArrowDown", function NgbDropdownToggle_keydown_ArrowDown_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Home", function NgbDropdownToggle_keydown_Home_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.End", function NgbDropdownToggle_keydown_End_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Tab", function NgbDropdownToggle_keydown_Tab_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        })("keydown.Shift.Tab", function NgbDropdownToggle_keydown_Shift_Tab_HostBindingHandler($event) {
          return ctx.dropdown.onKeyDown($event);
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-expanded", ctx.dropdown.isOpen());
      }
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: NgbDropdownAnchor,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbDropdownToggle)
    }]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵInheritDefinitionFeature"]]
  });
  return NgbDropdownToggle;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that provides contextual overlays for displaying lists of links and more.
 */


let NgbDropdown = /*#__PURE__*/(() => {
  class NgbDropdown {
    constructor(_changeDetector, config, _document, _ngZone, _elementRef, _renderer, ngbNavbar) {
      this._changeDetector = _changeDetector;
      this._document = _document;
      this._ngZone = _ngZone;
      this._elementRef = _elementRef;
      this._renderer = _renderer;
      this._closed$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._bodyContainer = null;
      /**
       * Defines whether or not the dropdown menu is opened initially.
       */

      this._open = false;
      /**
       * An event fired when the dropdown is opened or closed.
       *
       * The event payload is a `boolean`:
       * * `true` - the dropdown was opened
       * * `false` - the dropdown was closed
       */

      this.openChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.placement = config.placement;
      this.container = config.container;
      this.autoClose = config.autoClose;
      this.display = ngbNavbar ? 'static' : 'dynamic';
      this._zoneSubscription = _ngZone.onStable.subscribe(() => {
        this._positionMenu();
      });
    }

    ngAfterContentInit() {
      this._ngZone.onStable.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => {
        this._applyPlacementClasses();

        if (this._open) {
          this._setCloseHandlers();
        }
      });
    }

    ngOnChanges(changes) {
      if (changes.container && this._open) {
        this._applyContainer(this.container);
      }

      if (changes.placement && !changes.placement.isFirstChange) {
        this._applyPlacementClasses();
      }
    }
    /**
     * Checks if the dropdown menu is open.
     */


    isOpen() {
      return this._open;
    }
    /**
     * Opens the dropdown menu.
     */


    open() {
      if (!this._open) {
        this._open = true;

        this._applyContainer(this.container);

        this.openChange.emit(true);

        this._setCloseHandlers();

        if (this._anchor) {
          this._anchor.nativeElement.focus();
        }
      }
    }

    _setCloseHandlers() {
      ngbAutoClose(this._ngZone, this._document, this.autoClose, source => {
        this.close();

        if (source === 0
        /* ESCAPE */
        ) {
          this._anchor.nativeElement.focus();
        }
      }, this._closed$, this._menu ? [this._menu.nativeElement] : [], this._anchor ? [this._anchor.nativeElement] : [], '.dropdown-item,.dropdown-divider');
    }
    /**
     * Closes the dropdown menu.
     */


    close() {
      if (this._open) {
        this._open = false;

        this._resetContainer();

        this._closed$.next();

        this.openChange.emit(false);

        this._changeDetector.markForCheck();
      }
    }
    /**
     * Toggles the dropdown menu.
     */


    toggle() {
      if (this.isOpen()) {
        this.close();
      } else {
        this.open();
      }
    }

    ngOnDestroy() {
      this._resetContainer();

      this._closed$.next();

      this._zoneSubscription.unsubscribe();
    }

    onKeyDown(event) {
      // tslint:disable-next-line:deprecation
      const key = event.which;

      const itemElements = this._getMenuElements();

      let position = -1;
      let itemElement = null;

      const isEventFromToggle = this._isEventFromToggle(event);

      if (!isEventFromToggle && itemElements.length) {
        itemElements.forEach((item, index) => {
          if (item.contains(event.target)) {
            itemElement = item;
          }

          if (item === this._document.activeElement) {
            position = index;
          }
        });
      } // closing on Enter / Space


      if (key === Key.Space || key === Key.Enter) {
        if (itemElement && (this.autoClose === true || this.autoClose === 'inside')) {
          // Item is either a button or a link, so click will be triggered by the browser on Enter or Space.
          // So we have to register a one-time click handler that will fire after any user defined click handlers
          // to close the dropdown
          (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(itemElement, 'click').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => this.close());
        }

        return;
      }

      if (key === Key.Tab) {
        if (event.target && this.isOpen() && this.autoClose) {
          if (this._anchor.nativeElement === event.target) {
            if (this.container === 'body' && !event.shiftKey) {
              /* This case is special: user is using [Tab] from the anchor/toggle.
                 User expects the next focusable element in the dropdown menu to get focus.
                 But the menu is not a sibling to anchor/toggle, it is at the end of the body.
                 Trick is to synchronously focus the menu element, and let the [keydown.Tab] go
                 so that browser will focus the proper element (first one focusable in the menu) */
              this._renderer.setAttribute(this._menu.nativeElement, 'tabindex', '0');

              this._menu.nativeElement.focus();

              this._renderer.removeAttribute(this._menu.nativeElement, 'tabindex');
            } else if (event.shiftKey) {
              this.close();
            }

            return;
          } else if (this.container === 'body') {
            const focusableElements = this._menu.nativeElement.querySelectorAll(FOCUSABLE_ELEMENTS_SELECTOR);

            if (event.shiftKey && event.target === focusableElements[0]) {
              this._anchor.nativeElement.focus();

              event.preventDefault();
            } else if (!event.shiftKey && event.target === focusableElements[focusableElements.length - 1]) {
              this._anchor.nativeElement.focus();

              this.close();
            }
          } else {
            (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(event.target, 'focusout').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(({
              relatedTarget
            }) => {
              if (!this._elementRef.nativeElement.contains(relatedTarget)) {
                this.close();
              }
            });
          }
        }

        return;
      } // opening / navigating


      if (isEventFromToggle || itemElement) {
        this.open();

        if (itemElements.length) {
          switch (key) {
            case Key.ArrowDown:
              position = Math.min(position + 1, itemElements.length - 1);
              break;

            case Key.ArrowUp:
              if (this._isDropup() && position === -1) {
                position = itemElements.length - 1;
                break;
              }

              position = Math.max(position - 1, 0);
              break;

            case Key.Home:
              position = 0;
              break;

            case Key.End:
              position = itemElements.length - 1;
              break;
          }

          itemElements[position].focus();
        }

        event.preventDefault();
      }
    }

    _isDropup() {
      return this._elementRef.nativeElement.classList.contains('dropup');
    }

    _isEventFromToggle(event) {
      return this._anchor.nativeElement.contains(event.target);
    }

    _getMenuElements() {
      const menu = this._menu;

      if (menu == null) {
        return [];
      }

      return menu.menuItems.filter(item => !item.disabled).map(item => item.elementRef.nativeElement);
    }

    _positionMenu() {
      const menu = this._menu;

      if (this.isOpen() && menu) {
        this._applyPlacementClasses(this.display === 'dynamic' ? positionElements(this._anchor.nativeElement, this._bodyContainer || this._menu.nativeElement, this.placement, this.container === 'body') : this._getFirstPlacement(this.placement));
      }
    }

    _getFirstPlacement(placement) {
      return Array.isArray(placement) ? placement[0] : placement.split(' ')[0];
    }

    _resetContainer() {
      const renderer = this._renderer;

      if (this._menu) {
        const dropdownElement = this._elementRef.nativeElement;
        const dropdownMenuElement = this._menu.nativeElement;
        renderer.appendChild(dropdownElement, dropdownMenuElement);
        renderer.removeStyle(dropdownMenuElement, 'position');
        renderer.removeStyle(dropdownMenuElement, 'transform');
      }

      if (this._bodyContainer) {
        renderer.removeChild(this._document.body, this._bodyContainer);
        this._bodyContainer = null;
      }
    }

    _applyContainer(container = null) {
      this._resetContainer();

      if (container === 'body') {
        const renderer = this._renderer;
        const dropdownMenuElement = this._menu.nativeElement;
        const bodyContainer = this._bodyContainer = this._bodyContainer || renderer.createElement('div'); // Override some styles to have the positionning working

        renderer.setStyle(bodyContainer, 'position', 'absolute');
        renderer.setStyle(dropdownMenuElement, 'position', 'static');
        renderer.setStyle(bodyContainer, 'z-index', '1050');
        renderer.appendChild(bodyContainer, dropdownMenuElement);
        renderer.appendChild(this._document.body, bodyContainer);
      }
    }

    _applyPlacementClasses(placement) {
      const menu = this._menu;

      if (menu) {
        if (!placement) {
          placement = this._getFirstPlacement(this.placement);
        }

        const renderer = this._renderer;
        const dropdownElement = this._elementRef.nativeElement; // remove the current placement classes

        renderer.removeClass(dropdownElement, 'dropup');
        renderer.removeClass(dropdownElement, 'dropdown');
        menu.placement = this.display === 'static' ? null : placement;
        /*
        * apply the new placement
        * in case of top use up-arrow or down-arrow otherwise
        */

        const dropdownClass = placement.search('^top') !== -1 ? 'dropup' : 'dropdown';
        renderer.addClass(dropdownElement, dropdownClass);
        const bodyContainer = this._bodyContainer;

        if (bodyContainer) {
          renderer.removeClass(bodyContainer, 'dropup');
          renderer.removeClass(bodyContainer, 'dropdown');
          renderer.addClass(bodyContainer, dropdownClass);
        }
      }
    }

  }

  NgbDropdown.ɵfac = function NgbDropdown_Factory(t) {
    return new (t || NgbDropdown)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbDropdownConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbNavbar, 8));
  };

  NgbDropdown.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbDropdown,
    selectors: [["", "ngbDropdown", ""]],
    contentQueries: function NgbDropdown_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbDropdownMenu, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbDropdownAnchor, 5);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._menu = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._anchor = _t.first);
      }
    },
    hostVars: 2,
    hostBindings: function NgbDropdown_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("show", ctx.isOpen());
      }
    },
    inputs: {
      _open: ["open", "_open"],
      placement: "placement",
      container: "container",
      autoClose: "autoClose",
      display: "display"
    },
    outputs: {
      openChange: "openChange"
    },
    exportAs: ["ngbDropdown"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });
  return NgbDropdown;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const NGB_DROPDOWN_DIRECTIVES = [NgbDropdown, NgbDropdownAnchor, NgbDropdownToggle, NgbDropdownMenu, NgbDropdownItem, NgbNavbar];
let NgbDropdownModule = /*#__PURE__*/(() => {
  class NgbDropdownModule {}

  NgbDropdownModule.ɵfac = function NgbDropdownModule_Factory(t) {
    return new (t || NgbDropdownModule)();
  };

  NgbDropdownModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbDropdownModule
  });
  NgbDropdownModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({});
  return NgbDropdownModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbDropdownModule, {
    declarations: [NgbDropdown, NgbDropdownAnchor, NgbDropdownToggle, NgbDropdownMenu, NgbDropdownItem, NgbNavbar],
    exports: [NgbDropdown, NgbDropdownAnchor, NgbDropdownToggle, NgbDropdownMenu, NgbDropdownItem, NgbNavbar]
  });
})();
/**
 * A configuration service for the [`NgbModal`](#/components/modal/api#NgbModal) service.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all modals used in the application.
*
* @since 3.1.0
*/


let NgbModalConfig = /*#__PURE__*/(() => {
  class NgbModalConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.backdrop = true;
      this.keyboard = true;
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbModalConfig.ɵfac = function NgbModalConfig_Factory(t) {
    return new (t || NgbModalConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbModalConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbModalConfig_Factory() {
      return new NgbModalConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbModalConfig,
    providedIn: "root"
  });
  return NgbModalConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

class ContentRef {
  constructor(nodes, viewRef, componentRef) {
    this.nodes = nodes;
    this.viewRef = viewRef;
    this.componentRef = componentRef;
  }

}

class PopupService {
  constructor(_type, _injector, _viewContainerRef, _renderer, _ngZone, _componentFactoryResolver, _applicationRef) {
    this._type = _type;
    this._injector = _injector;
    this._viewContainerRef = _viewContainerRef;
    this._renderer = _renderer;
    this._ngZone = _ngZone;
    this._componentFactoryResolver = _componentFactoryResolver;
    this._applicationRef = _applicationRef;
    this._windowRef = null;
    this._contentRef = null;
  }

  open(content, context, animation = false) {
    if (!this._windowRef) {
      this._contentRef = this._getContentRef(content, context);
      this._windowRef = this._viewContainerRef.createComponent(this._componentFactoryResolver.resolveComponentFactory(this._type), this._viewContainerRef.length, this._injector, this._contentRef.nodes);
    }

    const {
      nativeElement
    } = this._windowRef.location;

    const transition$ = this._ngZone.onStable.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_26__.mergeMap)(() => ngbRunTransition(this._ngZone, nativeElement, ({
      classList
    }) => classList.add('show'), {
      animation,
      runningTransition: 'continue'
    })));

    return {
      windowRef: this._windowRef,
      transition$
    };
  }

  close(animation = false) {
    if (!this._windowRef) {
      return (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.of)(undefined);
    }

    return ngbRunTransition(this._ngZone, this._windowRef.location.nativeElement, ({
      classList
    }) => classList.remove('show'), {
      animation,
      runningTransition: 'stop'
    }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_23__.tap)(() => {
      var _a;

      if (this._windowRef) {
        // this is required because of the container='body' option
        this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowRef.hostView));

        this._windowRef = null;
      }

      if ((_a = this._contentRef) === null || _a === void 0 ? void 0 : _a.viewRef) {
        this._applicationRef.detachView(this._contentRef.viewRef);

        this._contentRef.viewRef.destroy();

        this._contentRef = null;
      }
    }));
  }

  _getContentRef(content, context) {
    if (!content) {
      return new ContentRef([]);
    } else if (content instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef) {
      const viewRef = content.createEmbeddedView(context);

      this._applicationRef.attachView(viewRef);

      return new ContentRef([viewRef.rootNodes], viewRef);
    } else {
      return new ContentRef([[this._renderer.createText(`${content}`)]]);
    }
  }

}

const noop = () => {};

const ɵ0$3 = noop;
/**
 * Utility to handle the scrollbar.
 *
 * It allows to compensate the lack of a vertical scrollbar by adding an
 * equivalent padding on the right of the body, and to remove this compensation.
 */

let ScrollBar = /*#__PURE__*/(() => {
  class ScrollBar {
    constructor(_document) {
      this._document = _document;
    }
    /**
     * To be called right before a potential vertical scrollbar would be removed:
     *
     * - if there was a scrollbar, adds some compensation padding to the body
     * to keep the same layout as when the scrollbar is there
     * - if there was none, there is nothing to do
     *
     * @return a callback used to revert the compensation (noop if there was none,
     * otherwise a function removing the padding)
     */


    compensate() {
      const width = this._getWidth();

      return !this._isPresent(width) ? noop : this._adjustBody(width);
    }
    /**
     * Adds a padding of the given width on the right of the body.
     *
     * @return a callback used to revert the padding to its previous value
     */


    _adjustBody(scrollbarWidth) {
      const body = this._document.body;
      const userSetPaddingStyle = body.style.paddingRight;
      const actualPadding = parseFloat(window.getComputedStyle(body)['padding-right']);
      body.style['padding-right'] = `${actualPadding + scrollbarWidth}px`;
      return () => body.style['padding-right'] = userSetPaddingStyle;
    }
    /**
     * Tells whether a scrollbar is currently present on the body.
     *
     * @return true if scrollbar is present, false otherwise
     */


    _isPresent(scrollbarWidth) {
      const rect = this._document.body.getBoundingClientRect();

      const bodyToViewportGap = window.innerWidth - (rect.left + rect.right);
      const uncertainty = 0.1 * scrollbarWidth;
      return bodyToViewportGap >= scrollbarWidth - uncertainty;
    }
    /**
     * Calculates and returns the width of a scrollbar.
     *
     * @return the width of a scrollbar on this page
     */


    _getWidth() {
      const measurer = this._document.createElement('div');

      measurer.className = 'modal-scrollbar-measure';
      const body = this._document.body;
      body.appendChild(measurer);
      const width = measurer.getBoundingClientRect().width - measurer.clientWidth;
      body.removeChild(measurer);
      return width;
    }

  }

  ScrollBar.ɵfac = function ScrollBar_Factory(t) {
    return new (t || ScrollBar)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT));
  };

  ScrollBar.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function ScrollBar_Factory() {
      return new ScrollBar((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT));
    },
    token: ScrollBar,
    providedIn: "root"
  });
  return ScrollBar;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbModalBackdrop = /*#__PURE__*/(() => {
  class NgbModalBackdrop {
    constructor(_el, _zone) {
      this._el = _el;
      this._zone = _zone;
    }

    ngOnInit() {
      this._zone.onStable.asObservable().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => {
        ngbRunTransition(this._zone, this._el.nativeElement, (element, animation) => {
          if (animation) {
            reflow(element);
          }

          element.classList.add('show');
        }, {
          animation: this.animation,
          runningTransition: 'continue'
        });
      });
    }

    hide() {
      return ngbRunTransition(this._zone, this._el.nativeElement, ({
        classList
      }) => classList.remove('show'), {
        animation: this.animation,
        runningTransition: 'stop'
      });
    }

  }

  NgbModalBackdrop.ɵfac = function NgbModalBackdrop_Factory(t) {
    return new (t || NgbModalBackdrop)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  NgbModalBackdrop.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbModalBackdrop,
    selectors: [["ngb-modal-backdrop"]],
    hostAttrs: [2, "z-index", "1050"],
    hostVars: 6,
    hostBindings: function NgbModalBackdrop_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("modal-backdrop" + (ctx.backdropClass ? " " + ctx.backdropClass : ""));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("show", !ctx.animation)("fade", ctx.animation);
      }
    },
    inputs: {
      animation: "animation",
      backdropClass: "backdropClass"
    },
    decls: 0,
    vars: 0,
    template: function NgbModalBackdrop_Template(rf, ctx) {},
    encapsulation: 2
  });
  return NgbModalBackdrop;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A reference to the currently opened (active) modal.
 *
 * Instances of this class can be injected into your component passed as modal content.
 * So you can `.close()` or `.dismiss()` the modal window from your component.
 */


class NgbActiveModal {
  /**
   * Closes the modal with an optional `result` value.
   *
   * The `NgbModalRef.result` promise will be resolved with the provided value.
   */
  close(result) {}
  /**
   * Dismisses the modal with an optional `reason` value.
   *
   * The `NgbModalRef.result` promise will be rejected with the provided value.
   */


  dismiss(reason) {}

}
/**
 * A reference to the newly opened modal returned by the `NgbModal.open()` method.
 */


class NgbModalRef {
  constructor(_windowCmptRef, _contentRef, _backdropCmptRef, _beforeDismiss) {
    this._windowCmptRef = _windowCmptRef;
    this._contentRef = _contentRef;
    this._backdropCmptRef = _backdropCmptRef;
    this._beforeDismiss = _beforeDismiss;
    this._closed = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
    this._dismissed = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
    this._hidden = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();

    _windowCmptRef.instance.dismissEvent.subscribe(reason => {
      this.dismiss(reason);
    });

    this.result = new Promise((resolve, reject) => {
      this._resolve = resolve;
      this._reject = reject;
    });
    this.result.then(null, () => {});
  }
  /**
   * The instance of a component used for the modal content.
   *
   * When a `TemplateRef` is used as the content or when the modal is closed, will return `undefined`.
   */


  get componentInstance() {
    if (this._contentRef && this._contentRef.componentRef) {
      return this._contentRef.componentRef.instance;
    }
  }
  /**
   * The observable that emits when the modal is closed via the `.close()` method.
   *
   * It will emit the result passed to the `.close()` method.
   *
   * @since 8.0.0
   */


  get closed() {
    return this._closed.asObservable().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._hidden));
  }
  /**
   * The observable that emits when the modal is dismissed via the `.dismiss()` method.
   *
   * It will emit the reason passed to the `.dismissed()` method by the user, or one of the internal
   * reasons like backdrop click or ESC key press.
   *
   * @since 8.0.0
   */


  get dismissed() {
    return this._dismissed.asObservable().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._hidden));
  }
  /**
   * The observable that emits when both modal window and backdrop are closed and animations were finished.
   * At this point modal and backdrop elements will be removed from the DOM tree.
   *
   * This observable will be completed after emitting.
   *
   * @since 8.0.0
   */


  get hidden() {
    return this._hidden.asObservable();
  }
  /**
   * The observable that emits when modal is fully visible and animation was finished.
   * Modal DOM element is always available synchronously after calling 'modal.open()' service.
   *
   * This observable will be completed after emitting.
   * It will not emit, if modal is closed before open animation is finished.
   *
   * @since 8.0.0
   */


  get shown() {
    return this._windowCmptRef.instance.shown.asObservable();
  }
  /**
   * Closes the modal with an optional `result` value.
   *
   * The `NgbMobalRef.result` promise will be resolved with the provided value.
   */


  close(result) {
    if (this._windowCmptRef) {
      this._closed.next(result);

      this._resolve(result);

      this._removeModalElements();
    }
  }

  _dismiss(reason) {
    this._dismissed.next(reason);

    this._reject(reason);

    this._removeModalElements();
  }
  /**
   * Dismisses the modal with an optional `reason` value.
   *
   * The `NgbModalRef.result` promise will be rejected with the provided value.
   */


  dismiss(reason) {
    if (this._windowCmptRef) {
      if (!this._beforeDismiss) {
        this._dismiss(reason);
      } else {
        const dismiss = this._beforeDismiss();

        if (dismiss && dismiss.then) {
          dismiss.then(result => {
            if (result !== false) {
              this._dismiss(reason);
            }
          }, () => {});
        } else if (dismiss !== false) {
          this._dismiss(reason);
        }
      }
    }
  }

  _removeModalElements() {
    const windowTransition$ = this._windowCmptRef.instance.hide();

    const backdropTransition$ = this._backdropCmptRef ? this._backdropCmptRef.instance.hide() : (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.of)(undefined); // hiding window

    windowTransition$.subscribe(() => {
      const {
        nativeElement
      } = this._windowCmptRef.location;
      nativeElement.parentNode.removeChild(nativeElement);

      this._windowCmptRef.destroy();

      if (this._contentRef && this._contentRef.viewRef) {
        this._contentRef.viewRef.destroy();
      }

      this._windowCmptRef = null;
      this._contentRef = null;
    }); // hiding backdrop

    backdropTransition$.subscribe(() => {
      if (this._backdropCmptRef) {
        const {
          nativeElement
        } = this._backdropCmptRef.location;
        nativeElement.parentNode.removeChild(nativeElement);

        this._backdropCmptRef.destroy();

        this._backdropCmptRef = null;
      }
    }); // all done

    (0,rxjs__WEBPACK_IMPORTED_MODULE_21__.zip)(windowTransition$, backdropTransition$).subscribe(() => {
      this._hidden.next();

      this._hidden.complete();
    });
  }

}

var ModalDismissReasons = /*#__PURE__*/(() => {
  (function (ModalDismissReasons) {
    ModalDismissReasons[ModalDismissReasons["BACKDROP_CLICK"] = 0] = "BACKDROP_CLICK";
    ModalDismissReasons[ModalDismissReasons["ESC"] = 1] = "ESC";
  })(ModalDismissReasons || (ModalDismissReasons = {}));

  return ModalDismissReasons;
})();
let NgbModalWindow = /*#__PURE__*/(() => {
  class NgbModalWindow {
    constructor(_document, _elRef, _zone) {
      this._document = _document;
      this._elRef = _elRef;
      this._zone = _zone;
      this._closed$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._elWithFocus = null; // element that is focused prior to modal opening

      this.backdrop = true;
      this.keyboard = true;
      this.dismissEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.shown = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this.hidden = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
    }

    dismiss(reason) {
      this.dismissEvent.emit(reason);
    }

    ngOnInit() {
      this._elWithFocus = this._document.activeElement;
    }

    ngAfterViewInit() {
      this._show();
    }

    ngOnDestroy() {
      this._disableEventHandling();
    }

    hide() {
      const {
        nativeElement
      } = this._elRef;
      const context = {
        animation: this.animation,
        runningTransition: 'stop'
      };
      const windowTransition$ = ngbRunTransition(this._zone, nativeElement, () => nativeElement.classList.remove('show'), context);
      const dialogTransition$ = ngbRunTransition(this._zone, this._dialogEl.nativeElement, () => {}, context);
      const transitions$ = (0,rxjs__WEBPACK_IMPORTED_MODULE_21__.zip)(windowTransition$, dialogTransition$);
      transitions$.subscribe(() => {
        this.hidden.next();
        this.hidden.complete();
      });

      this._disableEventHandling();

      this._restoreFocus();

      return transitions$;
    }

    _show() {
      const context = {
        animation: this.animation,
        runningTransition: 'continue'
      };
      const windowTransition$ = ngbRunTransition(this._zone, this._elRef.nativeElement, (element, animation) => {
        if (animation) {
          reflow(element);
        }

        element.classList.add('show');
      }, context);
      const dialogTransition$ = ngbRunTransition(this._zone, this._dialogEl.nativeElement, () => {}, context);
      (0,rxjs__WEBPACK_IMPORTED_MODULE_21__.zip)(windowTransition$, dialogTransition$).subscribe(() => {
        this.shown.next();
        this.shown.complete();
      });

      this._enableEventHandling();

      this._setFocus();
    }

    _enableEventHandling() {
      const {
        nativeElement
      } = this._elRef;

      this._zone.runOutsideAngular(() => {
        (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(nativeElement, 'keydown').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._closed$), // tslint:disable-next-line:deprecation
        (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(e => e.which === Key.Escape)).subscribe(event => {
          if (this.keyboard) {
            requestAnimationFrame(() => {
              if (!event.defaultPrevented) {
                this._zone.run(() => this.dismiss(ModalDismissReasons.ESC));
              }
            });
          } else if (this.backdrop === 'static') {
            this._bumpBackdrop();
          }
        }); // We're listening to 'mousedown' and 'mouseup' to prevent modal from closing when pressing the mouse
        // inside the modal dialog and releasing it outside

        let preventClose = false;
        (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(this._dialogEl.nativeElement, 'mousedown').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._closed$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_23__.tap)(() => preventClose = false), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_19__.switchMap)(() => (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(nativeElement, 'mouseup').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._closed$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1))), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(({
          target
        }) => nativeElement === target)).subscribe(() => {
          preventClose = true;
        }); // We're listening to 'click' to dismiss modal on modal window click, except when:
        // 1. clicking on modal dialog itself
        // 2. closing was prevented by mousedown/up handlers
        // 3. clicking on scrollbar when the viewport is too small and modal doesn't fit (click is not triggered at all)

        (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(nativeElement, 'click').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this._closed$)).subscribe(({
          target
        }) => {
          if (nativeElement === target) {
            if (this.backdrop === 'static') {
              this._bumpBackdrop();
            } else if (this.backdrop === true && !preventClose) {
              this._zone.run(() => this.dismiss(ModalDismissReasons.BACKDROP_CLICK));
            }
          }

          preventClose = false;
        });
      });
    }

    _disableEventHandling() {
      this._closed$.next();
    }

    _setFocus() {
      const {
        nativeElement
      } = this._elRef;

      if (!nativeElement.contains(document.activeElement)) {
        const autoFocusable = nativeElement.querySelector(`[ngbAutofocus]`);
        const firstFocusable = getFocusableBoundaryElements(nativeElement)[0];
        const elementToFocus = autoFocusable || firstFocusable || nativeElement;
        elementToFocus.focus();
      }
    }

    _restoreFocus() {
      const body = this._document.body;
      const elWithFocus = this._elWithFocus;
      let elementToFocus;

      if (elWithFocus && elWithFocus['focus'] && body.contains(elWithFocus)) {
        elementToFocus = elWithFocus;
      } else {
        elementToFocus = body;
      }

      this._zone.runOutsideAngular(() => {
        setTimeout(() => elementToFocus.focus());
        this._elWithFocus = null;
      });
    }

    _bumpBackdrop() {
      if (this.backdrop === 'static') {
        ngbRunTransition(this._zone, this._elRef.nativeElement, ({
          classList
        }) => {
          classList.add('modal-static');
          return () => classList.remove('modal-static');
        }, {
          animation: this.animation,
          runningTransition: 'continue'
        });
      }
    }

  }

  NgbModalWindow.ɵfac = function NgbModalWindow_Factory(t) {
    return new (t || NgbModalWindow)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  NgbModalWindow.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbModalWindow,
    selectors: [["ngb-modal-window"]],
    viewQuery: function NgbModalWindow_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](_c31, 7);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._dialogEl = _t.first);
      }
    },
    hostAttrs: ["role", "dialog", "tabindex", "-1"],
    hostVars: 7,
    hostBindings: function NgbModalWindow_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-modal", true)("aria-labelledby", ctx.ariaLabelledBy)("aria-describedby", ctx.ariaDescribedBy);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("modal d-block" + (ctx.windowClass ? " " + ctx.windowClass : ""));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("fade", ctx.animation);
      }
    },
    inputs: {
      backdrop: "backdrop",
      keyboard: "keyboard",
      animation: "animation",
      ariaLabelledBy: "ariaLabelledBy",
      ariaDescribedBy: "ariaDescribedBy",
      centered: "centered",
      scrollable: "scrollable",
      size: "size",
      windowClass: "windowClass"
    },
    outputs: {
      dismissEvent: "dismiss"
    },
    ngContentSelectors: _c3,
    decls: 4,
    vars: 2,
    consts: [["role", "document"], ["dialog", ""], [1, "modal-content"]],
    template: function NgbModalWindow_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0, 1)(2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("modal-dialog" + (ctx.size ? " modal-" + ctx.size : "") + (ctx.centered ? " modal-dialog-centered" : "") + (ctx.scrollable ? " modal-dialog-scrollable" : ""));
      }
    },
    styles: ["ngb-modal-window .component-host-scrollable{-ms-flex-direction:column;display:-ms-flexbox;display:flex;flex-direction:column;overflow:hidden}"],
    encapsulation: 2
  });
  return NgbModalWindow;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbModalStack = /*#__PURE__*/(() => {
  class NgbModalStack {
    constructor(_applicationRef, _injector, _document, _scrollBar, _rendererFactory, _ngZone) {
      this._applicationRef = _applicationRef;
      this._injector = _injector;
      this._document = _document;
      this._scrollBar = _scrollBar;
      this._rendererFactory = _rendererFactory;
      this._ngZone = _ngZone;
      this._activeWindowCmptHasChanged = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._ariaHiddenValues = new Map();
      this._backdropAttributes = ['animation', 'backdropClass'];
      this._modalRefs = [];
      this._windowAttributes = ['animation', 'ariaLabelledBy', 'ariaDescribedBy', 'backdrop', 'centered', 'keyboard', 'scrollable', 'size', 'windowClass'];
      this._windowCmpts = [];
      this._activeInstances = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter(); // Trap focus on active WindowCmpt

      this._activeWindowCmptHasChanged.subscribe(() => {
        if (this._windowCmpts.length) {
          const activeWindowCmpt = this._windowCmpts[this._windowCmpts.length - 1];
          ngbFocusTrap(this._ngZone, activeWindowCmpt.location.nativeElement, this._activeWindowCmptHasChanged);

          this._revertAriaHidden();

          this._setAriaHidden(activeWindowCmpt.location.nativeElement);
        }
      });
    }

    open(moduleCFR, contentInjector, content, options) {
      const containerEl = options.container instanceof HTMLElement ? options.container : isDefined(options.container) ? this._document.querySelector(options.container) : this._document.body;

      const renderer = this._rendererFactory.createRenderer(null, null);

      const revertPaddingForScrollBar = this._scrollBar.compensate();

      const removeBodyClass = () => {
        if (!this._modalRefs.length) {
          renderer.removeClass(this._document.body, 'modal-open');

          this._revertAriaHidden();
        }
      };

      if (!containerEl) {
        throw new Error(`The specified modal container "${options.container || 'body'}" was not found in the DOM.`);
      }

      const activeModal = new NgbActiveModal();

      const contentRef = this._getContentRef(moduleCFR, options.injector || contentInjector, content, activeModal, options);

      let backdropCmptRef = options.backdrop !== false ? this._attachBackdrop(moduleCFR, containerEl) : undefined;

      let windowCmptRef = this._attachWindowComponent(moduleCFR, containerEl, contentRef);

      let ngbModalRef = new NgbModalRef(windowCmptRef, contentRef, backdropCmptRef, options.beforeDismiss);

      this._registerModalRef(ngbModalRef);

      this._registerWindowCmpt(windowCmptRef);

      ngbModalRef.result.then(revertPaddingForScrollBar, revertPaddingForScrollBar);
      ngbModalRef.result.then(removeBodyClass, removeBodyClass);

      activeModal.close = result => {
        ngbModalRef.close(result);
      };

      activeModal.dismiss = reason => {
        ngbModalRef.dismiss(reason);
      };

      this._applyWindowOptions(windowCmptRef.instance, options);

      if (this._modalRefs.length === 1) {
        renderer.addClass(this._document.body, 'modal-open');
      }

      if (backdropCmptRef && backdropCmptRef.instance) {
        this._applyBackdropOptions(backdropCmptRef.instance, options);
      }

      return ngbModalRef;
    }

    get activeInstances() {
      return this._activeInstances;
    }

    dismissAll(reason) {
      this._modalRefs.forEach(ngbModalRef => ngbModalRef.dismiss(reason));
    }

    hasOpenModals() {
      return this._modalRefs.length > 0;
    }

    _attachBackdrop(moduleCFR, containerEl) {
      let backdropFactory = moduleCFR.resolveComponentFactory(NgbModalBackdrop);
      let backdropCmptRef = backdropFactory.create(this._injector);

      this._applicationRef.attachView(backdropCmptRef.hostView);

      containerEl.appendChild(backdropCmptRef.location.nativeElement);
      return backdropCmptRef;
    }

    _attachWindowComponent(moduleCFR, containerEl, contentRef) {
      let windowFactory = moduleCFR.resolveComponentFactory(NgbModalWindow);
      let windowCmptRef = windowFactory.create(this._injector, contentRef.nodes);

      this._applicationRef.attachView(windowCmptRef.hostView);

      containerEl.appendChild(windowCmptRef.location.nativeElement);
      return windowCmptRef;
    }

    _applyWindowOptions(windowInstance, options) {
      this._windowAttributes.forEach(optionName => {
        if (isDefined(options[optionName])) {
          windowInstance[optionName] = options[optionName];
        }
      });
    }

    _applyBackdropOptions(backdropInstance, options) {
      this._backdropAttributes.forEach(optionName => {
        if (isDefined(options[optionName])) {
          backdropInstance[optionName] = options[optionName];
        }
      });
    }

    _getContentRef(moduleCFR, contentInjector, content, activeModal, options) {
      if (!content) {
        return new ContentRef([]);
      } else if (content instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef) {
        return this._createFromTemplateRef(content, activeModal);
      } else if (isString(content)) {
        return this._createFromString(content);
      } else {
        return this._createFromComponent(moduleCFR, contentInjector, content, activeModal, options);
      }
    }

    _createFromTemplateRef(content, activeModal) {
      const context = {
        $implicit: activeModal,

        close(result) {
          activeModal.close(result);
        },

        dismiss(reason) {
          activeModal.dismiss(reason);
        }

      };
      const viewRef = content.createEmbeddedView(context);

      this._applicationRef.attachView(viewRef);

      return new ContentRef([viewRef.rootNodes], viewRef);
    }

    _createFromString(content) {
      const component = this._document.createTextNode(`${content}`);

      return new ContentRef([[component]]);
    }

    _createFromComponent(moduleCFR, contentInjector, content, context, options) {
      const contentCmptFactory = moduleCFR.resolveComponentFactory(content);
      const modalContentInjector = _angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector.create({
        providers: [{
          provide: NgbActiveModal,
          useValue: context
        }],
        parent: contentInjector
      });
      const componentRef = contentCmptFactory.create(modalContentInjector);
      const componentNativeEl = componentRef.location.nativeElement;

      if (options.scrollable) {
        componentNativeEl.classList.add('component-host-scrollable');
      }

      this._applicationRef.attachView(componentRef.hostView); // FIXME: we should here get rid of the component nativeElement
      // and use `[Array.from(componentNativeEl.childNodes)]` instead and remove the above CSS class.


      return new ContentRef([[componentNativeEl]], componentRef.hostView, componentRef);
    }

    _setAriaHidden(element) {
      const parent = element.parentElement;

      if (parent && element !== this._document.body) {
        Array.from(parent.children).forEach(sibling => {
          if (sibling !== element && sibling.nodeName !== 'SCRIPT') {
            this._ariaHiddenValues.set(sibling, sibling.getAttribute('aria-hidden'));

            sibling.setAttribute('aria-hidden', 'true');
          }
        });

        this._setAriaHidden(parent);
      }
    }

    _revertAriaHidden() {
      this._ariaHiddenValues.forEach((value, element) => {
        if (value) {
          element.setAttribute('aria-hidden', value);
        } else {
          element.removeAttribute('aria-hidden');
        }
      });

      this._ariaHiddenValues.clear();
    }

    _registerModalRef(ngbModalRef) {
      const unregisterModalRef = () => {
        const index = this._modalRefs.indexOf(ngbModalRef);

        if (index > -1) {
          this._modalRefs.splice(index, 1);

          this._activeInstances.emit(this._modalRefs);
        }
      };

      this._modalRefs.push(ngbModalRef);

      this._activeInstances.emit(this._modalRefs);

      ngbModalRef.result.then(unregisterModalRef, unregisterModalRef);
    }

    _registerWindowCmpt(ngbWindowCmpt) {
      this._windowCmpts.push(ngbWindowCmpt);

      this._activeWindowCmptHasChanged.next();

      ngbWindowCmpt.onDestroy(() => {
        const index = this._windowCmpts.indexOf(ngbWindowCmpt);

        if (index > -1) {
          this._windowCmpts.splice(index, 1);

          this._activeWindowCmptHasChanged.next();
        }
      });
    }

  }

  NgbModalStack.ɵfac = function NgbModalStack_Factory(t) {
    return new (t || NgbModalStack)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ApplicationRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](ScrollBar), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.RendererFactory2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  NgbModalStack.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbModalStack_Factory() {
      return new NgbModalStack((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.ApplicationRef), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.INJECTOR), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(ScrollBar), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.RendererFactory2), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
    },
    token: NgbModalStack,
    providedIn: "root"
  });
  return NgbModalStack;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A service for opening modal windows.
 *
 * Creating a modal is straightforward: create a component or a template and pass it as an argument to
 * the `.open()` method.
 */


let NgbModal = /*#__PURE__*/(() => {
  class NgbModal {
    constructor(_moduleCFR, _injector, _modalStack, _config) {
      this._moduleCFR = _moduleCFR;
      this._injector = _injector;
      this._modalStack = _modalStack;
      this._config = _config;
    }
    /**
     * Opens a new modal window with the specified content and supplied options.
     *
     * Content can be provided as a `TemplateRef` or a component type. If you pass a component type as content,
     * then instances of those components can be injected with an instance of the `NgbActiveModal` class. You can then
     * use `NgbActiveModal` methods to close / dismiss modals from "inside" of your component.
     *
     * Also see the [`NgbModalOptions`](#/components/modal/api#NgbModalOptions) for the list of supported options.
     */


    open(content, options = {}) {
      const combinedOptions = Object.assign(Object.assign(Object.assign({}, this._config), {
        animation: this._config.animation
      }), options);
      return this._modalStack.open(this._moduleCFR, this._injector, content, combinedOptions);
    }
    /**
     * Returns an observable that holds the active modal instances.
     */


    get activeInstances() {
      return this._modalStack.activeInstances;
    }
    /**
     * Dismisses all currently displayed modal windows with the supplied reason.
     *
     * @since 3.1.0
     */


    dismissAll(reason) {
      this._modalStack.dismissAll(reason);
    }
    /**
     * Indicates if there are currently any open modal windows in the application.
     *
     * @since 3.3.0
     */


    hasOpenModals() {
      return this._modalStack.hasOpenModals();
    }

  }

  NgbModal.ɵfac = function NgbModal_Factory(t) {
    return new (t || NgbModal)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentFactoryResolver), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbModalStack), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbModalConfig));
  };

  NgbModal.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbModal_Factory() {
      return new NgbModal((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentFactoryResolver), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.INJECTOR), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbModalStack), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbModalConfig));
    },
    token: NgbModal,
    providedIn: "root"
  });
  return NgbModal;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbModalModule = /*#__PURE__*/(() => {
  class NgbModalModule {}

  NgbModalModule.ɵfac = function NgbModalModule_Factory(t) {
    return new (t || NgbModalModule)();
  };

  NgbModalModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbModalModule
  });
  NgbModalModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    providers: [NgbModal]
  });
  return NgbModalModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbModalModule, {
    declarations: [NgbModalBackdrop, NgbModalWindow]
  });
})();
/**
 * A configuration service for the [`NgbNav`](#/components/nav/api#NgbNav) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the navs used in the application.
 *
 * @since 5.2.0
 */


let NgbNavConfig = /*#__PURE__*/(() => {
  class NgbNavConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.destroyOnHide = true;
      this.orientation = 'horizontal';
      this.roles = 'tablist';
      this.keyboard = false;
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbNavConfig.ɵfac = function NgbNavConfig_Factory(t) {
    return new (t || NgbNavConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbNavConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbNavConfig_Factory() {
      return new NgbNavConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbNavConfig,
    providedIn: "root"
  });
  return NgbNavConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const isValidNavId = id => isDefined(id) && id !== '';

const ɵ0$4 = isValidNavId;
let navCounter = 0;
/**
 * This directive must be used to wrap content to be displayed in the nav.
 *
 * @since 5.2.0
 */

let NgbNavContent = /*#__PURE__*/(() => {
  class NgbNavContent {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbNavContent.ɵfac = function NgbNavContent_Factory(t) {
    return new (t || NgbNavContent)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbNavContent.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbNavContent,
    selectors: [["ng-template", "ngbNavContent", ""]]
  });
  return NgbNavContent;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * The directive used to group nav link and related nav content. As well as set nav identifier and some options.
 *
 * @since 5.2.0
 */


let NgbNavItem = /*#__PURE__*/(() => {
  class NgbNavItem {
    constructor(nav, elementRef) {
      this.elementRef = elementRef;
      /**
       * If `true`, the current nav item is disabled and can't be toggled by user.
       *
       * Nevertheless disabled nav can be selected programmatically via the `.select()` method and the `[activeId]` binding.
       */

      this.disabled = false;
      /**
       * An event emitted when the fade in transition is finished on the related nav content
       *
       * @since 8.0.0
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the fade out transition is finished on the related nav content
       *
       * @since 8.0.0
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter(); // TODO: cf https://github.com/angular/angular/issues/30106

      this._nav = nav;
    }

    ngAfterContentChecked() {
      // We are using @ContentChildren instead of @ContentChild as in the Angular version being used
      // only @ContentChildren allows us to specify the {descendants: false} option.
      // Without {descendants: false} we are hitting bugs described in:
      // https://github.com/ng-bootstrap/ng-bootstrap/issues/2240
      this.contentTpl = this.contentTpls.first;
    }

    ngOnInit() {
      if (!isDefined(this.domId)) {
        this.domId = `ngb-nav-${navCounter++}`;
      }
    }

    get active() {
      return this._nav.activeId === this.id;
    }

    get id() {
      return isValidNavId(this._id) ? this._id : this.domId;
    }

    get panelDomId() {
      return `${this.domId}-panel`;
    }

    isPanelInDom() {
      return (isDefined(this.destroyOnHide) ? !this.destroyOnHide : !this._nav.destroyOnHide) || this.active;
    }

  }

  NgbNavItem.ɵfac = function NgbNavItem_Factory(t) {
    return new (t || NgbNavItem)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"]((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbNav)), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbNavItem.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbNavItem,
    selectors: [["", "ngbNavItem", ""]],
    contentQueries: function NgbNavItem_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbNavContent, 4);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.contentTpls = _t);
      }
    },
    hostVars: 2,
    hostBindings: function NgbNavItem_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("nav-item", true);
      }
    },
    inputs: {
      disabled: "disabled",
      domId: "domId",
      destroyOnHide: "destroyOnHide",
      _id: ["ngbNavItem", "_id"]
    },
    outputs: {
      shown: "shown",
      hidden: "hidden"
    },
    exportAs: ["ngbNavItem"]
  });
  return NgbNavItem;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A nav directive that helps with implementing tabbed navigation components.
 *
 * @since 5.2.0
 */


let NgbNav = /*#__PURE__*/(() => {
  class NgbNav {
    constructor(role, config, _cd, _document) {
      this.role = role;
      this._cd = _cd;
      this._document = _document;
      /**
       * The event emitted after the active nav changes
       * The payload of the event is the newly active nav id
       *
       * If you want to prevent nav change, you should use `(navChange)` event
       */

      this.activeIdChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the fade in transition is finished for one of the items.
       *
       * Payload of the event is the nav id that was just shown.
       *
       * @since 8.0.0
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the fade out transition is finished for one of the items.
       *
       * Payload of the event is the nav id that was just hidden.
       *
       * @since 8.0.0
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.destroy$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this.navItemChange$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      /**
       * The nav change event emitted right before the nav change happens on user click.
       *
       * This event won't be emitted if nav is changed programmatically via `[activeId]` or `.select()`.
       *
       * See [`NgbNavChangeEvent`](#/components/nav/api#NgbNavChangeEvent) for payload details.
       */

      this.navChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.animation = config.animation;
      this.destroyOnHide = config.destroyOnHide;
      this.orientation = config.orientation;
      this.roles = config.roles;
      this.keyboard = config.keyboard;
    }

    click(item) {
      if (!item.disabled) {
        this._updateActiveId(item.id);
      }
    }

    onKeyDown(event) {
      if (this.roles !== 'tablist' || !this.keyboard) {
        return;
      } // tslint:disable-next-line: deprecation


      const key = event.which;
      const enabledLinks = this.links.filter(link => !link.navItem.disabled);
      const {
        length
      } = enabledLinks;
      let position = -1;
      enabledLinks.forEach((link, index) => {
        if (link.elRef.nativeElement === this._document.activeElement) {
          position = index;
        }
      });

      if (length) {
        switch (key) {
          case Key.ArrowLeft:
            if (this.orientation === 'vertical') {
              return;
            }

            position = (position - 1 + length) % length;
            break;

          case Key.ArrowRight:
            if (this.orientation === 'vertical') {
              return;
            }

            position = (position + 1) % length;
            break;

          case Key.ArrowDown:
            if (this.orientation === 'horizontal') {
              return;
            }

            position = (position + 1) % length;
            break;

          case Key.ArrowUp:
            if (this.orientation === 'horizontal') {
              return;
            }

            position = (position - 1 + length) % length;
            break;

          case Key.Home:
            position = 0;
            break;

          case Key.End:
            position = length - 1;
            break;
        }

        if (this.keyboard === 'changeWithArrows') {
          this.select(enabledLinks[position].navItem.id);
        }

        enabledLinks[position].elRef.nativeElement.focus();
        event.preventDefault();
      }
    }
    /**
     * Selects the nav with the given id and shows its associated pane.
     * Any other nav that was previously selected becomes unselected and its associated pane is hidden.
     */


    select(id) {
      this._updateActiveId(id, false);
    }

    ngAfterContentInit() {
      if (!isDefined(this.activeId)) {
        const nextId = this.items.first ? this.items.first.id : null;

        if (isValidNavId(nextId)) {
          this._updateActiveId(nextId, false);

          this._cd.detectChanges();
        }
      }

      this.items.changes.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this.destroy$)).subscribe(() => this._notifyItemChanged(this.activeId));
    }

    ngOnChanges({
      activeId
    }) {
      if (activeId && !activeId.firstChange) {
        this._notifyItemChanged(activeId.currentValue);
      }
    }

    ngOnDestroy() {
      this.destroy$.next();
    }

    _updateActiveId(nextId, emitNavChange = true) {
      if (this.activeId !== nextId) {
        let defaultPrevented = false;

        if (emitNavChange) {
          this.navChange.emit({
            activeId: this.activeId,
            nextId,
            preventDefault: () => {
              defaultPrevented = true;
            }
          });
        }

        if (!defaultPrevented) {
          this.activeId = nextId;
          this.activeIdChange.emit(nextId);

          this._notifyItemChanged(nextId);
        }
      }
    }

    _notifyItemChanged(nextItemId) {
      this.navItemChange$.next(this._getItemById(nextItemId));
    }

    _getItemById(itemId) {
      return this.items && this.items.find(item => item.id === itemId) || null;
    }

  }

  NgbNav.ɵfac = function NgbNav_Factory(t) {
    return new (t || NgbNav)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinjectAttribute"]('role'), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbNavConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT));
  };

  NgbNav.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbNav,
    selectors: [["", "ngbNav", ""]],
    contentQueries: function NgbNav_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbNavItem, 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbNavLink, 5);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.items = _t);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.links = _t);
      }
    },
    hostVars: 6,
    hostBindings: function NgbNav_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("keydown.arrowLeft", function NgbNav_keydown_arrowLeft_HostBindingHandler($event) {
          return ctx.onKeyDown($event);
        })("keydown.arrowRight", function NgbNav_keydown_arrowRight_HostBindingHandler($event) {
          return ctx.onKeyDown($event);
        })("keydown.arrowDown", function NgbNav_keydown_arrowDown_HostBindingHandler($event) {
          return ctx.onKeyDown($event);
        })("keydown.arrowUp", function NgbNav_keydown_arrowUp_HostBindingHandler($event) {
          return ctx.onKeyDown($event);
        })("keydown.Home", function NgbNav_keydown_Home_HostBindingHandler($event) {
          return ctx.onKeyDown($event);
        })("keydown.End", function NgbNav_keydown_End_HostBindingHandler($event) {
          return ctx.onKeyDown($event);
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-orientation", ctx.orientation === "vertical" && ctx.roles === "tablist" ? "vertical" : undefined)("role", ctx.role ? ctx.role : ctx.roles ? "tablist" : undefined);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("nav", true)("flex-column", ctx.orientation === "vertical");
      }
    },
    inputs: {
      animation: "animation",
      destroyOnHide: "destroyOnHide",
      orientation: "orientation",
      roles: "roles",
      keyboard: "keyboard",
      activeId: "activeId"
    },
    outputs: {
      activeIdChange: "activeIdChange",
      shown: "shown",
      hidden: "hidden",
      navChange: "navChange"
    },
    exportAs: ["ngbNav"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });
  return NgbNav;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to put on the nav link.
 *
 * @since 5.2.0
 */


let NgbNavLink = /*#__PURE__*/(() => {
  class NgbNavLink {
    constructor(role, navItem, nav, elRef) {
      this.role = role;
      this.navItem = navItem;
      this.nav = nav;
      this.elRef = elRef;
    }

    hasNavItemClass() {
      // with alternative markup we have to add `.nav-item` class, because `ngbNavItem` is on the ng-container
      return this.navItem.elementRef.nativeElement.nodeType === Node.COMMENT_NODE;
    }

  }

  NgbNavLink.ɵfac = function NgbNavLink_Factory(t) {
    return new (t || NgbNavLink)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinjectAttribute"]('role'), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbNavItem), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbNav), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbNavLink.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbNavLink,
    selectors: [["a", "ngbNavLink", ""]],
    hostAttrs: ["href", ""],
    hostVars: 14,
    hostBindings: function NgbNavLink_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function NgbNavLink_click_HostBindingHandler($event) {
          ctx.nav.click(ctx.navItem);
          return $event.preventDefault();
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("id", ctx.navItem.domId);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("role", ctx.role ? ctx.role : ctx.nav.roles ? "tab" : undefined)("tabindex", ctx.navItem.disabled ? -1 : undefined)("aria-controls", ctx.navItem.isPanelInDom() ? ctx.navItem.panelDomId : null)("aria-selected", ctx.navItem.active)("aria-disabled", ctx.navItem.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("nav-link", true)("nav-item", ctx.hasNavItemClass())("active", ctx.navItem.active)("disabled", ctx.navItem.disabled);
      }
    }
  });
  return NgbNavLink;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const ngbNavFadeOutTransition = ({
  classList
}) => {
  classList.remove('show');
  return () => classList.remove('active');
};

const ngbNavFadeInTransition = (element, animation) => {
  if (animation) {
    reflow(element);
  }

  element.classList.add('show');
};

let NgbNavPane = /*#__PURE__*/(() => {
  class NgbNavPane {
    constructor(elRef) {
      this.elRef = elRef;
    }

  }

  NgbNavPane.ɵfac = function NgbNavPane_Factory(t) {
    return new (t || NgbNavPane)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbNavPane.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbNavPane,
    selectors: [["", "ngbNavPane", ""]],
    hostAttrs: [1, "tab-pane"],
    hostVars: 5,
    hostBindings: function NgbNavPane_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("id", ctx.item.panelDomId);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("role", ctx.role ? ctx.role : ctx.nav.roles ? "tabpanel" : undefined)("aria-labelledby", ctx.item.domId);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("fade", ctx.nav.animation);
      }
    },
    inputs: {
      item: "item",
      nav: "nav",
      role: "role"
    }
  });
  return NgbNavPane;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * The outlet where currently active nav content will be displayed.
 *
 * @since 5.2.0
 */


let NgbNavOutlet = /*#__PURE__*/(() => {
  class NgbNavOutlet {
    constructor(_cd, _ngZone) {
      this._cd = _cd;
      this._ngZone = _ngZone;
      this._activePane = null;
    }

    isPanelTransitioning(item) {
      var _a;

      return ((_a = this._activePane) === null || _a === void 0 ? void 0 : _a.item) === item;
    }

    ngAfterViewInit() {
      var _a; // initial display


      this._updateActivePane(); // this will be emitted for all 3 types of nav changes: .select(), [activeId] or (click)


      this.nav.navItemChange$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.takeUntil)(this.nav.destroy$), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.startWith)(((_a = this._activePane) === null || _a === void 0 ? void 0 : _a.item) || null), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_18__.distinctUntilChanged)(), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_27__.skip)(1)).subscribe(nextItem => {
        const options = {
          animation: this.nav.animation,
          runningTransition: 'stop'
        }; // next panel we're switching to will only appear in DOM after the change detection is done
        // and `this._panes` will be updated

        this._cd.detectChanges(); // fading out


        if (this._activePane) {
          ngbRunTransition(this._ngZone, this._activePane.elRef.nativeElement, ngbNavFadeOutTransition, options).subscribe(() => {
            var _a;

            const activeItem = (_a = this._activePane) === null || _a === void 0 ? void 0 : _a.item;
            this._activePane = this._getPaneForItem(nextItem); // mark for check when transition finishes as outlet or parent containers might be OnPush
            // without this the panes that have "faded out" will stay in DOM

            this._cd.markForCheck(); // fading in


            if (this._activePane) {
              // we have to add the '.active' class before running the transition,
              // because it should be in place before `ngbRunTransition` does `reflow()`
              this._activePane.elRef.nativeElement.classList.add('active');

              ngbRunTransition(this._ngZone, this._activePane.elRef.nativeElement, ngbNavFadeInTransition, options).subscribe(() => {
                if (nextItem) {
                  nextItem.shown.emit();
                  this.nav.shown.emit(nextItem.id);
                }
              });
            }

            if (activeItem) {
              activeItem.hidden.emit();
              this.nav.hidden.emit(activeItem.id);
            }
          });
        } else {
          this._updateActivePane();
        }
      });
    }

    _updateActivePane() {
      var _a, _b;

      this._activePane = this._getActivePane();
      (_a = this._activePane) === null || _a === void 0 ? void 0 : _a.elRef.nativeElement.classList.add('show');
      (_b = this._activePane) === null || _b === void 0 ? void 0 : _b.elRef.nativeElement.classList.add('active');
    }

    _getPaneForItem(item) {
      return this._panes && this._panes.find(pane => pane.item === item) || null;
    }

    _getActivePane() {
      return this._panes && this._panes.find(pane => pane.item.active) || null;
    }

  }

  NgbNavOutlet.ɵfac = function NgbNavOutlet_Factory(t) {
    return new (t || NgbNavOutlet)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone));
  };

  NgbNavOutlet.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbNavOutlet,
    selectors: [["", "ngbNavOutlet", ""]],
    viewQuery: function NgbNavOutlet_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵviewQuery"](NgbNavPane, 5);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx._panes = _t);
      }
    },
    hostVars: 2,
    hostBindings: function NgbNavOutlet_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("tab-content", true);
      }
    },
    inputs: {
      paneRole: "paneRole",
      nav: ["ngbNavOutlet", "nav"]
    },
    attrs: _c32,
    decls: 1,
    vars: 1,
    consts: [["ngFor", "", 3, "ngForOf"], ["ngbNavPane", "", 3, "item", "nav", "role", 4, "ngIf"], ["ngbNavPane", "", 3, "item", "nav", "role"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"]],
    template: function NgbNavOutlet_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbNavOutlet_ng_template_0_Template, 1, 1, "ng-template", 0);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.nav.items);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet, NgbNavPane],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbNavOutlet;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const NGB_NAV_DIRECTIVES = [NgbNavContent, NgbNav, NgbNavItem, NgbNavLink, NgbNavOutlet, NgbNavPane];
let NgbNavModule = /*#__PURE__*/(() => {
  class NgbNavModule {}

  NgbNavModule.ɵfac = function NgbNavModule_Factory(t) {
    return new (t || NgbNavModule)();
  };

  NgbNavModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbNavModule
  });
  NgbNavModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbNavModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbNavModule, {
    declarations: function () {
      return [NgbNavContent, NgbNav, NgbNavItem, NgbNavLink, NgbNavOutlet, NgbNavPane];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbNavContent, NgbNav, NgbNavItem, NgbNavLink, NgbNavOutlet, NgbNavPane];
    }
  });
})();
/**
 * A configuration service for the [`NgbPagination`](#/components/pagination/api#NgbPagination) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the paginations used in the application.
 */


let NgbPaginationConfig = /*#__PURE__*/(() => {
  class NgbPaginationConfig {
    constructor() {
      this.disabled = false;
      this.boundaryLinks = false;
      this.directionLinks = true;
      this.ellipses = true;
      this.maxSize = 0;
      this.pageSize = 10;
      this.rotate = false;
    }

  }

  NgbPaginationConfig.ɵfac = function NgbPaginationConfig_Factory(t) {
    return new (t || NgbPaginationConfig)();
  };

  NgbPaginationConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbPaginationConfig_Factory() {
      return new NgbPaginationConfig();
    },
    token: NgbPaginationConfig,
    providedIn: "root"
  });
  return NgbPaginationConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to match the 'ellipsis' link template
 *
 * @since 4.1.0
 */


let NgbPaginationEllipsis = /*#__PURE__*/(() => {
  class NgbPaginationEllipsis {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPaginationEllipsis.ɵfac = function NgbPaginationEllipsis_Factory(t) {
    return new (t || NgbPaginationEllipsis)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPaginationEllipsis.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPaginationEllipsis,
    selectors: [["ng-template", "ngbPaginationEllipsis", ""]]
  });
  return NgbPaginationEllipsis;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to match the 'first' link template
 *
 * @since 4.1.0
 */


let NgbPaginationFirst = /*#__PURE__*/(() => {
  class NgbPaginationFirst {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPaginationFirst.ɵfac = function NgbPaginationFirst_Factory(t) {
    return new (t || NgbPaginationFirst)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPaginationFirst.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPaginationFirst,
    selectors: [["ng-template", "ngbPaginationFirst", ""]]
  });
  return NgbPaginationFirst;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to match the 'last' link template
 *
 * @since 4.1.0
 */


let NgbPaginationLast = /*#__PURE__*/(() => {
  class NgbPaginationLast {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPaginationLast.ɵfac = function NgbPaginationLast_Factory(t) {
    return new (t || NgbPaginationLast)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPaginationLast.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPaginationLast,
    selectors: [["ng-template", "ngbPaginationLast", ""]]
  });
  return NgbPaginationLast;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to match the 'next' link template
 *
 * @since 4.1.0
 */


let NgbPaginationNext = /*#__PURE__*/(() => {
  class NgbPaginationNext {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPaginationNext.ɵfac = function NgbPaginationNext_Factory(t) {
    return new (t || NgbPaginationNext)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPaginationNext.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPaginationNext,
    selectors: [["ng-template", "ngbPaginationNext", ""]]
  });
  return NgbPaginationNext;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to match the page 'number' link template
 *
 * @since 4.1.0
 */


let NgbPaginationNumber = /*#__PURE__*/(() => {
  class NgbPaginationNumber {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPaginationNumber.ɵfac = function NgbPaginationNumber_Factory(t) {
    return new (t || NgbPaginationNumber)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPaginationNumber.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPaginationNumber,
    selectors: [["ng-template", "ngbPaginationNumber", ""]]
  });
  return NgbPaginationNumber;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive to match the 'previous' link template
 *
 * @since 4.1.0
 */


let NgbPaginationPrevious = /*#__PURE__*/(() => {
  class NgbPaginationPrevious {
    constructor(templateRef) {
      this.templateRef = templateRef;
    }

  }

  NgbPaginationPrevious.ɵfac = function NgbPaginationPrevious_Factory(t) {
    return new (t || NgbPaginationPrevious)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef));
  };

  NgbPaginationPrevious.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPaginationPrevious,
    selectors: [["ng-template", "ngbPaginationPrevious", ""]]
  });
  return NgbPaginationPrevious;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A component that displays page numbers and allows to customize them in several ways.
 */


let NgbPagination = /*#__PURE__*/(() => {
  class NgbPagination {
    constructor(config) {
      this.pageCount = 0;
      this.pages = [];
      /**
       *  The current page.
       *
       *  Page numbers start with `1`.
       */

      this.page = 1;
      /**
       *  An event fired when the page is changed. Will fire only if collection size is set and all values are valid.
       *
       *  Event payload is the number of the newly selected page.
       *
       *  Page numbers start with `1`.
       */

      this.pageChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter(true);
      this.disabled = config.disabled;
      this.boundaryLinks = config.boundaryLinks;
      this.directionLinks = config.directionLinks;
      this.ellipses = config.ellipses;
      this.maxSize = config.maxSize;
      this.pageSize = config.pageSize;
      this.rotate = config.rotate;
      this.size = config.size;
    }

    hasPrevious() {
      return this.page > 1;
    }

    hasNext() {
      return this.page < this.pageCount;
    }

    nextDisabled() {
      return !this.hasNext() || this.disabled;
    }

    previousDisabled() {
      return !this.hasPrevious() || this.disabled;
    }

    selectPage(pageNumber) {
      this._updatePages(pageNumber);
    }

    ngOnChanges(changes) {
      this._updatePages(this.page);
    }

    isEllipsis(pageNumber) {
      return pageNumber === -1;
    }
    /**
     * Appends ellipses and first/last page number to the displayed pages
     */


    _applyEllipses(start, end) {
      if (this.ellipses) {
        if (start > 0) {
          // The first page will always be included. If the displayed range
          // starts after the third page, then add ellipsis. But if the range
          // starts on the third page, then add the second page instead of
          // an ellipsis, because the ellipsis would only hide a single page.
          if (start > 2) {
            this.pages.unshift(-1);
          } else if (start === 2) {
            this.pages.unshift(2);
          }

          this.pages.unshift(1);
        }

        if (end < this.pageCount) {
          // The last page will always be included. If the displayed range
          // ends before the third-last page, then add ellipsis. But if the range
          // ends on third-last page, then add the second-last page instead of
          // an ellipsis, because the ellipsis would only hide a single page.
          if (end < this.pageCount - 2) {
            this.pages.push(-1);
          } else if (end === this.pageCount - 2) {
            this.pages.push(this.pageCount - 1);
          }

          this.pages.push(this.pageCount);
        }
      }
    }
    /**
     * Rotates page numbers based on maxSize items visible.
     * Currently selected page stays in the middle:
     *
     * Ex. for selected page = 6:
     * [5,*6*,7] for maxSize = 3
     * [4,5,*6*,7] for maxSize = 4
     */


    _applyRotation() {
      let start = 0;
      let end = this.pageCount;
      let leftOffset = Math.floor(this.maxSize / 2);
      let rightOffset = this.maxSize % 2 === 0 ? leftOffset - 1 : leftOffset;

      if (this.page <= leftOffset) {
        // very beginning, no rotation -> [0..maxSize]
        end = this.maxSize;
      } else if (this.pageCount - this.page < leftOffset) {
        // very end, no rotation -> [len-maxSize..len]
        start = this.pageCount - this.maxSize;
      } else {
        // rotate
        start = this.page - leftOffset - 1;
        end = this.page + rightOffset;
      }

      return [start, end];
    }
    /**
     * Paginates page numbers based on maxSize items per page.
     */


    _applyPagination() {
      let page = Math.ceil(this.page / this.maxSize) - 1;
      let start = page * this.maxSize;
      let end = start + this.maxSize;
      return [start, end];
    }

    _setPageInRange(newPageNo) {
      const prevPageNo = this.page;
      this.page = getValueInRange(newPageNo, this.pageCount, 1);

      if (this.page !== prevPageNo && isNumber(this.collectionSize)) {
        this.pageChange.emit(this.page);
      }
    }

    _updatePages(newPage) {
      this.pageCount = Math.ceil(this.collectionSize / this.pageSize);

      if (!isNumber(this.pageCount)) {
        this.pageCount = 0;
      } // fill-in model needed to render pages


      this.pages.length = 0;

      for (let i = 1; i <= this.pageCount; i++) {
        this.pages.push(i);
      } // set page within 1..max range


      this._setPageInRange(newPage); // apply maxSize if necessary


      if (this.maxSize > 0 && this.pageCount > this.maxSize) {
        let start = 0;
        let end = this.pageCount; // either paginating or rotating page numbers

        if (this.rotate) {
          [start, end] = this._applyRotation();
        } else {
          [start, end] = this._applyPagination();
        }

        this.pages = this.pages.slice(start, end); // adding ellipses

        this._applyEllipses(start, end);
      }
    }

  }

  NgbPagination.ɵfac = function NgbPagination_Factory(t) {
    return new (t || NgbPagination)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbPaginationConfig));
  };

  NgbPagination.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbPagination,
    selectors: [["ngb-pagination"]],
    contentQueries: function NgbPagination_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPaginationEllipsis, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPaginationFirst, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPaginationLast, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPaginationNext, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPaginationNumber, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbPaginationPrevious, 5);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.tplEllipsis = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.tplFirst = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.tplLast = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.tplNext = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.tplNumber = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.tplPrevious = _t.first);
      }
    },
    hostAttrs: ["role", "navigation"],
    inputs: {
      page: "page",
      disabled: "disabled",
      boundaryLinks: "boundaryLinks",
      directionLinks: "directionLinks",
      ellipses: "ellipses",
      maxSize: "maxSize",
      pageSize: "pageSize",
      rotate: "rotate",
      size: "size",
      collectionSize: "collectionSize"
    },
    outputs: {
      pageChange: "pageChange"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
    decls: 18,
    vars: 7,
    consts: function () {
      let i18n_34;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_first$$FESM2015_NG_BOOTSTRAP_JS__35 = goog.getMsg("\u00AB\u00AB");
        i18n_34 = MSG_EXTERNAL_ngb_pagination_first$$FESM2015_NG_BOOTSTRAP_JS__35;
      } else {
        i18n_34 = $localize`:@@ngb.pagination.first␟656506dfd46380956a655f919f1498d018f75ca0␟6867721956102594380:««`;
      }

      let i18n_36;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_previous$$FESM2015_NG_BOOTSTRAP_JS__37 = goog.getMsg("\u00AB");
        i18n_36 = MSG_EXTERNAL_ngb_pagination_previous$$FESM2015_NG_BOOTSTRAP_JS__37;
      } else {
        i18n_36 = $localize`:@@ngb.pagination.previous␟6e52b6ee77a4848d899dd21b591c6fd499e3aef3␟6479320895410098858:«`;
      }

      let i18n_38;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_next$$FESM2015_NG_BOOTSTRAP_JS__39 = goog.getMsg("\u00BB");
        i18n_38 = MSG_EXTERNAL_ngb_pagination_next$$FESM2015_NG_BOOTSTRAP_JS__39;
      } else {
        i18n_38 = $localize`:@@ngb.pagination.next␟ba9cbb4ff311464308a3627e4f1c3345d9fe6d7d␟5458177150283468089:»`;
      }

      let i18n_40;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_last$$FESM2015_NG_BOOTSTRAP_JS__41 = goog.getMsg("\u00BB\u00BB");
        i18n_40 = MSG_EXTERNAL_ngb_pagination_last$$FESM2015_NG_BOOTSTRAP_JS__41;
      } else {
        i18n_40 = $localize`:@@ngb.pagination.last␟49f27a460bc97e7e00be5b37098bfa79884fc7d9␟5277020320267646988:»»`;
      }

      let i18n_42;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_first_aria$$FESM2015_NG_BOOTSTRAP_JS__43 = goog.getMsg("First");
        i18n_42 = MSG_EXTERNAL_ngb_pagination_first_aria$$FESM2015_NG_BOOTSTRAP_JS__43;
      } else {
        i18n_42 = $localize`:@@ngb.pagination.first-aria␟f2f852318759c6396b5d3d17031d53817d7b38cc␟2241508602425256033:First`;
      }

      let i18n_45;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_previous_aria$$FESM2015_NG_BOOTSTRAP_JS__46 = goog.getMsg("Previous");
        i18n_45 = MSG_EXTERNAL_ngb_pagination_previous_aria$$FESM2015_NG_BOOTSTRAP_JS__46;
      } else {
        i18n_45 = $localize`:@@ngb.pagination.previous-aria␟680d5c75b7fd8d37961083608b9fcdc4167b4c43␟4452427314943113135:Previous`;
      }

      let i18n_50;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_next_aria$$FESM2015_NG_BOOTSTRAP_JS__51 = goog.getMsg("Next");
        i18n_50 = MSG_EXTERNAL_ngb_pagination_next_aria$$FESM2015_NG_BOOTSTRAP_JS__51;
      } else {
        i18n_50 = $localize`:@@ngb.pagination.next-aria␟f732c304c7433e5a83ffcd862c3dce709a0f4982␟3885497195825665706:Next`;
      }

      let i18n_52;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_pagination_last_aria$$FESM2015_NG_BOOTSTRAP_JS__53 = goog.getMsg("Last");
        i18n_52 = MSG_EXTERNAL_ngb_pagination_last_aria$$FESM2015_NG_BOOTSTRAP_JS__53;
      } else {
        i18n_52 = $localize`:@@ngb.pagination.last-aria␟5c729788ba138508aca1bec050b610f7bf81db3e␟4882268002141858767:Last`;
      }

      return [["first", ""], ["previous", ""], ["next", ""], ["last", ""], ["ellipsis", ""], ["defaultNumber", ""], ["class", "page-item", 3, "disabled", 4, "ngIf"], ["class", "page-item", 3, "active", "disabled", 4, "ngFor", "ngForOf"], ["aria-hidden", "true"], i18n_34, i18n_36, i18n_38, i18n_40, ["class", "sr-only", 4, "ngIf"], [1, "sr-only"], [1, "page-item"], ["aria-label", i18n_42, "href", "", 1, "page-link", 3, "click"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"], ["aria-label", i18n_45, "href", "", 1, "page-link", 3, "click"], ["class", "page-link", "tabindex", "-1", "aria-disabled", "true", 4, "ngIf"], ["class", "page-link", "href", "", 3, "click", 4, "ngIf"], ["tabindex", "-1", "aria-disabled", "true", 1, "page-link"], ["href", "", 1, "page-link", 3, "click"], ["aria-label", i18n_50, "href", "", 1, "page-link", 3, "click"], ["aria-label", i18n_52, "href", "", 1, "page-link", 3, "click"]];
    },
    template: function NgbPagination_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbPagination_ng_template_0_Template, 2, 0, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbPagination_ng_template_2_Template, 2, 0, "ng-template", null, 1, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, NgbPagination_ng_template_4_Template, 2, 0, "ng-template", null, 2, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](6, NgbPagination_ng_template_6_Template, 2, 0, "ng-template", null, 3, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](8, NgbPagination_ng_template_8_Template, 1, 0, "ng-template", null, 4, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](10, NgbPagination_ng_template_10_Template, 2, 2, "ng-template", null, 5, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](12, "ul");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, NgbPagination_li_13_Template, 3, 9, "li", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](14, NgbPagination_li_14_Template, 3, 8, "li", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](15, NgbPagination_li_15_Template, 3, 7, "li", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](16, NgbPagination_li_16_Template, 3, 9, "li", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](17, NgbPagination_li_17_Template, 3, 9, "li", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("pagination" + (ctx.size ? " pagination-" + ctx.size : ""));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.boundaryLinks);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.directionLinks);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.pages);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.directionLinks);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.boundaryLinks);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbPagination;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const DIRECTIVES = [NgbPagination, NgbPaginationEllipsis, NgbPaginationFirst, NgbPaginationLast, NgbPaginationNext, NgbPaginationNumber, NgbPaginationPrevious];
let NgbPaginationModule = /*#__PURE__*/(() => {
  class NgbPaginationModule {}

  NgbPaginationModule.ɵfac = function NgbPaginationModule_Factory(t) {
    return new (t || NgbPaginationModule)();
  };

  NgbPaginationModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbPaginationModule
  });
  NgbPaginationModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbPaginationModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbPaginationModule, {
    declarations: function () {
      return [NgbPagination, NgbPaginationEllipsis, NgbPaginationFirst, NgbPaginationLast, NgbPaginationNext, NgbPaginationNumber, NgbPaginationPrevious];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbPagination, NgbPaginationEllipsis, NgbPaginationFirst, NgbPaginationLast, NgbPaginationNext, NgbPaginationNumber, NgbPaginationPrevious];
    }
  });
})();

class Trigger {
  constructor(open, close) {
    this.open = open;
    this.close = close;

    if (!close) {
      this.close = open;
    }
  }

  isManual() {
    return this.open === 'manual' || this.close === 'manual';
  }

}

const DEFAULT_ALIASES = {
  'hover': ['mouseenter', 'mouseleave'],
  'focus': ['focusin', 'focusout']
};

function parseTriggers(triggers, aliases = DEFAULT_ALIASES) {
  const trimmedTriggers = (triggers || '').trim();

  if (trimmedTriggers.length === 0) {
    return [];
  }

  const parsedTriggers = trimmedTriggers.split(/\s+/).map(trigger => trigger.split(':')).map(triggerPair => {
    let alias = aliases[triggerPair[0]] || triggerPair;
    return new Trigger(alias[0], alias[1]);
  });
  const manualTriggers = parsedTriggers.filter(triggerPair => triggerPair.isManual());

  if (manualTriggers.length > 1) {
    throw 'Triggers parse error: only one manual trigger is allowed';
  }

  if (manualTriggers.length === 1 && parsedTriggers.length > 1) {
    throw 'Triggers parse error: manual trigger can\'t be mixed with other triggers';
  }

  return parsedTriggers;
}

function observeTriggers(renderer, nativeElement, triggers, isOpenedFn) {
  return new rxjs__WEBPACK_IMPORTED_MODULE_1__.Observable(subscriber => {
    const listeners = [];

    const openFn = () => subscriber.next(true);

    const closeFn = () => subscriber.next(false);

    const toggleFn = () => subscriber.next(!isOpenedFn());

    triggers.forEach(trigger => {
      if (trigger.open === trigger.close) {
        listeners.push(renderer.listen(nativeElement, trigger.open, toggleFn));
      } else {
        listeners.push(renderer.listen(nativeElement, trigger.open, openFn), renderer.listen(nativeElement, trigger.close, closeFn));
      }
    });
    return () => {
      listeners.forEach(unsubscribeFn => unsubscribeFn());
    };
  });
}

const delayOrNoop = time => time > 0 ? (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_25__.delay)(time) : a => a;

const ɵ0$5 = delayOrNoop;

function triggerDelay(openDelay, closeDelay, isOpenedFn) {
  return input$ => {
    let pending = null;
    const filteredInput$ = input$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(open => ({
      open
    })), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(event => {
      const currentlyOpen = isOpenedFn();

      if (currentlyOpen !== event.open && (!pending || pending.open === currentlyOpen)) {
        pending = event;
        return true;
      }

      if (pending && pending.open !== event.open) {
        pending = null;
      }

      return false;
    }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_28__.share)());
    const delayedOpen$ = filteredInput$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(event => event.open), delayOrNoop(openDelay));
    const delayedClose$ = filteredInput$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(event => !event.open), delayOrNoop(closeDelay));
    return (0,rxjs__WEBPACK_IMPORTED_MODULE_22__.merge)(delayedOpen$, delayedClose$).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.filter)(event => {
      if (event === pending) {
        pending = null;
        return event.open !== isOpenedFn();
      }

      return false;
    }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)(event => event.open));
  };
}

function listenToTriggers(renderer, nativeElement, triggers, isOpenedFn, openFn, closeFn, openDelay = 0, closeDelay = 0) {
  const parsedTriggers = parseTriggers(triggers);

  if (parsedTriggers.length === 1 && parsedTriggers[0].isManual()) {
    return () => {};
  }

  const subscription = observeTriggers(renderer, nativeElement, parsedTriggers, isOpenedFn).pipe(triggerDelay(openDelay, closeDelay, isOpenedFn)).subscribe(open => open ? openFn() : closeFn());
  return () => subscription.unsubscribe();
}
/**
 * A configuration service for the [`NgbPopover`](#/components/popover/api#NgbPopover) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the popovers used in the application.
 */


let NgbPopoverConfig = /*#__PURE__*/(() => {
  class NgbPopoverConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.autoClose = true;
      this.placement = 'auto';
      this.triggers = 'click';
      this.disablePopover = false;
      this.openDelay = 0;
      this.closeDelay = 0;
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbPopoverConfig.ɵfac = function NgbPopoverConfig_Factory(t) {
    return new (t || NgbPopoverConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbPopoverConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbPopoverConfig_Factory() {
      return new NgbPopoverConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbPopoverConfig,
    providedIn: "root"
  });
  return NgbPopoverConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let nextId$3 = 0;
let NgbPopoverWindow = /*#__PURE__*/(() => {
  class NgbPopoverWindow {
    isTitleTemplate() {
      return this.title instanceof _angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef;
    }

  }

  NgbPopoverWindow.ɵfac = function NgbPopoverWindow_Factory(t) {
    return new (t || NgbPopoverWindow)();
  };

  NgbPopoverWindow.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbPopoverWindow,
    selectors: [["ngb-popover-window"]],
    hostAttrs: ["role", "tooltip"],
    hostVars: 5,
    hostBindings: function NgbPopoverWindow_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("id", ctx.id);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("popover" + (ctx.popoverClass ? " " + ctx.popoverClass : ""));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("fade", ctx.animation);
      }
    },
    inputs: {
      animation: "animation",
      title: "title",
      id: "id",
      popoverClass: "popoverClass",
      context: "context"
    },
    ngContentSelectors: _c3,
    decls: 4,
    vars: 1,
    consts: [[1, "arrow"], ["class", "popover-header", 4, "ngIf"], [1, "popover-body"], [1, "popover-header"], ["simpleTitle", ""], [3, "ngTemplateOutlet", "ngTemplateOutletContext"]],
    template: function NgbPopoverWindow_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbPopoverWindow_h3_1_Template, 4, 2, "h3", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.title);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet],
    styles: ["ngb-popover-window.bs-popover-bottom>.arrow,ngb-popover-window.bs-popover-top>.arrow{left:50%;margin-left:-.5rem}ngb-popover-window.bs-popover-bottom-left>.arrow,ngb-popover-window.bs-popover-top-left>.arrow{left:2em}ngb-popover-window.bs-popover-bottom-right>.arrow,ngb-popover-window.bs-popover-top-right>.arrow{left:auto;right:2em}ngb-popover-window.bs-popover-left>.arrow,ngb-popover-window.bs-popover-right>.arrow{margin-top:-.5rem;top:50%}ngb-popover-window.bs-popover-left-top>.arrow,ngb-popover-window.bs-popover-right-top>.arrow{top:.7em}ngb-popover-window.bs-popover-left-bottom>.arrow,ngb-popover-window.bs-popover-right-bottom>.arrow{bottom:.7em;top:auto}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbPopoverWindow;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A lightweight and extensible directive for fancy popover creation.
 */


let NgbPopover = /*#__PURE__*/(() => {
  class NgbPopover {
    constructor(_elementRef, _renderer, injector, componentFactoryResolver, viewContainerRef, config, _ngZone, _document, _changeDetector, applicationRef) {
      this._elementRef = _elementRef;
      this._renderer = _renderer;
      this._ngZone = _ngZone;
      this._document = _document;
      this._changeDetector = _changeDetector;
      /**
       * An event emitted when the popover opening animation has finished. Contains no payload.
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the popover closing animation has finished. Contains no payload.
       *
       * At this point popover is not in the DOM anymore.
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this._ngbPopoverWindowId = `ngb-popover-${nextId$3++}`;
      this._windowRef = null;
      this.animation = config.animation;
      this.autoClose = config.autoClose;
      this.placement = config.placement;
      this.triggers = config.triggers;
      this.container = config.container;
      this.disablePopover = config.disablePopover;
      this.popoverClass = config.popoverClass;
      this.openDelay = config.openDelay;
      this.closeDelay = config.closeDelay;
      this._popupService = new PopupService(NgbPopoverWindow, injector, viewContainerRef, _renderer, this._ngZone, componentFactoryResolver, applicationRef);
      this._zoneSubscription = _ngZone.onStable.subscribe(() => {
        if (this._windowRef) {
          positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, this.container === 'body', 'bs-popover');
        }
      });
    }

    _isDisabled() {
      if (this.disablePopover) {
        return true;
      }

      if (!this.ngbPopover && !this.popoverTitle) {
        return true;
      }

      return false;
    }
    /**
     * Opens the popover.
     *
     * This is considered to be a "manual" triggering.
     * The `context` is an optional value to be injected into the popover template when it is created.
     */


    open(context) {
      if (!this._windowRef && !this._isDisabled()) {
        // this type assertion is safe because otherwise _isDisabled would return true
        const {
          windowRef,
          transition$
        } = this._popupService.open(this.ngbPopover, context, this.animation);

        this._windowRef = windowRef;
        this._windowRef.instance.animation = this.animation;
        this._windowRef.instance.title = this.popoverTitle;
        this._windowRef.instance.context = context;
        this._windowRef.instance.popoverClass = this.popoverClass;
        this._windowRef.instance.id = this._ngbPopoverWindowId;

        this._renderer.setAttribute(this._elementRef.nativeElement, 'aria-describedby', this._ngbPopoverWindowId);

        if (this.container === 'body') {
          this._document.querySelector(this.container).appendChild(this._windowRef.location.nativeElement);
        } // We need to detect changes, because we don't know where .open() might be called from.
        // Ex. opening popover from one of lifecycle hooks that run after the CD
        // (say from ngAfterViewInit) will result in 'ExpressionHasChanged' exception


        this._windowRef.changeDetectorRef.detectChanges(); // We need to mark for check, because popover won't work inside the OnPush component.
        // Ex. when we use expression like `{{ popover.isOpen() : 'opened' : 'closed' }}`
        // inside the template of an OnPush component and we change the popover from
        // open -> closed, the expression in question won't be updated unless we explicitly
        // mark the parent component to be checked.


        this._windowRef.changeDetectorRef.markForCheck();

        ngbAutoClose(this._ngZone, this._document, this.autoClose, () => this.close(), this.hidden, [this._windowRef.location.nativeElement]);
        transition$.subscribe(() => this.shown.emit());
      }
    }
    /**
     * Closes the popover.
     *
     * This is considered to be a "manual" triggering of the popover.
     */


    close() {
      if (this._windowRef) {
        this._renderer.removeAttribute(this._elementRef.nativeElement, 'aria-describedby');

        this._popupService.close(this.animation).subscribe(() => {
          this._windowRef = null;
          this.hidden.emit();

          this._changeDetector.markForCheck();
        });
      }
    }
    /**
     * Toggles the popover.
     *
     * This is considered to be a "manual" triggering of the popover.
     */


    toggle() {
      if (this._windowRef) {
        this.close();
      } else {
        this.open();
      }
    }
    /**
     * Returns `true`, if the popover is currently shown.
     */


    isOpen() {
      return this._windowRef != null;
    }

    ngOnInit() {
      this._unregisterListenersFn = listenToTriggers(this._renderer, this._elementRef.nativeElement, this.triggers, this.isOpen.bind(this), this.open.bind(this), this.close.bind(this), +this.openDelay, +this.closeDelay);
    }

    ngOnChanges({
      ngbPopover,
      popoverTitle,
      disablePopover,
      popoverClass
    }) {
      if (popoverClass && this.isOpen()) {
        this._windowRef.instance.popoverClass = popoverClass.currentValue;
      } // close popover if title and content become empty, or disablePopover set to true


      if ((ngbPopover || popoverTitle || disablePopover) && this._isDisabled()) {
        this.close();
      }
    }

    ngOnDestroy() {
      this.close(); // This check is needed as it might happen that ngOnDestroy is called before ngOnInit
      // under certain conditions, see: https://github.com/ng-bootstrap/ng-bootstrap/issues/2199

      if (this._unregisterListenersFn) {
        this._unregisterListenersFn();
      }

      this._zoneSubscription.unsubscribe();
    }

  }

  NgbPopover.ɵfac = function NgbPopover_Factory(t) {
    return new (t || NgbPopover)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentFactoryResolver), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbPopoverConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ApplicationRef));
  };

  NgbPopover.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbPopover,
    selectors: [["", "ngbPopover", ""]],
    inputs: {
      animation: "animation",
      autoClose: "autoClose",
      placement: "placement",
      triggers: "triggers",
      container: "container",
      disablePopover: "disablePopover",
      popoverClass: "popoverClass",
      openDelay: "openDelay",
      closeDelay: "closeDelay",
      ngbPopover: "ngbPopover",
      popoverTitle: "popoverTitle"
    },
    outputs: {
      shown: "shown",
      hidden: "hidden"
    },
    exportAs: ["ngbPopover"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });
  return NgbPopover;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbPopoverModule = /*#__PURE__*/(() => {
  class NgbPopoverModule {}

  NgbPopoverModule.ɵfac = function NgbPopoverModule_Factory(t) {
    return new (t || NgbPopoverModule)();
  };

  NgbPopoverModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbPopoverModule
  });
  NgbPopoverModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbPopoverModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbPopoverModule, {
    declarations: function () {
      return [NgbPopover, NgbPopoverWindow];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbPopover];
    }
  });
})();
/**
 * A configuration service for the [`NgbProgressbar`](#/components/progressbar/api#NgbProgressbar) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the progress bars used in the application.
 */


let NgbProgressbarConfig = /*#__PURE__*/(() => {
  class NgbProgressbarConfig {
    constructor() {
      this.max = 100;
      this.animated = false;
      this.striped = false;
      this.showValue = false;
    }

  }

  NgbProgressbarConfig.ɵfac = function NgbProgressbarConfig_Factory(t) {
    return new (t || NgbProgressbarConfig)();
  };

  NgbProgressbarConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbProgressbarConfig_Factory() {
      return new NgbProgressbarConfig();
    },
    token: NgbProgressbarConfig,
    providedIn: "root"
  });
  return NgbProgressbarConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that provides feedback on the progress of a workflow or an action.
 */


let NgbProgressbar = /*#__PURE__*/(() => {
  class NgbProgressbar {
    constructor(config) {
      /**
       * The current value for the progress bar.
       *
       * Should be in the `[0, max]` range.
       */
      this.value = 0;
      this.max = config.max;
      this.animated = config.animated;
      this.striped = config.striped;
      this.textType = config.textType;
      this.type = config.type;
      this.showValue = config.showValue;
      this.height = config.height;
    }
    /**
     * The maximal value to be displayed in the progress bar.
     *
     * Should be a positive number. Will default to 100 otherwise.
     */


    set max(max) {
      this._max = !isNumber(max) || max <= 0 ? 100 : max;
    }

    get max() {
      return this._max;
    }

    getValue() {
      return getValueInRange(this.value, this.max);
    }

    getPercentValue() {
      return 100 * this.getValue() / this.max;
    }

  }

  NgbProgressbar.ɵfac = function NgbProgressbar_Factory(t) {
    return new (t || NgbProgressbar)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbProgressbarConfig));
  };

  NgbProgressbar.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbProgressbar,
    selectors: [["ngb-progressbar"]],
    hostAttrs: [1, "progress"],
    hostVars: 2,
    hostBindings: function NgbProgressbar_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("height", ctx.height);
      }
    },
    inputs: {
      value: "value",
      max: "max",
      animated: "animated",
      striped: "striped",
      textType: "textType",
      type: "type",
      showValue: "showValue",
      height: "height"
    },
    ngContentSelectors: _c3,
    decls: 3,
    vars: 11,
    consts: function () {
      let i18n_54;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_progressbar_value$$FESM2015_NG_BOOTSTRAP_JS__55 = goog.getMsg("{$interpolation}", {
          "interpolation": "\uFFFD0\uFFFD"
        }, {
          original_code: {
            "interpolation": "{{getValue() / max | percent}}"
          }
        });
        i18n_54 = MSG_EXTERNAL_ngb_progressbar_value$$FESM2015_NG_BOOTSTRAP_JS__55;
      } else {
        i18n_54 = $localize`:@@ngb.progressbar.value␟f8e9a947b9db4252c0e9905765338712f2fd032f␟3720830768741091151:${"\uFFFD0\uFFFD"}:INTERPOLATION:`;
      }

      return [["role", "progressbar", "aria-valuemin", "0"], [4, "ngIf"], i18n_54];
    },
    template: function NgbProgressbar_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, NgbProgressbar_span_1_Template, 3, 3, "span", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMapInterpolate4"]("progress-bar", ctx.type ? " bg-" + ctx.type : "", "", ctx.textType ? " text-" + ctx.textType : "", "\n    ", ctx.animated ? " progress-bar-animated" : "", "", ctx.striped ? " progress-bar-striped" : "", "");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("width", ctx.getPercentValue(), "%");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-valuenow", ctx.getValue())("aria-valuemax", ctx.max);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.showValue);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.PercentPipe],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbProgressbar;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbProgressbarModule = /*#__PURE__*/(() => {
  class NgbProgressbarModule {}

  NgbProgressbarModule.ɵfac = function NgbProgressbarModule_Factory(t) {
    return new (t || NgbProgressbarModule)();
  };

  NgbProgressbarModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbProgressbarModule
  });
  NgbProgressbarModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbProgressbarModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbProgressbarModule, {
    declarations: function () {
      return [NgbProgressbar];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbProgressbar];
    }
  });
})();
/**
 * A configuration service for the [`NgbRating`](#/components/rating/api#NgbRating) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the ratings used in the application.
 */


let NgbRatingConfig = /*#__PURE__*/(() => {
  class NgbRatingConfig {
    constructor() {
      this.max = 10;
      this.readonly = false;
      this.resettable = false;
    }

  }

  NgbRatingConfig.ɵfac = function NgbRatingConfig_Factory(t) {
    return new (t || NgbRatingConfig)();
  };

  NgbRatingConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbRatingConfig_Factory() {
      return new NgbRatingConfig();
    },
    token: NgbRatingConfig,
    providedIn: "root"
  });
  return NgbRatingConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A directive that helps visualising and interacting with a star rating bar.
 */


let NgbRating = /*#__PURE__*/(() => {
  class NgbRating {
    constructor(config, _changeDetectorRef) {
      this._changeDetectorRef = _changeDetectorRef;
      this.contexts = [];
      this.disabled = false;
      /**
       * An event emitted when the user is hovering over a given rating.
       *
       * Event payload equals to the rating being hovered over.
       */

      this.hover = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the user stops hovering over a given rating.
       *
       * Event payload equals to the rating of the last item being hovered over.
       */

      this.leave = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the user selects a new rating.
       *
       * Event payload equals to the newly selected rating.
       */

      this.rateChange = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter(true);

      this.onChange = _ => {};

      this.onTouched = () => {};

      this.max = config.max;
      this.readonly = config.readonly;
    }

    ariaValueText() {
      return `${this.nextRate} out of ${this.max}`;
    }

    isInteractive() {
      return !this.readonly && !this.disabled;
    }

    enter(value) {
      if (this.isInteractive()) {
        this._updateState(value);
      }

      this.hover.emit(value);
    }

    handleBlur() {
      this.onTouched();
    }

    handleClick(value) {
      if (this.isInteractive()) {
        this.update(this.resettable && this.rate === value ? 0 : value);
      }
    }

    handleKeyDown(event) {
      // tslint:disable-next-line:deprecation
      switch (event.which) {
        case Key.ArrowDown:
        case Key.ArrowLeft:
          this.update(this.rate - 1);
          break;

        case Key.ArrowUp:
        case Key.ArrowRight:
          this.update(this.rate + 1);
          break;

        case Key.Home:
          this.update(0);
          break;

        case Key.End:
          this.update(this.max);
          break;

        default:
          return;
      } // note 'return' in default case


      event.preventDefault();
    }

    ngOnChanges(changes) {
      if (changes['rate']) {
        this.update(this.rate);
      }
    }

    ngOnInit() {
      this.contexts = Array.from({
        length: this.max
      }, (v, k) => ({
        fill: 0,
        index: k
      }));

      this._updateState(this.rate);
    }

    registerOnChange(fn) {
      this.onChange = fn;
    }

    registerOnTouched(fn) {
      this.onTouched = fn;
    }

    reset() {
      this.leave.emit(this.nextRate);

      this._updateState(this.rate);
    }

    setDisabledState(isDisabled) {
      this.disabled = isDisabled;
    }

    update(value, internalChange = true) {
      const newRate = getValueInRange(value, this.max, 0);

      if (this.isInteractive() && this.rate !== newRate) {
        this.rate = newRate;
        this.rateChange.emit(this.rate);
      }

      if (internalChange) {
        this.onChange(this.rate);
        this.onTouched();
      }

      this._updateState(this.rate);
    }

    writeValue(value) {
      this.update(value, false);

      this._changeDetectorRef.markForCheck();
    }

    _updateState(nextValue) {
      this.nextRate = nextValue;
      this.contexts.forEach((context, index) => context.fill = Math.round(getValueInRange(nextValue - index, 1, 0) * 100));
    }

  }

  NgbRating.ɵfac = function NgbRating_Factory(t) {
    return new (t || NgbRating)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbRatingConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef));
  };

  NgbRating.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbRating,
    selectors: [["ngb-rating"]],
    contentQueries: function NgbRating_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, _angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef, 5);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.starTemplateFromContent = _t.first);
      }
    },
    hostAttrs: ["role", "slider", "aria-valuemin", "0", 1, "d-inline-flex"],
    hostVars: 5,
    hostBindings: function NgbRating_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("blur", function NgbRating_blur_HostBindingHandler() {
          return ctx.handleBlur();
        })("keydown", function NgbRating_keydown_HostBindingHandler($event) {
          return ctx.handleKeyDown($event);
        })("mouseleave", function NgbRating_mouseleave_HostBindingHandler() {
          return ctx.reset();
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("tabindex", ctx.disabled ? -1 : 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-valuemax", ctx.max)("aria-valuenow", ctx.nextRate)("aria-valuetext", ctx.ariaValueText())("aria-disabled", ctx.readonly ? true : null);
      }
    },
    inputs: {
      max: "max",
      readonly: "readonly",
      rate: "rate",
      resettable: "resettable",
      starTemplate: "starTemplate"
    },
    outputs: {
      hover: "hover",
      leave: "leave",
      rateChange: "rateChange"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALUE_ACCESSOR,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbRating),
      multi: true
    }]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
    decls: 3,
    vars: 1,
    consts: [["t", ""], ["ngFor", "", 3, "ngForOf"], [1, "sr-only"], [3, "mouseenter", "click"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"]],
    template: function NgbRating_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbRating_ng_template_0_Template, 1, 1, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbRating_ng_template_2_Template, 4, 5, "ng-template", 1);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.contexts);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbRating;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbRatingModule = /*#__PURE__*/(() => {
  class NgbRatingModule {}

  NgbRatingModule.ɵfac = function NgbRatingModule_Factory(t) {
    return new (t || NgbRatingModule)();
  };

  NgbRatingModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbRatingModule
  });
  NgbRatingModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbRatingModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbRatingModule, {
    declarations: function () {
      return [NgbRating];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbRating];
    }
  });
})();

class NgbTime {
  constructor(hour, minute, second) {
    this.hour = toInteger(hour);
    this.minute = toInteger(minute);
    this.second = toInteger(second);
  }

  changeHour(step = 1) {
    this.updateHour((isNaN(this.hour) ? 0 : this.hour) + step);
  }

  updateHour(hour) {
    if (isNumber(hour)) {
      this.hour = (hour < 0 ? 24 + hour : hour) % 24;
    } else {
      this.hour = NaN;
    }
  }

  changeMinute(step = 1) {
    this.updateMinute((isNaN(this.minute) ? 0 : this.minute) + step);
  }

  updateMinute(minute) {
    if (isNumber(minute)) {
      this.minute = minute % 60 < 0 ? 60 + minute % 60 : minute % 60;
      this.changeHour(Math.floor(minute / 60));
    } else {
      this.minute = NaN;
    }
  }

  changeSecond(step = 1) {
    this.updateSecond((isNaN(this.second) ? 0 : this.second) + step);
  }

  updateSecond(second) {
    if (isNumber(second)) {
      this.second = second < 0 ? 60 + second % 60 : second % 60;
      this.changeMinute(Math.floor(second / 60));
    } else {
      this.second = NaN;
    }
  }

  isValid(checkSecs = true) {
    return isNumber(this.hour) && isNumber(this.minute) && (checkSecs ? isNumber(this.second) : true);
  }

  toString() {
    return `${this.hour || 0}:${this.minute || 0}:${this.second || 0}`;
  }

}
/**
 * A configuration service for the [`NgbTimepicker`](#/components/timepicker/api#NgbTimepicker) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the timepickers used in the application.
 */


let NgbTimepickerConfig = /*#__PURE__*/(() => {
  class NgbTimepickerConfig {
    constructor() {
      this.meridian = false;
      this.spinners = true;
      this.seconds = false;
      this.hourStep = 1;
      this.minuteStep = 1;
      this.secondStep = 1;
      this.disabled = false;
      this.readonlyInputs = false;
      this.size = 'medium';
    }

  }

  NgbTimepickerConfig.ɵfac = function NgbTimepickerConfig_Factory(t) {
    return new (t || NgbTimepickerConfig)();
  };

  NgbTimepickerConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbTimepickerConfig_Factory() {
      return new NgbTimepickerConfig();
    },
    token: NgbTimepickerConfig,
    providedIn: "root"
  });
  return NgbTimepickerConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

function NGB_DATEPICKER_TIME_ADAPTER_FACTORY() {
  return new NgbTimeStructAdapter();
}
/**
 * An abstract service that does the conversion between the internal timepicker `NgbTimeStruct` model and
 * any provided user time model `T`, ex. a string, a native date, etc.
 *
 * The adapter is used **only** for conversion when binding timepicker to a form control,
 * ex. `[(ngModel)]="userTimeModel"`. Here `userTimeModel` can be of any type.
 *
 * The default timepicker implementation assumes we use `NgbTimeStruct` as a user model.
 *
 * See the [custom time adapter demo](#/components/timepicker/examples#adapter) for an example.
 *
 * @since 2.2.0
 */


let NgbTimeAdapter = /*#__PURE__*/(() => {
  class NgbTimeAdapter {}

  NgbTimeAdapter.ɵfac = function NgbTimeAdapter_Factory(t) {
    return new (t || NgbTimeAdapter)();
  };

  NgbTimeAdapter.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: NGB_DATEPICKER_TIME_ADAPTER_FACTORY,
    token: NgbTimeAdapter,
    providedIn: "root"
  });
  return NgbTimeAdapter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbTimeStructAdapter = /*#__PURE__*/(() => {
  class NgbTimeStructAdapter extends NgbTimeAdapter {
    /**
     * Converts a NgbTimeStruct value into NgbTimeStruct value
     */
    fromModel(time) {
      return time && isInteger(time.hour) && isInteger(time.minute) ? {
        hour: time.hour,
        minute: time.minute,
        second: isInteger(time.second) ? time.second : null
      } : null;
    }
    /**
     * Converts a NgbTimeStruct value into NgbTimeStruct value
     */


    toModel(time) {
      return time && isInteger(time.hour) && isInteger(time.minute) ? {
        hour: time.hour,
        minute: time.minute,
        second: isInteger(time.second) ? time.second : null
      } : null;
    }

  }

  NgbTimeStructAdapter.ɵfac = /*@__PURE__*/function () {
    let ɵNgbTimeStructAdapter_BaseFactory;
    return function NgbTimeStructAdapter_Factory(t) {
      return (ɵNgbTimeStructAdapter_BaseFactory || (ɵNgbTimeStructAdapter_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetInheritedFactory"](NgbTimeStructAdapter)))(t || NgbTimeStructAdapter);
    };
  }();

  NgbTimeStructAdapter.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbTimeStructAdapter,
    factory: NgbTimeStructAdapter.ɵfac
  });
  return NgbTimeStructAdapter;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

function NGB_TIMEPICKER_I18N_FACTORY(locale) {
  return new NgbTimepickerI18nDefault(locale);
}
/**
 * Type of the service supplying day periods (for example, 'AM' and 'PM') to NgbTimepicker component.
 * The default implementation of this service honors the Angular locale, and uses the registered locale data,
 * as explained in the Angular i18n guide.
 */


let NgbTimepickerI18n = /*#__PURE__*/(() => {
  class NgbTimepickerI18n {}

  NgbTimepickerI18n.ɵfac = function NgbTimepickerI18n_Factory(t) {
    return new (t || NgbTimepickerI18n)();
  };

  NgbTimepickerI18n.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbTimepickerI18n_Factory() {
      return NGB_TIMEPICKER_I18N_FACTORY((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_core__WEBPACK_IMPORTED_MODULE_0__.LOCALE_ID));
    },
    token: NgbTimepickerI18n,
    providedIn: "root"
  });
  return NgbTimepickerI18n;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbTimepickerI18nDefault = /*#__PURE__*/(() => {
  class NgbTimepickerI18nDefault extends NgbTimepickerI18n {
    constructor(locale) {
      super();
      this._periods = (0,_angular_common__WEBPACK_IMPORTED_MODULE_12__.getLocaleDayPeriods)(locale, _angular_common__WEBPACK_IMPORTED_MODULE_12__.FormStyle.Standalone, _angular_common__WEBPACK_IMPORTED_MODULE_12__.TranslationWidth.Narrow);
    }

    getMorningPeriod() {
      return this._periods[0];
    }

    getAfternoonPeriod() {
      return this._periods[1];
    }

  }

  NgbTimepickerI18nDefault.ɵfac = function NgbTimepickerI18nDefault_Factory(t) {
    return new (t || NgbTimepickerI18nDefault)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.LOCALE_ID));
  };

  NgbTimepickerI18nDefault.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: NgbTimepickerI18nDefault,
    factory: NgbTimepickerI18nDefault.ɵfac
  });
  return NgbTimepickerI18nDefault;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const FILTER_REGEX = /[^0-9]/g;
/**
 * A directive that helps with wth picking hours, minutes and seconds.
 */

let NgbTimepicker = /*#__PURE__*/(() => {
  class NgbTimepicker {
    constructor(_config, _ngbTimeAdapter, _cd, i18n) {
      this._config = _config;
      this._ngbTimeAdapter = _ngbTimeAdapter;
      this._cd = _cd;
      this.i18n = i18n;

      this.onChange = _ => {};

      this.onTouched = () => {};

      this.meridian = _config.meridian;
      this.spinners = _config.spinners;
      this.seconds = _config.seconds;
      this.hourStep = _config.hourStep;
      this.minuteStep = _config.minuteStep;
      this.secondStep = _config.secondStep;
      this.disabled = _config.disabled;
      this.readonlyInputs = _config.readonlyInputs;
      this.size = _config.size;
    }
    /**
     * The number of hours to add/subtract when clicking hour spinners.
     */


    set hourStep(step) {
      this._hourStep = isInteger(step) ? step : this._config.hourStep;
    }

    get hourStep() {
      return this._hourStep;
    }
    /**
     * The number of minutes to add/subtract when clicking minute spinners.
     */


    set minuteStep(step) {
      this._minuteStep = isInteger(step) ? step : this._config.minuteStep;
    }

    get minuteStep() {
      return this._minuteStep;
    }
    /**
     * The number of seconds to add/subtract when clicking second spinners.
     */


    set secondStep(step) {
      this._secondStep = isInteger(step) ? step : this._config.secondStep;
    }

    get secondStep() {
      return this._secondStep;
    }

    writeValue(value) {
      const structValue = this._ngbTimeAdapter.fromModel(value);

      this.model = structValue ? new NgbTime(structValue.hour, structValue.minute, structValue.second) : new NgbTime();

      if (!this.seconds && (!structValue || !isNumber(structValue.second))) {
        this.model.second = 0;
      }

      this._cd.markForCheck();
    }

    registerOnChange(fn) {
      this.onChange = fn;
    }

    registerOnTouched(fn) {
      this.onTouched = fn;
    }

    setDisabledState(isDisabled) {
      this.disabled = isDisabled;
    }

    changeHour(step) {
      this.model.changeHour(step);
      this.propagateModelChange();
    }

    changeMinute(step) {
      this.model.changeMinute(step);
      this.propagateModelChange();
    }

    changeSecond(step) {
      this.model.changeSecond(step);
      this.propagateModelChange();
    }

    updateHour(newVal) {
      const isPM = this.model.hour >= 12;
      const enteredHour = toInteger(newVal);

      if (this.meridian && (isPM && enteredHour < 12 || !isPM && enteredHour === 12)) {
        this.model.updateHour(enteredHour + 12);
      } else {
        this.model.updateHour(enteredHour);
      }

      this.propagateModelChange();
    }

    updateMinute(newVal) {
      this.model.updateMinute(toInteger(newVal));
      this.propagateModelChange();
    }

    updateSecond(newVal) {
      this.model.updateSecond(toInteger(newVal));
      this.propagateModelChange();
    }

    toggleMeridian() {
      if (this.meridian) {
        this.changeHour(12);
      }
    }

    formatInput(input) {
      input.value = input.value.replace(FILTER_REGEX, '');
    }

    formatHour(value) {
      if (isNumber(value)) {
        if (this.meridian) {
          return padNumber(value % 12 === 0 ? 12 : value % 12);
        } else {
          return padNumber(value % 24);
        }
      } else {
        return padNumber(NaN);
      }
    }

    formatMinSec(value) {
      return padNumber(isNumber(value) ? value : NaN);
    }

    get isSmallSize() {
      return this.size === 'small';
    }

    get isLargeSize() {
      return this.size === 'large';
    }

    ngOnChanges(changes) {
      if (changes['seconds'] && !this.seconds && this.model && !isNumber(this.model.second)) {
        this.model.second = 0;
        this.propagateModelChange(false);
      }
    }

    propagateModelChange(touched = true) {
      if (touched) {
        this.onTouched();
      }

      if (this.model.isValid(this.seconds)) {
        this.onChange(this._ngbTimeAdapter.toModel({
          hour: this.model.hour,
          minute: this.model.minute,
          second: this.model.second
        }));
      } else {
        this.onChange(this._ngbTimeAdapter.toModel(null));
      }
    }

  }

  NgbTimepicker.ɵfac = function NgbTimepicker_Factory(t) {
    return new (t || NgbTimepicker)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbTimepickerConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbTimeAdapter), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbTimepickerI18n));
  };

  NgbTimepicker.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbTimepicker,
    selectors: [["ngb-timepicker"]],
    inputs: {
      meridian: "meridian",
      spinners: "spinners",
      seconds: "seconds",
      hourStep: "hourStep",
      minuteStep: "minuteStep",
      secondStep: "secondStep",
      readonlyInputs: "readonlyInputs",
      size: "size"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALUE_ACCESSOR,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbTimepicker),
      multi: true
    }]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
    decls: 16,
    vars: 25,
    consts: function () {
      let i18n_56;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_HH$$FESM2015_NG_BOOTSTRAP_JS_57 = goog.getMsg("HH");
        i18n_56 = MSG_EXTERNAL_ngb_timepicker_HH$$FESM2015_NG_BOOTSTRAP_JS_57;
      } else {
        i18n_56 = $localize`:@@ngb.timepicker.HH␟ce676ab1d6d98f85c836381cf100a4a91ef95a1f␟4043638465245303811:HH`;
      }

      let i18n_58;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_hours$$FESM2015_NG_BOOTSTRAP_JS_59 = goog.getMsg("Hours");
        i18n_58 = MSG_EXTERNAL_ngb_timepicker_hours$$FESM2015_NG_BOOTSTRAP_JS_59;
      } else {
        i18n_58 = $localize`:@@ngb.timepicker.hours␟3bbce5fef7e1151da052a4e529453edb340e3912␟8070396816726827304:Hours`;
      }

      let i18n_60;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_MM$$FESM2015_NG_BOOTSTRAP_JS_61 = goog.getMsg("MM");
        i18n_60 = MSG_EXTERNAL_ngb_timepicker_MM$$FESM2015_NG_BOOTSTRAP_JS_61;
      } else {
        i18n_60 = $localize`:@@ngb.timepicker.MM␟72c8edf6a50068a05bde70991e36b1e881f4ca54␟1647282246509919852:MM`;
      }

      let i18n_62;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_minutes$$FESM2015_NG_BOOTSTRAP_JS_63 = goog.getMsg("Minutes");
        i18n_62 = MSG_EXTERNAL_ngb_timepicker_minutes$$FESM2015_NG_BOOTSTRAP_JS_63;
      } else {
        i18n_62 = $localize`:@@ngb.timepicker.minutes␟41e62daa962947c0d23ded0981975d1bddf0bf38␟5531237363767747080:Minutes`;
      }

      let i18n_64;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_increment_hours$$FESM2015_NG_BOOTSTRAP_JS__65 = goog.getMsg("Increment hours");
        i18n_64 = MSG_EXTERNAL_ngb_timepicker_increment_hours$$FESM2015_NG_BOOTSTRAP_JS__65;
      } else {
        i18n_64 = $localize`:@@ngb.timepicker.increment-hours␟cb74bc1d625a6c1742f0d7d47306cf495780c218␟5939278348542933629:Increment hours`;
      }

      let i18n_66;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_decrement_hours$$FESM2015_NG_BOOTSTRAP_JS__67 = goog.getMsg("Decrement hours");
        i18n_66 = MSG_EXTERNAL_ngb_timepicker_decrement_hours$$FESM2015_NG_BOOTSTRAP_JS__67;
      } else {
        i18n_66 = $localize`:@@ngb.timepicker.decrement-hours␟147c7a19429da7d999e247d22e33fee370b1691b␟3651829882940481818:Decrement hours`;
      }

      let i18n_68;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_increment_minutes$$FESM2015_NG_BOOTSTRAP_JS__69 = goog.getMsg("Increment minutes");
        i18n_68 = MSG_EXTERNAL_ngb_timepicker_increment_minutes$$FESM2015_NG_BOOTSTRAP_JS__69;
      } else {
        i18n_68 = $localize`:@@ngb.timepicker.increment-minutes␟f5a4a3bc05e053f6732475d0e74875ec01c3a348␟180147720391025024:Increment minutes`;
      }

      let i18n_70;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_decrement_minutes$$FESM2015_NG_BOOTSTRAP_JS__71 = goog.getMsg("Decrement minutes");
        i18n_70 = MSG_EXTERNAL_ngb_timepicker_decrement_minutes$$FESM2015_NG_BOOTSTRAP_JS__71;
      } else {
        i18n_70 = $localize`:@@ngb.timepicker.decrement-minutes␟c1a6899e529c096da5b660385d4e77fe1f7ad271␟7447789825403243588:Decrement minutes`;
      }

      let i18n_72;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_SS$$FESM2015_NG_BOOTSTRAP_JS__73 = goog.getMsg("SS");
        i18n_72 = MSG_EXTERNAL_ngb_timepicker_SS$$FESM2015_NG_BOOTSTRAP_JS__73;
      } else {
        i18n_72 = $localize`:@@ngb.timepicker.SS␟ebe38d36a40a2383c5fefa9b4608ffbda08bd4a3␟3628127143071124194:SS`;
      }

      let i18n_74;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_seconds$$FESM2015_NG_BOOTSTRAP_JS__75 = goog.getMsg("Seconds");
        i18n_74 = MSG_EXTERNAL_ngb_timepicker_seconds$$FESM2015_NG_BOOTSTRAP_JS__75;
      } else {
        i18n_74 = $localize`:@@ngb.timepicker.seconds␟4f2ed9e71a7c981db3e50ae2fedb28aff2ec4e6c␟8874012390997067175:Seconds`;
      }

      let i18n_76;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_increment_seconds$$FESM2015_NG_BOOTSTRAP_JS___77 = goog.getMsg("Increment seconds");
        i18n_76 = MSG_EXTERNAL_ngb_timepicker_increment_seconds$$FESM2015_NG_BOOTSTRAP_JS___77;
      } else {
        i18n_76 = $localize`:@@ngb.timepicker.increment-seconds␟912322ecee7d659d04dcf494a70e22e49d334b26␟5364772110539092174:Increment seconds`;
      }

      let i18n_78;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_decrement_seconds$$FESM2015_NG_BOOTSTRAP_JS___79 = goog.getMsg("Decrement seconds");
        i18n_78 = MSG_EXTERNAL_ngb_timepicker_decrement_seconds$$FESM2015_NG_BOOTSTRAP_JS___79;
      } else {
        i18n_78 = $localize`:@@ngb.timepicker.decrement-seconds␟5db47ac104294243a70eb9124fbea9d0004ddf69␟753633511487974857:Decrement seconds`;
      }

      let i18n_80;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_PM$$FESM2015_NG_BOOTSTRAP_JS___81 = goog.getMsg("{$interpolation}", {
          "interpolation": "\uFFFD0\uFFFD"
        }, {
          original_code: {
            "interpolation": "{{ i18n.getAfternoonPeriod() }}"
          }
        });
        i18n_80 = MSG_EXTERNAL_ngb_timepicker_PM$$FESM2015_NG_BOOTSTRAP_JS___81;
      } else {
        i18n_80 = $localize`:@@ngb.timepicker.PM␟8d6e691e10306c1b34c6b26805151aaea320ef7f␟3564199131264287502:${"\uFFFD0\uFFFD"}:INTERPOLATION:`;
      }

      let i18n_82;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_timepicker_AM$$FESM2015_NG_BOOTSTRAP_JS___83 = goog.getMsg("{$interpolation}", {
          "interpolation": "\uFFFD0\uFFFD"
        }, {
          original_code: {
            "interpolation": "{{ i18n.getMorningPeriod() }}"
          }
        });
        i18n_82 = MSG_EXTERNAL_ngb_timepicker_AM$$FESM2015_NG_BOOTSTRAP_JS___83;
      } else {
        i18n_82 = $localize`:@@ngb.timepicker.AM␟69a1f176a93998876952adac57c3bc3863b6105e␟4592818992509942761:${"\uFFFD0\uFFFD"}:INTERPOLATION:`;
      }

      return [[3, "disabled"], [1, "ngb-tp"], [1, "ngb-tp-input-container", "ngb-tp-hour"], ["tabindex", "-1", "type", "button", "class", "btn btn-link", 3, "btn-sm", "btn-lg", "disabled", "click", 4, "ngIf"], ["type", "text", "maxlength", "2", "inputmode", "numeric", "placeholder", i18n_56, "aria-label", i18n_58, 1, "ngb-tp-input", "form-control", 3, "value", "readOnly", "disabled", "change", "input", "keydown.ArrowUp", "keydown.ArrowDown"], [1, "ngb-tp-spacer"], [1, "ngb-tp-input-container", "ngb-tp-minute"], ["type", "text", "maxlength", "2", "inputmode", "numeric", "placeholder", i18n_60, "aria-label", i18n_62, 1, "ngb-tp-input", "form-control", 3, "value", "readOnly", "disabled", "change", "input", "keydown.ArrowUp", "keydown.ArrowDown"], ["class", "ngb-tp-spacer", 4, "ngIf"], ["class", "ngb-tp-input-container ngb-tp-second", 4, "ngIf"], ["class", "ngb-tp-meridian", 4, "ngIf"], ["tabindex", "-1", "type", "button", 1, "btn", "btn-link", 3, "disabled", "click"], [1, "chevron", "ngb-tp-chevron"], [1, "sr-only"], i18n_64, [1, "chevron", "ngb-tp-chevron", "bottom"], i18n_66, i18n_68, i18n_70, [1, "ngb-tp-input-container", "ngb-tp-second"], ["type", "text", "maxlength", "2", "inputmode", "numeric", "placeholder", i18n_72, "aria-label", i18n_74, 1, "ngb-tp-input", "form-control", 3, "value", "readOnly", "disabled", "change", "input", "keydown.ArrowUp", "keydown.ArrowDown"], i18n_76, i18n_78, [1, "ngb-tp-meridian"], ["type", "button", 1, "btn", "btn-outline-primary", 3, "disabled", "click"], [4, "ngIf", "ngIfElse"], ["am", ""], i18n_80, i18n_82];
    },
    template: function NgbTimepicker_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "fieldset", 0)(1, "div", 1)(2, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, NgbTimepicker_button_3_Template, 4, 7, "button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](4, "input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function NgbTimepicker_Template_input_change_4_listener($event) {
          return ctx.updateHour($event.target.value);
        })("input", function NgbTimepicker_Template_input_input_4_listener($event) {
          return ctx.formatInput($event.target);
        })("keydown.ArrowUp", function NgbTimepicker_Template_input_keydown_ArrowUp_4_listener($event) {
          ctx.changeHour(ctx.hourStep);
          return $event.preventDefault();
        })("keydown.ArrowDown", function NgbTimepicker_Template_input_keydown_ArrowDown_4_listener($event) {
          ctx.changeHour(-ctx.hourStep);
          return $event.preventDefault();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](5, NgbTimepicker_button_5_Template, 4, 7, "button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](6, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](7, ":");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](8, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](9, NgbTimepicker_button_9_Template, 4, 7, "button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](10, "input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function NgbTimepicker_Template_input_change_10_listener($event) {
          return ctx.updateMinute($event.target.value);
        })("input", function NgbTimepicker_Template_input_input_10_listener($event) {
          return ctx.formatInput($event.target);
        })("keydown.ArrowUp", function NgbTimepicker_Template_input_keydown_ArrowUp_10_listener($event) {
          ctx.changeMinute(ctx.minuteStep);
          return $event.preventDefault();
        })("keydown.ArrowDown", function NgbTimepicker_Template_input_keydown_ArrowDown_10_listener($event) {
          ctx.changeMinute(-ctx.minuteStep);
          return $event.preventDefault();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](11, NgbTimepicker_button_11_Template, 4, 7, "button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](12, NgbTimepicker_div_12_Template, 2, 0, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](13, NgbTimepicker_div_13_Template, 4, 9, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](14, NgbTimepicker_div_14_Template, 1, 0, "div", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](15, NgbTimepicker_div_15_Template, 5, 9, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("disabled", ctx.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.spinners);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("form-control-sm", ctx.isSmallSize)("form-control-lg", ctx.isLargeSize);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx.formatHour(ctx.model == null ? null : ctx.model.hour))("readOnly", ctx.readonlyInputs)("disabled", ctx.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.spinners);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.spinners);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("form-control-sm", ctx.isSmallSize)("form-control-lg", ctx.isLargeSize);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("value", ctx.formatMinSec(ctx.model == null ? null : ctx.model.minute))("readOnly", ctx.readonlyInputs)("disabled", ctx.disabled);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.spinners);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.seconds);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.seconds);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.meridian);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.meridian);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf],
    styles: ["ngb-timepicker{font-size:1rem}.ngb-tp{-ms-flex-align:center;align-items:center;display:-ms-flexbox;display:flex}.ngb-tp-input-container{width:4em}.ngb-tp-chevron:before{-webkit-transform:rotate(-45deg);border-style:solid;border-width:.29em .29em 0 0;content:\"\";display:inline-block;height:.69em;left:.05em;position:relative;top:.15em;transform:rotate(-45deg);vertical-align:middle;width:.69em}.ngb-tp-chevron.bottom:before{-webkit-transform:rotate(135deg);top:-.3em;transform:rotate(135deg)}.ngb-tp-input{text-align:center}.ngb-tp-hour,.ngb-tp-meridian,.ngb-tp-minute,.ngb-tp-second{-ms-flex-align:center;-ms-flex-direction:column;-ms-flex-pack:distribute;align-items:center;display:-ms-flexbox;display:flex;flex-direction:column;justify-content:space-around}.ngb-tp-spacer{text-align:center;width:1em}"],
    encapsulation: 2
  });
  return NgbTimepicker;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbTimepickerModule = /*#__PURE__*/(() => {
  class NgbTimepickerModule {}

  NgbTimepickerModule.ɵfac = function NgbTimepickerModule_Factory(t) {
    return new (t || NgbTimepickerModule)();
  };

  NgbTimepickerModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbTimepickerModule
  });
  NgbTimepickerModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbTimepickerModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbTimepickerModule, {
    declarations: function () {
      return [NgbTimepicker];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbTimepicker];
    }
  });
})();
/**
 * Configuration service for the NgbToast component. You can inject this service, typically in your root component,
 * and customize the values of its properties in order to provide default values for all the toasts used in the
 * application.
 *
 * @since 5.0.0
 */


let NgbToastConfig = /*#__PURE__*/(() => {
  class NgbToastConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.autohide = true;
      this.delay = 500;
      this.ariaLive = 'polite';
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbToastConfig.ɵfac = function NgbToastConfig_Factory(t) {
    return new (t || NgbToastConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbToastConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbToastConfig_Factory() {
      return new NgbToastConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbToastConfig,
    providedIn: "root"
  });
  return NgbToastConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const ngbToastFadeInTransition = (element, animation) => {
  const {
    classList
  } = element;

  if (!animation) {
    classList.add('show');
    return;
  }

  classList.remove('hide');
  reflow(element);
  classList.add('showing');
  return () => {
    classList.remove('showing');
    classList.add('show');
  };
};

const ngbToastFadeOutTransition = ({
  classList
}) => {
  classList.remove('show');
  return () => {
    classList.add('hide');
  };
};
/**
 * This directive allows the usage of HTML markup or other directives
 * inside of the toast's header.
 *
 * @since 5.0.0
 */


let NgbToastHeader = /*#__PURE__*/(() => {
  class NgbToastHeader {}

  NgbToastHeader.ɵfac = function NgbToastHeader_Factory(t) {
    return new (t || NgbToastHeader)();
  };

  NgbToastHeader.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbToastHeader,
    selectors: [["", "ngbToastHeader", ""]]
  });
  return NgbToastHeader;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * Toasts provide feedback messages as notifications to the user.
 * Goal is to mimic the push notifications available both on mobile and desktop operating systems.
 *
 * @since 5.0.0
 */


let NgbToast = /*#__PURE__*/(() => {
  class NgbToast {
    constructor(ariaLive, config, _zone, _element) {
      this.ariaLive = ariaLive;
      this._zone = _zone;
      this._element = _element;
      /**
       * A template like `<ng-template ngbToastHeader></ng-template>` can be
       * used in the projected content to allow markup usage.
       */

      this.contentHeaderTpl = null;
      /**
       * An event fired after the animation triggered by calling `.show()` method has finished.
       *
       * @since 8.0.0
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event fired after the animation triggered by calling `.hide()` method has finished.
       *
       * It can only occur in 2 different scenarios:
       * - `autohide` timeout fires
       * - user clicks on a closing cross
       *
       * Additionally this output is purely informative. The toast won't be removed from DOM automatically, it's up
       * to the user to take care of that.
       *
       * @since 8.0.0
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();

      if (this.ariaLive == null) {
        this.ariaLive = config.ariaLive;
      }

      this.delay = config.delay;
      this.autohide = config.autohide;
      this.animation = config.animation;
    }

    ngAfterContentInit() {
      this._zone.onStable.asObservable().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.take)(1)).subscribe(() => {
        this._init();

        this.show();
      });
    }

    ngOnChanges(changes) {
      if ('autohide' in changes) {
        this._clearTimeout();

        this._init();
      }
    }
    /**
     * Triggers toast closing programmatically.
     *
     * The returned observable will emit and be completed once the closing transition has finished.
     * If the animations are turned off this happens synchronously.
     *
     * Alternatively you could listen or subscribe to the `(hidden)` output
     *
     * @since 8.0.0
     */


    hide() {
      this._clearTimeout();

      const transition = ngbRunTransition(this._zone, this._element.nativeElement, ngbToastFadeOutTransition, {
        animation: this.animation,
        runningTransition: 'stop'
      });
      transition.subscribe(() => {
        this.hidden.emit();
      });
      return transition;
    }
    /**
     * Triggers toast opening programmatically.
     *
     * The returned observable will emit and be completed once the opening transition has finished.
     * If the animations are turned off this happens synchronously.
     *
     * Alternatively you could listen or subscribe to the `(shown)` output
     *
     * @since 8.0.0
     */


    show() {
      const transition = ngbRunTransition(this._zone, this._element.nativeElement, ngbToastFadeInTransition, {
        animation: this.animation,
        runningTransition: 'continue'
      });
      transition.subscribe(() => {
        this.shown.emit();
      });
      return transition;
    }

    _init() {
      if (this.autohide && !this._timeoutID) {
        this._timeoutID = setTimeout(() => this.hide(), this.delay);
      }
    }

    _clearTimeout() {
      if (this._timeoutID) {
        clearTimeout(this._timeoutID);
        this._timeoutID = null;
      }
    }

  }

  NgbToast.ɵfac = function NgbToast_Factory(t) {
    return new (t || NgbToast)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinjectAttribute"]('aria-live'), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbToastConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef));
  };

  NgbToast.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbToast,
    selectors: [["ngb-toast"]],
    contentQueries: function NgbToast_ContentQueries(rf, ctx, dirIndex) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵcontentQuery"](dirIndex, NgbToastHeader, 7, _angular_core__WEBPACK_IMPORTED_MODULE_0__.TemplateRef);
      }

      if (rf & 2) {
        let _t;

        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵloadQuery"]()) && (ctx.contentHeaderTpl = _t.first);
      }
    },
    hostAttrs: ["role", "alert", "aria-atomic", "true", 1, "toast"],
    hostVars: 3,
    hostBindings: function NgbToast_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-live", ctx.ariaLive);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("fade", ctx.animation);
      }
    },
    inputs: {
      delay: "delay",
      autohide: "autohide",
      animation: "animation",
      header: "header"
    },
    outputs: {
      shown: "shown",
      hidden: "hidden"
    },
    exportAs: ["ngbToast"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
    ngContentSelectors: _c3,
    decls: 5,
    vars: 1,
    consts: function () {
      let i18n_84;

      if (typeof ngI18nClosureMode !== "undefined" && ngI18nClosureMode) {
        /**
         * @suppress {msgDescriptions}
         */
        const MSG_EXTERNAL_ngb_toast_close_aria$$FESM2015_NG_BOOTSTRAP_JS__85 = goog.getMsg("Close");
        i18n_84 = MSG_EXTERNAL_ngb_toast_close_aria$$FESM2015_NG_BOOTSTRAP_JS__85;
      } else {
        i18n_84 = $localize`:@@ngb.toast.close-aria␟f4e529ae5ffd73001d1ff4bbdeeb0a72e342e5c8␟7819314041543176992:Close`;
      }

      return [["headerTpl", ""], [3, "ngIf"], [1, "toast-body"], [1, "mr-auto"], [1, "toast-header"], [3, "ngTemplateOutlet"], ["type", "button", "aria-label", i18n_84, 1, "close", 3, "click"], ["aria-hidden", "true"]];
    },
    template: function NgbToast_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbToast_ng_template_0_Template, 2, 1, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbToast_ng_template_2_Template, 5, 1, "ng-template", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](3, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx.contentHeaderTpl || ctx.header);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet],
    styles: [".ngb-toasts{margin:.5em;position:fixed;right:0;top:0;z-index:1200}ngb-toast{display:block}ngb-toast .toast-header .close{margin-bottom:.25rem;margin-left:auto}"],
    encapsulation: 2
  });
  return NgbToast;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbToastModule = /*#__PURE__*/(() => {
  class NgbToastModule {}

  NgbToastModule.ɵfac = function NgbToastModule_Factory(t) {
    return new (t || NgbToastModule)();
  };

  NgbToastModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbToastModule
  });
  NgbToastModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbToastModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbToastModule, {
    declarations: function () {
      return [NgbToast, NgbToastHeader];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbToast, NgbToastHeader];
    }
  });
})();
/**
 * A configuration service for the [`NgbTooltip`](#/components/tooltip/api#NgbTooltip) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the tooltips used in the application.
 */


let NgbTooltipConfig = /*#__PURE__*/(() => {
  class NgbTooltipConfig {
    constructor(_ngbConfig) {
      this._ngbConfig = _ngbConfig;
      this.autoClose = true;
      this.placement = 'auto';
      this.triggers = 'hover focus';
      this.disableTooltip = false;
      this.openDelay = 0;
      this.closeDelay = 0;
    }

    get animation() {
      return this._animation === undefined ? this._ngbConfig.animation : this._animation;
    }

    set animation(animation) {
      this._animation = animation;
    }

  }

  NgbTooltipConfig.ɵfac = function NgbTooltipConfig_Factory(t) {
    return new (t || NgbTooltipConfig)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](NgbConfig));
  };

  NgbTooltipConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbTooltipConfig_Factory() {
      return new NgbTooltipConfig((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(NgbConfig));
    },
    token: NgbTooltipConfig,
    providedIn: "root"
  });
  return NgbTooltipConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let nextId$4 = 0;
let NgbTooltipWindow = /*#__PURE__*/(() => {
  class NgbTooltipWindow {}

  NgbTooltipWindow.ɵfac = function NgbTooltipWindow_Factory(t) {
    return new (t || NgbTooltipWindow)();
  };

  NgbTooltipWindow.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbTooltipWindow,
    selectors: [["ngb-tooltip-window"]],
    hostAttrs: ["role", "tooltip"],
    hostVars: 5,
    hostBindings: function NgbTooltipWindow_HostBindings(rf, ctx) {
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("id", ctx.id);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("tooltip" + (ctx.tooltipClass ? " " + ctx.tooltipClass : ""));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("fade", ctx.animation);
      }
    },
    inputs: {
      animation: "animation",
      id: "id",
      tooltipClass: "tooltipClass"
    },
    ngContentSelectors: _c3,
    decls: 3,
    vars: 0,
    consts: [[1, "arrow"], [1, "tooltip-inner"]],
    template: function NgbTooltipWindow_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojectionDef"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
      }
    },
    styles: ["ngb-tooltip-window.bs-tooltip-bottom .arrow,ngb-tooltip-window.bs-tooltip-top .arrow{left:calc(50% - .4rem)}ngb-tooltip-window.bs-tooltip-bottom-left .arrow,ngb-tooltip-window.bs-tooltip-top-left .arrow{left:1em}ngb-tooltip-window.bs-tooltip-bottom-right .arrow,ngb-tooltip-window.bs-tooltip-top-right .arrow{left:auto;right:.8rem}ngb-tooltip-window.bs-tooltip-left .arrow,ngb-tooltip-window.bs-tooltip-right .arrow{top:calc(50% - .4rem)}ngb-tooltip-window.bs-tooltip-left-top .arrow,ngb-tooltip-window.bs-tooltip-right-top .arrow{top:.4rem}ngb-tooltip-window.bs-tooltip-left-bottom .arrow,ngb-tooltip-window.bs-tooltip-right-bottom .arrow{bottom:.4rem;top:auto}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbTooltipWindow;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A lightweight and extensible directive for fancy tooltip creation.
 */


let NgbTooltip = /*#__PURE__*/(() => {
  class NgbTooltip {
    constructor(_elementRef, _renderer, injector, componentFactoryResolver, viewContainerRef, config, _ngZone, _document, _changeDetector, applicationRef) {
      this._elementRef = _elementRef;
      this._renderer = _renderer;
      this._ngZone = _ngZone;
      this._document = _document;
      this._changeDetector = _changeDetector;
      /**
       * An event emitted when the tooltip opening animation has finished. Contains no payload.
       */

      this.shown = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      /**
       * An event emitted when the tooltip closing animation has finished. Contains no payload.
       */

      this.hidden = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this._ngbTooltipWindowId = `ngb-tooltip-${nextId$4++}`;
      this._windowRef = null;
      this.animation = config.animation;
      this.autoClose = config.autoClose;
      this.placement = config.placement;
      this.triggers = config.triggers;
      this.container = config.container;
      this.disableTooltip = config.disableTooltip;
      this.tooltipClass = config.tooltipClass;
      this.openDelay = config.openDelay;
      this.closeDelay = config.closeDelay;
      this._popupService = new PopupService(NgbTooltipWindow, injector, viewContainerRef, _renderer, this._ngZone, componentFactoryResolver, applicationRef);
      this._zoneSubscription = _ngZone.onStable.subscribe(() => {
        if (this._windowRef) {
          positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, this.container === 'body', 'bs-tooltip');
        }
      });
    }
    /**
     * The string content or a `TemplateRef` for the content to be displayed in the tooltip.
     *
     * If the content if falsy, the tooltip won't open.
     */


    set ngbTooltip(value) {
      this._ngbTooltip = value;

      if (!value && this._windowRef) {
        this.close();
      }
    }

    get ngbTooltip() {
      return this._ngbTooltip;
    }
    /**
     * Opens the tooltip.
     *
     * This is considered to be a "manual" triggering.
     * The `context` is an optional value to be injected into the tooltip template when it is created.
     */


    open(context) {
      if (!this._windowRef && this._ngbTooltip && !this.disableTooltip) {
        const {
          windowRef,
          transition$
        } = this._popupService.open(this._ngbTooltip, context, this.animation);

        this._windowRef = windowRef;
        this._windowRef.instance.animation = this.animation;
        this._windowRef.instance.tooltipClass = this.tooltipClass;
        this._windowRef.instance.id = this._ngbTooltipWindowId;

        this._renderer.setAttribute(this._elementRef.nativeElement, 'aria-describedby', this._ngbTooltipWindowId);

        if (this.container === 'body') {
          this._document.querySelector(this.container).appendChild(this._windowRef.location.nativeElement);
        } // We need to detect changes, because we don't know where .open() might be called from.
        // Ex. opening tooltip from one of lifecycle hooks that run after the CD
        // (say from ngAfterViewInit) will result in 'ExpressionHasChanged' exception


        this._windowRef.changeDetectorRef.detectChanges(); // We need to mark for check, because tooltip won't work inside the OnPush component.
        // Ex. when we use expression like `{{ tooltip.isOpen() : 'opened' : 'closed' }}`
        // inside the template of an OnPush component and we change the tooltip from
        // open -> closed, the expression in question won't be updated unless we explicitly
        // mark the parent component to be checked.


        this._windowRef.changeDetectorRef.markForCheck();

        ngbAutoClose(this._ngZone, this._document, this.autoClose, () => this.close(), this.hidden, [this._windowRef.location.nativeElement]);
        transition$.subscribe(() => this.shown.emit());
      }
    }
    /**
     * Closes the tooltip.
     *
     * This is considered to be a "manual" triggering of the tooltip.
     */


    close() {
      if (this._windowRef != null) {
        this._renderer.removeAttribute(this._elementRef.nativeElement, 'aria-describedby');

        this._popupService.close(this.animation).subscribe(() => {
          this._windowRef = null;
          this.hidden.emit();

          this._changeDetector.markForCheck();
        });
      }
    }
    /**
     * Toggles the tooltip.
     *
     * This is considered to be a "manual" triggering of the tooltip.
     */


    toggle() {
      if (this._windowRef) {
        this.close();
      } else {
        this.open();
      }
    }
    /**
     * Returns `true`, if the popover is currently shown.
     */


    isOpen() {
      return this._windowRef != null;
    }

    ngOnInit() {
      this._unregisterListenersFn = listenToTriggers(this._renderer, this._elementRef.nativeElement, this.triggers, this.isOpen.bind(this), this.open.bind(this), this.close.bind(this), +this.openDelay, +this.closeDelay);
    }

    ngOnChanges({
      tooltipClass
    }) {
      if (tooltipClass && this.isOpen()) {
        this._windowRef.instance.tooltipClass = tooltipClass.currentValue;
      }
    }

    ngOnDestroy() {
      this.close(); // This check is needed as it might happen that ngOnDestroy is called before ngOnInit
      // under certain conditions, see: https://github.com/ng-bootstrap/ng-bootstrap/issues/2199

      if (this._unregisterListenersFn) {
        this._unregisterListenersFn();
      }

      this._zoneSubscription.unsubscribe();
    }

  }

  NgbTooltip.ɵfac = function NgbTooltip_Factory(t) {
    return new (t || NgbTooltip)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentFactoryResolver), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbTooltipConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ApplicationRef));
  };

  NgbTooltip.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbTooltip,
    selectors: [["", "ngbTooltip", ""]],
    inputs: {
      animation: "animation",
      autoClose: "autoClose",
      placement: "placement",
      triggers: "triggers",
      container: "container",
      disableTooltip: "disableTooltip",
      tooltipClass: "tooltipClass",
      openDelay: "openDelay",
      closeDelay: "closeDelay",
      ngbTooltip: "ngbTooltip"
    },
    outputs: {
      shown: "shown",
      hidden: "hidden"
    },
    exportAs: ["ngbTooltip"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]]
  });
  return NgbTooltip;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbTooltipModule = /*#__PURE__*/(() => {
  class NgbTooltipModule {}

  NgbTooltipModule.ɵfac = function NgbTooltipModule_Factory(t) {
    return new (t || NgbTooltipModule)();
  };

  NgbTooltipModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbTooltipModule
  });
  NgbTooltipModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({});
  return NgbTooltipModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbTooltipModule, {
    declarations: [NgbTooltip, NgbTooltipWindow],
    exports: [NgbTooltip]
  });
})();
/**
 * A component that helps with text highlighting.
 *
 * If splits the `result` text into parts that contain the searched `term` and generates the HTML markup to simplify
 * highlighting:
 *
 * Ex. `result="Alaska"` and `term="as"` will produce `Al<span class="ngb-highlight">as</span>ka`.
 */


let NgbHighlight = /*#__PURE__*/(() => {
  class NgbHighlight {
    constructor() {
      /**
       * The CSS class for `<span>` elements wrapping the `term` inside the `result`.
       */
      this.highlightClass = 'ngb-highlight';
    }

    ngOnChanges(changes) {
      const result = toString(this.result);
      const terms = Array.isArray(this.term) ? this.term : [this.term];
      const escapedTerms = terms.map(term => regExpEscape(toString(term))).filter(term => term);
      this.parts = escapedTerms.length ? result.split(new RegExp(`(${escapedTerms.join('|')})`, 'gmi')) : [result];
    }

  }

  NgbHighlight.ɵfac = function NgbHighlight_Factory(t) {
    return new (t || NgbHighlight)();
  };

  NgbHighlight.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbHighlight,
    selectors: [["ngb-highlight"]],
    inputs: {
      highlightClass: "highlightClass",
      result: "result",
      term: "term"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵNgOnChangesFeature"]],
    decls: 1,
    vars: 1,
    consts: [["ngFor", "", 3, "ngForOf"], [3, "class", 4, "ngIf", "ngIfElse"], ["even", ""]],
    template: function NgbHighlight_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbHighlight_ng_template_0_Template, 3, 2, "ng-template", 0);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.parts);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf],
    styles: [".ngb-highlight{font-weight:700}"],
    encapsulation: 2,
    changeDetection: 0
  });
  return NgbHighlight;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbTypeaheadWindow = /*#__PURE__*/(() => {
  class NgbTypeaheadWindow {
    constructor() {
      this.activeIdx = 0;
      /**
       * Flag indicating if the first row should be active initially
       */

      this.focusFirst = true;
      /**
       * A function used to format a given result before display. This function should return a formatted string without any
       * HTML markup
       */

      this.formatter = toString;
      /**
       * Event raised when user selects a particular result row
       */

      this.selectEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.activeChangeEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
    }

    hasActive() {
      return this.activeIdx > -1 && this.activeIdx < this.results.length;
    }

    getActive() {
      return this.results[this.activeIdx];
    }

    markActive(activeIdx) {
      this.activeIdx = activeIdx;

      this._activeChanged();
    }

    next() {
      if (this.activeIdx === this.results.length - 1) {
        this.activeIdx = this.focusFirst ? (this.activeIdx + 1) % this.results.length : -1;
      } else {
        this.activeIdx++;
      }

      this._activeChanged();
    }

    prev() {
      if (this.activeIdx < 0) {
        this.activeIdx = this.results.length - 1;
      } else if (this.activeIdx === 0) {
        this.activeIdx = this.focusFirst ? this.results.length - 1 : -1;
      } else {
        this.activeIdx--;
      }

      this._activeChanged();
    }

    resetActive() {
      this.activeIdx = this.focusFirst ? 0 : -1;

      this._activeChanged();
    }

    select(item) {
      this.selectEvent.emit(item);
    }

    ngOnInit() {
      this.resetActive();
    }

    _activeChanged() {
      this.activeChangeEvent.emit(this.activeIdx >= 0 ? this.id + '-' + this.activeIdx : undefined);
    }

  }

  NgbTypeaheadWindow.ɵfac = function NgbTypeaheadWindow_Factory(t) {
    return new (t || NgbTypeaheadWindow)();
  };

  NgbTypeaheadWindow.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineComponent"]({
    type: NgbTypeaheadWindow,
    selectors: [["ngb-typeahead-window"]],
    hostAttrs: ["role", "listbox", 1, "dropdown-menu", "show"],
    hostVars: 1,
    hostBindings: function NgbTypeaheadWindow_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("mousedown", function NgbTypeaheadWindow_mousedown_HostBindingHandler($event) {
          return $event.preventDefault();
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("id", ctx.id);
      }
    },
    inputs: {
      focusFirst: "focusFirst",
      formatter: "formatter",
      id: "id",
      results: "results",
      term: "term",
      resultTemplate: "resultTemplate"
    },
    outputs: {
      selectEvent: "select",
      activeChangeEvent: "activeChange"
    },
    exportAs: ["ngbTypeaheadWindow"],
    decls: 3,
    vars: 1,
    consts: [["rt", ""], ["ngFor", "", 3, "ngForOf"], [3, "result", "term"], ["type", "button", "role", "option", 1, "dropdown-item", 3, "id", "mouseenter", "click"], [3, "ngTemplateOutlet", "ngTemplateOutletContext"]],
    template: function NgbTypeaheadWindow_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, NgbTypeaheadWindow_ng_template_0_Template, 1, 2, "ng-template", null, 0, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, NgbTypeaheadWindow_ng_template_2_Template, 2, 9, "ng-template", 1);
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx.results);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_12__.NgTemplateOutlet, NgbHighlight],
    encapsulation: 2
  });
  return NgbTypeaheadWindow;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

const ARIA_LIVE_DELAY = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.InjectionToken('live announcer delay', {
  providedIn: 'root',
  factory: ARIA_LIVE_DELAY_FACTORY
});

function ARIA_LIVE_DELAY_FACTORY() {
  return 100;
}

function getLiveElement(document, lazyCreate = false) {
  let element = document.body.querySelector('#ngb-live');

  if (element == null && lazyCreate) {
    element = document.createElement('div');
    element.setAttribute('id', 'ngb-live');
    element.setAttribute('aria-live', 'polite');
    element.setAttribute('aria-atomic', 'true');
    element.classList.add('sr-only');
    document.body.appendChild(element);
  }

  return element;
}

let Live = /*#__PURE__*/(() => {
  class Live {
    constructor(_document, _delay) {
      this._document = _document;
      this._delay = _delay;
    }

    ngOnDestroy() {
      const element = getLiveElement(this._document);

      if (element) {
        // if exists, it will always be attached to the <body>
        element.parentElement.removeChild(element);
      }
    }

    say(message) {
      const element = getLiveElement(this._document, true);
      const delay = this._delay;

      if (element != null) {
        element.textContent = '';

        const setText = () => element.textContent = message;

        if (delay === null) {
          setText();
        } else {
          setTimeout(setText, delay);
        }
      }
    }

  }

  Live.ɵfac = function Live_Factory(t) {
    return new (t || Live)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](ARIA_LIVE_DELAY));
  };

  Live.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function Live_Factory() {
      return new Live((0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"])(ARIA_LIVE_DELAY));
    },
    token: Live,
    providedIn: "root"
  });
  return Live;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * A configuration service for the [`NgbTypeahead`](#/components/typeahead/api#NgbTypeahead) component.
 *
 * You can inject this service, typically in your root component, and customize the values of its properties in
 * order to provide default values for all the typeaheads used in the application.
 */


let NgbTypeaheadConfig = /*#__PURE__*/(() => {
  class NgbTypeaheadConfig {
    constructor() {
      this.editable = true;
      this.focusFirst = true;
      this.showHint = false;
      this.placement = ['bottom-left', 'bottom-right', 'top-left', 'top-right'];
    }

  }

  NgbTypeaheadConfig.ɵfac = function NgbTypeaheadConfig_Factory(t) {
    return new (t || NgbTypeaheadConfig)();
  };

  NgbTypeaheadConfig.ɵprov = (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"])({
    factory: function NgbTypeaheadConfig_Factory() {
      return new NgbTypeaheadConfig();
    },
    token: NgbTypeaheadConfig,
    providedIn: "root"
  });
  return NgbTypeaheadConfig;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let nextWindowId = 0;
/**
 * A directive providing a simple way of creating powerful typeaheads from any text input.
 */

let NgbTypeahead = /*#__PURE__*/(() => {
  class NgbTypeahead {
    constructor(_elementRef, viewContainerRef, _renderer, injector, componentFactoryResolver, config, ngZone, _live, _document, _ngZone, _changeDetector, applicationRef) {
      this._elementRef = _elementRef;
      this._renderer = _renderer;
      this._live = _live;
      this._document = _document;
      this._ngZone = _ngZone;
      this._changeDetector = _changeDetector;
      this._subscription = null;
      this._closed$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this._inputValueBackup = null;
      this._windowRef = null;
      /**
       * The value for the `autocomplete` attribute for the `<input>` element.
       *
       * Defaults to `"off"` to disable the native browser autocomplete, but you can override it if necessary.
       *
       * @since 2.1.0
       */

      this.autocomplete = 'off';
      /**
       * The preferred placement of the typeahead.
       *
       * Possible values are `"top"`, `"top-left"`, `"top-right"`, `"bottom"`, `"bottom-left"`,
       * `"bottom-right"`, `"left"`, `"left-top"`, `"left-bottom"`, `"right"`, `"right-top"`,
       * `"right-bottom"`
       *
       * Accepts an array of strings or a string with space separated possible values.
       *
       * The default order of preference is `"bottom-left bottom-right top-left top-right"`
       *
       * Please see the [positioning overview](#/positioning) for more details.
       */

      this.placement = 'bottom-left';
      /**
       * An event emitted right before an item is selected from the result list.
       *
       * Event payload is of type [`NgbTypeaheadSelectItemEvent`](#/components/typeahead/api#NgbTypeaheadSelectItemEvent).
       */

      this.selectItem = new _angular_core__WEBPACK_IMPORTED_MODULE_0__.EventEmitter();
      this.activeDescendant = null;
      this.popupId = `ngb-typeahead-${nextWindowId++}`;

      this._onTouched = () => {};

      this._onChange = _ => {};

      this.container = config.container;
      this.editable = config.editable;
      this.focusFirst = config.focusFirst;
      this.showHint = config.showHint;
      this.placement = config.placement;
      this._valueChanges = (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.fromEvent)(_elementRef.nativeElement, 'input').pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.map)($event => $event.target.value));
      this._resubscribeTypeahead = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(null);
      this._popupService = new PopupService(NgbTypeaheadWindow, injector, viewContainerRef, _renderer, this._ngZone, componentFactoryResolver, applicationRef);
      this._zoneSubscription = ngZone.onStable.subscribe(() => {
        if (this.isPopupOpen()) {
          positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, this.container === 'body');
        }
      });
    }

    ngOnInit() {
      const inputValues$ = this._valueChanges.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_23__.tap)(value => {
        this._inputValueBackup = this.showHint ? value : null;

        this._onChange(this.editable ? value : undefined);
      }));

      const results$ = inputValues$.pipe(this.ngbTypeahead);

      const userInput$ = this._resubscribeTypeahead.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_19__.switchMap)(() => results$));

      this._subscription = this._subscribeToUserInput(userInput$);
    }

    ngOnDestroy() {
      this._closePopup();

      this._unsubscribeFromUserInput();

      this._zoneSubscription.unsubscribe();
    }

    registerOnChange(fn) {
      this._onChange = fn;
    }

    registerOnTouched(fn) {
      this._onTouched = fn;
    }

    writeValue(value) {
      this._writeInputValue(this._formatItemForInput(value));

      if (this.showHint) {
        this._inputValueBackup = value;
      }
    }

    setDisabledState(isDisabled) {
      this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
    }
    /**
     * Dismisses typeahead popup window
     */


    dismissPopup() {
      if (this.isPopupOpen()) {
        this._resubscribeTypeahead.next(null);

        this._closePopup();

        if (this.showHint && this._inputValueBackup !== null) {
          this._writeInputValue(this._inputValueBackup);
        }

        this._changeDetector.markForCheck();
      }
    }
    /**
     * Returns true if the typeahead popup window is displayed
     */


    isPopupOpen() {
      return this._windowRef != null;
    }

    handleBlur() {
      this._resubscribeTypeahead.next(null);

      this._onTouched();
    }

    handleKeyDown(event) {
      if (!this.isPopupOpen()) {
        return;
      } // tslint:disable-next-line:deprecation


      switch (event.which) {
        case Key.ArrowDown:
          event.preventDefault();

          this._windowRef.instance.next();

          this._showHint();

          break;

        case Key.ArrowUp:
          event.preventDefault();

          this._windowRef.instance.prev();

          this._showHint();

          break;

        case Key.Enter:
        case Key.Tab:
          const result = this._windowRef.instance.getActive();

          if (isDefined(result)) {
            event.preventDefault();
            event.stopPropagation();

            this._selectResult(result);
          }

          this._closePopup();

          break;
      }
    }

    _openPopup() {
      if (!this.isPopupOpen()) {
        this._inputValueBackup = this._elementRef.nativeElement.value;

        const {
          windowRef
        } = this._popupService.open();

        this._windowRef = windowRef;
        this._windowRef.instance.id = this.popupId;

        this._windowRef.instance.selectEvent.subscribe(result => this._selectResultClosePopup(result));

        this._windowRef.instance.activeChangeEvent.subscribe(activeId => this.activeDescendant = activeId);

        if (this.container === 'body') {
          this._document.querySelector(this.container).appendChild(this._windowRef.location.nativeElement);
        }

        this._changeDetector.markForCheck();

        ngbAutoClose(this._ngZone, this._document, 'outside', () => this.dismissPopup(), this._closed$, [this._elementRef.nativeElement, this._windowRef.location.nativeElement]);
      }
    }

    _closePopup() {
      this._popupService.close().subscribe(() => {
        this._closed$.next();

        this._windowRef = null;
        this.activeDescendant = null;
      });
    }

    _selectResult(result) {
      let defaultPrevented = false;
      this.selectItem.emit({
        item: result,
        preventDefault: () => {
          defaultPrevented = true;
        }
      });

      this._resubscribeTypeahead.next(null);

      if (!defaultPrevented) {
        this.writeValue(result);

        this._onChange(result);
      }
    }

    _selectResultClosePopup(result) {
      this._selectResult(result);

      this._closePopup();
    }

    _showHint() {
      var _a;

      if (this.showHint && ((_a = this._windowRef) === null || _a === void 0 ? void 0 : _a.instance.hasActive()) && this._inputValueBackup != null) {
        const userInputLowerCase = this._inputValueBackup.toLowerCase();

        const formattedVal = this._formatItemForInput(this._windowRef.instance.getActive());

        if (userInputLowerCase === formattedVal.substr(0, this._inputValueBackup.length).toLowerCase()) {
          this._writeInputValue(this._inputValueBackup + formattedVal.substr(this._inputValueBackup.length));

          this._elementRef.nativeElement['setSelectionRange'].apply(this._elementRef.nativeElement, [this._inputValueBackup.length, formattedVal.length]);
        } else {
          this._writeInputValue(formattedVal);
        }
      }
    }

    _formatItemForInput(item) {
      return item != null && this.inputFormatter ? this.inputFormatter(item) : toString(item);
    }

    _writeInputValue(value) {
      this._renderer.setProperty(this._elementRef.nativeElement, 'value', toString(value));
    }

    _subscribeToUserInput(userInput$) {
      return userInput$.subscribe(results => {
        if (!results || results.length === 0) {
          this._closePopup();
        } else {
          this._openPopup();

          this._windowRef.instance.focusFirst = this.focusFirst;
          this._windowRef.instance.results = results;
          this._windowRef.instance.term = this._elementRef.nativeElement.value;

          if (this.resultFormatter) {
            this._windowRef.instance.formatter = this.resultFormatter;
          }

          if (this.resultTemplate) {
            this._windowRef.instance.resultTemplate = this.resultTemplate;
          }

          this._windowRef.instance.resetActive(); // The observable stream we are subscribing to might have async steps
          // and if a component containing typeahead is using the OnPush strategy
          // the change detection turn wouldn't be invoked automatically.


          this._windowRef.changeDetectorRef.detectChanges();

          this._showHint();
        } // live announcer


        const count = results ? results.length : 0;

        this._live.say(count === 0 ? 'No results available' : `${count} result${count === 1 ? '' : 's'} available`);
      });
    }

    _unsubscribeFromUserInput() {
      if (this._subscription) {
        this._subscription.unsubscribe();
      }

      this._subscription = null;
    }

  }

  NgbTypeahead.ɵfac = function NgbTypeahead_Factory(t) {
    return new (t || NgbTypeahead)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ViewContainerRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Renderer2), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.Injector), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ComponentFactoryResolver), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](NgbTypeaheadConfig), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](Live), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_12__.DOCUMENT), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.NgZone), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ChangeDetectorRef), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_0__.ApplicationRef));
  };

  NgbTypeahead.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineDirective"]({
    type: NgbTypeahead,
    selectors: [["input", "ngbTypeahead", ""]],
    hostAttrs: ["autocapitalize", "off", "autocorrect", "off", "role", "combobox", "aria-multiline", "false"],
    hostVars: 7,
    hostBindings: function NgbTypeahead_HostBindings(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("blur", function NgbTypeahead_blur_HostBindingHandler() {
          return ctx.handleBlur();
        })("keydown", function NgbTypeahead_keydown_HostBindingHandler($event) {
          return ctx.handleKeyDown($event);
        });
      }

      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵhostProperty"]("autocomplete", ctx.autocomplete);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-autocomplete", ctx.showHint ? "both" : "list")("aria-activedescendant", ctx.activeDescendant)("aria-owns", ctx.isPopupOpen() ? ctx.popupId : null)("aria-expanded", ctx.isPopupOpen());
        _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("open", ctx.isPopupOpen());
      }
    },
    inputs: {
      autocomplete: "autocomplete",
      placement: "placement",
      container: "container",
      editable: "editable",
      focusFirst: "focusFirst",
      showHint: "showHint",
      inputFormatter: "inputFormatter",
      ngbTypeahead: "ngbTypeahead",
      resultFormatter: "resultFormatter",
      resultTemplate: "resultTemplate"
    },
    outputs: {
      selectItem: "selectItem"
    },
    exportAs: ["ngbTypeahead"],
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵProvidersFeature"]([{
      provide: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NG_VALUE_ACCESSOR,
      useExisting: (0,_angular_core__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(() => NgbTypeahead),
      multi: true
    }])]
  });
  return NgbTypeahead;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

let NgbTypeaheadModule = /*#__PURE__*/(() => {
  class NgbTypeaheadModule {}

  NgbTypeaheadModule.ɵfac = function NgbTypeaheadModule_Factory(t) {
    return new (t || NgbTypeaheadModule)();
  };

  NgbTypeaheadModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbTypeaheadModule
  });
  NgbTypeaheadModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule]
  });
  return NgbTypeaheadModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbTypeaheadModule, {
    declarations: function () {
      return [NgbTypeahead, NgbHighlight, NgbTypeaheadWindow];
    },
    imports: function () {
      return [_angular_common__WEBPACK_IMPORTED_MODULE_12__.CommonModule];
    },
    exports: function () {
      return [NgbTypeahead, NgbHighlight];
    }
  });
})();

const NGB_MODULES = [NgbAccordionModule, NgbAlertModule, NgbButtonsModule, NgbCarouselModule, NgbCollapseModule, NgbDatepickerModule, NgbDropdownModule, NgbModalModule, NgbNavModule, NgbPaginationModule, NgbPopoverModule, NgbProgressbarModule, NgbRatingModule, NgbTimepickerModule, NgbToastModule, NgbTooltipModule, NgbTypeaheadModule];
let NgbModule = /*#__PURE__*/(() => {
  class NgbModule {}

  NgbModule.ɵfac = function NgbModule_Factory(t) {
    return new (t || NgbModule)();
  };

  NgbModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineNgModule"]({
    type: NgbModule
  });
  NgbModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjector"]({
    imports: [NGB_MODULES, NgbAccordionModule, NgbAlertModule, NgbButtonsModule, NgbCarouselModule, NgbCollapseModule, NgbDatepickerModule, NgbDropdownModule, NgbModalModule, NgbNavModule, NgbPaginationModule, NgbPopoverModule, NgbProgressbarModule, NgbRatingModule, NgbTimepickerModule, NgbToastModule, NgbTooltipModule, NgbTypeaheadModule]
  });
  return NgbModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsetNgModuleScope"](NgbModule, {
    imports: [NgbAccordionModule, NgbAlertModule, NgbButtonsModule, NgbCarouselModule, NgbCollapseModule, NgbDatepickerModule, NgbDropdownModule, NgbModalModule, NgbNavModule, NgbPaginationModule, NgbPopoverModule, NgbProgressbarModule, NgbRatingModule, NgbTimepickerModule, NgbToastModule, NgbTooltipModule, NgbTypeaheadModule],
    exports: [NgbAccordionModule, NgbAlertModule, NgbButtonsModule, NgbCarouselModule, NgbCollapseModule, NgbDatepickerModule, NgbDropdownModule, NgbModalModule, NgbNavModule, NgbPaginationModule, NgbPopoverModule, NgbProgressbarModule, NgbRatingModule, NgbTimepickerModule, NgbToastModule, NgbTooltipModule, NgbTypeaheadModule]
  });
})();
/**
 * Generated bundle index. Do not edit.
 */




/***/ }),

/***/ 89461:
/*!*************************************************************************!*\
  !*** ./node_modules/@ngx-translate/core/fesm2015/ngx-translate-core.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_LANGUAGE": () => (/* binding */ DEFAULT_LANGUAGE),
/* harmony export */   "FakeMissingTranslationHandler": () => (/* binding */ FakeMissingTranslationHandler),
/* harmony export */   "MissingTranslationHandler": () => (/* binding */ MissingTranslationHandler),
/* harmony export */   "TranslateCompiler": () => (/* binding */ TranslateCompiler),
/* harmony export */   "TranslateDefaultParser": () => (/* binding */ TranslateDefaultParser),
/* harmony export */   "TranslateDirective": () => (/* binding */ TranslateDirective),
/* harmony export */   "TranslateFakeCompiler": () => (/* binding */ TranslateFakeCompiler),
/* harmony export */   "TranslateFakeLoader": () => (/* binding */ TranslateFakeLoader),
/* harmony export */   "TranslateLoader": () => (/* binding */ TranslateLoader),
/* harmony export */   "TranslateModule": () => (/* binding */ TranslateModule),
/* harmony export */   "TranslateParser": () => (/* binding */ TranslateParser),
/* harmony export */   "TranslatePipe": () => (/* binding */ TranslatePipe),
/* harmony export */   "TranslateService": () => (/* binding */ TranslateService),
/* harmony export */   "TranslateStore": () => (/* binding */ TranslateStore),
/* harmony export */   "USE_DEFAULT_LANG": () => (/* binding */ USE_DEFAULT_LANG),
/* harmony export */   "USE_EXTEND": () => (/* binding */ USE_EXTEND),
/* harmony export */   "USE_STORE": () => (/* binding */ USE_STORE)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ 64139);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 40020);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 54350);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 55828);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 52160);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 83910);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 79128);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 86942);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 11133);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs/operators */ 59095);



/**
 * @fileoverview added by tsickle
 * Generated from: lib/translate.loader.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @abstract
 */



class TranslateLoader {}

if (false) {}
/**
 * This loader is just a placeholder that does nothing, in case you don't need a loader at all
 */


let TranslateFakeLoader = /*#__PURE__*/(() => {
  class TranslateFakeLoader extends TranslateLoader {
    /**
     * @param {?} lang
     * @return {?}
     */
    getTranslation(lang) {
      return (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)({});
    }

  }

  TranslateFakeLoader.ɵfac = /*@__PURE__*/function () {
    let ɵTranslateFakeLoader_BaseFactory;
    return function TranslateFakeLoader_Factory(t) {
      return (ɵTranslateFakeLoader_BaseFactory || (ɵTranslateFakeLoader_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](TranslateFakeLoader)))(t || TranslateFakeLoader);
    };
  }();

  TranslateFakeLoader.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: TranslateFakeLoader,
    factory: TranslateFakeLoader.ɵfac
  });
  return TranslateFakeLoader;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * @fileoverview added by tsickle
 * Generated from: lib/missing-translation-handler.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @record
 */


function MissingTranslationHandlerParams() {}

if (false) {}
/**
 * @abstract
 */


class MissingTranslationHandler {}

if (false) {}
/**
 * This handler is just a placeholder that does nothing, in case you don't need a missing translation handler at all
 */


let FakeMissingTranslationHandler = /*#__PURE__*/(() => {
  class FakeMissingTranslationHandler {
    /**
     * @param {?} params
     * @return {?}
     */
    handle(params) {
      return params.key;
    }

  }

  FakeMissingTranslationHandler.ɵfac = function FakeMissingTranslationHandler_Factory(t) {
    return new (t || FakeMissingTranslationHandler)();
  };

  FakeMissingTranslationHandler.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: FakeMissingTranslationHandler,
    factory: FakeMissingTranslationHandler.ɵfac
  });
  return FakeMissingTranslationHandler;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * @fileoverview added by tsickle
 * Generated from: lib/util.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/* tslint:disable */

/**
 * Determines if two objects or two values are equivalent.
 *
 * Two objects or values are considered equivalent if at least one of the following is true:
 *
 * * Both objects or values pass `===` comparison.
 * * Both objects or values are of the same type and all of their properties are equal by
 *   comparing them with `equals`.
 *
 * @param {?} o1 Object or value to compare.
 * @param {?} o2 Object or value to compare.
 * @return {?} true if arguments are equal.
 */


function equals(o1, o2) {
  if (o1 === o2) return true;
  if (o1 === null || o2 === null) return false;
  if (o1 !== o1 && o2 !== o2) return true; // NaN === NaN
  // NaN === NaN

  /** @type {?} */

  let t1 = typeof o1;
  /** @type {?} */

  let t2 = typeof o2;
  /** @type {?} */

  let length;
  /** @type {?} */

  let key;
  /** @type {?} */

  let keySet;

  if (t1 == t2 && t1 == 'object') {
    if (Array.isArray(o1)) {
      if (!Array.isArray(o2)) return false;

      if ((length = o1.length) == o2.length) {
        for (key = 0; key < length; key++) {
          if (!equals(o1[key], o2[key])) return false;
        }

        return true;
      }
    } else {
      if (Array.isArray(o2)) {
        return false;
      }

      keySet = Object.create(null);

      for (key in o1) {
        if (!equals(o1[key], o2[key])) {
          return false;
        }

        keySet[key] = true;
      }

      for (key in o2) {
        if (!(key in keySet) && typeof o2[key] !== 'undefined') {
          return false;
        }
      }

      return true;
    }
  }

  return false;
}
/* tslint:enable */

/**
 * @param {?} value
 * @return {?}
 */


function isDefined(value) {
  return typeof value !== 'undefined' && value !== null;
}
/**
 * @param {?} item
 * @return {?}
 */


function isObject(item) {
  return item && typeof item === 'object' && !Array.isArray(item);
}
/**
 * @param {?} target
 * @param {?} source
 * @return {?}
 */


function mergeDeep(target, source) {
  /** @type {?} */
  let output = Object.assign({}, target);

  if (isObject(target) && isObject(source)) {
    Object.keys(source).forEach(
    /**
    * @param {?} key
    * @return {?}
    */
    key => {
      if (isObject(source[key])) {
        if (!(key in target)) {
          Object.assign(output, {
            [key]: source[key]
          });
        } else {
          output[key] = mergeDeep(target[key], source[key]);
        }
      } else {
        Object.assign(output, {
          [key]: source[key]
        });
      }
    });
  }

  return output;
}
/**
 * @fileoverview added by tsickle
 * Generated from: lib/translate.parser.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @abstract
 */


class TranslateParser {}

if (false) {}

let TranslateDefaultParser = /*#__PURE__*/(() => {
  class TranslateDefaultParser extends TranslateParser {
    constructor() {
      super(...arguments);
      this.templateMatcher = /{{\s?([^{}\s]*)\s?}}/g;
    }
    /**
     * @param {?} expr
     * @param {?=} params
     * @return {?}
     */


    interpolate(expr, params) {
      /** @type {?} */
      let result;

      if (typeof expr === 'string') {
        result = this.interpolateString(expr, params);
      } else if (typeof expr === 'function') {
        result = this.interpolateFunction(expr, params);
      } else {
        // this should not happen, but an unrelated TranslateService test depends on it
        result =
        /** @type {?} */
        expr;
      }

      return result;
    }
    /**
     * @param {?} target
     * @param {?} key
     * @return {?}
     */


    getValue(target, key) {
      /** @type {?} */
      let keys = typeof key === 'string' ? key.split('.') : [key];
      key = '';

      do {
        key += keys.shift();

        if (isDefined(target) && isDefined(target[key]) && (typeof target[key] === 'object' || !keys.length)) {
          target = target[key];
          key = '';
        } else if (!keys.length) {
          target = undefined;
        } else {
          key += '.';
        }
      } while (keys.length);

      return target;
    }
    /**
     * @private
     * @param {?} fn
     * @param {?=} params
     * @return {?}
     */


    interpolateFunction(fn, params) {
      return fn(params);
    }
    /**
     * @private
     * @param {?} expr
     * @param {?=} params
     * @return {?}
     */


    interpolateString(expr, params) {
      if (!params) {
        return expr;
      }

      return expr.replace(this.templateMatcher,
      /**
      * @param {?} substring
      * @param {?} b
      * @return {?}
      */
      (substring, b) => {
        /** @type {?} */
        let r = this.getValue(params, b);
        return isDefined(r) ? r : substring;
      });
    }

  }

  TranslateDefaultParser.ɵfac = /*@__PURE__*/function () {
    let ɵTranslateDefaultParser_BaseFactory;
    return function TranslateDefaultParser_Factory(t) {
      return (ɵTranslateDefaultParser_BaseFactory || (ɵTranslateDefaultParser_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](TranslateDefaultParser)))(t || TranslateDefaultParser);
    };
  }();

  TranslateDefaultParser.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: TranslateDefaultParser,
    factory: TranslateDefaultParser.ɵfac
  });
  return TranslateDefaultParser;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

if (false) {}
/**
 * @fileoverview added by tsickle
 * Generated from: lib/translate.compiler.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @abstract
 */


class TranslateCompiler {}

if (false) {}
/**
 * This compiler is just a placeholder that does nothing, in case you don't need a compiler at all
 */


let TranslateFakeCompiler = /*#__PURE__*/(() => {
  class TranslateFakeCompiler extends TranslateCompiler {
    /**
     * @param {?} value
     * @param {?} lang
     * @return {?}
     */
    compile(value, lang) {
      return value;
    }
    /**
     * @param {?} translations
     * @param {?} lang
     * @return {?}
     */


    compileTranslations(translations, lang) {
      return translations;
    }

  }

  TranslateFakeCompiler.ɵfac = /*@__PURE__*/function () {
    let ɵTranslateFakeCompiler_BaseFactory;
    return function TranslateFakeCompiler_Factory(t) {
      return (ɵTranslateFakeCompiler_BaseFactory || (ɵTranslateFakeCompiler_BaseFactory = _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵgetInheritedFactory"](TranslateFakeCompiler)))(t || TranslateFakeCompiler);
    };
  }();

  TranslateFakeCompiler.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: TranslateFakeCompiler,
    factory: TranslateFakeCompiler.ɵfac
  });
  return TranslateFakeCompiler;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();
/**
 * @fileoverview added by tsickle
 * Generated from: lib/translate.store.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */


class TranslateStore {
  constructor() {
    /**
     * The lang currently used
     */
    this.currentLang = this.defaultLang;
    /**
     * a list of translations per lang
     */

    this.translations = {};
    /**
     * an array of langs
     */

    this.langs = [];
    /**
     * An EventEmitter to listen to translation change events
     * onTranslationChange.subscribe((params: TranslationChangeEvent) => {
     *     // do something
     * });
     */

    this.onTranslationChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    /**
     * An EventEmitter to listen to lang change events
     * onLangChange.subscribe((params: LangChangeEvent) => {
     *     // do something
     * });
     */

    this.onLangChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
    /**
     * An EventEmitter to listen to default lang change events
     * onDefaultLangChange.subscribe((params: DefaultLangChangeEvent) => {
     *     // do something
     * });
     */

    this.onDefaultLangChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
  }

}

if (false) {}
/**
 * @fileoverview added by tsickle
 * Generated from: lib/translate.service.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/** @type {?} */


const USE_STORE = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.InjectionToken('USE_STORE');
/** @type {?} */

const USE_DEFAULT_LANG = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.InjectionToken('USE_DEFAULT_LANG');
/** @type {?} */

const DEFAULT_LANGUAGE = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.InjectionToken('DEFAULT_LANGUAGE');
/** @type {?} */

const USE_EXTEND = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.InjectionToken('USE_EXTEND');
/**
 * @record
 */

function TranslationChangeEvent() {}

if (false) {}
/**
 * @record
 */


function LangChangeEvent() {}

if (false) {}
/**
 * @record
 */


function DefaultLangChangeEvent() {}

if (false) {}

let TranslateService = /*#__PURE__*/(() => {
  class TranslateService {
    /**
     *
     * @param {?} store an instance of the store (that is supposed to be unique)
     * @param {?} currentLoader An instance of the loader currently used
     * @param {?} compiler An instance of the compiler currently used
     * @param {?} parser An instance of the parser currently used
     * @param {?} missingTranslationHandler A handler for missing translations.
     * @param {?=} useDefaultLang whether we should use default language translation when current language translation is missing.
     * @param {?=} isolate whether this service should use the store or not
     * @param {?=} extend To make a child module extend (and use) translations from parent modules.
     * @param {?=} defaultLanguage Set the default language using configuration
     */
    constructor(store, currentLoader, compiler, parser, missingTranslationHandler, useDefaultLang = true, isolate = false, extend = false, defaultLanguage) {
      this.store = store;
      this.currentLoader = currentLoader;
      this.compiler = compiler;
      this.parser = parser;
      this.missingTranslationHandler = missingTranslationHandler;
      this.useDefaultLang = useDefaultLang;
      this.isolate = isolate;
      this.extend = extend;
      this.pending = false;
      this._onTranslationChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
      this._onLangChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
      this._onDefaultLangChange = new _angular_core__WEBPACK_IMPORTED_MODULE_1__.EventEmitter();
      this._langs = [];
      this._translations = {};
      this._translationRequests = {};
      /** set the default language from configuration */

      if (defaultLanguage) {
        this.setDefaultLang(defaultLanguage);
      }
    }
    /**
     * An EventEmitter to listen to translation change events
     * onTranslationChange.subscribe((params: TranslationChangeEvent) => {
     *     // do something
     * });
     * @return {?}
     */


    get onTranslationChange() {
      return this.isolate ? this._onTranslationChange : this.store.onTranslationChange;
    }
    /**
     * An EventEmitter to listen to lang change events
     * onLangChange.subscribe((params: LangChangeEvent) => {
     *     // do something
     * });
     * @return {?}
     */


    get onLangChange() {
      return this.isolate ? this._onLangChange : this.store.onLangChange;
    }
    /**
     * An EventEmitter to listen to default lang change events
     * onDefaultLangChange.subscribe((params: DefaultLangChangeEvent) => {
     *     // do something
     * });
     * @return {?}
     */


    get onDefaultLangChange() {
      return this.isolate ? this._onDefaultLangChange : this.store.onDefaultLangChange;
    }
    /**
     * The default lang to fallback when translations are missing on the current lang
     * @return {?}
     */


    get defaultLang() {
      return this.isolate ? this._defaultLang : this.store.defaultLang;
    }
    /**
     * @param {?} defaultLang
     * @return {?}
     */


    set defaultLang(defaultLang) {
      if (this.isolate) {
        this._defaultLang = defaultLang;
      } else {
        this.store.defaultLang = defaultLang;
      }
    }
    /**
     * The lang currently used
     * @return {?}
     */


    get currentLang() {
      return this.isolate ? this._currentLang : this.store.currentLang;
    }
    /**
     * @param {?} currentLang
     * @return {?}
     */


    set currentLang(currentLang) {
      if (this.isolate) {
        this._currentLang = currentLang;
      } else {
        this.store.currentLang = currentLang;
      }
    }
    /**
     * an array of langs
     * @return {?}
     */


    get langs() {
      return this.isolate ? this._langs : this.store.langs;
    }
    /**
     * @param {?} langs
     * @return {?}
     */


    set langs(langs) {
      if (this.isolate) {
        this._langs = langs;
      } else {
        this.store.langs = langs;
      }
    }
    /**
     * a list of translations per lang
     * @return {?}
     */


    get translations() {
      return this.isolate ? this._translations : this.store.translations;
    }
    /**
     * @param {?} translations
     * @return {?}
     */


    set translations(translations) {
      if (this.isolate) {
        this._translations = translations;
      } else {
        this.store.translations = translations;
      }
    }
    /**
     * Sets the default language to use as a fallback
     * @param {?} lang
     * @return {?}
     */


    setDefaultLang(lang) {
      if (lang === this.defaultLang) {
        return;
      }
      /** @type {?} */


      let pending = this.retrieveTranslations(lang);

      if (typeof pending !== "undefined") {
        // on init set the defaultLang immediately
        if (this.defaultLang == null) {
          this.defaultLang = lang;
        }

        pending.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.take)(1)).subscribe(
        /**
        * @param {?} res
        * @return {?}
        */
        res => {
          this.changeDefaultLang(lang);
        });
      } else {
        // we already have this language
        this.changeDefaultLang(lang);
      }
    }
    /**
     * Gets the default language used
     * @return {?}
     */


    getDefaultLang() {
      return this.defaultLang;
    }
    /**
     * Changes the lang currently used
     * @param {?} lang
     * @return {?}
     */


    use(lang) {
      // don't change the language if the language given is already selected
      if (lang === this.currentLang) {
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)(this.translations[lang]);
      }
      /** @type {?} */


      let pending = this.retrieveTranslations(lang);

      if (typeof pending !== "undefined") {
        // on init set the currentLang immediately
        if (!this.currentLang) {
          this.currentLang = lang;
        }

        pending.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.take)(1)).subscribe(
        /**
        * @param {?} res
        * @return {?}
        */
        res => {
          this.changeLang(lang);
        });
        return pending;
      } else {
        // we have this language, return an Observable
        this.changeLang(lang);
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)(this.translations[lang]);
      }
    }
    /**
     * Retrieves the given translations
     * @private
     * @param {?} lang
     * @return {?}
     */


    retrieveTranslations(lang) {
      /** @type {?} */
      let pending; // if this language is unavailable or extend is true, ask for it

      if (typeof this.translations[lang] === "undefined" || this.extend) {
        this._translationRequests[lang] = this._translationRequests[lang] || this.getTranslation(lang);
        pending = this._translationRequests[lang];
      }

      return pending;
    }
    /**
     * Gets an object of translations for a given language with the current loader
     * and passes it through the compiler
     * @param {?} lang
     * @return {?}
     */


    getTranslation(lang) {
      this.pending = true;
      /** @type {?} */

      const loadingTranslations = this.currentLoader.getTranslation(lang).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.shareReplay)(1), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.take)(1));
      this.loadingTranslations = loadingTranslations.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.map)(
      /**
      * @param {?} res
      * @return {?}
      */
      res => this.compiler.compileTranslations(res, lang)), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.shareReplay)(1), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.take)(1));
      this.loadingTranslations.subscribe({
        next:
        /**
        * @param {?} res
        * @return {?}
        */
        res => {
          this.translations[lang] = this.extend && this.translations[lang] ? Object.assign(Object.assign({}, res), this.translations[lang]) : res;
          this.updateLangs();
          this.pending = false;
        },
        error:
        /**
        * @param {?} err
        * @return {?}
        */
        err => {
          this.pending = false;
        }
      });
      return loadingTranslations;
    }
    /**
     * Manually sets an object of translations for a given language
     * after passing it through the compiler
     * @param {?} lang
     * @param {?} translations
     * @param {?=} shouldMerge
     * @return {?}
     */


    setTranslation(lang, translations, shouldMerge = false) {
      translations = this.compiler.compileTranslations(translations, lang);

      if ((shouldMerge || this.extend) && this.translations[lang]) {
        this.translations[lang] = mergeDeep(this.translations[lang], translations);
      } else {
        this.translations[lang] = translations;
      }

      this.updateLangs();
      this.onTranslationChange.emit({
        lang: lang,
        translations: this.translations[lang]
      });
    }
    /**
     * Returns an array of currently available langs
     * @return {?}
     */


    getLangs() {
      return this.langs;
    }
    /**
     * Add available langs
     * @param {?} langs
     * @return {?}
     */


    addLangs(langs) {
      langs.forEach(
      /**
      * @param {?} lang
      * @return {?}
      */
      lang => {
        if (this.langs.indexOf(lang) === -1) {
          this.langs.push(lang);
        }
      });
    }
    /**
     * Update the list of available langs
     * @private
     * @return {?}
     */


    updateLangs() {
      this.addLangs(Object.keys(this.translations));
    }
    /**
     * Returns the parsed result of the translations
     * @param {?} translations
     * @param {?} key
     * @param {?=} interpolateParams
     * @return {?}
     */


    getParsedResult(translations, key, interpolateParams) {
      /** @type {?} */
      let res;

      if (key instanceof Array) {
        /** @type {?} */
        let result = {};
        /** @type {?} */

        let observables = false;

        for (let k of key) {
          result[k] = this.getParsedResult(translations, k, interpolateParams);

          if ((0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(result[k])) {
            observables = true;
          }
        }

        if (observables) {
          /** @type {?} */
          const sources = key.map(
          /**
          * @param {?} k
          * @return {?}
          */
          k => (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(result[k]) ? result[k] : (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)(
          /** @type {?} */
          result[k]));
          return (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.forkJoin)(sources).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_4__.map)(
          /**
          * @param {?} arr
          * @return {?}
          */
          arr => {
            /** @type {?} */
            let obj = {};
            arr.forEach(
            /**
            * @param {?} value
            * @param {?} index
            * @return {?}
            */
            (value, index) => {
              obj[key[index]] = value;
            });
            return obj;
          }));
        }

        return result;
      }

      if (translations) {
        res = this.parser.interpolate(this.parser.getValue(translations, key), interpolateParams);
      }

      if (typeof res === "undefined" && this.defaultLang != null && this.defaultLang !== this.currentLang && this.useDefaultLang) {
        res = this.parser.interpolate(this.parser.getValue(this.translations[this.defaultLang], key), interpolateParams);
      }

      if (typeof res === "undefined") {
        /** @type {?} */
        let params = {
          key,
          translateService: this
        };

        if (typeof interpolateParams !== 'undefined') {
          params.interpolateParams = interpolateParams;
        }

        res = this.missingTranslationHandler.handle(params);
      }

      return typeof res !== "undefined" ? res : key;
    }
    /**
     * Gets the translated value of a key (or an array of keys)
     * @param {?} key
     * @param {?=} interpolateParams
     * @return {?} the translated key, or an object of translated keys
     */


    get(key, interpolateParams) {
      if (!isDefined(key) || !key.length) {
        throw new Error(`Parameter "key" required`);
      } // check if we are loading a new translation to use


      if (this.pending) {
        return this.loadingTranslations.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.concatMap)(
        /**
        * @param {?} res
        * @return {?}
        */
        res => {
          res = this.getParsedResult(res, key, interpolateParams);
          return (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(res) ? res : (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)(res);
        }));
      } else {
        /** @type {?} */
        let res = this.getParsedResult(this.translations[this.currentLang], key, interpolateParams);
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(res) ? res : (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)(res);
      }
    }
    /**
     * Returns a stream of translated values of a key (or an array of keys) which updates
     * whenever the translation changes.
     * @param {?} key
     * @param {?=} interpolateParams
     * @return {?} A stream of the translated key, or an object of translated keys
     */


    getStreamOnTranslationChange(key, interpolateParams) {
      if (!isDefined(key) || !key.length) {
        throw new Error(`Parameter "key" required`);
      }

      return (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.concat)((0,rxjs__WEBPACK_IMPORTED_MODULE_9__.defer)(
      /**
      * @return {?}
      */
      () => this.get(key, interpolateParams)), this.onTranslationChange.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.switchMap)(
      /**
      * @param {?} event
      * @return {?}
      */
      event => {
        /** @type {?} */
        const res = this.getParsedResult(event.translations, key, interpolateParams);

        if (typeof res.subscribe === 'function') {
          return res;
        } else {
          return (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)(res);
        }
      })));
    }
    /**
     * Returns a stream of translated values of a key (or an array of keys) which updates
     * whenever the language changes.
     * @param {?} key
     * @param {?=} interpolateParams
     * @return {?} A stream of the translated key, or an object of translated keys
     */


    stream(key, interpolateParams) {
      if (!isDefined(key) || !key.length) {
        throw new Error(`Parameter "key" required`);
      }

      return (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.concat)((0,rxjs__WEBPACK_IMPORTED_MODULE_9__.defer)(
      /**
      * @return {?}
      */
      () => this.get(key, interpolateParams)), this.onLangChange.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.switchMap)(
      /**
      * @param {?} event
      * @return {?}
      */
      event => {
        /** @type {?} */
        const res = this.getParsedResult(event.translations, key, interpolateParams);
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(res) ? res : (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.of)(res);
      })));
    }
    /**
     * Returns a translation instantly from the internal state of loaded translation.
     * All rules regarding the current language, the preferred language of even fallback languages will be used except any promise handling.
     * @param {?} key
     * @param {?=} interpolateParams
     * @return {?}
     */


    instant(key, interpolateParams) {
      if (!isDefined(key) || !key.length) {
        throw new Error(`Parameter "key" required`);
      }
      /** @type {?} */


      let res = this.getParsedResult(this.translations[this.currentLang], key, interpolateParams);

      if ((0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(res)) {
        if (key instanceof Array) {
          /** @type {?} */
          let obj = {};
          key.forEach(
          /**
          * @param {?} value
          * @param {?} index
          * @return {?}
          */
          (value, index) => {
            obj[key[index]] = key[index];
          });
          return obj;
        }

        return key;
      } else {
        return res;
      }
    }
    /**
     * Sets the translated value of a key, after compiling it
     * @param {?} key
     * @param {?} value
     * @param {?=} lang
     * @return {?}
     */


    set(key, value, lang = this.currentLang) {
      this.translations[lang][key] = this.compiler.compile(value, lang);
      this.updateLangs();
      this.onTranslationChange.emit({
        lang: lang,
        translations: this.translations[lang]
      });
    }
    /**
     * Changes the current lang
     * @private
     * @param {?} lang
     * @return {?}
     */


    changeLang(lang) {
      this.currentLang = lang;
      this.onLangChange.emit({
        lang: lang,
        translations: this.translations[lang]
      }); // if there is no default lang, use the one that we just set

      if (this.defaultLang == null) {
        this.changeDefaultLang(lang);
      }
    }
    /**
     * Changes the default lang
     * @private
     * @param {?} lang
     * @return {?}
     */


    changeDefaultLang(lang) {
      this.defaultLang = lang;
      this.onDefaultLangChange.emit({
        lang: lang,
        translations: this.translations[lang]
      });
    }
    /**
     * Allows to reload the lang file from the file
     * @param {?} lang
     * @return {?}
     */


    reloadLang(lang) {
      this.resetLang(lang);
      return this.getTranslation(lang);
    }
    /**
     * Deletes inner translation
     * @param {?} lang
     * @return {?}
     */


    resetLang(lang) {
      this._translationRequests[lang] = undefined;
      this.translations[lang] = undefined;
    }
    /**
     * Returns the language code name from the browser, e.g. "de"
     * @return {?}
     */


    getBrowserLang() {
      if (typeof window === 'undefined' || typeof window.navigator === 'undefined') {
        return undefined;
      }
      /** @type {?} */


      let browserLang = window.navigator.languages ? window.navigator.languages[0] : null;
      browserLang = browserLang || window.navigator.language || window.navigator.browserLanguage || window.navigator.userLanguage;

      if (typeof browserLang === 'undefined') {
        return undefined;
      }

      if (browserLang.indexOf('-') !== -1) {
        browserLang = browserLang.split('-')[0];
      }

      if (browserLang.indexOf('_') !== -1) {
        browserLang = browserLang.split('_')[0];
      }

      return browserLang;
    }
    /**
     * Returns the culture language code name from the browser, e.g. "de-DE"
     * @return {?}
     */


    getBrowserCultureLang() {
      if (typeof window === 'undefined' || typeof window.navigator === 'undefined') {
        return undefined;
      }
      /** @type {?} */


      let browserCultureLang = window.navigator.languages ? window.navigator.languages[0] : null;
      browserCultureLang = browserCultureLang || window.navigator.language || window.navigator.browserLanguage || window.navigator.userLanguage;
      return browserCultureLang;
    }

  }

  TranslateService.ɵfac = function TranslateService_Factory(t) {
    return new (t || TranslateService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](TranslateStore), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](TranslateLoader), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](TranslateCompiler), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](TranslateParser), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](MissingTranslationHandler), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](USE_DEFAULT_LANG), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](USE_STORE), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](USE_EXTEND), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](DEFAULT_LANGUAGE));
  };

  TranslateService.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: TranslateService,
    factory: TranslateService.ɵfac
  });
  /** @nocollapse */

  return TranslateService;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

if (false) {}
/**
 * @fileoverview added by tsickle
 * Generated from: lib/translate.directive.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */


let TranslateDirective = /*#__PURE__*/(() => {
  class TranslateDirective {
    /**
     * @param {?} translateService
     * @param {?} element
     * @param {?} _ref
     */
    constructor(translateService, element, _ref) {
      this.translateService = translateService;
      this.element = element;
      this._ref = _ref; // subscribe to onTranslationChange event, in case the translations of the current lang change

      if (!this.onTranslationChangeSub) {
        this.onTranslationChangeSub = this.translateService.onTranslationChange.subscribe(
        /**
        * @param {?} event
        * @return {?}
        */
        event => {
          if (event.lang === this.translateService.currentLang) {
            this.checkNodes(true, event.translations);
          }
        });
      } // subscribe to onLangChange event, in case the language changes


      if (!this.onLangChangeSub) {
        this.onLangChangeSub = this.translateService.onLangChange.subscribe(
        /**
        * @param {?} event
        * @return {?}
        */
        event => {
          this.checkNodes(true, event.translations);
        });
      } // subscribe to onDefaultLangChange event, in case the default language changes


      if (!this.onDefaultLangChangeSub) {
        this.onDefaultLangChangeSub = this.translateService.onDefaultLangChange.subscribe(
        /**
        * @param {?} event
        * @return {?}
        */
        event => {
          this.checkNodes(true);
        });
      }
    }
    /**
     * @param {?} key
     * @return {?}
     */


    set translate(key) {
      if (key) {
        this.key = key;
        this.checkNodes();
      }
    }
    /**
     * @param {?} params
     * @return {?}
     */


    set translateParams(params) {
      if (!equals(this.currentParams, params)) {
        this.currentParams = params;
        this.checkNodes(true);
      }
    }
    /**
     * @return {?}
     */


    ngAfterViewChecked() {
      this.checkNodes();
    }
    /**
     * @param {?=} forceUpdate
     * @param {?=} translations
     * @return {?}
     */


    checkNodes(forceUpdate = false, translations) {
      /** @type {?} */
      let nodes = this.element.nativeElement.childNodes; // if the element is empty

      if (!nodes.length) {
        // we add the key as content
        this.setContent(this.element.nativeElement, this.key);
        nodes = this.element.nativeElement.childNodes;
      }

      for (let i = 0; i < nodes.length; ++i) {
        /** @type {?} */
        let node = nodes[i];

        if (node.nodeType === 3) {
          // node type 3 is a text node
          // node type 3 is a text node

          /** @type {?} */
          let key;

          if (forceUpdate) {
            node.lastKey = null;
          }

          if (isDefined(node.lookupKey)) {
            key = node.lookupKey;
          } else if (this.key) {
            key = this.key;
          } else {
            /** @type {?} */
            let content = this.getContent(node);
            /** @type {?} */

            let trimmedContent = content.trim();

            if (trimmedContent.length) {
              node.lookupKey = trimmedContent; // we want to use the content as a key, not the translation value

              if (content !== node.currentValue) {
                key = trimmedContent; // the content was changed from the user, we'll use it as a reference if needed

                node.originalContent = content || node.originalContent;
              } else if (node.originalContent) {
                // the content seems ok, but the lang has changed
                // the current content is the translation, not the key, use the last real content as key
                key = node.originalContent.trim();
              } else if (content !== node.currentValue) {
                // we want to use the content as a key, not the translation value
                key = trimmedContent; // the content was changed from the user, we'll use it as a reference if needed

                node.originalContent = content || node.originalContent;
              }
            }
          }

          this.updateValue(key, node, translations);
        }
      }
    }
    /**
     * @param {?} key
     * @param {?} node
     * @param {?} translations
     * @return {?}
     */


    updateValue(key, node, translations) {
      if (key) {
        if (node.lastKey === key && this.lastParams === this.currentParams) {
          return;
        }

        this.lastParams = this.currentParams;
        /** @type {?} */

        let onTranslation =
        /**
        * @param {?} res
        * @return {?}
        */
        res => {
          if (res !== key) {
            node.lastKey = key;
          }

          if (!node.originalContent) {
            node.originalContent = this.getContent(node);
          }

          node.currentValue = isDefined(res) ? res : node.originalContent || key; // we replace in the original content to preserve spaces that we might have trimmed

          this.setContent(node, this.key ? node.currentValue : node.originalContent.replace(key, node.currentValue));

          this._ref.markForCheck();
        };

        if (isDefined(translations)) {
          /** @type {?} */
          let res = this.translateService.getParsedResult(translations, key, this.currentParams);

          if ((0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(res)) {
            res.subscribe(onTranslation);
          } else {
            onTranslation(res);
          }
        } else {
          this.translateService.get(key, this.currentParams).subscribe(onTranslation);
        }
      }
    }
    /**
     * @param {?} node
     * @return {?}
     */


    getContent(node) {
      return isDefined(node.textContent) ? node.textContent : node.data;
    }
    /**
     * @param {?} node
     * @param {?} content
     * @return {?}
     */


    setContent(node, content) {
      if (isDefined(node.textContent)) {
        node.textContent = content;
      } else {
        node.data = content;
      }
    }
    /**
     * @return {?}
     */


    ngOnDestroy() {
      if (this.onLangChangeSub) {
        this.onLangChangeSub.unsubscribe();
      }

      if (this.onDefaultLangChangeSub) {
        this.onDefaultLangChangeSub.unsubscribe();
      }

      if (this.onTranslationChangeSub) {
        this.onTranslationChangeSub.unsubscribe();
      }
    }

  }

  TranslateDirective.ɵfac = function TranslateDirective_Factory(t) {
    return new (t || TranslateDirective)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](TranslateService), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ElementRef), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef));
  };

  TranslateDirective.ɵdir = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineDirective"]({
    type: TranslateDirective,
    selectors: [["", "translate", ""], ["", "ngx-translate", ""]],
    inputs: {
      translate: "translate",
      translateParams: "translateParams"
    }
  });
  /** @nocollapse */

  return TranslateDirective;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

if (false) {}
/**
 * @fileoverview added by tsickle
 * Generated from: lib/translate.pipe.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */


let TranslatePipe = /*#__PURE__*/(() => {
  class TranslatePipe {
    /**
     * @param {?} translate
     * @param {?} _ref
     */
    constructor(translate, _ref) {
      this.translate = translate;
      this._ref = _ref;
      this.value = '';
    }
    /**
     * @param {?} key
     * @param {?=} interpolateParams
     * @param {?=} translations
     * @return {?}
     */


    updateValue(key, interpolateParams, translations) {
      /** @type {?} */
      let onTranslation =
      /**
      * @param {?} res
      * @return {?}
      */
      res => {
        this.value = res !== undefined ? res : key;
        this.lastKey = key;

        this._ref.markForCheck();
      };

      if (translations) {
        /** @type {?} */
        let res = this.translate.getParsedResult(translations, key, interpolateParams);

        if ((0,rxjs__WEBPACK_IMPORTED_MODULE_5__.isObservable)(res.subscribe)) {
          res.subscribe(onTranslation);
        } else {
          onTranslation(res);
        }
      }

      this.translate.get(key, interpolateParams).subscribe(onTranslation);
    }
    /**
     * @param {?} query
     * @param {...?} args
     * @return {?}
     */


    transform(query, ...args) {
      if (!query || !query.length) {
        return query;
      } // if we ask another time for the same key, return the last value


      if (equals(query, this.lastKey) && equals(args, this.lastParams)) {
        return this.value;
      }
      /** @type {?} */


      let interpolateParams;

      if (isDefined(args[0]) && args.length) {
        if (typeof args[0] === 'string' && args[0].length) {
          // we accept objects written in the template such as {n:1}, {'n':1}, {n:'v'}
          // which is why we might need to change it to real JSON objects such as {"n":1} or {"n":"v"}

          /** @type {?} */
          let validArgs = args[0].replace(/(\')?([a-zA-Z0-9_]+)(\')?(\s)?:/g, '"$2":').replace(/:(\s)?(\')(.*?)(\')/g, ':"$3"');

          try {
            interpolateParams = JSON.parse(validArgs);
          } catch (e) {
            throw new SyntaxError(`Wrong parameter in TranslatePipe. Expected a valid Object, received: ${args[0]}`);
          }
        } else if (typeof args[0] === 'object' && !Array.isArray(args[0])) {
          interpolateParams = args[0];
        }
      } // store the query, in case it changes


      this.lastKey = query; // store the params, in case they change

      this.lastParams = args; // set the value

      this.updateValue(query, interpolateParams); // if there is a subscription to onLangChange, clean it

      this._dispose(); // subscribe to onTranslationChange event, in case the translations change


      if (!this.onTranslationChange) {
        this.onTranslationChange = this.translate.onTranslationChange.subscribe(
        /**
        * @param {?} event
        * @return {?}
        */
        event => {
          if (this.lastKey && event.lang === this.translate.currentLang) {
            this.lastKey = null;
            this.updateValue(query, interpolateParams, event.translations);
          }
        });
      } // subscribe to onLangChange event, in case the language changes


      if (!this.onLangChange) {
        this.onLangChange = this.translate.onLangChange.subscribe(
        /**
        * @param {?} event
        * @return {?}
        */
        event => {
          if (this.lastKey) {
            this.lastKey = null; // we want to make sure it doesn't return the same value until it's been updated

            this.updateValue(query, interpolateParams, event.translations);
          }
        });
      } // subscribe to onDefaultLangChange event, in case the default language changes


      if (!this.onDefaultLangChange) {
        this.onDefaultLangChange = this.translate.onDefaultLangChange.subscribe(
        /**
        * @return {?}
        */
        () => {
          if (this.lastKey) {
            this.lastKey = null; // we want to make sure it doesn't return the same value until it's been updated

            this.updateValue(query, interpolateParams);
          }
        });
      }

      return this.value;
    }
    /**
     * Clean any existing subscription to change events
     * @private
     * @return {?}
     */


    _dispose() {
      if (typeof this.onTranslationChange !== 'undefined') {
        this.onTranslationChange.unsubscribe();
        this.onTranslationChange = undefined;
      }

      if (typeof this.onLangChange !== 'undefined') {
        this.onLangChange.unsubscribe();
        this.onLangChange = undefined;
      }

      if (typeof this.onDefaultLangChange !== 'undefined') {
        this.onDefaultLangChange.unsubscribe();
        this.onDefaultLangChange = undefined;
      }
    }
    /**
     * @return {?}
     */


    ngOnDestroy() {
      this._dispose();
    }

  }

  TranslatePipe.ɵfac = function TranslatePipe_Factory(t) {
    return new (t || TranslatePipe)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](TranslateService, 16), _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdirectiveInject"](_angular_core__WEBPACK_IMPORTED_MODULE_1__.ChangeDetectorRef, 16));
  };

  TranslatePipe.ɵpipe = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefinePipe"]({
    name: "translate",
    type: TranslatePipe,
    pure: false
  });
  TranslatePipe.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: TranslatePipe,
    factory: TranslatePipe.ɵfac
  });
  /** @nocollapse */

  return TranslatePipe;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

if (false) {}
/**
 * @fileoverview added by tsickle
 * Generated from: public_api.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */

/**
 * @record
 */


function TranslateModuleConfig() {}

if (false) {}

let TranslateModule = /*#__PURE__*/(() => {
  class TranslateModule {
    /**
     * Use this method in your root module to provide the TranslateService
     * @param {?=} config
     * @return {?}
     */
    static forRoot(config = {}) {
      return {
        ngModule: TranslateModule,
        providers: [config.loader || {
          provide: TranslateLoader,
          useClass: TranslateFakeLoader
        }, config.compiler || {
          provide: TranslateCompiler,
          useClass: TranslateFakeCompiler
        }, config.parser || {
          provide: TranslateParser,
          useClass: TranslateDefaultParser
        }, config.missingTranslationHandler || {
          provide: MissingTranslationHandler,
          useClass: FakeMissingTranslationHandler
        }, TranslateStore, {
          provide: USE_STORE,
          useValue: config.isolate
        }, {
          provide: USE_DEFAULT_LANG,
          useValue: config.useDefaultLang
        }, {
          provide: USE_EXTEND,
          useValue: config.extend
        }, {
          provide: DEFAULT_LANGUAGE,
          useValue: config.defaultLanguage
        }, TranslateService]
      };
    }
    /**
     * Use this method in your other (non root) modules to import the directive/pipe
     * @param {?=} config
     * @return {?}
     */


    static forChild(config = {}) {
      return {
        ngModule: TranslateModule,
        providers: [config.loader || {
          provide: TranslateLoader,
          useClass: TranslateFakeLoader
        }, config.compiler || {
          provide: TranslateCompiler,
          useClass: TranslateFakeCompiler
        }, config.parser || {
          provide: TranslateParser,
          useClass: TranslateDefaultParser
        }, config.missingTranslationHandler || {
          provide: MissingTranslationHandler,
          useClass: FakeMissingTranslationHandler
        }, {
          provide: USE_STORE,
          useValue: config.isolate
        }, {
          provide: USE_DEFAULT_LANG,
          useValue: config.useDefaultLang
        }, {
          provide: USE_EXTEND,
          useValue: config.extend
        }, {
          provide: DEFAULT_LANGUAGE,
          useValue: config.defaultLanguage
        }, TranslateService]
      };
    }

  }

  TranslateModule.ɵfac = function TranslateModule_Factory(t) {
    return new (t || TranslateModule)();
  };

  TranslateModule.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
    type: TranslateModule
  });
  TranslateModule.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({});
  return TranslateModule;
})();

(function () {
  (typeof ngDevMode === "undefined" || ngDevMode) && void 0;
})();

(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](TranslateModule, {
    declarations: [TranslatePipe, TranslateDirective],
    exports: [TranslatePipe, TranslateDirective]
  });
})();
/**
 * @fileoverview added by tsickle
 * Generated from: ngx-translate-core.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */




/***/ }),

/***/ 34370:
/*!***************************************************************************************!*\
  !*** ./node_modules/@ngx-translate/http-loader/fesm2015/ngx-translate-http-loader.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TranslateHttpLoader": () => (/* binding */ TranslateHttpLoader)
/* harmony export */ });
class TranslateHttpLoader {
  constructor(http, prefix = "/assets/i18n/", suffix = ".json") {
    this.http = http;
    this.prefix = prefix;
    this.suffix = suffix;
  }
  /**
   * Gets the translations from the server
   */


  getTranslation(lang) {
    return this.http.get(`${this.prefix}${lang}${this.suffix}`);
  }

}
/**
 * Generated bundle index. Do not edit.
 */




/***/ }),

/***/ 68501:
/*!*********************************************************************************!*\
  !*** ./node_modules/@swimlane/ngx-datatable/fesm2015/swimlane-ngx-datatable.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClickType": () => (/* binding */ ClickType),
/* harmony export */   "ColumnChangesService": () => (/* binding */ ColumnChangesService),
/* harmony export */   "ColumnMode": () => (/* binding */ ColumnMode),
/* harmony export */   "ContextmenuType": () => (/* binding */ ContextmenuType),
/* harmony export */   "DataTableBodyCellComponent": () => (/* binding */ DataTableBodyCellComponent),
/* harmony export */   "DataTableBodyComponent": () => (/* binding */ DataTableBodyComponent),
/* harmony export */   "DataTableBodyRowComponent": () => (/* binding */ DataTableBodyRowComponent),
/* harmony export */   "DataTableColumnCellDirective": () => (/* binding */ DataTableColumnCellDirective),
/* harmony export */   "DataTableColumnCellTreeToggle": () => (/* binding */ DataTableColumnCellTreeToggle),
/* harmony export */   "DataTableColumnDirective": () => (/* binding */ DataTableColumnDirective),
/* harmony export */   "DataTableColumnHeaderDirective": () => (/* binding */ DataTableColumnHeaderDirective),
/* harmony export */   "DataTableFooterComponent": () => (/* binding */ DataTableFooterComponent),
/* harmony export */   "DataTableFooterTemplateDirective": () => (/* binding */ DataTableFooterTemplateDirective),
/* harmony export */   "DataTableHeaderCellComponent": () => (/* binding */ DataTableHeaderCellComponent),
/* harmony export */   "DataTableHeaderComponent": () => (/* binding */ DataTableHeaderComponent),
/* harmony export */   "DataTablePagerComponent": () => (/* binding */ DataTablePagerComponent),
/* harmony export */   "DataTableRowWrapperComponent": () => (/* binding */ DataTableRowWrapperComponent),
/* harmony export */   "DataTableSelectionComponent": () => (/* binding */ DataTableSelectionComponent),
/* harmony export */   "DataTableSummaryRowComponent": () => (/* binding */ DataTableSummaryRowComponent),
/* harmony export */   "DatatableComponent": () => (/* binding */ DatatableComponent),
/* harmony export */   "DatatableFooterDirective": () => (/* binding */ DatatableFooterDirective),
/* harmony export */   "DatatableGroupHeaderDirective": () => (/* binding */ DatatableGroupHeaderDirective),
/* harmony export */   "DatatableGroupHeaderTemplateDirective": () => (/* binding */ DatatableGroupHeaderTemplateDirective),
/* harmony export */   "DatatableRowDetailDirective": () => (/* binding */ DatatableRowDetailDirective),
/* harmony export */   "DatatableRowDetailTemplateDirective": () => (/* binding */ DatatableRowDetailTemplateDirective),
/* harmony export */   "DimensionsHelper": () => (/* binding */ DimensionsHelper),
/* harmony export */   "DraggableDirective": () => (/* binding */ DraggableDirective),
/* harmony export */   "Keys": () => (/* binding */ Keys),
/* harmony export */   "LongPressDirective": () => (/* binding */ LongPressDirective),
/* harmony export */   "NgxDatatableModule": () => (/* binding */ NgxDatatableModule),
/* harmony export */   "OrderableDirective": () => (/* binding */ OrderableDirective),
/* harmony export */   "ProgressBarComponent": () => (/* binding */ ProgressBarComponent),
/* harmony export */   "ResizeableDirective": () => (/* binding */ ResizeableDirective),
/* harmony export */   "RowHeightCache": () => (/* binding */ RowHeightCache),
/* harmony export */   "ScrollbarHelper": () => (/* binding */ ScrollbarHelper),
/* harmony export */   "ScrollerComponent": () => (/* binding */ ScrollerComponent),
/* harmony export */   "SelectionType": () => (/* binding */ SelectionType),
/* harmony export */   "SortDirection": () => (/* binding */ SortDirection),
/* harmony export */   "SortType": () => (/* binding */ SortType),
/* harmony export */   "VisibilityDirective": () => (/* binding */ VisibilityDirective),
/* harmony export */   "adjustColumnWidths": () => (/* binding */ adjustColumnWidths),
/* harmony export */   "camelCase": () => (/* binding */ camelCase),
/* harmony export */   "columnGroupWidths": () => (/* binding */ columnGroupWidths),
/* harmony export */   "columnTotalWidth": () => (/* binding */ columnTotalWidth),
/* harmony export */   "columnsByPin": () => (/* binding */ columnsByPin),
/* harmony export */   "columnsByPinArr": () => (/* binding */ columnsByPinArr),
/* harmony export */   "columnsTotalWidth": () => (/* binding */ columnsTotalWidth),
/* harmony export */   "deCamelCase": () => (/* binding */ deCamelCase),
/* harmony export */   "deepValueGetter": () => (/* binding */ deepValueGetter),
/* harmony export */   "elementsFromPoint": () => (/* binding */ elementsFromPoint),
/* harmony export */   "emptyStringGetter": () => (/* binding */ emptyStringGetter),
/* harmony export */   "forceFillColumnWidths": () => (/* binding */ forceFillColumnWidths),
/* harmony export */   "getTotalFlexGrow": () => (/* binding */ getTotalFlexGrow),
/* harmony export */   "getVendorPrefixedName": () => (/* binding */ getVendorPrefixedName),
/* harmony export */   "getterForProp": () => (/* binding */ getterForProp),
/* harmony export */   "groupRowsByParents": () => (/* binding */ groupRowsByParents),
/* harmony export */   "id": () => (/* binding */ id),
/* harmony export */   "isNullOrUndefined": () => (/* binding */ isNullOrUndefined),
/* harmony export */   "nextSortDir": () => (/* binding */ nextSortDir),
/* harmony export */   "numericIndexGetter": () => (/* binding */ numericIndexGetter),
/* harmony export */   "optionalGetterForProp": () => (/* binding */ optionalGetterForProp),
/* harmony export */   "orderByComparator": () => (/* binding */ orderByComparator),
/* harmony export */   "selectRows": () => (/* binding */ selectRows),
/* harmony export */   "selectRowsBetween": () => (/* binding */ selectRowsBetween),
/* harmony export */   "setColumnDefaults": () => (/* binding */ setColumnDefaults),
/* harmony export */   "shallowValueGetter": () => (/* binding */ shallowValueGetter),
/* harmony export */   "sortRows": () => (/* binding */ sortRows),
/* harmony export */   "throttle": () => (/* binding */ throttle),
/* harmony export */   "throttleable": () => (/* binding */ throttleable),
/* harmony export */   "translateTemplates": () => (/* binding */ translateTemplates),
/* harmony export */   "translateXY": () => (/* binding */ translateXY),
/* harmony export */   "ɵ0": () => (/* binding */ ɵ0)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 92218);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 36312);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 84505);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs/operators */ 85921);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 34929);





/**
 * Gets the width of the scrollbar.  Nesc for windows
 * http://stackoverflow.com/a/13382873/888165
 */



const _c0 = ["*"];

function DataTableBodyComponent_datatable_progress_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "datatable-progress");
  }
}

function DataTableBodyComponent_datatable_scroller_3_datatable_summary_row_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "datatable-summary-row", 9);
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("rowHeight", ctx_r4.summaryHeight)("offsetX", ctx_r4.offsetX)("innerWidth", ctx_r4.innerWidth)("rows", ctx_r4.rows)("columns", ctx_r4.columns);
  }
}

function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_datatable_body_row_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-body-row", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("treeAction", function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_datatable_body_row_1_Template_datatable_body_row_treeAction_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r14);
      const group_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r12.onTreeAction(group_r7));
    })("activate", function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_datatable_body_row_1_Template_datatable_body_row_activate_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r14);
      const i_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().index;
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);

      const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);

      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](_r1.onActivate($event, ctx_r15.indexes.first + i_r8));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const group_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);

    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("isSelected", _r1.getRowSelected(group_r7))("innerWidth", ctx_r9.innerWidth)("offsetX", ctx_r9.offsetX)("columns", ctx_r9.columns)("rowHeight", ctx_r9.getRowHeight(group_r7))("row", group_r7)("rowIndex", ctx_r9.getRowIndex(group_r7))("expanded", ctx_r9.getRowExpanded(group_r7))("rowClass", ctx_r9.rowClass)("displayCheck", ctx_r9.displayCheck)("treeStatus", group_r7 && group_r7.treeStatus);
  }
}

function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_ng_template_2_datatable_body_row_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-body-row", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("activate", function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_ng_template_2_datatable_body_row_0_Template_datatable_body_row_activate_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r22);
      const i_r20 = restoredCtx.index;
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](4);

      const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);

      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](_r1.onActivate($event, i_r20));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const row_r19 = ctx.$implicit;
    const group_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2).$implicit;
    const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);

    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](2);

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("isSelected", _r1.getRowSelected(row_r19))("innerWidth", ctx_r18.innerWidth)("offsetX", ctx_r18.offsetX)("columns", ctx_r18.columns)("rowHeight", ctx_r18.getRowHeight(row_r19))("row", row_r19)("group", group_r7.value)("rowIndex", ctx_r18.getRowIndex(row_r19))("expanded", ctx_r18.getRowExpanded(row_r19))("rowClass", ctx_r18.rowClass);
  }
}

function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_ng_template_2_datatable_body_row_0_Template, 1, 10, "datatable-body-row", 14);
  }

  if (rf & 2) {
    const group_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]().$implicit;
    const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", group_r7.value)("ngForTrackBy", ctx_r11.rowTrackingFn);
  }
}

function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-row-wrapper", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("rowContextmenu", function DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_Template_datatable_row_wrapper_rowContextmenu_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r26);
      const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r25.rowContextmenu.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_datatable_body_row_1_Template, 1, 11, "datatable-body-row", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_ng_template_2_Template, 1, 2, "ng-template", null, 12, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const group_r7 = ctx.$implicit;
    const i_r8 = ctx.index;

    const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵreference"](3);

    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("groupedRows", ctx_r5.groupedRows)("innerWidth", ctx_r5.innerWidth)("ngStyle", ctx_r5.getRowsStyles(group_r7))("rowDetail", ctx_r5.rowDetail)("groupHeader", ctx_r5.groupHeader)("offsetX", ctx_r5.offsetX)("detailRowHeight", ctx_r5.getDetailRowHeight(group_r7 && group_r7[i_r8], i_r8))("row", group_r7)("expanded", ctx_r5.getRowExpanded(group_r7))("rowIndex", ctx_r5.getRowIndex(group_r7 && group_r7[i_r8]));
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r5.groupedRows)("ngIfElse", _r10);
  }
}

function DataTableBodyComponent_datatable_scroller_3_datatable_summary_row_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "datatable-summary-row", 16);
  }

  if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", ctx_r6.getBottomSummaryRowStyles())("rowHeight", ctx_r6.summaryHeight)("offsetX", ctx_r6.offsetX)("innerWidth", ctx_r6.innerWidth)("rows", ctx_r6.rows)("columns", ctx_r6.columns);
  }
}

function DataTableBodyComponent_datatable_scroller_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r28 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-scroller", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("scroll", function DataTableBodyComponent_datatable_scroller_3_Template_datatable_scroller_scroll_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r28);
      const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r27.onBodyScroll($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableBodyComponent_datatable_scroller_3_datatable_summary_row_1_Template, 1, 5, "datatable-summary-row", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, DataTableBodyComponent_datatable_scroller_3_datatable_row_wrapper_2_Template, 4, 12, "datatable-row-wrapper", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, DataTableBodyComponent_datatable_scroller_3_datatable_summary_row_3_Template, 1, 6, "datatable-summary-row", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("scrollbarV", ctx_r2.scrollbarV)("scrollbarH", ctx_r2.scrollbarH)("scrollHeight", ctx_r2.scrollHeight)("scrollWidth", ctx_r2.columnGroupWidths == null ? null : ctx_r2.columnGroupWidths.total);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r2.summaryRow && ctx_r2.summaryPosition === "top");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", ctx_r2.temp)("ngForTrackBy", ctx_r2.rowTrackingFn);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r2.summaryRow && ctx_r2.summaryPosition === "bottom");
  }
}

function DataTableBodyComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "div", 17);
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("innerHTML", ctx_r3.emptyMessage, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeHtml"]);
  }
}

function DataTableHeaderComponent_div_1_datatable_header_cell_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-header-cell", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("resize", function DataTableHeaderComponent_div_1_datatable_header_cell_1_Template_datatable_header_cell_resize_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const column_r3 = restoredCtx.$implicit;
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r4.onColumnResized($event, column_r3));
    })("longPressStart", function DataTableHeaderComponent_div_1_datatable_header_cell_1_Template_datatable_header_cell_longPressStart_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r6.onLongPressStart($event));
    })("longPressEnd", function DataTableHeaderComponent_div_1_datatable_header_cell_1_Template_datatable_header_cell_longPressEnd_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r7.onLongPressEnd($event));
    })("sort", function DataTableHeaderComponent_div_1_datatable_header_cell_1_Template_datatable_header_cell_sort_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r8.onSort($event));
    })("select", function DataTableHeaderComponent_div_1_datatable_header_cell_1_Template_datatable_header_cell_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r9.select.emit($event));
    })("columnContextmenu", function DataTableHeaderComponent_div_1_datatable_header_cell_1_Template_datatable_header_cell_columnContextmenu_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r10.columnContextmenu.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const column_r3 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("resizeEnabled", column_r3.resizeable)("pressModel", column_r3)("pressEnabled", ctx_r2.reorderable && column_r3.draggable)("dragX", ctx_r2.reorderable && column_r3.draggable && column_r3.dragging)("dragY", false)("dragModel", column_r3)("dragEventTarget", ctx_r2.dragEventTarget)("headerHeight", ctx_r2.headerHeight)("isTarget", column_r3.isTarget)("targetMarkerTemplate", ctx_r2.targetMarkerTemplate)("targetMarkerContext", column_r3.targetMarkerContext)("column", column_r3)("sortType", ctx_r2.sortType)("sorts", ctx_r2.sorts)("selectionType", ctx_r2.selectionType)("sortAscendingIcon", ctx_r2.sortAscendingIcon)("sortDescendingIcon", ctx_r2.sortDescendingIcon)("sortUnsetIcon", ctx_r2.sortUnsetIcon)("allRowsSelected", ctx_r2.allRowsSelected);
  }
}

function DataTableHeaderComponent_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableHeaderComponent_div_1_datatable_header_cell_1_Template, 1, 19, "datatable-header-cell", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const colGroup_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMap"]("datatable-row-" + colGroup_r1.type);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", ctx_r0._styleByGroup[colGroup_r1.type]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", colGroup_r1.columns)("ngForTrackBy", ctx_r0.columnTrackingFn);
  }
}

function DatatableComponent_datatable_header_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-header", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("sort", function DatatableComponent_datatable_header_1_Template_datatable_header_sort_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r2.onColumnSort($event));
    })("resize", function DatatableComponent_datatable_header_1_Template_datatable_header_resize_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r4.onColumnResize($event));
    })("reorder", function DatatableComponent_datatable_header_1_Template_datatable_header_reorder_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r5.onColumnReorder($event));
    })("select", function DatatableComponent_datatable_header_1_Template_datatable_header_select_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r6.onHeaderSelect($event));
    })("columnContextmenu", function DatatableComponent_datatable_header_1_Template_datatable_header_columnContextmenu_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r7.onColumnContextmenu($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipe"](1, "async");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("sorts", ctx_r0.sorts)("sortType", ctx_r0.sortType)("scrollbarH", ctx_r0.scrollbarH)("innerWidth", ctx_r0._innerWidth)("offsetX", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpipeBind1"](1, 15, ctx_r0._offsetX))("dealsWithGroup", ctx_r0.groupedRows !== undefined)("columns", ctx_r0._internalColumns)("headerHeight", ctx_r0.headerHeight)("reorderable", ctx_r0.reorderable)("targetMarkerTemplate", ctx_r0.targetMarkerTemplate)("sortAscendingIcon", ctx_r0.cssClasses.sortAscending)("sortDescendingIcon", ctx_r0.cssClasses.sortDescending)("sortUnsetIcon", ctx_r0.cssClasses.sortUnset)("allRowsSelected", ctx_r0.allRowsSelected)("selectionType", ctx_r0.selectionType);
  }
}

function DatatableComponent_datatable_footer_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-footer", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("page", function DatatableComponent_datatable_footer_4_Template_datatable_footer_page_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r9);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r8.onFooterPage($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("rowCount", ctx_r1.rowCount)("pageSize", ctx_r1.pageSize)("offset", ctx_r1.offset)("footerHeight", ctx_r1.footerHeight)("footerTemplate", ctx_r1.footer)("totalMessage", ctx_r1.messages.totalMessage)("pagerLeftArrowIcon", ctx_r1.cssClasses.pagerLeftArrow)("pagerRightArrowIcon", ctx_r1.cssClasses.pagerRightArrow)("pagerPreviousIcon", ctx_r1.cssClasses.pagerPrevious)("selectedCount", ctx_r1.selected.length)("selectedMessage", !!ctx_r1.selectionType && ctx_r1.messages.selectedMessage)("pagerNextIcon", ctx_r1.cssClasses.pagerNext);
  }
}

function DataTableHeaderCellComponent_1_ng_template_0_Template(rf, ctx) {}

function DataTableHeaderCellComponent_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableHeaderCellComponent_1_ng_template_0_Template, 0, 0, "ng-template", 5);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r0.targetMarkerTemplate)("ngTemplateOutletContext", ctx_r0.targetMarkerContext);
  }
}

function DataTableHeaderCellComponent_label_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "label", 6)(1, "input", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function DataTableHeaderCellComponent_label_2_Template_input_change_1_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r5.select.emit(!ctx_r5.allRowsSelected));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r1.allRowsSelected);
  }
}

function DataTableHeaderCellComponent_span_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span", 8)(1, "span", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function DataTableHeaderCellComponent_span_3_Template_span_click_1_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r8);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r7.onSort());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("innerHTML", ctx_r2.name, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeHtml"]);
  }
}

function DataTableHeaderCellComponent_4_ng_template_0_Template(rf, ctx) {}

function DataTableHeaderCellComponent_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableHeaderCellComponent_4_ng_template_0_Template, 0, 0, "ng-template", 5);
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r3.column.headerTemplate)("ngTemplateOutletContext", ctx_r3.cellContext);
  }
}

function DataTableFooterComponent_1_ng_template_0_Template(rf, ctx) {}

const _c1 = function (a0, a1, a2, a3, a4) {
  return {
    rowCount: a0,
    pageSize: a1,
    selectedCount: a2,
    curPage: a3,
    offset: a4
  };
};

function DataTableFooterComponent_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableFooterComponent_1_ng_template_0_Template, 0, 0, "ng-template", 4);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r0.footerTemplate.template)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction5"](2, _c1, ctx_r0.rowCount, ctx_r0.pageSize, ctx_r0.selectedCount, ctx_r0.curPage, ctx_r0.offset));
  }
}

function DataTableFooterComponent_div_2_span_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"](" ", ctx_r4.selectedCount == null ? null : ctx_r4.selectedCount.toLocaleString(), " ", ctx_r4.selectedMessage, " / ");
  }
}

function DataTableFooterComponent_div_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableFooterComponent_div_2_span_1_Template, 2, 2, "span", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r1.selectedMessage);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate2"](" ", ctx_r1.rowCount == null ? null : ctx_r1.rowCount.toLocaleString(), " ", ctx_r1.totalMessage, " ");
  }
}

function DataTableFooterComponent_datatable_pager_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-pager", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("change", function DataTableFooterComponent_datatable_pager_3_Template_datatable_pager_change_0_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r5.page.emit($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("pagerLeftArrowIcon", ctx_r2.pagerLeftArrowIcon)("pagerRightArrowIcon", ctx_r2.pagerRightArrowIcon)("pagerPreviousIcon", ctx_r2.pagerPreviousIcon)("pagerNextIcon", ctx_r2.pagerNextIcon)("page", ctx_r2.curPage)("size", ctx_r2.pageSize)("count", ctx_r2.rowCount)("hidden", !ctx_r2.isVisible);
  }
}

const _c2 = function (a0) {
  return {
    "selected-count": a0
  };
};

function DataTablePagerComponent_li_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "li", 6)(1, "a", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function DataTablePagerComponent_li_7_Template_a_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r3);
      const pg_r1 = restoredCtx.$implicit;
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r2.selectPage(pg_r1.number));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const pg_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassProp"]("active", pg_r1.number === ctx_r0.page);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵattribute"]("aria-label", "page " + pg_r1.number);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtextInterpolate1"](" ", pg_r1.text, " ");
  }
}

function DataTableBodyRowComponent_div_0_datatable_body_cell_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "datatable-body-cell", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("activate", function DataTableBodyRowComponent_div_0_datatable_body_cell_1_Template_datatable_body_cell_activate_0_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r7);
      const ii_r5 = restoredCtx.index;
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r6.onActivate($event, ii_r5));
    })("treeAction", function DataTableBodyRowComponent_div_0_datatable_body_cell_1_Template_datatable_body_cell_treeAction_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r7);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r8.onTreeAction());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const column_r4 = ctx.$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("row", ctx_r3.row)("group", ctx_r3.group)("expanded", ctx_r3.expanded)("isSelected", ctx_r3.isSelected)("rowIndex", ctx_r3.rowIndex)("column", column_r4)("rowHeight", ctx_r3.rowHeight)("displayCheck", ctx_r3.displayCheck)("treeStatus", ctx_r3.treeStatus);
  }
}

function DataTableBodyRowComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableBodyRowComponent_div_0_datatable_body_cell_1_Template, 1, 9, "datatable-body-cell", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const colGroup_r1 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵclassMapInterpolate1"]("datatable-row-", colGroup_r1.type, " datatable-row-group");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", ctx_r0._groupStyles[colGroup_r1.type]);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngForOf", colGroup_r1.columns)("ngForTrackBy", ctx_r0.columnTrackingFn);
  }
}

function DataTableRowWrapperComponent_div_0_1_ng_template_0_Template(rf, ctx) {}

function DataTableRowWrapperComponent_div_0_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableRowWrapperComponent_div_0_1_ng_template_0_Template, 0, 0, "ng-template", 4);
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r3.groupHeader.template)("ngTemplateOutletContext", ctx_r3.groupContext);
  }
}

function DataTableRowWrapperComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableRowWrapperComponent_div_0_1_Template, 1, 2, null, 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngStyle", ctx_r0.getGroupHeaderStyle());
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r0.groupHeader && ctx_r0.groupHeader.template);
  }
}

function DataTableRowWrapperComponent_ng_content_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵprojection"](0, 0, ["*ngIf", "(groupHeader && groupHeader.template && expanded) || !groupHeader || !groupHeader.template"]);
  }
}

function DataTableRowWrapperComponent_div_2_1_ng_template_0_Template(rf, ctx) {}

function DataTableRowWrapperComponent_div_2_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableRowWrapperComponent_div_2_1_ng_template_0_Template, 0, 0, "ng-template", 4);
  }

  if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r5.rowDetail.template)("ngTemplateOutletContext", ctx_r5.rowContext);
  }
}

function DataTableRowWrapperComponent_div_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableRowWrapperComponent_div_2_1_Template, 1, 2, null, 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]();
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵstyleProp"]("height", ctx_r2.detailRowHeight, "px");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r2.rowDetail && ctx_r2.rowDetail.template);
  }
}

const _c3 = ["cellTemplate"];

function DataTableBodyCellComponent_label_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "label", 4)(1, "input", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function DataTableBodyCellComponent_label_1_Template_input_click_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r4.onCheckboxChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("checked", ctx_r0.isSelected);
  }
}

function DataTableBodyCellComponent_ng_container_2_button_1_i_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "i", 11);
  }
}

function DataTableBodyCellComponent_ng_container_2_button_1_i_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "i", 12);
  }
}

function DataTableBodyCellComponent_ng_container_2_button_1_i_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "i", 13);
  }
}

function DataTableBodyCellComponent_ng_container_2_button_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵgetCurrentView"]();

    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](0, "button", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵlistener"]("click", function DataTableBodyCellComponent_ng_container_2_button_1_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵrestoreView"](_r12);
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵresetView"](ctx_r11.onTreeAction());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementStart"](1, "span");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, DataTableBodyCellComponent_ng_container_2_button_1_i_2_Template, 1, 0, "i", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](3, DataTableBodyCellComponent_ng_container_2_button_1_i_3_Template, 1, 0, "i", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](4, DataTableBodyCellComponent_ng_container_2_button_1_i_4_Template, 1, 0, "i", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementEnd"]()();
  }

  if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("disabled", ctx_r6.treeStatus === "disabled");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r6.treeStatus === "loading");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r6.treeStatus === "collapsed");
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r6.treeStatus === "expanded" || ctx_r6.treeStatus === "disabled");
  }
}

function DataTableBodyCellComponent_ng_container_2_2_ng_template_0_Template(rf, ctx) {}

const _c4 = function (a0) {
  return {
    cellContext: a0
  };
};

function DataTableBodyCellComponent_ng_container_2_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableBodyCellComponent_ng_container_2_2_ng_template_0_Template, 0, 0, "ng-template", 14);
  }

  if (rf & 2) {
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r7.column.treeToggleTemplate)("ngTemplateOutletContext", _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵpureFunction1"](2, _c4, ctx_r7.cellContext));
  }
}

function DataTableBodyCellComponent_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](1, DataTableBodyCellComponent_ng_container_2_button_1_Template, 5, 4, "button", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](2, DataTableBodyCellComponent_ng_container_2_2_Template, 1, 4, null, 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelementContainerEnd"]();
  }

  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", !ctx_r1.column.treeToggleTemplate);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngIf", ctx_r1.column.treeToggleTemplate);
  }
}

function DataTableBodyCellComponent_span_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "span", 15);
  }

  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("title", ctx_r2.sanitizedValue)("innerHTML", ctx_r2.value, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵsanitizeHtml"]);
  }
}

function DataTableBodyCellComponent_4_ng_template_0_Template(rf, ctx) {}

function DataTableBodyCellComponent_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplate"](0, DataTableBodyCellComponent_4_ng_template_0_Template, 0, 0, "ng-template", 14, 16, _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtemplateRefExtractor"]);
  }

  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("ngTemplateOutlet", ctx_r3.column.cellTemplate)("ngTemplateOutletContext", ctx_r3.cellContext);
  }
}

function DataTableSummaryRowComponent_datatable_body_row_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵelement"](0, "datatable-body-row", 1);
  }

  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵproperty"]("innerWidth", ctx_r0.innerWidth)("offsetX", ctx_r0.offsetX)("columns", ctx_r0._internalColumns)("rowHeight", ctx_r0.rowHeight)("row", ctx_r0.summaryRow)("rowIndex", -1);
  }
}

let ScrollbarHelper = /*#__PURE__*/(() => {
  class ScrollbarHelper {
    constructor(document) {
      this.document = document;
      this.width = this.getWidth();
    }

    getWidth() {
      const outer = this.document.createElement('div');
      outer.style.visibility = 'hidden';
      outer.style.width = '100px';
      outer.style.msOverflowStyle = 'scrollbar';
      this.document.body.appendChild(outer);
      const widthNoScroll = outer.offsetWidth;
      outer.style.overflow = 'scroll';
      const inner = this.document.createElement('div');
      inner.style.width = '100%';
      outer.appendChild(inner);
      const widthWithScroll = inner.offsetWidth;
      outer.parentNode.removeChild(outer);
      return widthNoScroll - widthWithScroll;
    }

  }

  ScrollbarHelper.ɵfac = function ScrollbarHelper_Factory(t) {
    return new (t || ScrollbarHelper)(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵinject"](_angular_common__WEBPACK_IMPORTED_MODULE_1__.DOCUMENT));
  };

  ScrollbarHelper.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: ScrollbarHelper,
    factory: ScrollbarHelper.ɵfac
  });
  return ScrollbarHelper;
})();

/**
 * Gets the width of the scrollbar.  Nesc for windows
 * http://stackoverflow.com/a/13382873/888165
 */
let DimensionsHelper = /*#__PURE__*/(() => {
  class DimensionsHelper {
    getDimensions(element) {
      return element.getBoundingClientRect();
    }

  }

  DimensionsHelper.ɵfac = function DimensionsHelper_Factory(t) {
    return new (t || DimensionsHelper)();
  };

  DimensionsHelper.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: DimensionsHelper,
    factory: DimensionsHelper.ɵfac
  });
  /**
   * service to make DatatableComponent aware of changes to
   * input bindings of DataTableColumnDirective
   */

  return DimensionsHelper;
})();
let ColumnChangesService = /*#__PURE__*/(() => {
  class ColumnChangesService {
    constructor() {
      this.columnInputChanges = new rxjs__WEBPACK_IMPORTED_MODULE_2__.Subject();
    }

    get columnInputChanges$() {
      return this.columnInputChanges.asObservable();
    }

    onInputChange() {
      this.columnInputChanges.next();
    }

  }

  ColumnChangesService.ɵfac = function ColumnChangesService_Factory(t) {
    return new (t || ColumnChangesService)();
  };

  ColumnChangesService.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({
    token: ColumnChangesService,
    factory: ColumnChangesService.ɵfac
  });
  return ColumnChangesService;
})();
let DataTableFooterTemplateDirective = /*#__PURE__*/(() => {
  class DataTableFooterTemplateDirective {
    constructor(template) {
      this.template = template;
    }

  }

  DataTableFooterTe